#!/bin/sh

if [ "x${ROOT_DIR}" = "x" ]; then
    if [ -d "/tmp/SIM" ]; then
        ROOT_DIR="/tmp/SIM"
    else
        ROOT_DIR=""
    fi
fi

PATH="${ROOT_DIR}/usr/local/bin:/usr/sbin:/sbin:/usr/bin:/bin:${PATH}"
LD_LIBRARY_PATH="${ROOT_DIR}/usr/local/lib:/usr/lib:/lib:${LD_LIBRARY_PATH}"

MACHINE=$(uname -m)

if [ "$MACHINE" = 'armv5teb' ]; then
    OURPATH=""
else
    OURPATH=$(dirname $(dirname $(dirname $(dirname $(readlink -f $0)))))
fi

if [ -d "${OURPATH}/bin" ]; then
    PATH="${OURPATH}/bin:${PATH}"
fi

if [ -d "${OURPATH}/lib" ]; then
    LD_LIBRARY_PATH="${OURPATH}/bin:${LD_LIBRARY_PATH}"
fi

if [ -d "${OURPATH}/srv" ]; then 
    ACTIVE_SRV_DIR="${OURPATH}/srv"
else
    ACTIVE_SRV_DIR="${ROOT_DIR}/usr/local/srv"
fi
PASSIVE_SRV_DIR="${ROOT_DIR}/mnt/passive/usr/local/srv"

if [ "$MACHINE" = 'armv5teb' ]; then
    ACTIVE_ETC_DIR="/usr/local/etc"
else
    if [ -d "${OURPATH}/etc" ]; then 
        ACTIVE_ETC_DIR="${OURPATH}/etc"
    else
        ACTIVE_ETC_DIR="${ROOT_DIR}/usr/local/etc"
    fi
fi

if [ -d "${OURPATH}/www/html/cgi-bin" ]; then
    PATH="${OURPATH}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${OURPATH}/www/html/cgi-bin/functions"
else
    PATH="${ROOT_DIR}/www/html/cgi-bin:$PATH"
    FUNCTIONS="${ROOT_DIR}/www/html/cgi-bin/functions"
fi

export PATH
export LD_LIBRARY_PATH

. ${FUNCTIONS}

if [ -d "${ROOT_DIR}/ffs/run/trs_data" ]; then
    TRS_DATA="${ROOT_DIR}/ffs/run/trs_data"
    ACTIVE_CONFIG_DIR="${TRS_DATA}/active"
    PASSIVE_CONFIG_DIR="${TRS_DATA}/passive"
    PERSISTENCE_DIR="${TRS_DATA}/db"
else
    ACTIVE_CONFIG_DIR="${ROOT_DIR}/usr/local/etc/config"
    PASSIVE_CONFIG_DIR="${ROOT_DIR}/tmp/passCfg"
    PERSISTENCE_DIR="${ACTIVE_CONFIG_DIR}"
fi

was_cgi_bin=$(wasCgiBin $SCRIPT_NAME)
if [ $was_cgi_bin -eq 1 ]; then
  sendMessage 0 "Please use the link [ View TRS Log files -> Display system information ]" "Unauthorized - Access denied" 6
  exit
fi

PRODUCT=$(test_envInfo -a|sed -e '/Product/ !d;s/.*PROD_//;s/)$//;s/\s//')
UNIT=$(test_envInfo -a|sed -e '/Unit/ !d;s/.*UNIT_//;s/)$//;s/\s//')

printHeader()
{
echo "**********************************************"
echo "*                                            *"
while [ -n "$1" ]; do
    echo "*   $(printf "%-41s" "$1")*"
    shift
done
echo "*                                            *"
echo "**********************************************"
}

printHeader "date"
date

printHeader "uptime"
uptime

printHeader "Target information"
if [ "mips64" = "${MACHINE}" ]; then
    echo "=> Please check the sysinfo file"
elif [ `isFsmr4` -eq 1 ]; then
    test_envInfo envInfoReadTarget 2>/dev/null
    echo ''
else
    test_hlEeprom readUnitData 2>/dev/null
    echo ''
fi
echo 'y' | test_hlPiu -a 2>/dev/null | grep -vE '^(test_hlPiu:|Continue tests anyway)'

printHeader "   TargetBD.xml of" "Active Software Partition"
printf "<textarea readonly rows=20 cols=110>"
cat "${ACTIVE_SRV_DIR}/targetBD.xml" 2>/dev/null
printf "</textarea><br><br>"

if [ -s "${PASSIVE_SRV_DIR}/targetBD.xml" ]; then
    printHeader "   TargetBD.xml of" "Passive Software Partition"
    printf "<textarea readonly rows=20 cols=110>"
    cat "${PASSIVE_SRV_DIR}/targetBD.xml" 2>/dev/null
    printf "</textarea><br><br>"
fi

echo ''
echo ''
printHeader "Hardware Information (eidutil)"
llpd /usr/bin/eidutil
echo ''

printHeader "File system information"
df 2>/dev/null
cat /proc/mounts 2> /dev/null
echo "**********************************************"
for dir in \
    ${ROOT_DIR}/var/log \
    ${ROOT_DIR}/ffs/run/logs \
    ${ROOT_DIR}/shareTmp \
    ${ACTIVE_CONFIG_DIR} \
    ${PASSIVE_CONFIG_DIR}; do
    [ -d "$dir" ] && ls -lAR "${dir}/" 2> /dev/null
done

printHeader "Task Information (ukTmgrShow)"
llpd /opt/trs/bin/ukTmgrShow 2>/dev/null

printHeader "System information (pidin)"
cat /proc/meminfo 2>/dev/null

printHeader "bootmem allocation"
cat /sys/devices/system/cpu/bootmem 2>/dev/null

printHeader "Active Processes (pidin)"
ps -efa 2>/dev/null

printHeader "${PERSISTENCE_DIR}/persist.db"
cat "${PERSISTENCE_DIR}/persist.db" 2>/dev/null

printHeader "${PERSISTENCE_DIR}/persist.bak"
cat "${PERSISTENCE_DIR}/persist.bak" 2>/dev/null

printHeader "Contents of file ntp.conf"
cat $(ls -1 "${ROOT_DIR}/tmp/ntp.conf" "${ROOT_DIR}/shareTmp/bts/ntp.conf" 2>/dev/null) 2>/dev/null </dev/null

printHeader "Local interface settings (ip addr show, ip link show)"
ip addr show 2>/dev/null
ip link show 2>/dev/null

printHeader "Ethernet interface statistics (ip -s link)"
ip -s link 2>/dev/null

printHeader "Address Resolution (ip neigh show)"
ip neigh show 2>/dev/null

printHeader "Netstat (netstat -anp)"
netstat -anp 2>/dev/null

printHeader "Ipv4 multicast entries (netstat -g)"
netstat -ng 2>/dev/null

if [ "FTIB" = "$UNIT" ] || [ "mips64" = "${MACHINE}" ] || [ "armv7l" = "${MACHINE}" ]; then  #armv7l =>FZM

        printHeader "ipsec status"
        llpd /usr/sbin/ipsec status 2>/dev/null &
        sleep 5
        if kill -s 0 %+; then
            kill -9 %+
        fi
        wait %+

        printHeader "ipsec statusall"
        llpd /usr/sbin/ipsec statusall 2>/dev/null &
        sleep 5
        if kill -s 0 %+; then
            kill -9 %+
        fi
        wait %+

        printHeader "ip xfrm state"
        llpd ip xfrm state 2>/dev/null

        printHeader "ip xfrm policy"
        llpd ip xfrm policy 2>/dev/null

        if [ -e ${ROOT_DIR}/etc/ipsec.secrets ]; then
            printHeader "${ROOT_DIR}/etc/ipsec.secrets"
            cat "${ROOT_DIR}/etc/ipsec.secrets"  2>/dev/null
        fi

        if [ -e ${ROOT_DIR}/etc/ipsec.conf ]; then
            printHeader "${ROOT_DIR}/etc/ipsec.conf"
            cat "${ROOT_DIR}/etc/ipsec.conf" 2>/dev/null
        fi
fi

printHeader "System Log"
dmesg | sed '/[A-Za-z._0-9]*@[A-Za-z._0-9].[A-Za-z]/d' 2>/dev/null

if [ "WCDMA" = "$PRODUCT" ]; then
   printHeader "cpp Signaling"

   /opt/trs/bin/objcli tls_show_iubip_cac 2>/dev/null
   /opt/trs/bin/objcli tls_show_aal2s_counter 2>/dev/null
   /opt/trs/bin/objcli tls_show_ipcs_counter 2>/dev/null
   /opt/trs/bin/objcli tls_show_iub_ip_counter 2>/dev/null
   /opt/trs/bin/objcli tls_mb_ipcs_show_conn 2>/dev/null
   /opt/trs/bin/objcli tls_mb_ipcs_show_counter 2>/dev/null
fi

printHeader "IP routing (ip rule ls)"
ip rule ls 2>/dev/null

printHeader "IP routing (ip route ls \$t)"
tables=$(cat /etc/iproute2/rt_tables)
if [ "armv5teb" = "${MACHINE}" ]; then
    let t=20
else
    let t=1
fi
while [ $t -le 255 ]; do
    res=$(ip route ls table $t)
    if [ "x" != "x$res" ]; then
        table=$(echo "$tables" | sed -ne "s/^[[:space:]]*$t[[:space:]][[:space:]]*//p")
        if [ "x" = "x$table" ]; then
            table=$t
        else
            table="$table ($t)"
        fi
        echo "************ $table ************"
        echo "$res"
        echo
    fi

    if [ "armv5teb" = "${MACHINE}" ]; then
        if [ $t -lt 70 ]; then
            let t+=10
        elif [ $t -eq 70 ]; then
            let t=253
        else
            let ++t
        fi
    else
        let ++t
    fi
done

printHeader "IPv6 routing (ip -6 rule ls)"
ip -6 rule ls 2>/dev/null

printHeader "IPv6 routing (ip -6 route ls)"
if [ "armv5teb" = "${MACHINE}" ]; then
    let t=20
else
    let t=1
fi
while [ $t -le 255 ]; do
    res=$(ip -6 route ls table $t)
    if [ "x" != "x$res" ]; then
        table=$(echo "$tables" | sed -ne "s/^[[:space:]]*$t[[:space:]][[:space:]]*//p")
        if [ "x" = "x$table" ]; then
            table=$t
        else
            table="$table ($t)"
        fi
        echo "************ $table ************"
        echo "$res"
        echo
    fi

    if [ "armv5teb" = "${MACHINE}" ]; then
        if [ $t -lt 70 ]; then
            let t+=10
        elif [ $t -eq 70 ]; then
            let t=253
        else
            let ++t
        fi
    else
        let ++t
    fi
done

printHeader "IPTABLES Status"
export PATH="/sbin:/usr/sbin:$PATH"
llpd cat /proc/net/ip_tables_names 2>/dev/null | while read t; do
    echo "======================================================================"
    echo "                       $t - table"
    echo "======================================================================"
    llpd iptables -v -L -n -t $t --line-numbers 2>/dev/null
done

printHeader "ARPTABLES Status"
llpd cat /proc/net/arp 2>/dev/null 

if [ "armv5teb" = "${MACHINE}" ]; then
    if [ "LTE_DCM" = "$PRODUCT" -o "LTE_WMP" = "$PRODUCT" ]; then
        printHeader "ucode configuration"
        np me_ltetest_show_config
    fi
fi

printHeader "IP6TABLES Status"
llpd cat /proc/net/ip6_tables_names 2>/dev/null | while read t; do
    echo "======================================================================"
    echo "                       $t - table"
    echo "======================================================================"
    llpd ip6tables -v -L -n -t $t --line-numbers 2>/dev/null
done

if [ "armv5teb" = "${MACHINE}" ]; then
    printHeader "DHCP lease file content"
    if [[ -f ${ROOT_DIR}/tmp/etc/dhcpd.leases ]]; then
        cat ${ROOT_DIR}/tmp/etc/dhcpd.leases 2>/dev/null
    else
        echo 'No dhcp leases file created'
    fi
fi

printHeader "MIB Version"
grep -A 1 "(MIB)" "${ACTIVE_ETC_DIR}"/RAML_* 2>/dev/null

if [ "mips64" = "${MACHINE}" ]; then
    printHeader "AppDef.txt"
    if [ -f ${ROOT_DIR}/tmp/AppDef.txt ]; then
        cat ${ROOT_DIR}/tmp/AppDef.txt 2>/dev/null
    fi

    printHeader "SRIO Endpoints (checkep)"
    checkep

    printHeader "SysCom Routes"
        nc localhost 15007 <<<"aasyscomgw -r" 2>/dev/null
        echo

    printHeader "SysCom Hops"
        nc localhost 15007 <<<"hop -r" 2>/dev/null
        echo

    printHeader "RP441 Mode"
        /opt/trs/bin/test_envInfo envInfoIfRP441 2>/dev/null

    printHeader "Transport Container Info"
        /usr/bin/lxc-info -n 2 2>/dev/null

    printHeader "BTS Container Info"
        /usr/bin/lxc-info -n 1 2>/dev/null

    printHeader "Ethernet link statistics (ip -s link)"
    /usr/sbin/ip addr show
    ip -s link
    ethtool_cmd=/usr/sbin/ethtool
    if [ -x $ethtool_cmd ]; then

        for interface in \
            sw0 \
            sw1 \
            sw2 \
            eth1 \
            eth2 \
            eth3 \
            eth4 \
            eth5; do

            $ethtool_cmd $interface 2>/dev/null
            echo
        done
    else
        echo "ERROR: Not executable or missing: $ethtool_cmd"
    fi
    /usr/sbin/ip addr show
    ip -s link
fi

if [ -f ${OURPATH}/bin/trsBtoothWeb ]; then
    printHeader "Site specific data for Bluetooth"
    trsBtoothWeb --data
fi

OAM_ROLE_FILE=${ACTIVE_CONFIG_DIR}/oam_role

if [ -f ${OAM_ROLE_FILE} ]; then
    printHeader "OAM ROLE FILE content"
    echo -n ${OAM_ROLE_FILE} " : " 2> /dev/null
    cat ${OAM_ROLE_FILE} 2> /dev/null
fi

