#!/bin/bash
trap '' PIPE

export PATH=/usr/local/bin:/bin:/usr/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions

printf "Content-Type: text/html\r\n\r\n"

if [ -f /opt/trs/bin/FPCiTest ]
then
  CAPTURING_BIN=/opt/trs/bin/FPCiTest
elif [ -f /opt/trs/bin/vtc ]
then
  CAPTURING_BIN=/opt/trs/bin/vtc
else
  CAPTURING_BIN=/opt/trs/bin/trafficCapturing
fi

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

function web_page_stopping()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h3">Aborting Local and Remote IP Traffic Capturing PCAP File Generation!</h3>

</body>
</html>
EOF
}

web_page_stopped()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.getElementById("h3").innerHTML="Local and Remote IP Traffic Capturing pcap file Generation Aborted...";
</script>

</body>
</html>
EOF
}

web_page_invalid_abort()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script type="text/javascript">
document.body.innerHTML = '<h3>Invalid Operation: PCAP Generation abort is not allowed in current state....!!!</h3>';
</script>

</body>
</html>
EOF
}

web_page_mem_failed()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h3").innerHTML="Local and Remote IP Traffic Capturing Feature Disabled Due to unavailability of memory...";
</script>

</body>
</html>
EOF
}

web_page_mem_not_allocated()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.body.innerHTML = '<h3 id="h3">Memory is not allocated please refresh the page....!!!</h3>';
</script>

</body>
</html>
EOF
}


if [ -f "/tmp/portMirrorringMemFailed" ]; then
    web_page_mem_failed
    exit 0
fi
if [ ! -f "/tmp/portMirrorringMemAllocated" ]; then
    web_page_mem_not_allocated
    exit 0
fi

buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
buffer=${buffer/"PORT MIRRORRING STATUS "/""}
if [[ $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_START" || $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_STOP" ]]; then

web_page_stopping
/opt/trs/bin/llpd rm -rf /lte1460/portMirroringTmp.*
/opt/trs/bin/llpd rm -rf /tmp/*_UPLANE.pcap

PID=`ps -ef | grep "/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_gen_pcap_test" | awk '{print $2}'`
for tmpPid in `echo $PID` ; do
/opt/trs/bin/llpd kill -9 $tmpPid  > /dev/null
done
/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_abort_test > /dev/null
/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_set_status_test 4 > /dev/null
/opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 144 > /dev/null
/opt/trs/bin/llpd rm -rf /tmp/portMirroringBuffAccessFail > /dev/null
/opt/trs/bin/llpd rm -rf /tmp/portMirroringZipFileCreationFail > /dev/null
web_page_stopped
logger -s "LTE1460 : PCAP File Generation Aborted"
else
web_page_invalid_abort
fi

