#!/bin/bash

trap '' PIPE

export PATH=/usr/local/bin:/bin:/usr/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

. `dirname "$0"`/../cgi-bin/functions

POST_DATA=$1
POST_DATA1=`echo $POST_DATA | cut -d '&' -f1`
password=''
replace=''
password=${POST_DATA1/"Password="/$replace}
password=${password:0:246}

filename='portMirroringTmp.zip'

if [ -f "/tmp/portMirrorringConfTmpFile" ]; then
    FILE_NAME=`cat /tmp/portMirrorringConfTmpFile | grep FILE_NAME`
    FILE_NAME=${FILE_NAME/FILE_NAME /}
    if [ `isFsmr4` -eq 1 ]; then
        filename=$FILE_NAME".pcap.gz"
    else
        filename=$FILE_NAME".zip"
    fi
    if [ "$password" != "Password" ]; then
        filename=$filename".enc"
    fi
fi

collectAndDownloadPcapFile()
{
   # dump to standard out
    
    #Since the 'sed' versions used in FSMR3 and FSMR4 are different, for the URL decode, providing the flag check.
    if [ `isFsmr4` -eq 1 ] || [ `isFzm` -eq 1 ]; then
        VAR=$(echo "$password" | sed -e's/%\([0-9A-Fa-f][0-9A-Fa-f]\)/\\\\\x\1/g' | xargs echo -e)
        VAR=$(echo "$VAR" | sed -e's/%\([0-9A-Fa-f][0-9A-Fa-f]\)/\\\\\x\1/g' | xargs echo -e)
    else
        VAR=`echo "$password" | sed -e's/%\([0-9A-Fa-f][0-9A-Fa-f]\)/\\\\\x\1/g' | xargs echo -e`
        VAR=`echo "$VAR" | sed -e's/%\([0-9A-Fa-f][0-9A-Fa-f]\)/\\\\\x\1/g' | xargs echo -e`
    fi
    /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 146 > /dev/null

    if [ "$password" != 'Password' ]; then
        if [ `isFsmr4` -eq 1 ]; then
            /opt/trs/bin/llpd openssl aes-128-cbc -a -salt -k "$VAR" -in /lte1460/portMirroringTmp.pcap.gz
        else
            /opt/trs/bin/llpd openssl aes-128-cbc -a -salt -k "$VAR" -in /lte1460/portMirroringTmp.zip
        fi
    else
        if [ `isFsmr4` -eq 1 ]; then
            cat /lte1460/portMirroringTmp.pcap.gz
        else
            cat /lte1460/portMirroringTmp.zip
        fi
    fi

    /opt/trs/bin/llpd rm -rf /lte1460/portMirroringTmp.*
    /opt/trs/bin/llpd rm -rf /tmp/*_UPLANE.pcap > /dev/null
}

ETAG="`date -u +%s 2>/dev/null`"

cat <<EOF
Content-Disposition: attachment; filename="$filename"
Etag: $ETAG
Expires: -1
EOF

cache_control: private

cat <<EOF
Connection: Keep-Alive 800
Content-type: application/x-tar-gz

EOF

collectAndDownloadPcapFile ${1+"$@"} </dev/null 2>/dev/null
