#!/bin/sh

export PATH=$PATH:/usr/local/bin:/bin:/usr/bin:/usr/sbin:/sbin:/opt/trs/bin/
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

trap '' INT TERM PIPE HUP QUIT
trap 'rm -rf /tmp/iptables_test' EXIT

while ! mkdir /tmp/iptables_test 2> /dev/null
do
sleep 1
done

. `dirname "$0"`/../cgi-bin/functions


if [ "$1" != "1" ] ; then
    header 1
fi

TRS_RND_FLAG_CHK_FILE=/tmp/trs_rnd_flag
TRS_RND_FLAG_VALUE=$(cat $TRS_RND_FLAG_CHK_FILE 2>/dev/null)

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

if [ `wasFsmr3` == 1 ] || [ `isFzm` == 1 ] || [ `isFsmr4` -eq 1 ]; then
    if [ -e "/tmp/iptables_addresses.conf" ]; then
        ETH_PORT_SEC=`cat /tmp/iptables_addresses.conf | grep ETHSEC_ENABLE | sed 's/ETHSEC_ENABLE=\([0-1]\)/\1/'` 2>/dev/null
	    MPLANE_IP=`grep IP_MPLANE /tmp/iptables_addresses.conf |awk -F"=" '{print $2}'`
     else
        if [ "$TRS_RND_FLAG_VALUE" = "1" ] && [ `isFzm` != 1 ]; then
            ETH_PORT_SEC=0
        else
            ETH_PORT_SEC=1
        fi
    fi

    UNIT_TYPE=$(test_envInfo envInfoUnitType | grep "UNIT")

    if [ "$UNIT_TYPE" == "UNIT_FSCA" ]; then
      EPORT_LMP=ncpeth1
    elif [ "$UNIT_TYPE" == "UNIT_FCTJ" ]; then
      EPORT_LMP=ethlmp0
    else
      result=`/opt/trs/bin/test_envInfo envInfoIfLMP | cut -d " " -f 3`
      EPORT_LMP=eth$result
    fi

    FCT_SYS_IP=$(get_fct_sys_ip)

    if [ `isFzm` != 1 ] || [ "$1" != "1" ]; then
      llpd /opt/trs/bin/objcli enableOrDisableRndPort RND_PORT_ENABLE >/dev/null
      llpd /opt/trs/bin/objcli updateRndEnabledAlarm raise >/dev/null
    fi

    if [ `isFzm` == 1 ] && [ "eth1" = "$EPORT_LMP" ] ; then
        llpd iptables -D INPUT -p tcp -i $EPORT_LMP+ -m multiport --dport 15001:15005  -j DISCARD_CHAIN 2>/dev/null
        llpd iptables -D INPUT -i $EPORT_LMP+ -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd iptables -D INPUT -i $EPORT_LMP+ -p tcp -m tcp --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd iptables -D INPUT -p tcp -m multiport --dport 15001:15005  -j DISCARD_CHAIN 2>/dev/null
        llpd iptables -D INPUT -i $EPORT_LMP+ -p tcp -m tcp --dport 15001:15005  -j DISCARD_CHAIN 2>/dev/null
        llpd iptables -D INPUT -i br0+ -p tcp -m multiport --dports 15001:15005  -j ACCEPT 2>/dev/null
        llpd iptables -D MP_TRAFFIC -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd iptables -D ETH_SECURITY_DST  -d $FCT_SYS_IP -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd iptables -t mangle -D OUTPUT -p tcp -m multiport --sport 15001:15005  -j CHAIN_MPLANE 2>/dev/null

        llpd ip6tables -D INPUT -p tcp -i $EPORT_LMP+ -m multiport --dport 15001:15005  -j DISCARD_CHAIN 2>/dev/null
        llpd ip6tables -D INPUT -i $EPORT_LMP+ -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd ip6tables -D INPUT -i $EPORT_LMP+ -p tcp -m tcp --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd ip6tables -D INPUT -p tcp -m multiport --dport 15001:15005  -j DISCARD_CHAIN 2>/dev/null
        llpd ip6tables -D INPUT -i $EPORT_LMP+ -p tcp -m tcp --dport 15001:15005  -j DISCARD_CHAIN 2>/dev/null
        llpd ip6tables -D INPUT -i br0+ -p tcp -m multiport --dports 15001:15005  -j ACCEPT 2>/dev/null
        llpd ip6tables -D MP_TRAFFIC -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd ip6tables -D ETH_SECURITY_DST  -d $FCT_SYS_IP -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd ip6tables -t mangle -D OUTPUT -p tcp -m multiport --sport 15001:15005  -j CHAIN_MPLANE 2>/dev/null
 
        if [ $ETH_PORT_SEC == 1 ] ; then
            llpd iptables -I INPUT 1 -p tcp -i $EPORT_LMP+ -m multiport --dport 15001:15005  -j DISCARD_CHAIN 2>/dev/null
            llpd ip6tables -I INPUT 1 -p tcp -i $EPORT_LMP+ -m multiport --dport 15001:15005  -j DISCARD_CHAIN 2>/dev/null
        else
            llpd iptables -I INPUT 1 -p tcp -i $EPORT_LMP+ -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
            llpd ip6tables -I INPUT 1 -p tcp -i $EPORT_LMP+ -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        fi

        llpd iptables -A MP_TRAFFIC -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd iptables -A ETH_SECURITY_DST  -d $FCT_SYS_IP -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd iptables -t mangle -A OUTPUT -p tcp -m multiport --sport 15001:15005  -j CHAIN_MPLANE 2>/dev/null

        llpd ip6tables -A MP_TRAFFIC -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd ip6tables -A ETH_SECURITY_DST  -d $FCT_SYS_IP -p tcp -m multiport --dport 15001:15005  -j ACCEPT 2>/dev/null
        llpd ip6tables -t mangle -A OUTPUT -p tcp -m multiport --sport 15001:15005  -j CHAIN_MPLANE 2>/dev/null
    fi

   if [ `isFzm` == 1 ] ; then
     llpd enableFcmRndAccess > /tmp/iptables_ports_service.conf
     llpd enableFcmRndAccess > /tmp/trs_rnd_flag
   fi

  if [ `isFzm` == 1 ] ; then
    llpd iptables -D FORWARD -s 192.168.255.58/32  -d 192.168.255.126/32 -j ACCEPT 2>/dev/null
    llpd iptables -D FORWARD -s 192.168.255.126/32 -d 192.168.255.58/32  -j ACCEPT 2>/dev/null
    llpd iptables -D FORWARD -s 192.168.255.58/32  -d 192.168.255.130/32 -j ACCEPT 2>/dev/null
    llpd iptables -D FORWARD -s 192.168.255.130/32 -d 192.168.255.58/32  -j ACCEPT 2>/dev/null
    llpd iptables -D FORWARD -s 192.168.255.58/32  -d 192.168.255.100/32 -j ACCEPT 2>/dev/null
    llpd iptables -D FORWARD -s 192.168.255.100/32 -d 192.168.255.58/32  -j ACCEPT 2>/dev/null
   fi

  if [ "$1" != "1" ] ; then
    if [ $ETH_PORT_SEC == 1 ] ; then
      if [ `isFzm` == 1 ] ; then
        llpd iptables -A FORWARD -s 192.168.255.58/32  -d 192.168.255.126/32 -j ACCEPT 2>/dev/null
        llpd iptables -A FORWARD -s 192.168.255.126/32 -d 192.168.255.58/32  -j ACCEPT 2>/dev/null
        llpd iptables -A FORWARD -s 192.168.255.58/32  -d 192.168.255.130/32 -j ACCEPT 2>/dev/null
        llpd iptables -A FORWARD -s 192.168.255.130/32 -d 192.168.255.58/32  -j ACCEPT 2>/dev/null
      fi
      printf "<p>"
      printf "<h3>R&D Ports Service Enabled Successfully</h3>\n"
      printf "</p>"
    else
      printf "<p>"
      printf "<h3>R&D Ports Service Enabled Successfully</h3>\n"
      printf "</p>"
      if [ `isFzm` == 1 ] ; then
        llpd iptables -A FORWARD -s 192.168.255.58/32  -d 192.168.255.126/32 -j ACCEPT 2>/dev/null
        llpd iptables -A FORWARD -s 192.168.255.126/32 -d 192.168.255.58/32  -j ACCEPT 2>/dev/null
        llpd iptables -A FORWARD -s 192.168.255.58/32  -d 192.168.255.100/32 -j ACCEPT 2>/dev/null
        llpd iptables -A FORWARD -s 192.168.255.100/32 -d 192.168.255.58/32  -j ACCEPT 2>/dev/null
      fi
    fi
  fi
fi

if [ "$1" != "1" ] ; then
    ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 125 >/dev/null
    footer
fi

