#!/bin/bash
trap '' PIPE

export PATH=/usr/local/bin:/bin:/usr/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions
POST_DATA=$1
POST_DATA1=`echo $POST_DATA | cut -d '&' -f1`
BUFFER=$(echo $POST_DATA1 | tr '&' ' ' | tr '=' ' ')
        
password='dummy'
current_option=''

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

printf "Content-Type: text/html\r\n\r\n"

if [ -f /opt/trs/bin/FPCiTest ]
then
  CAPTURING_BIN=/opt/trs/bin/FPCiTest
elif [ -f /opt/trs/bin/vtc ]
then
  CAPTURING_BIN=/opt/trs/bin/vtc
else
  CAPTURING_BIN=/opt/trs/bin/trafficCapturing
fi

LOGDOWNLDSTATUS="/tmp/debugLogDownloadStatus"

#Parsing Query String

TIMESTAMP="########"
TOKEN="********"
FILENAME="$%$%$%$%"

parse_query_string ()
{
    declare -a RECV_QUERY_STRING=`echo $1 | cut -d '?' -f2 | sed 's/&/ /g'`
    for element in ${RECV_QUERY_STRING[@]}; do
         name=$( echo $element|cut -d= -f1 )
         value=$( echo $element|cut -d= -f2 )
         if [ $name = "stamp" ]; then
            TIMESTAMP=$value
         elif [ $name = "token" ]; then
            TOKEN=$value
         elif [ $name = "frame" ]; then
            FILENAME=$value
         fi
    done
}

if [ $? = "0" ]; then
 parse_query_string "$POST_DATA"
fi

web_page()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
<script>
function onLoad()
{

 //Set State of the windows
  var stateDocument = window.parent.frames["Eingabe"].document;
  stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
  stateDocument.getElementById("strt").disabled = false;
  stateDocument.getElementById("stp").disabled = true;
  stateDocument.getElementById("getfile").disabled = false;
  var frm = document.getElementById("getpcap");
  var passwd="$password";
  document.getElementById("Password").value=passwd;
  document.getElementById("stamp1").value="$TIMESTAMP";
  document.getElementById("token1").value="$TOKEN";
  document.getElementById("frame1").value="$FILENAME";
  frm.submit();
}
</script>
</HEAD>
<body onload="onLoad()" bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing PCAP File Generation Completed!";
</script>

<form method="post" id="getpcap" action="downloadfile.cgi">
<input type="hidden" NAME="Password" id="Password" SIZE="20" type="password" maxlength="120" ><BR>
<input type=hidden id="stamp1" name=stamp value="########">
<input type=hidden id="token1" name=token value="********">
<input type=hidden id="frame1" name=frame value="$%$%$%$%">
</form>

</body>
</html>
EOF
}

web_page_pcap_download_not_allowed()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
<script>
function onLoad()
{

 //Set State of the windows
  var stateDocument = window.parent.frames["Eingabe"].document;
  stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
  stateDocument.getElementById("strt").disabled = false;
  stateDocument.getElementById("stp").disabled = true;
  stateDocument.getElementById("getfile").disabled = false;
}
</script>
</HEAD>
<body onload="onLoad()" bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h4 id="h1">Warning: While Debug logs download in progress, can not Download Local and Remote IP Traffic Capturing PCAP File.!!</h4>

</body>
</html>
EOF
}

web_page_pcap_generate()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h1">Local and Remote IP Traffic Capturing PCAP File Generation Ongoing!</h3>
<h4 >Don't refresh/click any other link when generation of file is ongoing on this Main window. Otherwise download of file will be interrupted!</h4>
</h5>Note: In case of multiple browser instances/tabs, simultaneously trying to generate PCAP file is not supported. One of them may not show any data. In this case refreshing webpage where data is not available would help!</h5>
</body>
</html>
EOF
}

web_page_pcap_not_allowed()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h1">Debug logs download in progress, Local and Remote IP Traffic Capturing PCAP File Download can not be started!</h3>
<h4 id="h1">Warning: While Debug logs download in progress, can not Download Local and Remote IP Traffic Capturing PCAP File.!!</h4>
</body>
</html>
EOF
}

web_page_pcap_generate2()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing PCAP File Generation Ongoing!";
</script>

</body>
</html>
EOF
}

web_page_invalid_password()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
<script>
function onLoad()
{

 //Set State of the windows
 var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
  stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
 stateDocument.getElementById("strt").disabled = false;
 stateDocument.getElementById("stp").disabled = true;
}
</script>
</HEAD>
<body onload="onLoad()" bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h1">Local and Remote IP Traffic Capturing Stopped if running...!!!</h3>
<h3 >Warning: Password is invalid..PCAP file will not be generated...!!!</h3>
<h4 > 1. Password Should be of minimum 8 characters. </h4>
<h4 > 2. Unsupported Characters [space,'<','{',':','>','"','\','|','^','}','&#96;'] </h4>
</body>
</html>
EOF
}

web_page_invalid_pcap_gen()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h1">Invalid Operation: Can not generate PCAP file in current state....!!!</h3>

</body>
</html>
EOF
}

web_page_no_packet_2()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
  document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing has Not Started / No Data Available!!!";
  var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
  stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
  stateDocument.getElementById("strt").disabled = false;
  stateDocument.getElementById("getfile").disabled = false;
</script>  
</body>
</html>
EOF
}

web_page_no_packet_buff_fail()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
  document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing PCAP File Generation failed due to insufficient memory!!! Retry Gen&Download after a minute !!";
  var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
  stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
  stateDocument.getElementById("strt").disabled = false;
  stateDocument.getElementById("getfile").disabled = false;
</script>
</body>
</html>
EOF
}

web_page_no_packet_file_fail()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
 document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing PCAP File Generation failed due to insufficient memory!!!! Retry Gen&Download after a minute !!";
 var stateDocument = window.top.frames["view"].frames["Eingabe"].document;
 stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
 stateDocument.getElementById("strt").disabled = false;
 stateDocument.getElementById("getfile").disabled = false;
</script>
</body>
</html>
EOF
}

web_page_no_packet()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h1">Local and Remote IP Traffic Capturing Not Started / No Data Available!!!</h3>
<script>
  var stateDocument;
  var v1 =window.top.frames["view"];
  if (v1 == null )
  {
     stateDocument = window.parent.frames["Eingabe"].document;
  }
  else
  {
     stateDocument=v1.frames["Eingabe"].document;
  }
  stateDocument.getElementById("ServerState")[0].value = "SERVER_CAPTURING_STOP";
  stateDocument.getElementById("strt").disabled = false;
  stateDocument.getElementById("getfile").disabled = false;
</script>
</body>
</html>
EOF
}

web_page_aborted()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3 id="h1">PCAP file generation is aborted....!!!</h3>

</body>
</html>
EOF
}

web_page_mem_failed()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.getElementById("h1").innerHTML="Local and Remote IP Traffic Capturing Feature Disabled Due to unavailability of memory...";
</script>

</body>
</html>
EOF
}

web_page_mem_not_allocated()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<HTML><HEAD>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache">
<META HTTP-EQUIV="Expires" CONTENT="-1">
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=iso-8859-1">
</HEAD>
<body bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<script>
document.body.innerHTML = '<h3 id="h1">Memory is not allocated please refresh the page....!!!</h3>';
</script>

</body>
</html>
EOF
}

#header 1
#printf "<h3>Port Mirrorring Argument!!!! %s </h3>" $BUFFER
for i in `echo $BUFFER` ; do
    let n=$n+1
    let m=$n%2
    if [ $m == 1 ]; then
      current_option=${i}
#   else
#      printf "%s=%s" ${current_option} ${i}
#      printf "<p></p>"
    fi
    case ${current_option} in
      Password)
        password=${i:0:123}
        ;;
    esac
done

VAR=$(printf "%s" "$password" | sed 's/+/ /g')
if [ `isFsmr4` -eq 1 ] || [ `isFzm` -eq 1 ]; then
    VAR=$(echo "$VAR" | sed -e's/%\([0-9A-Fa-f][0-9A-Fa-f]\)/\\\\\x\1/g' | xargs echo -e)
else
    VAR=`echo "$VAR" | sed -e's/%\([0-9A-Fa-f][0-9A-Fa-f]\)/\\\\\x\1/g' | xargs echo -e`
fi


#getPortMirrorringFile.cgi: <h4 > 1. Password Should be of minimum 8 and Maximum 40 characters. </h4>
if [ "${#VAR}" -lt 8 ] || [ "${#VAR}" -gt 40 ]; then
  password=invalid
fi

# getPortMirrorringFile.cgi: <h4 > 2. Unsupported Characters [space,'<','{',':','>','"','\','|','^','}'] </h4>
if [[ "$VAR" == *@(' '|'<'|'{'|':'|'>'|'"'|'\'|'|'|'^'|'}'|'`')* ]]; then
  password=invalid
fi

#printf "%s %s" $current_option $password
#printf "<p></p>"
#footer

buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
buffer=${buffer/"PORT MIRRORRING STATUS "/""}

if [ -f "/tmp/portMirrorringMemFailed" ]; then
    web_page_mem_failed
    exit 0
fi
if [ ! -f "/tmp/portMirrorringMemAllocated" ]; then
    web_page_mem_not_allocated
    exit 0
fi

param_details=''
if [ "$password" == "Password" ]; then
    param_details='(password:)'
else
    param_details='(password:XXXXXX)'
fi

if [ $buffer == "TRAFFIC_CAPTURE_START" ]; then
  /opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_stop_test > /dev/null
  /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 142 > /dev/null
  /opt/trs/bin/llpd /opt/trs/bin/objcli port_mirroring raise_alarm stop > /dev/null
fi

buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
buffer=${buffer/"PORT MIRRORRING STATUS "/""}

if [[ $buffer == "TRAFFIC_CAPTURE_STOP" || $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_STOP" || $buffer == "TRAFFIC_CAPTURE_ABORT" || $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_START" || $buffer == "TRAFFIC_CAPTURE_TIMER_EXPIRED" ]]; then

if [[ $buffer != "TRAFFIC_CAPTURE_GEN_PCAP_START" ]]; then
 if [ "$password" == "invalid" ]; then
   web_page_invalid_password
   exit 0
 fi

 if [ `isFsmr4` -eq 1 ] && [[ $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_START" ]]; then
     if [ ! -f $LOGDOWNLDSTATUS ]; then
        web_page_pcap_generate
     else
        web_page_pcap_not_allowed
     fi
 else
     /opt/trs/bin/llpd rm -rf /lte1460/portMirroringTmp.* > /dev/null
     /opt/trs/bin/llpd rm -rf /tmp/*_UPLANE.pcap > /dev/null
     /opt/trs/bin/llpd rm -rf /tmp/portMirroringBuffAccessFail > /dev/null
     /opt/trs/bin/llpd rm -rf /tmp/portMirroringZipFileCreationFail > /dev/null
     if [ ! -f $LOGDOWNLDSTATUS ]; then
        web_page_pcap_generate
        /opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_set_status_test 1 > /dev/null
        /opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_gen_pcap_test "$password" > /dev/null &
     else
        web_page_pcap_not_allowed
     fi
 fi

 /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 143 "$param_details"> /dev/null
 if [ `isFsmr4` -eq 1 ]; then
     logger -s "LTE1460 : PCAP File Generation started"
 fi

 UNIT_FZM=`/opt/trs/bin/test_envInfo envInfoUnitTypeIsFzm | grep "UNIT_FZM"`

 #check if UPLANE packets are enabled
 USER_PLANE=`cat /tmp/portMirrorringConfTmpFile | grep USER_PLANE`
 USER_PLANE=${USER_PLANE/USER_PLANE /}

 #append _UPLANE after the original filename
 FILE_NAME=`cat /tmp/portMirrorringConfTmpFile | grep FILE_NAME`
 FILE_NAME=${FILE_NAME/FILE_NAME /}
 FILENAME_PCAP="${FILE_NAME}_UPLANE"

 if [[ UNIT_FZM == "$UNIT_FZM" ]] && [ 1 == $USER_PLANE ]; then
     /opt/trs/bin/llpd /bin/dd if=/tmp/fuse/iwf/trace of=/tmp/$FILENAME_PCAP.pcap bs=131072
     echo 0 >> /tmp/fuse/iwf/tracing_on
     echo 1 >> /tmp/fuse/iwf/trace_release
 fi

 sleep 2
fi
cnt="0"
while [ 1 ]
 do
   buffer=`/opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_get_status_test | grep "PORT MIRRORRING STATUS"`
   buffer=${buffer/"PORT MIRRORRING STATUS "/""}
   if [[ $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_START" ]]; then
	sleep 5
	cnt=$(( cnt + 1 ))
	if [ $cnt == "7" ]; then
		cnt=0
        if [ ! -f $LOGDOWNLDSTATUS ]; then
           web_page_pcap_generate2
        else
           web_page_pcap_not_allowed
        fi
	fi
   else
        if [[ $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_STOP" || $buffer == "TRAFFIC_CAPTURE_TIMER_EXPIRED" ]]; then
            if [ -f "/lte1460/portMirroringTmp.pcap.gz" -o -f "/lte1460/portMirroringTmp.zip" ]; then
                break
            elif [ -f "/tmp/portMirroringBuffAccessFail" -o -f "/tmp/portMirroringZipFileCreationFail" ]; then
                break
            else
                sleep 3
            fi
        fi
   fi 
 done

 if [[ $buffer == "TRAFFIC_CAPTURE_GEN_PCAP_STOP"  || $buffer == "TRAFFIC_CAPTURE_TIMER_EXPIRED" ]]; then
   if [ -f "/lte1460/portMirroringTmp.zip" ]; then
     if [ ! -f $LOGDOWNLDSTATUS ]; then
        web_page
     else
        /opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_set_status_test 3 > /dev/null
        web_page_pcap_download_not_allowed
     fi
     /opt/trs/bin/llpd rm -rf /tmp/portMirroringBuffAccessFail > /dev/null
     /opt/trs/bin/llpd rm -rf /tmp/portMirroringZipFileCreationFail > /dev/null
   elif [ -f "/lte1460/portMirroringTmp.pcap.gz" ]; then
     if [ ! -f $LOGDOWNLDSTATUS ]; then
        web_page
     else
        /opt/trs/bin/llpd ${CAPTURING_BIN} vtc_traffic_capture_set_status_test 3 > /dev/null
        web_page_pcap_download_not_allowed
     fi
     sleep 3
   elif [ -f "/tmp/portMirroringBuffAccessFail" ]; then
     web_page_no_packet_buff_fail
   elif [ -f "/tmp/portMirroringZipFileCreationFail" ]; then
     web_page_no_packet_file_fail
   else
     web_page_no_packet_2
   fi
 elif [[ $buffer == "TRAFFIC_CAPTURE_ABORT" ]]; then
  web_page_aborted
 fi
else
 if [[ $buffer == "TRAFFIC_CAPTURE_INIT" ]]; then #When no packet captured from previous session or when not captured started
  /opt/trs/bin/ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 145 "$param_details"> /dev/null
 fi
 web_page_no_packet
fi

