#!/bin/sh

export PATH=$PATH:/usr/local/bin:/bin:/usr/bin:/opt/trs/bin

. `dirname "$0"`/../cgi-bin/functions

header 1

function validate_ipv6
{
    INPUT="$@"

    #Get IP value
    INPUT=$(echo $INPUT | cut -d '=' -f2 | cut -d '&' -f1 | sed -e 's/'%3A'/':'/g')
    O=""
    
    while [ "$O" != "$INPUT" ]; do
        O="$INPUT"
        
        # fill all words with zeroes
        INPUT="$( sed 's|:\([0-9a-fA-F]\{3\}\):|:0\1:|g' <<< "$INPUT" )"
        INPUT="$( sed 's|:\([0-9a-fA-F]\{3\}\)$|:0\1|g' <<< "$INPUT")"
        INPUT="$( sed 's|^\([0-9a-fA-F]\{3\}\):|0\1:|g' <<< "$INPUT" )"
        
        INPUT="$( sed 's|:\([0-9a-fA-F]\{2\}\):|:00\1:|g' <<< "$INPUT")"
        INPUT="$( sed 's|:\([0-9a-fA-F]\{2\}\)$|:00\1|g' <<< "$INPUT")"
        INPUT="$( sed 's|^\([0-9a-fA-F]\{2\}\):|00\1:|g' <<< "$INPUT")"
        
        INPUT="$( sed 's|:\([0-9a-fA-F]\):|:000\1:|g' <<< "$INPUT")"
        INPUT="$( sed 's|:\([0-9a-fA-F]\)$|:000\1|g' <<< "$INPUT")"
        INPUT="$( sed 's|^\([0-9a-fA-F]\):|000\1:|g' <<< "$INPUT")"
        INPUT="$( sed 's|^:|0:|g' <<< "$INPUT" )"

    done
    
    # now expand the ::    
    grep -qs "::" <<< "$INPUT"
    if [ "$?" -eq 0 ]; then
        GRPS="$(sed 's|[0-9a-fA-F]||g' <<< "$INPUT" | wc -m)"
        ((GRPS--)) # carriage return
        ((MISSING=8-GRPS))
        for ((i=0;i<$MISSING;i++)); do
            ZEROES="$ZEROES:0000"
        done
        
      # be careful where to place the :
        INPUT="$( sed 's|\(.\)::\(.\)|\1'$ZEROES':\2|g' <<< "$INPUT")"
        INPUT="$( sed 's|\(.\)::$|\1'$ZEROES':0000|g' <<< "$INPUT")"
        INPUT="$( sed 's|^::\(.\)|'$ZEROES':0000:\1|g;s|^:||g' <<< "$INPUT")"
        
    fi
    grep -qs "%" <<< "$INPUT"
    if [ "$?" -eq 0 ]; then
        echo ""
    # an expanded address has 39 chars + CR
    elif [ $(echo $INPUT | wc -m) != 40 ]; then
        echo ""
    else
        echo $INPUT
    fi
}


IPADDR6=$(validate_ipv6 $QUERY_STRING)
#IPADDR=$(echo $QUERY_STRING|sed -e 's/.*ip= *\(\([0-9]\{1,3\}\.\)\{3,3\}[0-9]\{1,3\}\)$/\1/g ')
IPADDR=`echo $QUERY_STRING | cut -d '&' -f1 | cut -d '=' -f2 `
if [[ $IPADDR =~ ^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$ ]]; then
    IP=$(echo $IPADDR | awk -F'.' 'NF ==4 && $1 >0 && $1<=255 && $2 >= 0 && $2 <=255 && $3 >= 0 && $3 <=255 && $4 >=0 && $4 <=255')
fi
echo "<pre>"
if [ -n "$IP" ]; then
    printf "<p>"
    printf "<h3>Ping result for host %s</h3>\n" $IP
    printf "</p>"
    if [ `getProduct` == "LTE_WMP" ]; then
        /opt/trs/bin/llpd ping -c 4 $IP 2>&1
    else
        ping -c 4 $IP 2>&1
    fi
    echo '<h3> ping ready ... </h3>'
elif [ -n "$IPADDR6" ]; then
    printf "<p>"
    printf "<h3>Ping result for host %s</h3>\n" $IPADDR6
    printf "</p>"
    if [ `getProduct` == "LTE_WMP" ]; then
        /opt/trs/bin/llpd ping6 -c 4 $IPADDR6 2>&1
    else
        ping6 -c 4 $IPADDR6 2>&1
    fi
    echo '<h3> ping ready ... </h3>'
else
    printf "<p>"
    printf "<h3>Ping result </h3>\n" 
    printf "</p>"
    echo "invalid supplied IP address"
fi
echo "</pre>"

footer
