#!/bin/bash
trap '' PIPE

export PATH=/usr/local/bin:/bin:/usr/bin:/www/html/cgi-bin
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions

STATUS_CLI=`/opt/trs/bin/llpd /opt/trs/bin/objcli WpaSupplicant status`
PORT_SECURITY_STATUS=$( echo "$STATUS_CLI" | tr -d ">" | tr -d "\r\n<" )
if [ $PORT_SECURITY_STATUS == "ENABLED" ]; then
    SUPPLICANT_STATUS_STRING=`/opt/trs/bin/llpd /opt/trs/bin/objcli WpaSupplicant supplicantStatus`
    SUPPLICANT_STATUS_STRING=$( echo "$SUPPLICANT_STATUS_STRING" | tr -d ">" | tr -d "\r\n<" )
    SUPPLICANT_PAE_STATE="$(echo "$SUPPLICANT_STATUS_STRING" | cut -d':' -f2 |cut -d '|' -f1)"
    SUPPLICANT_PORT_STATUS="$(echo "$SUPPLICANT_STATUS_STRING" | cut -d':' -f3 |cut -d '|' -f1)"
    SUPPLICANT_EAP_STATE="$(echo "$SUPPLICANT_STATUS_STRING" | cut -d':' -f4 |cut -d '|' -f1)"
    EAP_AUTH_TIME=`/opt/trs/bin/llpd /opt/trs/bin/objcli WpaSupplicant lastEAPAuthTime`
    EAP_AUTH_TIME=$( echo "$EAP_AUTH_TIME" | tr -d ">" | tr -d "\r\n<" )
    LOG_LEVEL=`/opt/trs/bin/llpd /opt/trs/bin/objcli WpaSupplicant logLevel`
	LOG_LEVEL=$( echo "$LOG_LEVEL" | tr -d "> " | tr -d " \r\n<" )
fi

server_response
web_page()
{
cat <<EOF
<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<html>
<head>
   <META HTTP-EQUIV="Cache-control" CONTENT="no-store">
   <META HTTP-EQUIV="Pragma" CONTENT="no-cache">
   <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
   <meta http-equiv="refresh" content="540">
</head>
<body onload bgcolor="#E7E7E7">

<bgcolor="#00FF00" text="#000000" link="#A00000" vlink="#600000" alink="#A00000">

<h3><FONT face="Arial, Helvetica, sans-serif">
  <font color="#000000">Port-based Network Access Security</FONT></h3>
<br><br>
<p> PNASC Status : <b> $PORT_SECURITY_STATUS</b> </p>
EOF
}

web_page_parameters()
{
cat <<EOF
<p> Supplicant PAE state      :<b>$SUPPLICANT_PAE_STATE</b></p>
<p>    Supplicant Port Status :<b>$SUPPLICANT_PORT_STATUS</b> </p>
<p>    EAP state              :<b>$SUPPLICANT_EAP_STATE</b></p>
<p>    Last EAP Auth Time     :<b>$EAP_AUTH_TIME</b>
<p>
Logging Level:
<select id="logLevelList">
  <option id="info" value="info">INFO</option>
  <option id="error" value="error">ERROR</option>
  <option id="debug" value="debug">DEBUG</option>
  <option id="warning" value="warning">WARNING</option>
  <option id="msgdump" value="msgdump">MSGDUMP</option>
</select>
<button type="button" onclick="changeLogLevel()" >Submit</button>
</p>
<script>
document.getElementById("$LOG_LEVEL").selected=true;
function changeLogLevel()
{
     var listObject = document.getElementById("logLevelList");
     var logLevelValue= listObject.options[listObject.selectedIndex].value;
     var http = new XMLHttpRequest();
     var url = "/protected/portNetworkAccessSecurityLogLevel.cgi";
     http.open("POST", url, true);

     //Send the proper header information along with the request
     http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");

     http.onreadystatechange = function()
	 {
		if(http.readyState == 4 && http.status == 200)
		{
			alert(http.responseText);
		}
	 }
     http.send(logLevelValue);
}
</script>
EOF
}
footer()
{

cat <<EOF
</body>
</html>
EOF
}
web_page
if [ $PORT_SECURITY_STATUS == "ENABLED" ]; then
    web_page_parameters
fi
footer
