#!/bin/sh

export PATH=$PATH:/usr/local/bin:/bin:/usr/bin:/usr/sbin:/sbin:/opt/trs/bin/
export LD_LIBRARY_PATH=/usr/local/lib:/usr/lib

. `dirname "$0"`/../cgi-bin/functions

header 1
test_envInfo envInfoUnitType >/dev/null
UNIT=$?
unitIsFzm=$(isFzm)
modeIsRP441=$(isRP441)

if [ $unitIsFzm -eq 1 ]; then
    trap '' INT TERM PIPE HUP QUIT
    trap 'rm -rf /tmp/iptables_test' EXIT
    while ! mkdir /tmp/iptables_test 2> /dev/null
    do
        sleep 1
    done
fi

if [ -f /tmp/user_name.txt ]; then
    export REMOTE_USER=`cat /tmp/user_name.txt`
fi

if [ $UNIT -lt 15 ]; then  #FSMR2
    /etc/rc.d/init.d/sshd status
    if [ $? = 0 ]; then
        status=1
    else
        status=0
    fi
else
    if [ $unitIsFzm -eq 1 ]; then
        #FZM
        llpd iptables -vnL | grep -E ["eth1|br0"] | grep "dpt:22" | grep ACCEPT  >/dev/null
        status=`echo $?`
        if [ $status == 0 ] ; then
            status=1
        else
            status=0
        fi
    else
        #FSMR3
        llpd /opt/trs/bin/objcli getStatus SSH |grep 0 > /dev/null
        status=`echo $?`

    fi
fi

ruemUdpClient "$REMOTE_USER" $REMOTE_ADDR 1 124 >/dev/null

if test $status == 0 ; then
  printf "<p>"
  printf "<h3>SSH Service Status is Disabled</h3>\n"
  printf "<p>"
else
  printf "<p>"
  printf "<h3>SSH Service Status is Enabled</h3>\n"
  printf "</p>"
fi

if [ `isFsmr4` -eq 1 ] || [ $UNIT -lt 15 ]; then  #FSMr4 or FSMR2
  ssh-keygen -l -f /etc/ssh/ssh_host_rsa_key.pub
else
  ssh-keygen -l -f /ffs/run/etc/ssh/ssh_host_rsa_key.pub
fi
printf "</p>"
printf "</p>"
printf "</p>"

if [ $UNIT -lt 15 ]; then  #FSMR2
  w | grep pts > /tmp/file
  awk < /tmp/file '{ print $1, $3 ,$4}' >/tmp/file1
  IN="`cat /tmp/file1`"

  arr=$(echo $IN | tr " " "\n")
  count=0
  for x in $arr
  do
    echo -n "$x "
    if [ $count = 2 ]; then
      count=0
      printf "<p>"
      echo ""
    else
      count=`expr $count + 1`
    fi
  done
else  

  if test $status == 1 ; then

    if [ $unitIsFzm -eq 1 ]; then
      PGREP_CMD="pgrep -lfa"
    else
      PGREP_CMD="pgrep -lf"
    fi
    printf "INTERACTIVE SESSION"
    printf "<p>"

    #LTE1266/RP441/RAN2860
    if [ $modeIsRP441 -eq 1 ]; then

      if [ $unitIsFzm == 0 ]; then
          llpd /opt/trs/bin/objcli hostcmd ps -aef | grep sshd | grep pts | grep -v grep | awk -v OFS='\t' '{print $2, $3, $8, $9}' > /tmp/pts
          cat /tmp/pts | while read pid ppid name info ;
        do
          llpd /opt/trs/bin/objcli hostcmd ls -ld /proc/`echo $pid` | sed 's/^> //' > /tmp/date;
          IN=`awk < /tmp/date '{ print $6, $7,$8}'`;
          llpd /opt/trs/bin/objcli hostcmd netstat -tpneW | grep " $pid\|$ppid" | sed 's/^> //' > /tmp/ip;
          IP=`awk < /tmp/ip '{ print $5}'`;
          echo  ${info%%@*} $IN $IP;
          printf "<p>"
        done
      else
          llpd /opt/trs/bin/objcli hostcmd ${PGREP_CMD} sshd | grep "pts\|priv" 2>/dev/null | sed 's/^> //'  > /tmp/pts
          cat /tmp/pts | while read pid name info ;
        do
          llpd /opt/trs/bin/objcli hostcmd ls -ld /proc/`echo $pid` | sed 's/^> //' > /tmp/date;
          IN=`awk < /tmp/date '{ print $6, $7,$8}'`;
            llpd /opt/trs/bin/objcli hostcmd netstat -tpneW | grep "$pid" | sed 's/^> //' > /tmp/ip;
            IP=`awk < /tmp/ip '{ print $5}'`;
            echo  ${info%%[[\|@]*} $IN $IP;
            printf "<p>"
         done
        fi

      if [ ! -f /tmp/ip ]; then
        printf "No active session"
        printf "<p>";
      fi

      rm /tmp/pts;
      rm /tmp/ip;
      rm /tmp/date;

    else
      ps -ef | grep sshd | grep pts | grep -v grep | awk -v OFS='\t' '{print $2, $3, $8, $9}' > /tmp/pts
      cat /tmp/pts | while read pid ppid name info ;
      do
        ls -ld /proc/`echo $pid` | tr -s ' ' > /tmp/date;
        IN=`awk < /tmp/date '{ print $6, $7,$8}'`;
        llpd  netstat -tpneW | grep " $pid\|$ppid" | sed 's/^> // ' > /tmp/ip;
        IP=`awk < /tmp/ip '{ print $5}'`;
        echo  ${info%%@*} $IN $IP;
        printf "<p>"
      done

      if [ ! -f /tmp/ip ]; then
        printf "No active session"
        printf "<p>";
      fi

      rm /tmp/ip;
      rm /tmp/date;
      rm /tmp/pts;

    fi

    printf "NON INTERACTIVE SESSION"
    printf "<p>"

    #LTE1266/RP441/RAN2860
    if [ $modeIsRP441 -eq 1 ]; then

      if [ `isFsmr4` -eq 1 ]; then
        llpd /opt/trs/bin/objcli hostcmd ps -aef | grep sshd | grep notty | grep -v grep | awk -v OFS='\t' '{print $2, $8, $9}' > /tmp/notty
      else
        llpd /opt/trs/bin/objcli hostcmd ${PGREP_CMD} sshd | grep notty 2>/dev/null | sed 's/^> //' > /tmp/notty
      fi

      cat /tmp/notty | while read pid name info ;
      do
        llpd  /opt/trs/bin/objcli hostcmd ls -ld /proc/`echo $pid` | sed 's/^> //' > /tmp/date;
        IN=`awk < /tmp/date '{ print $6, $7,$8}'`;
        llpd  /opt/trs/bin/objcli hostcmd netstat -tpneW | grep " $pid/" | sed 's/^> //'> /tmp/ip;
        IP=`awk < /tmp/ip '{ print $5}'`;
        echo  ${info%%@*} $IN $IP;
        printf "<p>"
      done
  
      if [ ! -f /tmp/ip ]; then
        printf "No active session"
        printf "<p>";
      fi

      rm /tmp/notty;
      rm /tmp/ip;
      rm /tmp/date;

    else
      ${PGREP_CMD} sshd | grep notty | while read pid name info ;
      do
        ls -ld /proc/`echo $pid` | tr -s ' ' > /tmp/date;
        IN=`awk < /tmp/date '{ print $6, $7,$8}'`;
        llpd  netstat -tpneW | grep " $pid/" | tr -s ' ' > /tmp/ip;
        IP=`awk < /tmp/ip '{ print $5}'`;
        echo  ${info%%@*} $IN $IP;
        printf "<p>"
      done

      if [ ! -f /tmp/ip ]; then
        printf "No active session"
        printf "<p>";
      fi
  
      rm /tmp/ip;
      rm /tmp/date;
    fi
  fi
fi
footer
