/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.e2k.CarrierInfo;
import org.e2k.CircularDataBuffer;
import org.e2k.Complex;
import org.e2k.OFDM;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class AT3x04
extends OFDM {
    private int state = 0;
    private Rivet theApp;
    private long sampleCount = 0L;
    private long symbolCounter = 0L;
    private double samplesPerSymbol;
    private int[][][] carrierBinNos = new int[12][20][2];
    private double totalCarriersEnergy;
    private double[] mag = new double[3];
    private final int TIMINGBUFFERSIZE = 3;
    private int timingBufferCounter = 0;
    private double[] timingBuffer = new double[3];
    double[] realV = new double[12];
    double[] imagV = new double[12];
    List<CarrierInfo> startCarrierList1 = new ArrayList<CarrierInfo>();
    List<CarrierInfo> startCarrierList2 = new ArrayList<CarrierInfo>();
    List<CarrierInfo> startCarrierList3 = new ArrayList<CarrierInfo>();
    private int startCarrierCounter = 0;
    private int pilotToneBin = 0;

    public AT3x04(Rivet tapp) {
        this.theApp = tapp;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 0) {
            this.theApp.setStatusLabel("Setup");
        } else if (state == 1) {
            this.theApp.setStatusLabel("Signal Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Msg Hunt");
        }
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nAT3x04 recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.samplesPerSymbol = this.samplesPerSymbol(120.0, waveData.getSampleRate());
            this.startCarrierCounter = 0;
            this.theApp.writeLine("Please note that this mode is experimental and doesn't work yet !", Color.RED, this.theApp.italicFont);
            this.setState(1);
            return true;
        }
        if (this.state == 1) {
            ++this.sampleCount;
            if (this.sampleCount < 0L) {
                return true;
            }
            if (this.sampleCount % 100L == 0L) {
                double[] spr = this.doRDFTFFTSpectrum(circBuf, waveData, 0, true, 800, true);
                if (this.startCarrierCounter == 0) {
                    this.startCarrierList1 = this.findOFDMCarriersWithinRange(spr, waveData.getSampleRate(), 800, 0.8, 270, 350);
                    ++this.startCarrierCounter;
                } else if (this.startCarrierCounter == 1) {
                    this.startCarrierList2 = this.findOFDMCarriersWithinRange(spr, waveData.getSampleRate(), 800, 0.8, 270, 350);
                    ++this.startCarrierCounter;
                } else if (this.startCarrierCounter == 2) {
                    this.startCarrierList3 = this.findOFDMCarriersWithinRange(spr, waveData.getSampleRate(), 800, 0.8, 270, 350);
                    ++this.startCarrierCounter;
                } else if (this.startCarrierCounter == 3) {
                    if (this.AT3x04PilotToneHunt(spr)) {
                        List<CarrierInfo> clist = this.findOFDMCarriers(spr, waveData.getSampleRate(), 800, 0.8);
                        if (this.AT3x04CarrierConfirm(clist)) {
                            this.setState(2);
                            this.sampleCount = 0L;
                            this.populateCarrierTonesBins();
                            StringBuilder sb = new StringBuilder();
                            double toneFreq = this.pilotToneBin * 10;
                            sb.append(this.theApp.getTimeStamp() + " AT3x04 Pilot Tone found at " + Double.toString(toneFreq) + " Hz");
                            sb.append(" , Carrier 12 at " + Double.toString(toneFreq -= 400.0) + " Hz");
                            sb.append(" + Carrier 1 at " + Double.toString(toneFreq -= 2200.0) + " Hz");
                            this.theApp.writeLine(sb.toString(), Color.BLACK, this.theApp.boldFont);
                        }
                    } else {
                        this.startCarrierCounter = 0;
                    }
                }
            }
        } else if (this.state == 2) {
            double[] ri;
            ++this.sampleCount;
            double[] r = this.doRDFTFFTSpectrum(circBuf, waveData, 0, false, (int)this.samplesPerSymbol, false);
            List<Complex> sc = this.extractCarrierSymbols(r);
            double rv = sc.get(11).getReal();
            double iv = sc.get(11).getImag();
            double mg = sc.get(11).getMagnitude();
            String line = Double.toString(rv) + "," + Double.toString(iv) + "," + Double.toString(mg);
            if (this.sampleCount == 17L) {
                ri = this.doRDFTFFTSpectrum(circBuf, waveData, 0, false, (int)this.samplesPerSymbol, false);
                this.extractCarrierSymbols(ri);
                this.mag[0] = this.totalCarriersEnergy;
                line = line + ",0";
            } else if (this.sampleCount == 33L) {
                ri = this.doRDFTFFTSpectrum(circBuf, waveData, 0, false, (int)this.samplesPerSymbol, false);
                List<Complex> symbolComplex = this.extractCarrierSymbols(ri);
                this.mag[1] = this.totalCarriersEnergy;
                for (int a = 0; a < symbolComplex.size(); ++a) {
                    this.realV[a] = symbolComplex.get(a).getReal();
                    this.imagV[a] = symbolComplex.get(a).getImag();
                }
                line = line + ",10000";
            } else if (this.sampleCount == 49L) {
                ri = this.doRDFTFFTSpectrum(circBuf, waveData, 0, false, (int)this.samplesPerSymbol, false);
                this.extractCarrierSymbols(ri);
                this.mag[2] = this.totalCarriersEnergy;
                line = line + ",0";
            } else {
                line = line + ",0";
            }
            if (this.sampleCount == 66L) {
                double pdif;
                double d;
                ++this.symbolCounter;
                double total = this.mag[0] + this.mag[2];
                if (this.mag[0] > this.mag[2]) {
                    d = this.mag[0] - this.mag[2];
                    pdif = d / total * 100.0;
                    pdif = 0.0 - pdif;
                } else {
                    d = this.mag[2] - this.mag[0];
                    pdif = d / total * 100.0;
                }
                this.addToTimingBuffer(pdif);
                pdif = this.getBufferAverage();
                this.sampleCount = (long)pdif / 5L;
                StringBuffer sb = new StringBuffer();
                sb.append(Long.toString(this.symbolCounter) + ",");
                for (int a = 0; a < 12; ++a) {
                    sb.append(Double.toString(this.realV[a]) + "," + Double.toString(this.imagV[a]) + ",");
                }
                sb.append(Double.toString(pdif));
            }
        }
        return true;
    }

    private boolean AT3x04PilotToneHunt(double[] spectrum) {
        for (int a = this.startCarrierList1.size() - 1; a >= 0; --a) {
            int pbin = this.startCarrierList1.get(a).getBinFFT();
            if (!this.checkBinExists(this.startCarrierList2, pbin) || !this.checkBinExists(this.startCarrierList3, pbin)) continue;
            this.pilotToneBin = pbin;
            return true;
        }
        return false;
    }

    private boolean checkBinExists(List<CarrierInfo> cil, int bin) {
        for (int a = 0; a < cil.size(); ++a) {
            if (cil.get(a).getBinFFT() != bin) continue;
            return true;
        }
        return false;
    }

    private boolean AT3x04CarrierConfirm(List<CarrierInfo> clist) {
        int a;
        int[] expectedCarrierBins = new int[12];
        int p = this.pilotToneBin - 40;
        int findCounter = 0;
        for (a = 11; a >= 0; --a) {
            expectedCarrierBins[a] = p;
            p -= 20;
        }
        for (a = 0; a < clist.size(); ++a) {
            for (int b = 0; b < 12; ++b) {
                double dif = Math.abs(clist.get(a).getBinFFT() - expectedCarrierBins[b]);
                if (!(dif < 2.0)) continue;
                ++findCounter;
            }
        }
        return findCounter >= 6;
    }

    private void populateCarrierTonesBins() {
        int lastCarrierBin = this.pilotToneBin - 40;
        for (int carrierNos = 11; carrierNos >= 0; --carrierNos) {
            int mod = -10;
            for (int binNos = 0; binNos < 20; ++binNos) {
                int rb = lastCarrierBin + mod;
                this.carrierBinNos[carrierNos][binNos][0] = this.returnRealBin(rb);
                this.carrierBinNos[carrierNos][binNos][1] = this.returnImagBin(rb);
                ++mod;
            }
            lastCarrierBin -= 20;
        }
    }

    private double[] recoverCarrier(int carrierNo, double[] spectrumIn) {
        double[] spectrum = new double[spectrumIn.length];
        for (int b = 0; b < 20; ++b) {
            int rBin = this.carrierBinNos[carrierNo][b][0];
            int iBin = this.carrierBinNos[carrierNo][b][1];
            spectrum[rBin] = spectrumIn[rBin];
            spectrum[iBin] = spectrumIn[iBin];
        }
        this.RDFTfft.realInverse(spectrum, false);
        return spectrum;
    }

    private List<Complex> extractCarrierSymbols(double[] fdata) {
        ArrayList<Complex> complexList = new ArrayList<Complex>();
        this.totalCarriersEnergy = 0.0;
        for (int carrierNo = 0; carrierNo < 12; ++carrierNo) {
            Complex total = new Complex();
            for (int b = 0; b < 20; ++b) {
                int rBin = this.carrierBinNos[carrierNo][b][0];
                int iBin = this.carrierBinNos[carrierNo][b][1];
                Complex tbin = new Complex(fdata[rBin], fdata[iBin]);
                total = total.add(tbin);
            }
            complexList.add(total);
            this.totalCarriersEnergy += total.getMagnitude();
        }
        return complexList;
    }

    private void addToTimingBuffer(double in) {
        this.timingBuffer[this.timingBufferCounter] = in;
        ++this.timingBufferCounter;
        if (this.timingBufferCounter == 3) {
            this.timingBufferCounter = 0;
        }
    }

    private double getBufferAverage() {
        double total = 0.0;
        double size = 0.0;
        for (int a = 0; a < this.timingBuffer.length; ++a) {
            total += this.timingBuffer[a];
            size += 1.0;
        }
        return total / size;
    }
}

