/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.io.FileWriter;
import java.text.DateFormat;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

class AudioMixer {
    public String description;
    public Mixer mixer;
    public TargetDataLine line;
    public Line.Info lineInfo;
    public AudioFormat format = null;
    private String errorMsg;
    private boolean debugAudio = false;

    public AudioMixer() {
        this.setDefaultLine();
    }

    public AudioMixer(String x, Mixer m, Line.Info l) {
        this.description = x;
        this.mixer = m;
        this.lineInfo = l;
    }

    public Mixer getMixer() {
        return this.mixer;
    }

    public void setMixer(Mixer mixer) {
        this.mixer = mixer;
    }

    public TargetDataLine getLine() {
        return this.line;
    }

    public void setLine(TargetDataLine line) {
        this.line = line;
    }

    public void setAudioFormat(AudioFormat tformat) {
        this.format = tformat;
    }

    private AudioFormat getFormat() {
        if (this.format == null) {
            return new AudioFormat(8000.0f, 16, 1, true, true);
        }
        return this.format;
    }

    public void setDefaultLine() {
        Mixer mx = AudioSystem.getMixer(null);
        this.setMixer(mx);
        DataLine.Info info = this.getDataLineInfo();
        try {
            this.line = (TargetDataLine)AudioSystem.getLine(info);
        }
        catch (LineUnavailableException ex) {
            String err = "setDefaultLine() : " + ex.getMessage();
            this.audioDebugDump(err);
        }
    }

    private DataLine.Info getDataLineInfo() {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.format);
        if (!AudioSystem.isLineSupported(info)) {
            this.audioDebugDump("getDataLineInfo() : Error");
        }
        return info;
    }

    public Line getDataLineForMixer() {
        TargetDataLine line = null;
        try {
            line = (TargetDataLine)this.mixer.getLine(this.getDataLineInfo());
        }
        catch (LineUnavailableException e) {
            String err = "getDataLineForMixer() : " + e.getMessage();
            this.audioDebugDump(err);
        }
        return line;
    }

    public boolean openLine() {
        try {
            this.line.open(this.getFormat());
            return true;
        }
        catch (LineUnavailableException e) {
            this.errorMsg = "openLine() : " + e.getMessage();
            this.audioDebugDump(this.errorMsg);
            return false;
        }
    }

    public boolean changeMixer(String mixerName) {
        Mixer mx = null;
        try {
            this.line.stop();
            this.line.close();
            this.line.flush();
            if (this.debugAudio) {
                this.audioDebugDump("changeMixer() : mixerName=" + mixerName);
            }
            if ((mx = this.getMixer(mixerName)) == null) {
                if (this.debugAudio) {
                    this.audioDebugDump("changeMixer() : mx==null");
                }
                return false;
            }
            this.setMixer(mx);
            this.line = (TargetDataLine)this.getDataLineForMixer();
            if (!this.openLine()) {
                if (this.debugAudio) {
                    this.audioDebugDump("changeMixer() : openLine()==false");
                }
                return false;
            }
            this.line.start();
        }
        catch (Exception e) {
            this.errorMsg = "changeMixer() : " + e.getMessage();
            if (mx != null) {
                Mixer.Info mInfo = mx.getMixerInfo();
                this.errorMsg = this.errorMsg + "\nMixer Name : " + mInfo.getName() + "\nMixer Description : " + mInfo.getDescription();
            }
            this.audioDebugDump(this.errorMsg);
            return false;
        }
        return true;
    }

    public Mixer getMixer(String mixerName) {
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        if (this.debugAudio) {
            this.audioDebugDump("getMixer() : Hunting for " + mixerName);
        }
        for (int i = 0; i < mixers.length; ++i) {
            Mixer m = AudioSystem.getMixer(mixers[i]);
            if (this.debugAudio) {
                this.audioDebugDump("getMixer() : Found " + m.getMixerInfo().getName() + " + " + m.getMixerInfo().getDescription());
            }
            boolean isCaptureDevice = m.getMixerInfo().getDescription().endsWith("Capture");
            if (!m.getMixerInfo().getName().equals(mixerName) || !isCaptureDevice) continue;
            if (this.debugAudio) {
                this.audioDebugDump("getMixer() : Match !");
            }
            return m;
        }
        if (this.debugAudio) {
            this.audioDebugDump("getMixer() : Nothing found !");
        }
        return null;
    }

    public Mixer.Info getMixerInfo(String mixerName) {
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        this.audioDebugDump("getMixerInfo() : Hunting for " + mixerName);
        for (int i = 0; i < mixers.length; ++i) {
            Mixer m = AudioSystem.getMixer(mixers[i]);
            if (this.debugAudio) {
                this.audioDebugDump("getMixerInfo() : Found " + m.getMixerInfo().getName() + " + " + m.getMixerInfo().getDescription());
            }
            boolean isCaptureDevice = m.getMixerInfo().getDescription().endsWith("Capture");
            if (!m.getMixerInfo().getName().equals(mixerName) || !isCaptureDevice) continue;
            if (this.debugAudio) {
                this.audioDebugDump("getMixerInfo() : Match !");
            }
            return m.getMixerInfo();
        }
        if (this.debugAudio) {
            this.audioDebugDump("getMixerInfo() : Nothing found !");
        }
        return null;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void stopAudio() {
        if (this.line.isOpen()) {
            this.line.stop();
            this.line.close();
        }
    }

    public void audioDebugDump(String line) {
        try {
            Date now = new Date();
            DateFormat df = DateFormat.getTimeInstance();
            FileWriter dfile = new FileWriter("audioDebug.txt", true);
            dfile.write(df.format(now) + " " + line);
            dfile.write("\r\n");
            dfile.flush();
            dfile.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}

