/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.e2k.CircularDataBuffer;
import org.e2k.FSK;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class CCIR493
extends FSK {
    private int state = 0;
    private double samplesPerSymbol;
    private Rivet theApp;
    public long sampleCount = 0L;
    private long symbolCounter = 0L;
    public StringBuilder lineBuffer = new StringBuilder();
    private int highTone;
    private int lowTone;
    private int messageState;
    private int highBin;
    private int lowBin;
    private int buffer10 = 0;
    private int buffer20 = 0;
    private int dx;
    private int rx;
    private int formatSpecifier;
    private int bitCount = 0;
    private int[] messageBuffer = new int[20];
    private int invertedPDXCounter;
    private int unCorrectedInput;
    private final int[] VALIDWORDS = new int[]{7, 518, 262, 773, 134, 645, 389, 900, 70, 581, 325, 836, 197, 708, 452, 963, 38, 549, 293, 804, 165, 676, 420, 931, 101, 612, 356, 867, 228, 739, 483, 994, 22, 533, 277, 788, 149, 660, 404, 915, 85, 596, 340, 851, 212, 723, 467, 978, 53, 564, 308, 819, 180, 691, 435, 946, 116, 627, 371, 882, 243, 754, 498, 1009, 14, 525, 269, 780, 141, 652, 396, 907, 77, 588, 332, 843, 204, 715, 459, 970, 45, 556, 300, 811, 172, 683, 427, 938, 108, 619, 363, 874, 235, 746, 490, 1001, 29, 540, 284, 795, 156, 667, 411, 922, 92, 603, 347, 858, 219, 730, 474, 985, 60, 571, 315, 826, 187, 698, 442, 953, 123, 634, 378, 889, 250, 761, 505, 1016};
    private final int[] BITVALUES = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512};
    private final double KALMAN1 = 0.99;
    private final double KALMAN2 = 0.009;
    private final double EARLYLATEADJUST = 5.0;

    public CCIR493(Rivet tapp) {
        this.theApp = tapp;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nCCIR493-4 recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.samplesPerSymbol = this.samplesPerSymbol(100.0, waveData.getSampleRate());
            this.state = 1;
            this.lineBuffer.delete(0, this.lineBuffer.length());
            this.messageState = 0;
            this.theApp.setStatusLabel("Sync Hunt");
            return true;
        }
        if (this.state == 1) {
            ++this.sampleCount;
            if (this.sampleCount < 0L) {
                return true;
            }
            if (this.detectSync(circBuf, waveData)) {
                this.state = 2;
                this.lineBuffer.delete(0, this.lineBuffer.length());
                this.rx = 0;
                this.dx = 0;
                this.buffer10 = 0;
                this.buffer20 = 0;
                this.bitCount = 0;
                this.invertedPDXCounter = 0;
                if (this.theApp.isDebug()) {
                    String dout = this.theApp.getTimeStamp() + " CCIR493-4 Sync Found";
                    this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
                }
                this.clearMessageBuffer();
                return true;
            }
        }
        if (this.state == 2 && this.symbolCounter >= (long)this.samplesPerSymbol) {
            boolean bit = this.getSymbolFreqBin(circBuf, waveData, 0);
            this.handleTraffic(bit);
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    private boolean detectSync(CircularDataBuffer circBuf, WaveData waveData) {
        int pos = 0;
        int f0 = this.getSymbolFreq(circBuf, waveData, pos);
        int b0 = this.getFreqBin();
        if (this.getPercentageOfTotal() < 10.0) {
            return false;
        }
        pos = (int)this.samplesPerSymbol * 1;
        int f1 = this.getSymbolFreq(circBuf, waveData, pos);
        int b1 = this.getFreqBin();
        if (f0 == f1) {
            return false;
        }
        if (f0 > f1) {
            this.highTone = f0;
            this.highBin = b0;
            this.lowTone = f1;
            this.lowBin = b1;
        } else {
            this.highTone = f1;
            this.highBin = b1;
            this.lowTone = f0;
            this.lowBin = b0;
        }
        int shift = this.highTone - this.lowTone;
        if (this.lowBin == 0 || this.highBin == 0) {
            return false;
        }
        return shift >= 150 && shift < 190;
    }

    private int getSymbolFreq(CircularDataBuffer circBuf, WaveData waveData, int start) {
        int fr = this.doCCIR493_160FFT(circBuf, waveData, start);
        return fr;
    }

    private boolean getSymbolFreqBin(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] early = this.do160FFTHalfSymbolBinRequest(circBuf, start, this.lowBin, this.highBin);
        double[] late = this.do160FFTHalfSymbolBinRequest(circBuf, start += (int)this.samplesPerSymbol / 2, this.lowBin, this.highBin);
        double lowTotal = early[0] + late[0];
        double highTotal = early[1] + late[1];
        boolean bit = !this.theApp.isInvertSignal() ? lowTotal > highTotal : !(lowTotal > highTotal);
        if (lowTotal > highTotal) {
            this.kalmanFilter(this.getPercentageDifference(early[0], late[0]), 0.99, 0.009);
        } else {
            this.kalmanFilter(this.getPercentageDifference(early[1], late[1]), 0.99, 0.009);
        }
        this.symbolCounter = this.adjAdjust();
        return bit;
    }

    private int adjAdjust() {
        double r = Math.abs(this.kalmanNew) / 5.0;
        if (this.kalmanNew < 0.0) {
            r = 0.0 - r;
        }
        return (int)r;
    }

    private void handleTraffic(boolean b) {
        String[] outLines = new String[3];
        this.addTo10BitBuffer(b);
        this.addTo20BitBuffer(b);
        ++this.bitCount;
        if (this.messageState == 0) {
            int c;
            if (this.buffer10 == 262) {
                if (this.theApp.isDebug()) {
                    outLines[0] = this.theApp.getTimeStamp() + " CCIR493-4 Inverted PDX";
                }
                ++this.invertedPDXCounter;
            }
            if (this.invertedPDXCounter == 2) {
                this.invertedPDXCounter = 0;
                ++this.dx;
                if (this.theApp.isInvertSignal()) {
                    this.theApp.setInvertSignal(false);
                } else {
                    this.theApp.setInvertSignal(true);
                }
                this.invertBuffer10();
            }
            if ((c = this.ret10BitCode(this.buffer10, false)) == 125) {
                if (this.theApp.isDebug()) {
                    outLines[0] = this.theApp.getTimeStamp() + " CCIR493-4 PDX";
                }
                ++this.dx;
            } else if (c <= 111 && c >= 104) {
                if (this.theApp.isDebug()) {
                    outLines[0] = this.theApp.getTimeStamp() + " CCIR493-4 RX (" + Integer.toString(c) + ")";
                }
                ++this.rx;
            }
            if (this.dx == 2 && this.rx == 1 || this.dx == 1 && this.rx == 2) {
                this.bitCount = 0;
                this.messageState = 1;
                if (this.theApp.isDebug()) {
                    outLines[0] = this.theApp.getTimeStamp() + " CCIR493-4 Phasing Detect : PDX=" + Integer.toString(this.dx) + " RX=" + Integer.toString(this.rx);
                }
            }
            if (this.bitCount > 1800) {
                if (this.theApp.isDebug()) {
                    outLines[0] = this.theApp.getTimeStamp() + " CCIR493-4 Phasing Timeout";
                }
                this.state = 1;
            }
        } else if (this.messageState == 1) {
            if (this.bitCount % 10 == 0) {
                int c1 = this.ret10BitCode((this.buffer20 & 0xFFC00) >> 10, true);
                int c2 = this.ret10BitCode(this.buffer20 & 0x3FF, true);
                this.formatSpecifier = this.formatSpecifierHunt(c1, c2);
                if (this.theApp.isDebug()) {
                    outLines[0] = c2 != -1 ? this.theApp.getTimeStamp() + " CCIR493-4 Character " + Integer.toString(c2) : this.theApp.getTimeStamp() + " CCIR493-4 Character Error was " + Integer.toString(this.unCorrectedInput);
                }
                if (this.bitCount > 300) {
                    if (this.theApp.isDebug()) {
                        outLines[0] = this.theApp.getTimeStamp() + " CCIR493-4 Format Specifier Timeout";
                    }
                    this.state = 1;
                }
                if (this.formatSpecifier != -1) {
                    this.bitCount = 0;
                    this.messageState = 2;
                    if (this.formatSpecifier == 112) {
                        this.lineBuffer.append(this.theApp.getTimeStamp() + " CCIR493-4 Distress Alert ");
                    } else if (this.formatSpecifier == 116) {
                        this.lineBuffer.append(this.theApp.getTimeStamp() + " CCIR493-4 All Stations ");
                    } else if (this.formatSpecifier == 114) {
                        this.lineBuffer.append(this.theApp.getTimeStamp() + " CCIR493-4 Group Selective Call ");
                    } else if (this.formatSpecifier == 120) {
                        this.lineBuffer.append(this.theApp.getTimeStamp() + " CCIR493-4 Individual Selective Call ");
                    } else if (this.formatSpecifier == 102) {
                        this.lineBuffer.append(this.theApp.getTimeStamp() + " CCIR493-4 Geographic Selective Call ");
                    } else if (this.formatSpecifier == 123) {
                        this.lineBuffer.append(this.theApp.getTimeStamp() + " CCIR493-4 Individual Selective Call Using Semi/Automatic Service ");
                    } else {
                        this.lineBuffer.append(this.theApp.getTimeStamp() + " CCIR493-4 Unknown Call ");
                    }
                }
            }
        } else if (this.messageState == 2) {
            if (this.bitCount % 10 == 0) {
                int i = this.bitCount / 10;
                if (i >= this.messageBuffer.length) {
                    this.messageState = 3;
                } else {
                    this.messageBuffer[i - 1] = this.ret10BitCode(this.buffer10, true);
                }
                if (i > 3 && this.messageBuffer[i - 1] == 117 && this.messageBuffer[i - 2] == 117) {
                    this.messageState = 3;
                }
            }
        } else if (this.messageState == 3) {
            outLines = this.decodeMessageBody();
            this.messageState = 0;
            this.state = 1;
        }
        for (int a = 0; a < outLines.length; ++a) {
            if (outLines[a] == null) continue;
            this.theApp.writeLine(outLines[a], Color.BLACK, this.theApp.boldFont);
        }
    }

    private void addTo10BitBuffer(boolean b) {
        this.buffer10 <<= 1;
        this.buffer10 &= 0x3FF;
        if (b) {
            ++this.buffer10;
        }
    }

    private void addTo20BitBuffer(boolean b) {
        this.buffer20 <<= 1;
        this.buffer20 &= 0xFFFFF;
        if (b) {
            ++this.buffer20;
        }
    }

    private int ret10BitCode(int in, boolean errorBitsAllowed) {
        this.unCorrectedInput = in;
        boolean errorMax = errorBitsAllowed;
        for (int a = 0; a < this.VALIDWORDS.length; ++a) {
            int dif = 0;
            for (int b = 0; b < this.BITVALUES.length; ++b) {
                if ((in & this.BITVALUES[b]) == (this.VALIDWORDS[a] & this.BITVALUES[b])) continue;
                ++dif;
            }
            if (dif > errorMax) continue;
            return a;
        }
        return -1;
    }

    private int formatSpecifierHunt(int c1, int c2) {
        if (c1 != c2) {
            return -1;
        }
        if (c1 == 112) {
            return c1;
        }
        if (c1 == 116) {
            return c1;
        }
        if (c1 == 114) {
            return c1;
        }
        if (c1 == 120) {
            return c1;
        }
        if (c1 == 102) {
            return c1;
        }
        if (c1 == 123) {
            return c1;
        }
        return -1;
    }

    private String[] decodeMessageBody() {
        String[] ol = new String[3];
        ol[0] = this.lineBuffer.toString() + "Station " + this.getAStationIdentity() + " Calling " + this.getBStationIdentity() + this.getCategory();
        return ol;
    }

    private String getBStationIdentity() {
        int b2;
        int b1;
        int b11 = this.messageBuffer[0];
        int b12 = this.messageBuffer[5];
        if (b11 == -1 && b12 != -1) {
            b1 = b12;
        } else if (b12 == -1 && b11 != -1) {
            b1 = b11;
        } else {
            if (b11 == -1 && b12 == -1) {
                return "ERROR";
            }
            b1 = b11 == b12 ? b11 : b11;
        }
        int b21 = this.messageBuffer[2];
        int b22 = this.messageBuffer[7];
        if (b21 == -1 && b22 != -1) {
            b2 = b22;
        } else if (b22 == -1 && b21 != -1) {
            b2 = b21;
        } else {
            if (b21 == -1 && b22 == -1) {
                return "ERROR";
            }
            b2 = b21 == b22 ? b21 : b21;
        }
        String r = String.format("%02d", b1) + String.format("%02d", b2);
        return r;
    }

    private String getAStationIdentity() {
        int a2;
        int a1;
        int a11 = this.messageBuffer[6];
        int a12 = this.messageBuffer[11];
        if (a11 == -1 && a12 != -1) {
            a1 = a12;
        } else if (a12 == -1 && a11 != -1) {
            a1 = a11;
        } else {
            if (a11 == -1 && a12 == -1) {
                return "ERROR";
            }
            a1 = a11;
        }
        int a21 = this.messageBuffer[8];
        int a22 = this.messageBuffer[13];
        if (a21 == -1 && a22 != -1) {
            a2 = a22;
        } else if (a22 == -1 && a21 != -1) {
            a2 = a21;
        } else {
            if (a21 == -1 && a22 == -1) {
                return "ERROR";
            }
            a2 = a21;
        }
        String r = String.format("%02d", a1) + String.format("%02d", a2);
        return r;
    }

    private String getCategory() {
        int c;
        int c1 = this.messageBuffer[4];
        int c2 = this.messageBuffer[9];
        if (c1 == -1 && c2 != -1) {
            c = c2;
        } else if (c2 == -1 && c1 != -1) {
            c = c1;
        } else {
            if (c2 == -1 && c1 == -1) {
                return " (ERROR)";
            }
            c = c1;
        }
        if (c == 100) {
            return " (Routine)";
        }
        if (c == 106) {
            return " (Ship's Business)";
        }
        if (c == 108) {
            return " (Safety)";
        }
        if (c == 110) {
            return " (Urgency)";
        }
        if (c == 112) {
            return " (Distress)";
        }
        return "(Unknown)";
    }

    private void clearMessageBuffer() {
        for (int a = 0; a < this.messageBuffer.length; ++a) {
            this.messageBuffer[a] = -1;
        }
    }

    private void invertBuffer10() {
        int c = 0;
        for (int a = 0; a < this.BITVALUES.length; ++a) {
            if ((this.buffer10 & this.BITVALUES[a]) != 0) continue;
            c += this.BITVALUES[a];
        }
        this.buffer10 = c;
    }
}

