/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.e2k.CircularDataBuffer;
import org.e2k.FSK;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class CIS3650
extends FSK {
    private int state = 0;
    private int shift = 200;
    private double samplesPerSymbol50;
    private Rivet theApp;
    public long sampleCount = 0L;
    private long symbolCounter = 0L;
    private int highTone;
    private int lowTone;
    private int syncState;
    private int buffer7 = 0;
    private int buffer21 = 0;
    private int characterCount;
    private int startCount;
    private int totalCharacterCount = 0;
    private int totalErrorCount = 0;
    private int highBin;
    private int lowBin;
    private int b7Count;
    private int countSinceSync;
    private boolean[] startBuffer = new boolean[184];
    private final double KALMAN1 = 0.99;
    private final double KALMAN2 = 0.009;
    private final double EARLYLATEADJUST = 2.0;

    public CIS3650(Rivet tapp) {
        this.theApp = tapp;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nCIS 36-50 recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.samplesPerSymbol50 = this.samplesPerSymbol(50.0, waveData.getSampleRate());
            this.setState(1);
            this.syncState = 0;
            this.buffer7 = 0;
            this.buffer21 = 0;
            this.characterCount = 0;
            return true;
        }
        if (this.state == 1) {
            ++this.sampleCount;
            if (this.sampleCount < 0L) {
                return true;
            }
            if (this.detect50Sync(circBuf, waveData)) {
                this.totalErrorCount = 0;
                this.totalCharacterCount = 0;
                this.syncState = 1;
                this.setState(2);
                this.buffer7 = 0;
                this.b7Count = 0;
                return true;
            }
        } else if (this.state == 2) {
            if (this.symbolCounter >= (long)this.samplesPerSymbol50) {
                boolean bit = this.getSymbolFreqBin(circBuf, waveData, 0);
                this.addToBuffer7(bit);
                ++this.b7Count;
                if (this.b7Count == 14) {
                    this.buffer7 &= 7;
                    if (this.buffer7 == 5 || this.buffer7 == 2) {
                        this.setState(3);
                        if (this.theApp.isDebug()) {
                            String dout = this.theApp.getTimeStamp() + " CIS 36-50 50 baud sync sequence found : lowBin=" + Integer.toString(this.lowBin) + " highBin=" + Integer.toString(this.highBin);
                            this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
                        }
                        this.b7Count = 0;
                        this.countSinceSync = 0;
                        this.clearStartBuffer();
                    } else {
                        if (this.theApp.isDebug()) {
                            String dout = this.theApp.getTimeStamp() + " Unable to obtain CIS 36-50 50 baud alternating sequence";
                            this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
                        }
                        this.state = 1;
                    }
                }
            }
        } else if (this.state == 3 && this.symbolCounter >= (long)this.samplesPerSymbol50) {
            String dout;
            boolean bit = this.getSymbolFreqBin(circBuf, waveData, 0);
            if (this.syncState == 1) {
                ++this.countSinceSync;
                this.addToBuffer7(bit);
                if (this.buffer7 == 85 || this.buffer7 == 42) {
                    this.countSinceSync = 0;
                }
                if (this.countSinceSync >= 250) {
                    this.setState(1);
                    if (this.theApp.isDebug()) {
                        dout = this.theApp.getTimeStamp() + " CIS 36-50 50 baud sync timeout";
                        this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
                    }
                }
            }
            if (!this.theApp.isDebug()) {
                if (this.syncState == 1) {
                    this.addToStartBuffer(bit);
                    if (this.checkStartBuffer()) {
                        this.syncState = 2;
                        this.setState(this.state);
                        String d1 = this.theApp.getTimeStamp() + " Message Start";
                        this.theApp.writeLine(d1, Color.BLACK, this.theApp.italicFont);
                        String d2 = "Sync 0x" + Long.toHexString(this.extractSyncAsLong());
                        this.theApp.writeLine(d2, Color.BLACK, this.theApp.boldFont);
                        String d3 = this.extractSessionKey();
                        this.theApp.writeLine(d3, Color.BLACK, this.theApp.boldFont);
                        this.buffer21 = 0;
                        this.buffer7 = 0;
                        this.startCount = 0;
                        this.totalCharacterCount = 0;
                        this.totalErrorCount = 0;
                    }
                } else if (this.syncState == 2) {
                    this.addToBuffer7(bit);
                    this.addToBuffer21(bit);
                    ++this.startCount;
                    if (this.buffer21 == 1965047) {
                        this.characterCount = 0;
                        this.syncState = 4;
                    }
                    if (this.startCount == 7) {
                        StringBuilder ch;
                        if (this.checkITA3Char(this.buffer7)) {
                            ch = new StringBuilder();
                            ch.append("0x");
                            if (this.buffer7 < 16) {
                                ch.append("0");
                            }
                            ch.append(Integer.toHexString(this.buffer7) + " ");
                            this.characterCount += ch.length();
                            this.theApp.writeChar(ch.toString(), Color.BLACK, this.theApp.boldFont);
                        } else if (this.buffer7 == 119) {
                            this.theApp.writeChar("<EOM>", Color.BLACK, this.theApp.boldFont);
                            this.characterCount += 5;
                        } else {
                            ch = new StringBuilder();
                            ch.append("[0x");
                            if (this.buffer7 < 16) {
                                ch.append("0");
                            }
                            ch.append(Integer.toHexString(this.buffer7) + "] ");
                            this.characterCount += ch.length();
                            this.theApp.writeChar(ch.toString(), Color.BLACK, this.theApp.boldFont);
                            ++this.totalErrorCount;
                        }
                        this.startCount = 0;
                        this.buffer7 = 0;
                        ++this.totalCharacterCount;
                        if (this.totalCharacterCount > 5000) {
                            this.syncState = 4;
                        }
                    }
                    if (this.characterCount >= 80) {
                        this.theApp.newLineWrite();
                        this.characterCount = 0;
                    }
                } else if (this.syncState == 4) {
                    dout = "End of Message (" + Integer.toString(this.totalCharacterCount) + " characters in this message " + Integer.toString(this.totalErrorCount) + " of these contained errors)";
                    this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
                    this.countSinceSync = 0;
                    this.syncState = 1;
                    this.clearStartBuffer();
                    this.setState(3);
                }
            } else {
                if (bit) {
                    this.theApp.writeChar("1", Color.BLACK, this.theApp.boldFont);
                } else {
                    this.theApp.writeChar("0", Color.BLACK, this.theApp.boldFont);
                }
                if (this.characterCount == 100) {
                    this.theApp.newLineWrite();
                    this.characterCount = 0;
                } else {
                    ++this.characterCount;
                }
            }
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 1) {
            this.theApp.setStatusLabel("Sync Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Validating Sync");
        } else if (state == 3 && this.syncState == 1) {
            this.theApp.setStatusLabel("50 Baud Sync Found");
        } else if (state == 3 && this.syncState == 2) {
            this.theApp.setStatusLabel("Decoding Message");
        }
    }

    public int getState() {
        return this.state;
    }

    private int getSymbolFreq(CircularDataBuffer circBuf, WaveData waveData, int start) {
        int fr = this.do80FFT(circBuf, waveData, start);
        return fr;
    }

    private boolean getSymbolFreqBin(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] early = this.do80FFTBinRequest(circBuf, waveData, start, this.lowBin, this.highBin);
        double[] late = this.do80FFTBinRequest(circBuf, waveData, start += (int)this.samplesPerSymbol50 / 2, this.lowBin, this.highBin);
        double lowTotal = early[0] + late[0];
        double highTotal = early[1] + late[1];
        boolean bit = !this.theApp.isInvertSignal() ? lowTotal > highTotal : lowTotal > highTotal;
        if (lowTotal > highTotal) {
            this.kalmanFilter(this.getPercentageDifference(early[0], late[0]), 0.99, 0.009);
        } else {
            this.kalmanFilter(this.getPercentageDifference(early[1], late[1]), 0.99, 0.009);
        }
        this.symbolCounter = this.adjAdjust();
        return bit;
    }

    private void addToBuffer7(boolean bit) {
        this.buffer7 <<= 1;
        this.buffer7 &= 0x7F;
        if (bit) {
            ++this.buffer7;
        }
    }

    private void addToBuffer21(boolean bit) {
        this.buffer21 <<= 1;
        this.buffer21 &= 0x1FFFFF;
        if (bit) {
            ++this.buffer21;
        }
    }

    private boolean detect50Sync(CircularDataBuffer circBuf, WaveData waveData) {
        int pos = 0;
        int f0 = this.getSymbolFreq(circBuf, waveData, pos);
        int b0 = this.getFreqBin();
        if (this.getPercentageOfTotal() < 10.0) {
            return false;
        }
        pos = (int)this.samplesPerSymbol50 * 1;
        int f1 = this.getSymbolFreq(circBuf, waveData, pos);
        int b1 = this.getFreqBin();
        if (f0 == f1) {
            return false;
        }
        if (f0 > f1) {
            this.highTone = f0;
            this.highBin = b0;
            this.lowTone = f1;
            this.lowBin = b1;
        } else {
            this.highTone = f1;
            this.highBin = b1;
            this.lowTone = f0;
            this.lowBin = b0;
        }
        if (this.lowBin == 0 || this.highBin == 0) {
            return false;
        }
        int dif = this.highTone - this.lowTone;
        int ashift = dif > this.shift ? dif - this.shift : this.shift - dif;
        return ashift <= 10;
    }

    private int adjAdjust() {
        double r = Math.abs(this.kalmanNew) / 2.0;
        if (this.kalmanNew < 0.0) {
            r = 0.0 - r;
        }
        return (int)r;
    }

    private void addToStartBuffer(boolean in) {
        for (int a = 1; a < this.startBuffer.length; ++a) {
            this.startBuffer[a - 1] = this.startBuffer[a];
        }
        this.startBuffer[183] = in;
    }

    private boolean checkStartBuffer() {
        int a;
        int count = 0;
        for (a = 0; a < 44; ++a) {
            if (!this.startBuffer[a]) continue;
            ++count;
        }
        if (count != 21) {
            return false;
        }
        count = 0;
        for (a = 0; a < 70; ++a) {
            if (this.startBuffer[a + 44] == this.startBuffer[a + 44 + 70]) continue;
            ++count;
        }
        if (count > 1) {
            return false;
        }
        count = 0;
        for (a = 44; a < 114; a += 7) {
            int o = this.extractIntFromStart(a);
            if (!this.checkITA3Char(o)) continue;
            ++count;
        }
        return count >= 8;
    }

    private long extractSyncAsLong() {
        int bc = 0;
        long r = 0L;
        for (int a = 43; a >= 0; --a) {
            if (this.startBuffer[a]) {
                r += (long)Math.pow(2.0, bc);
            }
            ++bc;
        }
        return r;
    }

    private void clearStartBuffer() {
        for (int a = 0; a < this.startBuffer.length; ++a) {
            this.startBuffer[a] = false;
        }
    }

    private String extractSessionKey() {
        StringBuilder sb = new StringBuilder();
        sb.append("Session Key is ");
        for (int a = 44; a < 114; a += 7) {
            int o = this.extractIntFromStart(a);
            if (this.checkITA3Char(o)) {
                sb.append("0x");
                if (o < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(o) + " ");
                continue;
            }
            sb.append("<ERROR> ");
        }
        return sb.toString();
    }

    private int extractIntFromStart(int pos) {
        int v = 0;
        if (this.startBuffer[pos]) {
            v = 64;
        }
        if (this.startBuffer[pos + 1]) {
            v += 32;
        }
        if (this.startBuffer[pos + 2]) {
            v += 16;
        }
        if (this.startBuffer[pos + 3]) {
            v += 8;
        }
        if (this.startBuffer[pos + 4]) {
            v += 4;
        }
        if (this.startBuffer[pos + 5]) {
            v += 2;
        }
        if (this.startBuffer[pos + 6]) {
            ++v;
        }
        return v;
    }

    public int getShift() {
        return this.shift;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }
}

