/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

public class CRC {
    private int width;
    private int polynomial;
    private int initialVal;
    private int finalXorVal;
    private boolean inputReflected;
    private boolean resultReflected;
    private int castMask;
    private int msbMask;
    private int[] crcTable;

    public CRC(int width, int polynomial, int initialVal, int finalXorVal, boolean inputReflected, boolean resultReflected) {
        this.width = width;
        this.polynomial = polynomial;
        this.initialVal = initialVal;
        this.finalXorVal = finalXorVal;
        this.inputReflected = inputReflected;
        this.resultReflected = resultReflected;
        this.castMask = (1 << width) - 1;
        this.msbMask = 1 << width - 1;
        this.crcTable = new int[256];
        for (int divident = 0; divident < 256; ++divident) {
            int currByte = divident << width - 8 & this.castMask;
            for (int bit = 0; bit < 8; ++bit) {
                if ((currByte & this.msbMask) != 0) {
                    currByte <<= 1;
                    currByte ^= polynomial;
                    continue;
                }
                currByte <<= 1;
            }
            this.crcTable[divident] = currByte & this.castMask;
        }
    }

    public int compute(int[] bytes) {
        int crc = this.initialVal;
        for (int i = 0; i < bytes.length; ++i) {
            int currByte = bytes[i] & 0xFF;
            if (this.inputReflected) {
                currByte = this.reflect8(currByte);
            }
            crc = (crc ^ currByte << this.width - 8) & this.castMask;
            int pos = crc >> this.width - 8 & 0xFF;
            crc = crc << 8 & this.castMask;
            crc = (crc ^ this.crcTable[pos]) & this.castMask;
        }
        if (this.resultReflected) {
            crc = this.reflectGeneric(crc, this.width);
        }
        return (crc ^ this.finalXorVal) & this.castMask;
    }

    private int reflect8(int val) {
        int resByte = 0;
        for (int i = 0; i < 8; ++i) {
            if ((val & 1 << i) == 0) continue;
            resByte |= 1 << 7 - i & 0xFF;
        }
        return resByte;
    }

    private int reflectGeneric(int val, int width) {
        int resByte = 0;
        for (int i = 0; i < width; ++i) {
            if ((val & 1 << i) == 0) continue;
            resByte |= 1 << width - 1 - i;
        }
        return resByte;
    }
}

