/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.e2k.CircularDataBuffer;
import org.e2k.MFSK;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class CROWD36
extends MFSK {
    private int baudRate = 40;
    private int state = 0;
    private double samplesPerSymbol;
    private Rivet theApp;
    public long sampleCount = 0L;
    private long symbolCounter = 0L;
    private long energyStartPoint;
    private CircularDataBuffer energyBuffer = new CircularDataBuffer();
    private boolean figureShift = false;
    private int lineCount = 0;
    private int correctionValue = 0;
    private int highFreq = -1;
    private int lowFreq = 5000;
    private final int[] TONES = new int[]{1410, 1450, 1490, 1530, 1570, 1610, 1650, 1690, 1730, 1770, 1810, 1850, 1890, 1930, 1970, 2010, 2050, 2090, 2130, 2170, 2210, 2250, 2290, 2330, 2370, 2410, 2450, 2490, 2530, 2570, 2610, 2650, 2690, 2730};
    private int[] toneCount = new int[34];
    private int toneLowCount;
    private int toneHighCount;
    private int syncHighTone = 24;
    private final String[] DEBUGLETTERS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public CROWD36(Rivet tapp, int baud) {
        this.baudRate = baud;
        this.theApp = tapp;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        if (this.state == 0) {
            if (waveData.getSampleRate() > 11025.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nCROWD36 recordings must have\nbeen recorded at a sample rate\nof 11.025 KHz or less.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.samplesPerSymbol = this.samplesPerSymbol(this.baudRate, waveData.getSampleRate());
            this.state = 1;
            this.figureShift = false;
            this.highFreq = -1;
            this.lowFreq = 5000;
            this.correctionValue = 0;
            this.toneCountClear();
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.energyBuffer.setBufferCounter(0);
            this.lineCount = 0;
            this.theApp.setStatusLabel("Known Tone Hunt");
            return true;
        }
        if (this.state == 1) {
            String dout = this.syncToneHunt(circBuf, waveData);
            if (dout != null) {
                this.state = 2;
                this.energyStartPoint = this.sampleCount;
                this.energyBuffer.setBufferCounter(0);
                this.theApp.setStatusLabel("Calculating Symbol Timing");
                this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
                this.theApp.newLineWrite();
                String sinform = "Sync High Tone is " + Integer.toString(this.syncHighTone);
                this.theApp.writeLine(sinform, Color.BLACK, this.theApp.italicFont);
                this.theApp.newLineWrite();
            }
        } else if (this.state == 2) {
            boolean lookAHEAD = true;
            double no = this.samplesPerSymbol / 20.0;
            this.energyBuffer.addToCircBuffer(circBuf.getABSAverage(0, (int)no));
            if (this.energyBuffer.getBufferCounter() > (int)(this.samplesPerSymbol * 1.0)) {
                long perfectPoint = (long)this.energyBuffer.returnLowestBin() + this.energyStartPoint + (long)((int)this.samplesPerSymbol);
                this.symbolCounter = (long)((int)this.samplesPerSymbol) - (perfectPoint - this.sampleCount);
                this.state = 3;
                this.theApp.setStatusLabel("Symbol Timing Achieved");
                ++this.sampleCount;
                ++this.symbolCounter;
                return true;
            }
        } else if (this.state == 3 && (double)this.symbolCounter >= this.samplesPerSymbol) {
            this.symbolCounter = 0L;
            int freq = this.crowd36Freq(circBuf, waveData, 0);
            this.displayMessage(freq, waveData.isFromFile());
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    private int crowd36Freq(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        if (waveData.getSampleRate() == 8000.0) {
            int freq = this.doCR36_8000FFT(circBuf, waveData, pos);
            return freq += this.correctionValue;
        }
        if (waveData.getSampleRate() == 11025.0) {
            int freq = this.doCR36_11025FFT(circBuf, waveData, pos);
            return freq += this.correctionValue;
        }
        return -1;
    }

    private void displayMessage(int freq, boolean isFile) {
        int tone = this.getTone(freq);
        String ch = this.getChar(tone);
        if (!this.theApp.isDebug()) {
            if (ch.equals("ls")) {
                return;
            }
            if (ch.equals("fs")) {
                return;
            }
            if (ch.equals("cr")) {
                this.lineCount = 50;
            } else {
                this.theApp.writeChar(ch, Color.BLACK, this.theApp.boldFont);
                if (ch.length() > 0) {
                    ++this.lineCount;
                }
            }
            if (this.lineCount == 80) {
                this.theApp.newLineWrite();
                this.lineCount = 0;
                return;
            }
            return;
        }
        if (tone == -1) {
            this.theApp.writeChar("*", Color.BLACK, this.theApp.boldFont);
        } else {
            this.theApp.writeChar(this.DEBUGLETTERS[tone], Color.BLACK, this.theApp.boldFont);
        }
        ++this.lineCount;
        if (this.lineCount == 80) {
            this.lineCount = 0;
            this.theApp.newLineWrite();
        }
    }

    private String getChar(int tone) {
        String out = "";
        String[] C36A = new String[]{"Q", "X", "W", "V", "E", "K", " ", "B", "R", "J", "<*10>", "G", "T", "F", "<fs>", "M", "Y", "C", "cr", "Z", "U", "L", "<*22>", "D", "I", "H", "<ls>", "S", "O", "N", "<*30>", "A", "P", "<*33>"};
        String[] F36A = new String[]{"1", "\u0429", "2", "=", "3", "(", " ", "?", "4", "\u042e", "<*10>", "8", "5", "\u042d", "<fs>", ".", "6", ":", "cr", "+", "7", ")", "<*22>", " ", "8", "\u0449", "<ls>", "", "9", ",", "<*30>", "-", "0", "<*33>"};
        try {
            if (tone < 0) {
                ++this.toneLowCount;
                tone = 0;
            } else if (tone > 33) {
                ++this.toneHighCount;
                tone = 33;
            } else {
                int n = tone;
                this.toneCount[n] = this.toneCount[n] + 1;
            }
            out = !this.figureShift ? C36A[tone] : F36A[tone];
            if (out.equals("<ls>")) {
                this.figureShift = false;
            } else if (out.equals("<fs>")) {
                this.figureShift = true;
            } else if (out.equals("cr")) {
                this.figureShift = false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Rivet", 1);
            return "";
        }
        return out;
    }

    private int getTone(int freq) {
        int index = -1;
        int lowVal = 999;
        if (freq > this.highFreq) {
            this.highFreq = freq;
        } else if (freq < this.lowFreq) {
            this.lowFreq = freq;
        }
        for (int a = 0; a < this.TONES.length; ++a) {
            int dif = Math.abs(this.TONES[a] - freq);
            if (dif >= lowVal) continue;
            lowVal = dif;
            index = a;
        }
        if (index == 0 && lowVal > 40) {
            return -1;
        }
        if (index == 33 && lowVal > 40) {
            return 34;
        }
        return index;
    }

    private String syncToneHunt(CircularDataBuffer circBuf, WaveData waveData) {
        int freq1 = this.crowd36Freq(circBuf, waveData, 0);
        if (this.getPercentageOfTotal() < 5.0) {
            return null;
        }
        int freq2 = this.crowd36Freq(circBuf, waveData, (int)this.samplesPerSymbol * 1);
        if (freq2 > freq1) {
            return null;
        }
        int difference = freq1 - freq2;
        if (difference < 100) {
            return null;
        }
        int freq3 = this.crowd36Freq(circBuf, waveData, (int)this.samplesPerSymbol * 2);
        if (freq1 != freq3) {
            return null;
        }
        int freq4 = this.crowd36Freq(circBuf, waveData, (int)this.samplesPerSymbol * 3);
        if (freq1 != freq3 || freq2 != freq4) {
            return null;
        }
        if (freq1 == freq2 || freq3 == freq4) {
            return null;
        }
        difference = freq1 - freq2;
        this.correctionValue = this.TONES[this.syncHighTone] - freq1;
        String line = this.theApp.getTimeStamp() + " CROWD36 Sync Tones Found (Correcting by " + Integer.toString(this.correctionValue) + " Hz) sync tone difference " + Integer.toString(difference) + " Hz";
        return line;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public String lowHighFreqs() {
        String line = "Lowest frequency " + Integer.toString(this.lowFreq) + " Hz : Highest Frequency " + Integer.toString(this.highFreq) + " Hz";
        return line;
    }

    private void toneCountClear() {
        this.toneHighCount = 0;
        this.toneLowCount = 0;
        for (int a = 0; a < this.toneCount.length; ++a) {
            this.toneCount[a] = 0;
        }
    }

    public void toneResults() {
        this.theApp.writeLine("Low Tone Count " + Integer.toString(this.toneLowCount), Color.BLACK, this.theApp.plainFont);
        for (int a = 0; a < this.toneCount.length; ++a) {
            String l = "Tone #" + Integer.toString(a) + " " + Integer.toString(this.toneCount[a]);
            this.theApp.writeLine(l, Color.BLACK, this.theApp.plainFont);
        }
        this.theApp.writeLine("High Tone Count " + Integer.toString(this.toneHighCount), Color.BLACK, this.theApp.plainFont);
    }

    public int getSyncHighTone() {
        return this.syncHighTone;
    }

    public void setSyncHighTone(int syncHighTone) {
        this.syncHighTone = syncHighTone;
    }
}

