/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class CircularBitSet
extends BitSet {
    private static final long serialVersionUID = 1L;
    private int counter = 0;
    private int totalLength;

    public void add(boolean bit) {
        if (bit) {
            this.set(this.counter);
        } else {
            this.clear(this.counter);
        }
        ++this.counter;
        if (this.counter == this.totalLength) {
            this.counter = 0;
        }
    }

    public void totalClear() {
        this.clear();
        this.counter = 0;
    }

    public String extractSection(int start, int end) {
        StringBuilder out = new StringBuilder();
        int tc = this.counter + start;
        if (tc >= this.totalLength) {
            tc -= this.totalLength;
        }
        for (int a = start; a < end; ++a) {
            if (this.get(tc)) {
                out.append("1");
            } else {
                out.append("0");
            }
            if (++tc != this.totalLength) continue;
            tc = 0;
        }
        return out.toString();
    }

    public String extractSequence(int len) {
        StringBuilder sb = new StringBuilder();
        int pos = this.counter - len;
        if (pos < 0) {
            pos = this.totalLength - pos;
        }
        for (int a = 0; a < len; ++a) {
            if (this.get(pos)) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if (++pos < this.totalLength) continue;
            pos = 0;
        }
        return sb.toString();
    }

    public String extractSectionFromStart(int start, int end) {
        StringBuilder out = new StringBuilder();
        for (int a = start; a < end; ++a) {
            if (this.get(a)) {
                out.append("1");
                continue;
            }
            out.append("0");
        }
        return out.toString();
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public String extractBitSetasHex() {
        StringBuilder out = new StringBuilder();
        int[] idata = this.returnInts();
        for (int a = 0; a < idata.length; ++a) {
            if (idata[a] < 16) {
                out.append("0");
            }
            out.append(Integer.toHexString(idata[a]));
            if (a >= idata.length - 1) continue;
            out.append(",");
        }
        return out.toString();
    }

    public int[] returnInts() {
        int itotal = this.totalLength / 8;
        int[] out = new int[itotal];
        BitSet bset = new BitSet();
        int tc = this.counter;
        int bcount = 0;
        int ocount = 0;
        for (int a = 0; a < this.totalLength; ++a) {
            if (this.get(tc)) {
                bset.set(bcount);
            } else {
                bset.clear(bcount);
            }
            if (++bcount == 8) {
                out[ocount] = this.binaryToInt8(bset);
                ++ocount;
                bset.clear();
                bcount = 0;
            }
            if (++tc != this.totalLength) continue;
            tc = 0;
        }
        return out;
    }

    public List<Integer> returnIntsFromStart(int start) {
        ArrayList<Integer> listI = new ArrayList<Integer>();
        BitSet bset = new BitSet();
        int bcount = 0;
        for (int a = start; a < this.totalLength; ++a) {
            if (this.get(a)) {
                bset.set(bcount);
            } else {
                bset.clear(bcount);
            }
            if (++bcount != 8) continue;
            listI.add(this.binaryToInt8(bset));
            bset.clear();
            bcount = 0;
        }
        return listI;
    }

    private int binaryToInt8(BitSet bin) {
        int total = 0;
        if (bin.get(0)) {
            total += 128;
        }
        if (bin.get(1)) {
            total += 64;
        }
        if (bin.get(2)) {
            total += 32;
        }
        if (bin.get(3)) {
            total += 16;
        }
        if (bin.get(4)) {
            total += 8;
        }
        if (bin.get(5)) {
            total += 4;
        }
        if (bin.get(6)) {
            total += 2;
        }
        if (bin.get(7)) {
            ++total;
        }
        return total;
    }
}

