/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import javax.swing.JOptionPane;

public class CircularDataBuffer {
    private final int MAXCIRC = 10240;
    private int circBufferCounter = 0;
    private int[] circDataBuffer = new int[10240];

    public void addToCircBuffer(int i) {
        try {
            this.circDataBuffer[this.circBufferCounter] = i;
            ++this.circBufferCounter;
            if (this.circBufferCounter == 10240) {
                this.circBufferCounter = 0;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in addToCircBuffer() " + e.toString(), "Rivet", 0);
        }
    }

    public int[] extractData(int start, int length) {
        try {
            int count = 0;
            int a = this.circBufferCounter + start;
            int[] outData = new int[length];
            if (a >= 10240) {
                a -= 10240;
            }
            for (count = 0; count < length; ++count) {
                outData[count] = this.circDataBuffer[a];
                if (++a != 10240) continue;
                a = 0;
            }
            return outData;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in extractData() " + e.toString(), "Rivet", 0);
            return null;
        }
    }

    public double[] extractDataDouble(int start, int length) {
        try {
            int count = 0;
            int a = this.circBufferCounter + start;
            double[] outData = new double[length];
            if (a >= 10240) {
                a -= 10240;
            }
            for (count = 0; count < length; ++count) {
                outData[count] = this.circDataBuffer[a];
                if (++a != 10240) continue;
                a = 0;
            }
            return outData;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in extractDataDouble() " + e.toString(), "Rivet", 0);
            return null;
        }
    }

    public int retMax() {
        return 10240;
    }

    public int getBufferCounter() {
        return this.circBufferCounter;
    }

    public void setBufferCounter(int val) {
        this.circBufferCounter = val;
    }

    public int returnHighestBin() {
        try {
            int highBin = -1;
            int highVal = Integer.MIN_VALUE;
            for (int a = 0; a < this.circBufferCounter; ++a) {
                if (this.circDataBuffer[a] <= highVal) continue;
                highVal = this.circDataBuffer[a];
                highBin = a;
            }
            return highBin;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in returnHighestBin() " + e.toString(), "Rivet", 0);
            return 0;
        }
    }

    public int returnLowestBin() {
        try {
            int lowBin = -1;
            int lowVal = Integer.MAX_VALUE;
            for (int a = 0; a < this.circBufferCounter; ++a) {
                if (this.circDataBuffer[a] >= lowVal) continue;
                lowVal = this.circDataBuffer[a];
                lowBin = a;
            }
            return lowBin;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in returnLowestBin() " + e.toString(), "Rivet", 0);
            return 0;
        }
    }

    public int directAccess(int i) {
        return this.circDataBuffer[i];
    }

    public int getABSAverage(int start, int length) {
        double runtotal = 0.0;
        int[] samples = this.extractData(start, length);
        for (int a = 0; a < length; ++a) {
            runtotal += (double)Math.abs(samples[a]);
        }
        return (int)(runtotal /= (double)length);
    }

    public int getLast() {
        return this.circDataBuffer[this.circBufferCounter];
    }
}

