/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.MenuElement;
import org.e2k.AudioMixer;
import org.e2k.BareBonesBrowserLaunch;
import org.e2k.BitStreamFileFilter;
import org.e2k.JStatusBar;
import org.e2k.Rivet;
import org.e2k.TextFileFilter;
import org.e2k.Trigger;
import org.e2k.TriggerModify;
import org.e2k.WAVfileFilter;

public class DisplayFrame
extends JFrame
implements ActionListener {
    private JMenuBar menuBar = new JMenuBar();
    private Rivet theApp;
    public static final long serialVersionUID = 1L;
    private JStatusBar statusBar = new JStatusBar();
    public JScrollBar vscrollbar = new JScrollBar(1, 0, 1, 0, 6000);
    private JMenu triggersMenu = new JMenu("Triggers");
    private JMenuItem exit_item;
    private JMenuItem wavLoad_item;
    private JMenuItem save_to_file;
    private JMenuItem about_item;
    private JMenuItem help_item;
    private JMenuItem debug_item;
    private JMenuItem soundcard_item;
    private JMenuItem reset_item;
    private JMenuItem copy_item;
    private JMenuItem bitstream_item;
    private JMenuItem XPA_10_item;
    private JMenuItem XPA_20_item;
    private JMenuItem XPA2_item;
    private JMenuItem CROWD36_item;
    private JMenuItem experimental_item;
    private JMenuItem CIS3650_item;
    private JMenuItem FSK200500_item;
    private JMenuItem CCIR493_item;
    private JMenuItem GW_item;
    private JMenuItem RTTY_item;
    private JMenuItem FSK2001000_item;
    private JMenuItem CROWD36_sync_item;
    private JMenuItem invert_item;
    private JMenuItem save_settings_item;
    private JMenuItem sample_item;
    private JMenuItem e2k_item;
    private JMenuItem twitter_item;
    private JMenuItem freeChannelMarkerGW_item;
    private JMenuItem RTTYOptions_item;
    private JMenuItem FSK_item;
    private JMenuItem AddEditTrigger_item;
    private JMenuItem credits_item;
    private JMenuItem system_info_item;
    private JMenuItem ClearDisplay_item;
    private JMenuItem DisplayBad_item;
    private JMenuItem DisplayUTC_item;
    private JMenuItem UDXF_item;
    private JMenuItem CIS360Options_item;
    private List<JMenuItem> trigger_items = new ArrayList<JMenuItem>();
    private JMenu audioDevicesMenu;
    private static ArrayList<AudioMixer> devices;

    public DisplayFrame(String title, Rivet theApp) {
        String err;
        this.setTitle(title);
        this.theApp = theApp;
        this.setDefaultCloseOperation(3);
        this.getContentPane().setBackground(Color.WHITE);
        try {
            theApp.readTriggerSettings();
        }
        catch (Exception e) {
            err = e.toString();
            System.out.println("\nInformative : Unable to read the file trigger.xml " + err);
        }
        try {
            theApp.readDefaultSettings();
            boolean cin = theApp.issoundCardInputTemp();
            theApp.setSoundCardInput(cin);
        }
        catch (Exception e) {
            err = e.toString();
            System.out.println("\nInformative : Unable to read the file rivet_settings.xml " + err);
        }
        this.setJMenuBar(this.menuBar);
        JMenu mainMenu = new JMenu("Main");
        this.copy_item = new JMenuItem("Copy All to the Clipboard");
        mainMenu.add(this.copy_item);
        this.copy_item.addActionListener(this);
        this.wavLoad_item = new JMenuItem("Load a WAV File");
        mainMenu.add(this.wavLoad_item);
        this.wavLoad_item.addActionListener(this);
        this.reset_item = new JMenuItem("Reset Decoding State");
        mainMenu.add(this.reset_item);
        this.reset_item.addActionListener(this);
        this.save_settings_item = new JMenuItem("Save the Current Settings");
        mainMenu.add(this.save_settings_item);
        this.save_settings_item.addActionListener(this);
        this.save_to_file = new JRadioButtonMenuItem("Save to File", theApp.getLogging());
        mainMenu.add(this.save_to_file);
        this.save_to_file.addActionListener(this);
        this.bitstream_item = new JRadioButtonMenuItem("Save Bit Stream to File", theApp.isBitStreamOut());
        mainMenu.add(this.bitstream_item);
        this.bitstream_item.addActionListener(this);
        this.soundcard_item = new JRadioButtonMenuItem("Soundcard Input", theApp.isSoundCardInput());
        mainMenu.add(this.soundcard_item);
        this.soundcard_item.addActionListener(this);
        this.exit_item = new JMenuItem("Exit");
        mainMenu.add(this.exit_item);
        this.exit_item.addActionListener(this);
        this.menuBar.add(mainMenu);
        JMenu audioMenu = new JMenu("Audio");
        this.audioDevicesMenu = this.buildAudioDevices();
        audioMenu.add(this.audioDevicesMenu);
        this.audioDevicesMenu.updateUI();
        this.menuBar.add(audioMenu);
        JMenu modeMenu = new JMenu("Modes");
        this.RTTY_item = new JRadioButtonMenuItem(theApp.MODENAMES[10], theApp.isRTTY());
        modeMenu.add(this.RTTY_item);
        this.RTTY_item.addActionListener(this);
        this.CCIR493_item = new JRadioButtonMenuItem(theApp.MODENAMES[7], theApp.isCCIR493());
        modeMenu.add(this.CCIR493_item);
        this.CCIR493_item.addActionListener(this);
        this.CIS3650_item = new JRadioButtonMenuItem(theApp.MODENAMES[5], theApp.isCIS3650());
        modeMenu.add(this.CIS3650_item);
        this.CIS3650_item.addActionListener(this);
        this.CROWD36_item = new JRadioButtonMenuItem(theApp.MODENAMES[0], theApp.isCROWD36());
        modeMenu.add(this.CROWD36_item);
        this.CROWD36_item.addActionListener(this);
        this.FSK200500_item = new JRadioButtonMenuItem(theApp.MODENAMES[6], theApp.isFSK200500());
        modeMenu.add(this.FSK200500_item);
        this.FSK200500_item.addActionListener(this);
        this.FSK2001000_item = new JRadioButtonMenuItem(theApp.MODENAMES[8], theApp.isFSK2001000());
        modeMenu.add(this.FSK2001000_item);
        this.FSK2001000_item.addActionListener(this);
        this.FSK_item = new JRadioButtonMenuItem(theApp.MODENAMES[11], theApp.isFSK());
        modeMenu.add(this.FSK_item);
        this.FSK_item.addActionListener(this);
        this.GW_item = new JRadioButtonMenuItem(theApp.MODENAMES[9], theApp.isGW());
        modeMenu.add(this.GW_item);
        this.GW_item.addActionListener(this);
        this.XPA_10_item = new JRadioButtonMenuItem(theApp.MODENAMES[1], theApp.isXPA_10());
        modeMenu.add(this.XPA_10_item);
        this.XPA_10_item.addActionListener(this);
        this.XPA_20_item = new JRadioButtonMenuItem(theApp.MODENAMES[3], theApp.isXPA_20());
        modeMenu.add(this.XPA_20_item);
        this.XPA_20_item.addActionListener(this);
        this.XPA2_item = new JRadioButtonMenuItem(theApp.MODENAMES[2], theApp.isXPA2());
        modeMenu.add(this.XPA2_item);
        this.XPA2_item.addActionListener(this);
        modeMenu.addSeparator();
        this.experimental_item = new JRadioButtonMenuItem(theApp.MODENAMES[4], theApp.isExperimental());
        modeMenu.add(this.experimental_item);
        this.experimental_item.addActionListener(this);
        this.menuBar.add(modeMenu);
        JMenu optionsMenu = new JMenu("Options");
        this.RTTYOptions_item = new JMenuItem("Baudot & FSK Options");
        optionsMenu.add(this.RTTYOptions_item);
        this.RTTYOptions_item.addActionListener(this);
        this.CIS360Options_item = new JMenuItem("CIS36-50 Options");
        optionsMenu.add(this.CIS360Options_item);
        this.CIS360Options_item.addActionListener(this);
        this.debug_item = new JRadioButtonMenuItem("Debug Mode", theApp.isDebug());
        optionsMenu.add(this.debug_item);
        this.debug_item.addActionListener(this);
        this.invert_item = new JRadioButtonMenuItem("Invert", theApp.isInvertSignal());
        optionsMenu.add(this.invert_item);
        this.invert_item.addActionListener(this);
        this.CROWD36_sync_item = new JMenuItem("Set the CROWD36 Sync High Tone");
        optionsMenu.add(this.CROWD36_sync_item);
        this.CROWD36_sync_item.addActionListener(this);
        this.menuBar.add(optionsMenu);
        this.updateTriggerMenuItems();
        this.menuBar.add(this.triggersMenu);
        JMenu viewMenu = new JMenu("View");
        this.ClearDisplay_item = new JMenuItem("Clear Display");
        viewMenu.add(this.ClearDisplay_item);
        this.ClearDisplay_item.addActionListener(this);
        this.DisplayBad_item = new JRadioButtonMenuItem("Display Possible Bad Data", theApp.isDisplayBadPackets());
        viewMenu.add(this.DisplayBad_item);
        this.DisplayBad_item.addActionListener(this);
        this.DisplayUTC_item = new JRadioButtonMenuItem("Display UTC Time", theApp.isLogInUTC());
        viewMenu.add(this.DisplayUTC_item);
        this.DisplayUTC_item.addActionListener(this);
        this.freeChannelMarkerGW_item = new JRadioButtonMenuItem("View GW Free Channel Markers", theApp.isViewGWChannelMarkers());
        viewMenu.add(this.freeChannelMarkerGW_item);
        this.freeChannelMarkerGW_item.addActionListener(this);
        this.menuBar.add(viewMenu);
        JMenu helpMenu = new JMenu("Help");
        this.about_item = new JMenuItem("About");
        helpMenu.add(this.about_item);
        this.about_item.addActionListener(this);
        this.credits_item = new JMenuItem("Credits");
        helpMenu.add(this.credits_item);
        this.credits_item.addActionListener(this);
        this.sample_item = new JMenuItem("Download the latest version of Rivet or sound sample files");
        helpMenu.add(this.sample_item);
        this.sample_item.addActionListener(this);
        this.e2k_item = new JMenuItem("Enigma2000");
        helpMenu.add(this.e2k_item);
        this.e2k_item.addActionListener(this);
        this.twitter_item = new JMenuItem("Follow Rivet Progress on Twitter");
        helpMenu.add(this.twitter_item);
        this.twitter_item.addActionListener(this);
        this.help_item = new JMenuItem("Help");
        helpMenu.add(this.help_item);
        this.help_item.addActionListener(this);
        this.system_info_item = new JMenuItem("System Information");
        helpMenu.add(this.system_info_item);
        this.system_info_item.addActionListener(this);
        this.UDXF_item = new JMenuItem("UDXF");
        helpMenu.add(this.UDXF_item);
        this.UDXF_item.addActionListener(this);
        this.menuBar.add(helpMenu);
        this.add((Component)this.vscrollbar, "East");
        this.vscrollbar.addAdjustmentListener(new MyAdjustmentListener());
        this.vscrollbar.addMouseWheelListener(new MouseAdjustmentListener());
        this.addMouseWheelListener(new MouseAdjustmentListener());
        this.getContentPane().add((Component)this.statusBar, "South");
        this.statusBar.setLoggingStatus("Not Logging");
        this.statusBar.setStatusLabel("Idle");
        this.statusBar.setApp(theApp);
        this.menuItemUpdate();
        this.statusBarUpdate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String fileName;
        String event_name = event.getActionCommand();
        if (event_name == "Copy All to the Clipboard") {
            String contents = this.theApp.getAllText();
            this.setClipboard(contents);
        }
        if (event_name == "About") {
            String line = this.theApp.program_version + "\r\nianwraith@gmail.com\r\nfor the Enigma2000 & UDXF groups.";
            JOptionPane.showMessageDialog(null, line, "Rivet", 1);
        }
        if (event_name == "Enigma2000") {
            BareBonesBrowserLaunch.openURL("http://www.enigma2000.org.uk/");
        }
        if (event_name == "UDXF") {
            BareBonesBrowserLaunch.openURL("http://www.udxf.nl/");
        }
        if (event_name == "Help") {
            BareBonesBrowserLaunch.openURL("https://github.com/IanWraith/Rivet/wiki/Introduction");
        }
        if (event_name == "Download the latest version of Rivet or sound sample files") {
            BareBonesBrowserLaunch.openURL("http://borg.shef.ac.uk/rivet");
        }
        if (event_name == "Follow Rivet Progress on Twitter") {
            BareBonesBrowserLaunch.openURL("https://twitter.com/#!/IanWraith");
        }
        if (event_name == "Debug Mode") {
            if (this.theApp.isDebug()) {
                this.theApp.setDebug(false);
            } else {
                this.theApp.setDebug(true);
            }
        }
        for (int a = 0; a < this.theApp.MODENAMES.length; ++a) {
            if (event_name != this.theApp.MODENAMES[a]) continue;
            this.theApp.setSystem(a);
        }
        if (event_name == "Load a WAV File" && (fileName = this.loadDialogBox()) != null) {
            this.theApp.loadWAVfile(fileName);
        }
        if (event_name == "Save to File") {
            if (!this.theApp.getLogging()) {
                if (!this.saveDialogBox()) {
                    this.menuItemUpdate();
                    return;
                }
                this.theApp.setLogging(true);
                this.statusBar.setLoggingStatus("Logging");
            } else {
                this.closeLogFile();
            }
        }
        if (event_name == "Save Bit Stream to File") {
            if (!this.theApp.isBitStreamOut()) {
                if (!this.saveBitStreamDialogBox()) {
                    this.menuItemUpdate();
                    return;
                }
                this.theApp.setBitStreamOut(true);
                this.theApp.clearBitStreamCountOut();
            } else {
                this.closeBitStreamFile();
            }
        }
        if (event_name == "Soundcard Input") {
            if (this.theApp.isSoundCardInput()) {
                this.theApp.setSoundCardInput(false);
            } else {
                this.theApp.setSoundCardInput(true);
            }
        }
        if (event_name == "Reset Decoding State") {
            this.theApp.resetDecoderState();
        }
        if (event_name == "Set the CROWD36 Sync High Tone") {
            this.theApp.getCROWD36SyncHighTone();
        }
        if (event_name == "Baudot & FSK Options") {
            this.theApp.setRTTYOptions();
        }
        if (event_name == "CIS36-50 Options") {
            this.theApp.setBEEOptions();
        }
        if (event_name == "Invert") {
            if (this.theApp.isInvertSignal()) {
                this.theApp.setInvertSignal(false);
            } else {
                this.theApp.setInvertSignal(true);
            }
        }
        if (event_name == "Save the Current Settings") {
            this.theApp.saveSettings();
        }
        if (event_name == "System Information") {
            this.theApp.displaySystemInfo();
        }
        if (event_name == "Clear Display") {
            this.theApp.clearScreen();
        }
        if (event_name == "Display Possible Bad Data") {
            if (this.theApp.isDisplayBadPackets()) {
                this.theApp.setDisplayBadPackets(false);
            } else {
                this.theApp.setDisplayBadPackets(true);
            }
        }
        if (event_name == "View GW Free Channel Markers") {
            if (this.theApp.isViewGWChannelMarkers()) {
                this.theApp.setViewGWChannelMarkers(false);
            } else {
                this.theApp.setViewGWChannelMarkers(true);
            }
        }
        if (event_name == "Display UTC Time") {
            if (this.theApp.isLogInUTC()) {
                this.theApp.setLogInUTC(false);
            } else {
                this.theApp.setLogInUTC(true);
            }
        }
        if (event_name == "Exit") {
            if (this.theApp.getLogging()) {
                this.closeLogFile();
            }
            System.exit(0);
        }
        List<Trigger> trigList = this.theApp.getListTriggers();
        for (int a = 0; a < trigList.size(); ++a) {
            if (!event_name.equals(trigList.get(a).getTriggerDescription() + trigList.get(a).getTypeDescription())) continue;
            if (trigList.get(a).isActive()) {
                trigList.get(a).setActive(false);
            } else {
                trigList.get(a).setActive(true);
            }
            this.theApp.setListTriggers(trigList);
        }
        if (event_name == "Add,Edit or Delete a Trigger") {
            this.DialogTriggerModify();
        }
        if (event_name.equalsIgnoreCase("mixer")) {
            this.changeMixer(((JRadioButtonMenuItem)event.getSource()).getText());
        }
        if (event_name == "Credits") {
            StringBuilder sb = new StringBuilder();
            sb.append("Thanks to ..");
            sb.append("\r\nAlan W for his help with the GW MMSI decoding");
            JOptionPane.showMessageDialog(null, sb.toString(), "Rivet", 1);
        }
        this.menuItemUpdate();
        this.statusBarUpdate();
    }

    public void menuItemUpdate() {
        this.save_to_file.setSelected(this.theApp.getLogging());
        this.CROWD36_item.setSelected(this.theApp.isCROWD36());
        this.XPA_10_item.setSelected(this.theApp.isXPA_10());
        this.XPA_20_item.setSelected(this.theApp.isXPA_20());
        this.XPA2_item.setSelected(this.theApp.isXPA2());
        this.CIS3650_item.setSelected(this.theApp.isCIS3650());
        this.CCIR493_item.setSelected(this.theApp.isCCIR493());
        this.GW_item.setSelected(this.theApp.isGW());
        this.experimental_item.setSelected(this.theApp.isExperimental());
        this.FSK_item.setSelected(this.theApp.isFSK());
        this.FSK200500_item.setSelected(this.theApp.isFSK200500());
        this.FSK2001000_item.setSelected(this.theApp.isFSK2001000());
        this.debug_item.setSelected(this.theApp.isDebug());
        this.soundcard_item.setSelected(this.theApp.isSoundCardInput());
        this.invert_item.setSelected(this.theApp.isInvertSignal());
        this.bitstream_item.setSelected(this.theApp.isBitStreamOut());
        this.freeChannelMarkerGW_item.setSelected(this.theApp.isViewGWChannelMarkers());
        this.DisplayBad_item.setSelected(this.theApp.isDisplayBadPackets());
        this.DisplayUTC_item.setSelected(this.theApp.isLogInUTC());
        this.RTTY_item.setSelected(this.theApp.isRTTY());
        List<Trigger> trigList = this.theApp.getListTriggers();
        for (int a = 0; a < trigList.size(); ++a) {
            this.trigger_items.get(a).setSelected(trigList.get(a).isActive());
        }
        MenuElement[] devs = this.audioDevicesMenu.getSubElements();
        if (devs.length > 0) {
            for (MenuElement m : devs[0].getSubElements()) {
                if (!((JRadioButtonMenuItem)m).getText().equals(this.theApp.inputThread.getMixerName())) continue;
                ((JRadioButtonMenuItem)m).setSelected(true);
                break;
            }
        }
    }

    public String loadDialogBox() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Select a WAV file to load");
        fc.setCurrentDirectory(new File("."));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new WAVfileFilter());
        int returnval = fc.showOpenDialog(this);
        if (returnval == 1) {
            return null;
        }
        String file_name = fc.getSelectedFile().getPath();
        return file_name;
    }

    private void statusBarUpdate() {
        this.statusBar.setModeLabel(this.theApp.MODENAMES[this.theApp.getSystem()]);
        this.statusBar.setSoundCardInput(this.theApp.getSoundCardLevel());
        this.theApp.setSoundCardLevel(this.theApp.getSoundCardLevel());
    }

    public void progressBarUpdate(int v) {
        this.statusBar.setVolumeBar(v);
    }

    public void setStatusLabel(String st) {
        this.statusBar.setStatusLabel(st);
    }

    public void closeLogFile() {
        this.theApp.setLogging(false);
        this.statusBar.setLoggingStatus("Not Logging");
        try {
            if (this.theApp.isGW()) {
                this.theApp.fileWriteLine(this.theApp.getShipList());
            }
            this.theApp.file.flush();
            this.theApp.file.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error closing Log file", "Rivet", 1);
        }
    }

    public void closeBitStreamFile() {
        this.theApp.setBitStreamOut(false);
        try {
            this.theApp.bitStreamFile.flush();
            this.theApp.bitStreamFile.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error closing the Bit Stream file", "Rivet", 1);
        }
    }

    public boolean saveDialogBox() {
        int response;
        File tfile;
        if (this.theApp.getLogging()) {
            return false;
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Select the log file name");
        fc.setCurrentDirectory(new File("."));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new TextFileFilter());
        int returnval = fc.showSaveDialog(this);
        if (returnval == 1) {
            return false;
        }
        String file_name = fc.getSelectedFile().getPath();
        int last_index = file_name.lastIndexOf(".txt");
        if (last_index != file_name.length() - 4) {
            file_name = file_name + ".txt";
        }
        if ((tfile = new File(file_name)).exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
            return false;
        }
        try {
            this.theApp.file = new FileWriter(tfile);
            String fline = this.theApp.program_version + "\r\n";
            this.theApp.file.write(fline);
        }
        catch (Exception e) {
            System.out.println("\nError opening the logging file");
            return false;
        }
        this.theApp.setLogging(true);
        return true;
    }

    public void setClipboard(String str) {
        StringSelection ss = new StringSelection(str);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, null);
    }

    public boolean saveBitStreamDialogBox() {
        int response;
        File tfile;
        if (this.theApp.isBitStreamOut()) {
            return false;
        }
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Select the bit stream output file name");
        fc.setCurrentDirectory(new File("."));
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new BitStreamFileFilter());
        int returnval = fc.showSaveDialog(this);
        if (returnval == 1) {
            return false;
        }
        String file_name = fc.getSelectedFile().getPath();
        int last_index = file_name.lastIndexOf(".bsf");
        if (last_index != file_name.length() - 4) {
            file_name = file_name + ".bsf";
        }
        if ((tfile = new File(file_name)).exists() && (response = JOptionPane.showConfirmDialog(null, "Overwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
            return false;
        }
        try {
            this.theApp.bitStreamFile = new FileWriter(tfile);
        }
        catch (Exception e) {
            System.out.println("\nError opening the bit stream file");
            return false;
        }
        this.theApp.setBitStreamOut(true);
        return true;
    }

    void DialogTriggerModify() {
        TriggerModify triggerModify = new TriggerModify(this, this.theApp);
        if (triggerModify.isChangedTriggers()) {
            this.updateTriggerMenuItems();
        }
    }

    void updateTriggerMenuItems() {
        this.triggersMenu.removeAll();
        List<Trigger> trigList = this.theApp.getListTriggers();
        for (int a = 0; a < trigList.size(); ++a) {
            JRadioButtonMenuItem tmenu = new JRadioButtonMenuItem(trigList.get(a).getTriggerDescription() + trigList.get(a).getTypeDescription(), trigList.get(a).isActive());
            tmenu.addActionListener(this);
            this.trigger_items.add(tmenu);
            this.triggersMenu.add(tmenu);
        }
        this.triggersMenu.addSeparator();
        this.AddEditTrigger_item = new JMenuItem("Add,Edit or Delete a Trigger");
        this.triggersMenu.add(this.AddEditTrigger_item);
        this.AddEditTrigger_item.addActionListener(this);
        if (!this.theApp.saveTriggerXMLFile()) {
            JOptionPane.showMessageDialog(null, "Error saving the Triggers", "Rivet", 1);
        }
    }

    private JMenu buildAudioDevices() {
        JMenu ret = new JMenu("Audio Devices");
        ButtonGroup group = new ButtonGroup();
        ArrayList<AudioMixer> deviceList = this.getCompatibleDevices();
        for (int i = 0; i < deviceList.size(); ++i) {
            JRadioButtonMenuItem dev = new JRadioButtonMenuItem(deviceList.get((int)i).description);
            dev.setActionCommand("mixer");
            dev.addActionListener(this);
            if (i == 0) {
                dev.setSelected(true);
            }
            group.add(dev);
            ret.add(dev);
        }
        return ret;
    }

    private ArrayList<AudioMixer> getCompatibleDevices() {
        devices = new ArrayList();
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        for (int i = 0; i < mixers.length; ++i) {
            Mixer m = AudioSystem.getMixer(mixers[i]);
            Line.Info[] l = m.getTargetLineInfo();
            if (l.length <= 0 || !m.getMixerInfo().getDescription().endsWith("Capture")) continue;
            for (int x = 0; x < l.length; ++x) {
                if (!l[0].getLineClass().getName().equals("javax.sound.sampled.TargetDataLine")) continue;
                AudioMixer mc = new AudioMixer(mixers[i].getName(), m, l[x]);
                devices.add(mc);
            }
        }
        return devices;
    }

    private void changeMixer(String mixerName) {
        if (!this.theApp.changeMixer(mixerName)) {
            JOptionPane.showMessageDialog(null, "Error changing mixer\n" + this.theApp.inputThread.getMixerErrorMessage(), "Rivet", 0);
        }
    }

    public void scrollDown(int v) {
        this.vscrollbar.setValue(v);
    }

    public boolean isAdjusting() {
        return this.vscrollbar.getValueIsAdjusting();
    }

    public void setSmallScreen() {
        this.statusBar.setSmallScreen();
    }

    class MouseAdjustmentListener
    implements MouseWheelListener {
        MouseAdjustmentListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent me) {
            int notches = me.getWheelRotation();
            int vc = DisplayFrame.this.vscrollbar.getValue();
            int ADJUST = 4;
            if (notches > 0) {
                DisplayFrame.this.vscrollbar.setValue(vc += 4);
            } else if (notches < 0) {
                if (vc > 4) {
                    vc -= 4;
                }
                DisplayFrame.this.vscrollbar.setValue(vc);
            } else {
                return;
            }
            DisplayFrame.this.theApp.setLastUserScroll(System.currentTimeMillis() / 1000L);
            DisplayFrame.this.theApp.setAutoScroll(false);
        }
    }

    class MyAdjustmentListener
    implements AdjustmentListener {
        MyAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (e.getSource() == DisplayFrame.this.vscrollbar) {
                ((DisplayFrame)DisplayFrame.this).theApp.vertical_scrollbar_value = e.getValue();
                if (DisplayFrame.this.vscrollbar.getValueIsAdjusting()) {
                    DisplayFrame.this.theApp.setLastUserScroll(System.currentTimeMillis() / 1000L);
                    DisplayFrame.this.theApp.setAutoScroll(false);
                }
                DisplayFrame.this.repaint();
            }
        }
    }
}

