/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.e2k.Rivet;

public class DisplayView
extends JComponent
implements Observer {
    public static final long serialVersionUID = 1L;
    private static final int DISPLAYCOUNT = 329;
    private String[] displayString = new String[329];
    private Color[] displayColour = new Color[329];
    private Font[] displayFont = new Font[329];
    private int displayCounter = 0;
    private Rivet theApp;

    public DisplayView(Rivet theApp) {
        this.theApp = theApp;
    }

    @Override
    public void update(Observable o, Object rectangle) {
    }

    @Override
    public void paint(Graphics g) {
        int count = 0;
        int pos = 20;
        int i = this.displayCounter + 1;
        if (i >= 329) {
            i = 0;
        }
        Graphics2D g2D = (Graphics2D)g;
        while (count < 329) {
            if (this.displayString[i] != null) {
                g.setColor(this.displayColour[i]);
                g.setFont(this.displayFont[i]);
                g2D.drawString(this.displayString[i].toString(), 5 - this.theApp.horizontal_scrollbar_value, pos - this.theApp.vertical_scrollbar_value);
                pos += 20;
            }
            if (++i == 329) {
                i = 0;
            }
            ++count;
        }
        if (this.theApp.isAutoScroll() && !this.theApp.isAdjusting() && pos - this.theApp.vertical_scrollbar_value > this.theApp.getCurrentHeight()) {
            this.theApp.scrollDown(pos);
            this.repaint();
        }
    }

    public void addLine(String line, Color tcol, Font tfont) {
        ++this.displayCounter;
        if (this.displayCounter == 329) {
            this.displayCounter = 0;
        }
        this.displayString[this.displayCounter] = line;
        this.displayColour[this.displayCounter] = tcol;
        this.displayFont[this.displayCounter] = tfont;
        this.theApp.setAutoScroll(this.autoScrollSet());
        this.repaint();
    }

    public String getText() {
        StringBuilder buffer = new StringBuilder();
        int i = this.displayCounter + 1;
        int count = 0;
        if (i >= 329) {
            i = 0;
        }
        while (count < 329) {
            if (this.displayString[i] != null) {
                buffer.append(this.displayString[i]);
                buffer.append("\n");
            }
            if (++i >= 329) {
                i = 0;
            }
            ++count;
        }
        return buffer.toString();
    }

    public void addChar(String ch, Color col, Font font) {
        if (this.displayString[this.displayCounter] == null) {
            this.displayString[this.displayCounter] = "";
        }
        StringBuilder sb = new StringBuilder(this.displayString[this.displayCounter]);
        sb.append(ch);
        this.displayColour[this.displayCounter] = col;
        this.displayFont[this.displayCounter] = font;
        this.displayString[this.displayCounter] = sb.toString();
        this.theApp.setAutoScroll(this.autoScrollSet());
        this.repaint();
    }

    public void newLine() {
        ++this.displayCounter;
        if (this.displayCounter == 329) {
            this.displayCounter = 0;
        }
        this.displayString[this.displayCounter] = "";
        this.theApp.setAutoScroll(this.autoScrollSet());
        this.repaint();
    }

    public void clearScreen() {
        this.displayCounter = 0;
        for (int a = 0; a < 329; ++a) {
            this.displayString[a] = null;
        }
        this.theApp.scrollDown(0);
        this.repaint();
    }

    private void screenTest() {
        for (int a = 0; a < 329; ++a) {
            String line = "Line " + Integer.toString(a) + " test";
            this.addLine(line, Color.BLACK, this.theApp.italicFont);
        }
    }

    private boolean autoScrollSet() {
        long currentTime = System.currentTimeMillis() / 1000L;
        return currentTime - this.theApp.getLastUserScroll() >= 30L;
    }
}

