/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.util.ArrayList;
import java.util.List;
import org.e2k.Core;
import org.e2k.Rivet;

public class FFT
extends Core {
    private int highSpectrum;
    private double totalEnergy;
    private double highestValue;
    public final int FFT_64_SIZE = 64;
    public final int FFT_80_SIZE = 80;
    public final int FFT_106_SIZE = 106;
    public final int FFT_160_SIZE = 160;
    public final int FFT_176_SIZE = 176;
    public final int RDFT_FFT_SIZE = 800;
    private int freqBin;
    public DoubleFFT_1D fft64 = new DoubleFFT_1D(64);
    public DoubleFFT_1D fft80 = new DoubleFFT_1D(80);
    public DoubleFFT_1D fft106 = new DoubleFFT_1D(106);
    public DoubleFFT_1D fft160 = new DoubleFFT_1D(160);
    public DoubleFFT_1D fft176 = new DoubleFFT_1D(176);
    public DoubleFFT_1D RDFTfft = new DoubleFFT_1D(800);
    private double componentDC;
    private List<Double> spectrumVals = new ArrayList<Double>();
    private boolean spectrumRecord = false;

    public double[] getSpectrum(double[] data) {
        double[] spectrum = new double[data.length / 2];
        double highS = 0.0;
        if (this.spectrumRecord) {
            this.spectrumVals.clear();
        }
        this.totalEnergy = 0.0;
        int count = 0;
        this.componentDC = data[0];
        for (int a = 2; a < data.length; a += 2) {
            spectrum[count] = Math.sqrt(Math.pow(data[a], 2.0) + Math.pow(data[a + 1], 2.0));
            if (this.spectrumRecord) {
                this.spectrumVals.add(spectrum[count]);
            }
            if (spectrum[count] > highS) {
                highS = spectrum[count];
            }
            this.totalEnergy += spectrum[count];
            ++count;
        }
        this.setHighSpectrum((int)highS);
        return spectrum;
    }

    public int getFFTFreq(double[] x, double sampleFreq) {
        int bin = this.findHighBin(x);
        this.freqBin = bin - 1;
        double len = x.length * 2;
        double ret = sampleFreq / len * (double)bin;
        return (int)ret;
    }

    public int findHighBin(double[] x) {
        int highBin = -1;
        this.highestValue = -1.0;
        for (int a = 0; a < x.length; ++a) {
            if (!(x[a] > this.highestValue)) continue;
            this.highestValue = x[a];
            highBin = a;
        }
        return highBin + 1;
    }

    public int getHighSpectrum() {
        return this.highSpectrum;
    }

    public void setHighSpectrum(int highSpectrum) {
        this.highSpectrum = highSpectrum;
    }

    public double getTotalEnergy() {
        return this.totalEnergy;
    }

    public double windowHamming(double in, int i, int m) {
        double r = 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)i / (double)m);
        return in * r;
    }

    public double windowBlackman(double in, int i, int m) {
        double r = 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)m) + 0.08 * Math.cos(Math.PI * 4 * (double)i / (double)m);
        return in * r;
    }

    public double getPercentageOfTotal() {
        double p = this.highestValue / this.totalEnergy * 100.0;
        return p;
    }

    public int getFreqBin() {
        return this.freqBin;
    }

    public double getComponentDC() {
        return this.componentDC;
    }

    public String getSpectrumValsString() {
        StringBuilder sb = new StringBuilder();
        for (int a = 0; a < this.spectrumVals.size(); ++a) {
            double s = this.spectrumVals.get(a);
            sb.append(Double.toString(s) + ",");
        }
        return sb.toString();
    }

    public void saveSpectrumtoFile(Rivet rTheApp, double[] s) {
        rTheApp.debugDump("#");
        for (int a = 0; a < s.length; ++a) {
            rTheApp.debugDump(Double.toString(s[a]));
        }
    }
}

