/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import javax.swing.JOptionPane;
import org.e2k.CircularDataBuffer;
import org.e2k.FFT;
import org.e2k.WaveData;

public class FSK
extends FFT {
    private final String[] BAUDOT_LETTERS = new String[]{"N/A", "E", "<LF>", "A", " ", "S", "I", "U", "<CR>", "D", "R", "J", "N", "F", "C", "K", "T", "Z", "L", "W", "H", "Y", "P", "Q", "O", "B", "G", "<FIG>", "M", "X", "V", "<LET>"};
    private final String[] BAUDOT_NUMBERS = new String[]{"N/A", "3", "<LF>", "-", " ", "<BELL>", "8", "7", "<CR>", "$", "4", "'", ",", "!", ":", "(", "5", "+", ")", "2", "#", "6", "0", "1", "9", "?", "&", "<FIG>", ".", "/", "=", "<LET>"};
    public final int[] ITA3VALS = new int[]{13, 37, 56, 100, 69, 21, 50, 112, 70, 74, 26, 42, 28, 19, 97, 82, 35, 11, 98, 49, 22, 76, 73, 25, 84, 81, 67, 88, 38, 14, 41, 44, 52, 104, 7};
    public final String[] ITA3LETS = new String[]{"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "A", "S", "D", "F", "G", "H", "J", "K", "L", "Z", "X", "C", "V", "B", "N", "M", "<cr>", "<lf>", "<fig>", "<let>", "<alpha>", "<beta>", "<rep>", "<0x68>", "<0x7>"};
    public final int[] CCIR476VALS = new int[]{106, 92, 46, 39, 86, 85, 116, 43, 78, 77, 113, 45, 71, 75, 83, 27, 53, 105, 23, 30, 101, 99, 58, 29, 60, 114, 89, 57, 120, 108, 54, 90, 15};
    public final String[] CCIR476LETS = new String[]{"<32>", " ", "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "A", "S", "D", "F", "G", "H", "J", "K", "L", "Z", "X", "C", "V", "B", "N", "M", "<cr>", "<lf>", "<fig>", "<let>", "<alpha>"};
    public final String[] CCIR476NUMS = new String[]{"<32>", " ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", "'", " ", "%", "@", "#", "*", "(", ")", "+", "/", ":", "=", "?", ",", ".", "<cr>", "<lf>", "<fig>", "<let>", "<alpha>"};
    public boolean lettersMode = true;
    public double kalmanNew = 0.0;
    public double kalmanOld = 0.0;

    public int doFSK200500_8000FFT(CircularDataBuffer circBuf, WaveData waveData, int start, int ss) {
        double[] datao = circBuf.extractDataDouble(start, ss);
        double[] datar = new double[64];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 12 && a < 52 ? datao[a - 12] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int doRTTY_8000FFT(CircularDataBuffer circBuf, WaveData waveData, int start, int ss, double baud) {
        if (baud == 45.45) {
            double[] datar = circBuf.extractDataDouble(start, 176);
            this.fft176.realForward(datar);
            double[] spec = this.getSpectrum(datar);
            int freq = this.getFFTFreq(spec, waveData.getSampleRate());
            return freq;
        }
        if (baud == 50.0) {
            double[] datar = circBuf.extractDataDouble(start, 160);
            this.fft160.realForward(datar);
            double[] spec = this.getSpectrum(datar);
            int freq = this.getFFTFreq(spec, waveData.getSampleRate());
            return freq;
        }
        if (baud == 75.0) {
            double[] datar = circBuf.extractDataDouble(start, 106);
            this.fft106.realForward(datar);
            double[] spec = this.getSpectrum(datar);
            int freq = this.getFFTFreq(spec, waveData.getSampleRate());
            return freq;
        }
        if (baud == 100.0) {
            return this.do100baudFFT(circBuf, waveData, start);
        }
        if (baud == 145.0) {
            return this.do145baudFFT(circBuf, waveData, start);
        }
        if (baud == 150.0) {
            return this.do150baudFFT(circBuf, waveData, start);
        }
        if (baud == 200.0) {
            return this.doFSK200500_8000FFT(circBuf, waveData, start, ss);
        }
        if (baud == 300.0) {
            return this.do300baudFFT(circBuf, waveData, start);
        }
        if (baud == 600.0) {
            return this.do600baudFFT(circBuf, waveData, start);
        }
        return 0;
    }

    public int do64FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 64);
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public double[] do64FFTBinRequest(CircularDataBuffer circBuf, WaveData waveData, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] datar = circBuf.extractDataDouble(start, 64);
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public double[] do80FFTBinRequest(CircularDataBuffer circBuf, WaveData waveData, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] datar = circBuf.extractDataDouble(start, 80);
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft80.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public double[] do100baudFSKHalfSymbolBinRequest(CircularDataBuffer circBuf, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] samData = circBuf.extractDataDouble(start, 40);
        double[] datar = new double[160];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 60 && a < 100 ? samData[a - 60] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public double[] do145baudFSKHalfSymbolBinRequest(CircularDataBuffer circBuf, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] samData = circBuf.extractDataDouble(start, 27);
        double[] datar = new double[160];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 66 && a < 93 ? samData[a - 66] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public double[] do150baudFSKHalfSymbolBinRequest(CircularDataBuffer circBuf, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] samData = circBuf.extractDataDouble(start, 26);
        double[] datar = new double[160];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 67 && a < 93 ? samData[a - 67] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public double[] do200baudFSKHalfSymbolBinRequest(CircularDataBuffer circBuf, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] samData = circBuf.extractDataDouble(start, 20);
        double[] datar = new double[64];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 22 && a < 42 ? samData[a - 22] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public double[] do300baudFSKHalfSymbolBinRequest(CircularDataBuffer circBuf, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] samData = circBuf.extractDataDouble(start, 13);
        double[] datar = new double[64];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 25 && a < 38 ? samData[a - 25] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public double[] do600baudFSKHalfSymbolBinRequest(CircularDataBuffer circBuf, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] samData = circBuf.extractDataDouble(start, 6);
        double[] datar = new double[64];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 29 && a < 35 ? samData[a - 29] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public double[] doRTTYHalfSymbolBinRequest(double baud, CircularDataBuffer circBuf, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        if (baud == 45.45) {
            double[] samData = circBuf.extractDataDouble(start, 88);
            double[] datar = new double[176];
            for (int a = 0; a < datar.length; ++a) {
                datar[a] = a >= 44 && a < 132 ? samData[a - 44] : 0.0;
                datar[a] = this.windowBlackman(datar[a], a, datar.length);
            }
            this.fft176.realForward(datar);
            double[] spec = this.getSpectrum(datar);
            vals[0] = spec[bin0];
            vals[1] = spec[bin1];
            return vals;
        }
        if (baud == 50.0) {
            double[] samData = circBuf.extractDataDouble(start, 80);
            double[] datar = new double[160];
            for (int a = 0; a < datar.length; ++a) {
                datar[a] = a >= 40 && a < 120 ? samData[a - 40] : 0.0;
                datar[a] = this.windowBlackman(datar[a], a, datar.length);
            }
            this.fft160.realForward(datar);
            double[] spec = this.getSpectrum(datar);
            vals[0] = spec[bin0];
            vals[1] = spec[bin1];
            return vals;
        }
        if (baud == 75.0) {
            double[] samData = circBuf.extractDataDouble(start, 53);
            double[] datar = new double[106];
            for (int a = 0; a < datar.length; ++a) {
                datar[a] = a >= 26 && a < 79 ? samData[a - 26] : 0.0;
                datar[a] = this.windowBlackman(datar[a], a, datar.length);
            }
            this.fft106.realForward(datar);
            double[] spec = this.getSpectrum(datar);
            vals[0] = spec[bin0];
            vals[1] = spec[bin1];
            return vals;
        }
        if (baud == 100.0) {
            return this.do100baudFSKHalfSymbolBinRequest(circBuf, start, bin0, bin1);
        }
        if (baud == 145.0) {
            return this.do145baudFSKHalfSymbolBinRequest(circBuf, start, bin0, bin1);
        }
        if (baud == 150.0) {
            return this.do150baudFSKHalfSymbolBinRequest(circBuf, start, bin0, bin1);
        }
        if (baud == 200.0) {
            return this.do200baudFSKHalfSymbolBinRequest(circBuf, start, bin0, bin1);
        }
        if (baud == 300.0) {
            return this.do300baudFSKHalfSymbolBinRequest(circBuf, start, bin0, bin1);
        }
        if (baud == 600.0) {
            return this.do600baudFSKHalfSymbolBinRequest(circBuf, start, bin0, bin1);
        }
        JOptionPane.showMessageDialog(null, "Unsupported Baud Rate", "Rivet", 0);
        return null;
    }

    public int do80FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 80);
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft80.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do160FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 160);
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do100baudFFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] samData = circBuf.extractDataDouble(start, 80);
        double[] datar = new double[160];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 40 && a < 120 ? samData[a - 40] : 0.0;
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do145baudFFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] samData = circBuf.extractDataDouble(start, 80);
        double[] datar = new double[160];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 40 && a < 120 ? samData[a - 40] : 0.0;
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do150baudFFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] samData = circBuf.extractDataDouble(start, 55);
        double[] datar = new double[160];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 52 && a < 107 ? samData[a - 52] : 0.0;
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do600baudFFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] samData = circBuf.extractDataDouble(start, 13);
        double[] datar = new double[64];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 25 && a < 38 ? samData[a - 25] : 0.0;
        }
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do300baudFFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] samData = circBuf.extractDataDouble(start, 26);
        double[] datar = new double[64];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 19 && a < 45 ? samData[a - 19] : 0.0;
        }
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int doCCIR493_160FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] samData = circBuf.extractDataDouble(start, 80);
        double[] datar = new double[160];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 60 && a < 120 ? samData[a - 60] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public double[] do160FFTHalfSymbolBinRequest(CircularDataBuffer circBuf, int start, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] datar = new double[160];
        double[] samData = circBuf.extractDataDouble(start, 40);
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 60 && a < 100 ? samData[a - 60] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft160.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public boolean toneTest(int freq, int tone, int errorAllow) {
        return freq > tone - errorAllow && freq < tone + errorAllow;
    }

    public boolean freqDecision(int freq, int centreFreq, boolean inv) {
        if (!inv) {
            return freq > centreFreq;
        }
        return freq <= centreFreq;
    }

    public double[] do64FFTHalfSymbolBinRequest(CircularDataBuffer circBuf, int start, int samples, int bin0, int bin1) {
        double[] vals = new double[2];
        double[] datar = new double[64];
        double[] samData = circBuf.extractDataDouble(start, samples);
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = a >= 22 && a < 42 ? samData[a - 22] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
        }
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        vals[0] = spec[bin0];
        vals[1] = spec[bin1];
        return vals;
    }

    public String getBAUDOT_LETTERS(int i) {
        return this.BAUDOT_LETTERS[i];
    }

    public String getBAUDOT_NUMBERS(int i) {
        return this.BAUDOT_NUMBERS[i];
    }

    public double getPercentageDifference(double x, double y) {
        return (x - y) / (x + y) * 100.0;
    }

    public double kalmanFilter(double in, double cof1, double cof2) {
        double newo = cof1 * this.kalmanOld + cof2 * in;
        this.kalmanOld = this.kalmanNew;
        this.kalmanNew = newo;
        return newo;
    }

    public int retITA3Val(int c) {
        for (int a = 0; a < this.ITA3VALS.length; ++a) {
            if (c != this.ITA3VALS[a]) continue;
            return a;
        }
        return 0;
    }

    public boolean checkITA3Char(int c) {
        for (int a = 0; a < this.ITA3VALS.length; ++a) {
            if (c != this.ITA3VALS[a]) continue;
            return true;
        }
        return false;
    }

    public int retCCIR476Val(int c) {
        for (int a = 0; a < this.CCIR476VALS.length; ++a) {
            if (c != this.CCIR476VALS[a]) continue;
            return a;
        }
        return 0;
    }

    public boolean checkCCIR476Char(int c) {
        for (int a = 0; a < this.CCIR476VALS.length; ++a) {
            if (c != this.CCIR476VALS[a]) continue;
            return true;
        }
        return false;
    }
}

