/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.e2k.CRC;
import org.e2k.CircularBitSet;
import org.e2k.CircularDataBuffer;
import org.e2k.FSK;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class FSK2001000
extends FSK {
    private int baudRate = 200;
    private int state = 0;
    private double samplesPerSymbol;
    private Rivet theApp;
    public long sampleCount = 0L;
    private long symbolCounter = 0L;
    private CircularDataBuffer energyBuffer = new CircularDataBuffer();
    private int characterCount = 0;
    private int highBin;
    private int lowBin;
    private final int MAXCHARLENGTH = 80;
    private double[] adjBuffer = new double[5];
    private int adjCounter = 0;
    private CircularBitSet circularBitSet = new CircularBitSet();
    private int bitCount = 0;
    private int blockCount = 0;
    private int missingBlockCount = 0;
    private int bitsSinceLastBlockHeader = 0;
    private int messageTotalBlockCount = 0;
    private CRC crcCalculator;
    private int txType;

    public FSK2001000(Rivet tapp, int baud) {
        this.baudRate = baud;
        this.theApp = tapp;
        this.circularBitSet.setTotalLength(288);
        this.crcCalculator = new CRC(16, 4129, 65535, 65535, true, true);
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 1) {
            this.theApp.setStatusLabel("Sync Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Msg Hunt");
        } else if (state == 3) {
            this.theApp.setStatusLabel("Debug Only");
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nFSK200/1000 recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.samplesPerSymbol = this.samplesPerSymbol(this.baudRate, waveData.getSampleRate());
            this.setState(1);
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.energyBuffer.setBufferCounter(0);
            this.characterCount = 0;
            this.lettersMode = true;
            this.txType = 0;
            return true;
        }
        if (this.state == 1) {
            String dout = this.sampleCount > 0L ? this.syncSequenceHunt(circBuf, waveData) : null;
            if (dout != null) {
                this.theApp.writeLine(dout, Color.BLACK, this.theApp.boldFont);
                if (this.theApp.isDebug()) {
                    this.setState(3);
                } else {
                    this.setState(2);
                }
                this.energyBuffer.setBufferCounter(0);
                this.bitsSinceLastBlockHeader = 0;
            }
        } else if (this.state == 2) {
            if ((double)this.symbolCounter >= this.samplesPerSymbol) {
                this.symbolCounter = 0L;
                boolean ibit = this.fsk2001000FreqHalf(circBuf, waveData, 0);
                this.circularBitSet.add(ibit);
                ++this.bitCount;
                ++this.bitsSinceLastBlockHeader;
                int difSync = this.compareSync(this.circularBitSet.extractSection(0, 32));
                if (difSync < 2) {
                    this.processBlock();
                }
                if (this.bitsSinceLastBlockHeader > 2880) {
                    this.setState(1);
                }
            }
        } else if (this.state == 3 && (double)this.symbolCounter >= this.samplesPerSymbol) {
            this.symbolCounter = 0L;
            boolean ibit = this.fsk2001000FreqHalf(circBuf, waveData, 0);
            if (ibit) {
                this.theApp.writeChar("1", Color.BLACK, this.theApp.boldFont);
            } else {
                this.theApp.writeChar("0", Color.BLACK, this.theApp.boldFont);
            }
            ++this.characterCount;
            if (this.characterCount == 80) {
                this.theApp.newLineWrite();
                this.characterCount = 0;
            }
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    private String syncSequenceHunt(CircularDataBuffer circBuf, WaveData waveData) {
        int freq1 = this.fsk2001000Freq(circBuf, waveData, 0);
        int bin1 = this.getFreqBin();
        if (this.getPercentageOfTotal() < 5.0) {
            return null;
        }
        int freq2 = this.fsk2001000Freq(circBuf, waveData, (int)this.samplesPerSymbol * 1);
        int bin2 = this.getFreqBin();
        if (freq2 > freq1) {
            return null;
        }
        int difference = freq1 - freq2;
        if (difference < 975 || difference > 1025) {
            return null;
        }
        int freq3 = this.fsk2001000Freq(circBuf, waveData, (int)this.samplesPerSymbol * 2);
        if (freq1 != freq3) {
            return null;
        }
        int freq4 = this.fsk2001000Freq(circBuf, waveData, (int)this.samplesPerSymbol * 3);
        if (freq1 != freq3 || freq2 != freq4) {
            return null;
        }
        if (freq1 == freq2 || freq3 == freq4) {
            return null;
        }
        if (freq1 > freq2) {
            this.highBin = bin1;
            this.lowBin = bin2;
        } else {
            this.highBin = bin2;
            this.lowBin = bin1;
        }
        if (this.lowBin == 0 || this.highBin == 0) {
            return null;
        }
        String line = this.theApp.getTimeStamp() + " FSK200/1000 Sync Sequence Found";
        if (this.theApp.isDebug()) {
            line = line + " (lowBin=" + Integer.toString(this.lowBin) + " highBin=" + Integer.toString(this.highBin) + ")";
        }
        return line;
    }

    private int fsk2001000Freq(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        if (waveData.getSampleRate() == 8000.0) {
            int freq = this.doFSK200500_8000FFT(circBuf, waveData, pos, (int)this.samplesPerSymbol);
            return freq;
        }
        return -1;
    }

    private boolean fsk2001000FreqHalf(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        double[] late;
        int sp = (int)this.samplesPerSymbol / 2;
        double[] early = this.do64FFTHalfSymbolBinRequest(circBuf, pos, sp, this.lowBin, this.highBin);
        if (early[0] + (late = this.do64FFTHalfSymbolBinRequest(circBuf, pos + sp, sp, this.lowBin, this.highBin))[0] > early[1] + late[1]) {
            this.addToAdjBuffer(this.getPercentageDifference(early[0], late[0]));
        } else {
            this.addToAdjBuffer(this.getPercentageDifference(early[1], late[1]));
        }
        this.symbolCounter = this.adjAdjust();
        double lowTotal = early[0] + late[0];
        double highTotal = early[1] + late[1];
        boolean out = !this.theApp.isInvertSignal() ? !(lowTotal > highTotal) : lowTotal > highTotal;
        if (this.theApp.isBitStreamOut()) {
            if (out) {
                this.theApp.bitStreamWrite("1");
            } else {
                this.theApp.bitStreamWrite("0");
            }
        }
        return out;
    }

    private void addToAdjBuffer(double in) {
        this.adjBuffer[this.adjCounter] = in;
        ++this.adjCounter;
        if (this.adjCounter == this.adjBuffer.length) {
            this.adjCounter = 0;
        }
    }

    private double adjAverage() {
        double total = 0.0;
        for (int a = 0; a < this.adjBuffer.length; ++a) {
            total += this.adjBuffer[a];
        }
        return total / (double)this.adjBuffer.length;
    }

    private int adjAdjust() {
        double av = this.adjAverage();
        double r = Math.abs(av) / 10.0;
        if (av < 0.0) {
            r = 0.0 - r;
        }
        return (int)r;
    }

    public String getQuailty() {
        String line = "There were " + Integer.toString(this.blockCount) + " blocks in this message with " + Integer.toString(this.missingBlockCount) + " missing.";
        return line;
    }

    private int compareSync(String comp) {
        String INVSYNC = "10000010111011010100111100011001";
        String SYNC = "01111101000100101011000011100110";
        if (comp.length() != "01111101000100101011000011100110".length()) {
            return 32;
        }
        int dif = 0;
        int invdif = 0;
        for (int a = 0; a < comp.length(); ++a) {
            if (comp.charAt(a) != "01111101000100101011000011100110".charAt(a)) {
                ++dif;
            }
            if (comp.charAt(a) == "10000010111011010100111100011001".charAt(a)) continue;
            ++invdif;
        }
        if (invdif < 2) {
            if (this.theApp.isInvertSignal()) {
                this.theApp.setInvertSignal(false);
            } else {
                this.theApp.setInvertSignal(true);
            }
            return invdif;
        }
        return dif;
    }

    private void processBlock() {
        boolean isValid;
        int[] frame;
        if (this.bitCount > 288) {
            this.missingBlockCount += this.bitCount / 288;
        }
        if (this.checkDividerBlock(frame = this.circularBitSet.returnInts())) {
            this.theApp.writeLine("----------------------------------------------------------", Color.BLUE, this.theApp.boldFont);
            return;
        }
        int frameIndex = frame[4] << 3 | (frame[5] & 0xE0) >> 5;
        int[] data = new int[]{frame[6] & 0xF0 | frame[8] >> 4 & 0xF, frame[10] & 0xF0 | frame[12] >> 4 & 0xF, frame[14] & 0xF0 | frame[16] >> 4 & 0xF, frame[18] & 0xF0 | frame[20] >> 4 & 0xF, frame[22] & 0xF0 | frame[6] & 0xF, frame[8] << 4 & 0xF0 | frame[10] & 0xF, frame[12] << 4 & 0xF0 | frame[14] & 0xF, frame[16] << 4 & 0xF0 | frame[18] & 0xF, frame[20] << 4 & 0xF0 | frame[22] & 0xF, frame[7] & 0xF0 | frame[9] >> 4 & 0xF, frame[11] & 0xF0 | frame[13] >> 4 & 0xF, frame[15] & 0xF0 | frame[17] >> 4 & 0xF, frame[19] & 0xF0 | frame[21] >> 4 & 0xF, frame[23] & 0xF0 | frame[7] & 0xF, frame[9] << 4 & 0xF0 | frame[11] & 0xF, frame[13] << 4 & 0xF0 | frame[15] & 0xF};
        int crc = frame[17] << 12 & 0xFFFF | frame[19] << 8 & 0xFFF | frame[21] << 4 & 0xFF | frame[23] & 0xF;
        boolean bl = isValid = crc == this.crcCalculator.compute(data);
        if (frameIndex % 16 == 0) {
            int frameCount = data[0] << 3 | data[1] >> 5;
            int messageCount = data[1] & 0x1F;
            this.theApp.writeLine(String.format("[#%d] [INFO] %d blocks, %d message(s)", frameIndex, frameCount, messageCount), Color.BLUE, this.theApp.boldFont);
            return;
        }
        int[] digits = new int[]{data[0] << 2 | data[1] >> 6, data[1] << 4 & 0x3FF | data[2] >> 4, data[2] << 6 & 0x3FF | data[3] >> 2, data[3] << 8 & 0x3FF | data[4], data[5] << 2 | data[6] >> 6, data[6] << 4 & 0x3FF | data[7] >> 4, data[7] << 6 & 0x3FF | data[8] >> 2, data[8] << 8 & 0x3FF | data[9], data[10] << 2 | data[11] >> 6, data[11] << 4 & 0x3FF | data[12] >> 4, data[12] << 6 & 0x3FF | data[13] >> 2, data[13] << 8 & 0x3FF | data[14], data[15] >> 4, data[15] & 0xF};
        if (frameIndex == 1 && data[0] == 52 && data[1] == 54) {
            this.txType = 1;
        } else if (frameIndex == 1 && data[0] == 0 && data[1] == 0) {
            this.txType = 2;
        } else if (frameIndex == 1 && data[0] == 27) {
            this.txType = 0;
        }
        if (this.txType == 0) {
            this.theApp.writeLine(String.format("[#%d] %03d%03d%03d%03d%03d%03d%03d%03d%03d%03d%03d%03d%d%d | CRC %s", frameIndex, digits[0], digits[1], digits[2], digits[3], digits[4], digits[5], digits[6], digits[7], digits[8], digits[9], digits[10], digits[11], digits[12], digits[13], isValid ? "OK" : "ERROR"), isValid ? Color.BLACK : Color.RED, this.theApp.boldFont);
        } else if (this.txType == 1) {
            this.theApp.writeLine(String.format("[#%d] %c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c | CRC %s", frameIndex, data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[8], data[9], data[10], data[11], data[12], data[13], data[14], data[15], isValid ? "OK" : "ERROR"), isValid ? Color.BLACK : Color.RED, this.theApp.boldFont);
        } else if (this.txType == 2) {
            this.theApp.writeLine(String.format("[#%d] %02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x | CRC %s", frameIndex, data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[8], data[9], data[10], data[11], data[12], data[13], data[14], data[15], isValid ? "OK" : "ERROR"), isValid ? Color.BLACK : Color.RED, this.theApp.boldFont);
        }
        this.bitCount = 0;
        this.bitsSinceLastBlockHeader = 0;
        ++this.blockCount;
    }

    private boolean checkDividerBlock(int[] da) {
        int zeroCount = 0;
        for (int a = 5; a < da.length; ++a) {
            if (da[a] != 0) continue;
            ++zeroCount;
        }
        return zeroCount >= 30;
    }
}

