/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.e2k.CircularDataBuffer;
import org.e2k.FSK;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class FSK200500
extends FSK {
    private int baudRate = 200;
    private int state = 0;
    private double samplesPerSymbol;
    private Rivet theApp;
    public long sampleCount = 0L;
    private long symbolCounter = 0L;
    private StringBuilder lineBuffer = new StringBuilder();
    private CircularDataBuffer energyBuffer = new CircularDataBuffer();
    private int characterCount = 0;
    private int highBin;
    private int lowBin;
    private boolean[] inChar = new boolean[7];
    private final int MAXCHARLENGTH = 80;
    private int bcount;
    private long missingCharCounter = 0L;
    private long totalCharCounter = 0L;
    private double[] adjBuffer = new double[2];
    private int adjCounter = 0;
    private double errorPercentage;

    public FSK200500(Rivet tapp, int baud) {
        this.baudRate = baud;
        this.theApp = tapp;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 1) {
            this.theApp.setStatusLabel("Sync Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Decoding Traffic");
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        String dout;
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nFSK200/500 recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.samplesPerSymbol = this.samplesPerSymbol(this.baudRate, waveData.getSampleRate());
            this.setState(1);
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.energyBuffer.setBufferCounter(0);
            this.characterCount = 0;
            this.lineBuffer.delete(0, this.lineBuffer.length());
            this.lettersMode = true;
            return true;
        }
        if (this.state == 1 && (dout = this.sampleCount > 0L ? this.syncSequenceHunt(circBuf, waveData) : null) != null) {
            this.setState(2);
            this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
            this.energyBuffer.setBufferCounter(0);
            this.bcount = 0;
            this.totalCharCounter = 0L;
            this.missingCharCounter = 0L;
        }
        if (this.state == 2 && (double)this.symbolCounter >= this.samplesPerSymbol) {
            int ibit = this.fsk200500FreqHalf(circBuf, waveData, 0);
            if (this.theApp.isInvertSignal()) {
                if (ibit == 0) {
                    ibit = 1;
                } else if (ibit == 1) {
                    ibit = 0;
                }
            }
            if (this.theApp.isBitStreamOut()) {
                if (ibit == 1) {
                    this.theApp.bitStreamWrite("1");
                } else if (ibit == 0) {
                    this.theApp.bitStreamWrite("0");
                } else if (ibit == 2) {
                    this.theApp.bitStreamWrite("2");
                } else if (ibit == 3) {
                    this.theApp.bitStreamWrite("3");
                }
            }
            if (ibit == 2) {
                String dout2;
                ++this.totalCharCounter;
                this.symbolCounter = (int)this.samplesPerSymbol / 2;
                if (this.theApp.isDebug()) {
                    dout2 = this.getCharBuffer() + " (" + Integer.toString(this.bcount) + ")  " + this.getBaudotChar();
                    this.theApp.writeLine(dout2, Color.BLACK, this.theApp.boldFont);
                } else {
                    String ch = this.getBaudotChar();
                    if (ch.equals(this.getBAUDOT_LETTERS(2))) {
                        this.theApp.newLineWrite();
                    } else if (ch.equals(this.getBAUDOT_LETTERS(8))) {
                        this.theApp.newLineWrite();
                    } else {
                        this.lineBuffer.append(ch);
                        this.theApp.writeChar(ch, Color.BLACK, this.theApp.boldFont);
                        ++this.characterCount;
                        if (this.lineBuffer.lastIndexOf("162)5761") != -1) {
                            this.characterCount = 80;
                        }
                        if (this.lineBuffer.length() > 20 && this.lineBuffer.charAt(this.lineBuffer.length() - 6) == '=') {
                            this.characterCount = 80;
                        }
                        if (this.lineBuffer.length() > 20 && this.lineBuffer.charAt(this.lineBuffer.length() - 6) == ')' && this.lineBuffer.charAt(this.lineBuffer.length() - 7) == ' ') {
                            this.characterCount = 80;
                        }
                    }
                }
                if (this.bcount != 7) {
                    ++this.missingCharCounter;
                    this.errorPercentage = (double)this.missingCharCounter / (double)this.totalCharCounter * 100.0;
                    if (this.errorPercentage > 50.0) {
                        dout2 = this.theApp.getTimeStamp() + " FSK200/500 Sync Lost";
                        this.theApp.writeLine(dout2, Color.BLACK, this.theApp.italicFont);
                        this.setState(1);
                    }
                }
                this.bcount = 0;
            } else {
                this.addToCharBuffer(ibit);
                this.symbolCounter = this.adjAdjust();
            }
            if (this.characterCount >= 80) {
                this.theApp.newLineWrite();
                this.lineBuffer.delete(0, this.lineBuffer.length());
                this.characterCount = 0;
            }
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    private String syncSequenceHunt(CircularDataBuffer circBuf, WaveData waveData) {
        int freq1 = this.fsk200500Freq(circBuf, waveData, 0);
        int bin1 = this.getFreqBin();
        if (this.getPercentageOfTotal() < 5.0) {
            return null;
        }
        int freq2 = this.fsk200500Freq(circBuf, waveData, (int)this.samplesPerSymbol * 1);
        int bin2 = this.getFreqBin();
        if (freq2 > freq1) {
            return null;
        }
        int difference = freq1 - freq2;
        if (difference < 475 || difference > 525) {
            return null;
        }
        int freq3 = this.fsk200500Freq(circBuf, waveData, (int)this.samplesPerSymbol * 2);
        if (freq1 != freq3) {
            return null;
        }
        int freq4 = this.fsk200500Freq(circBuf, waveData, (int)this.samplesPerSymbol * 3);
        if (freq1 != freq3 || freq2 != freq4) {
            return null;
        }
        if (freq1 == freq2 || freq3 == freq4) {
            return null;
        }
        if (freq1 > freq2) {
            this.highBin = bin1;
            this.lowBin = bin2;
        } else {
            this.highBin = bin2;
            this.lowBin = bin1;
        }
        if (this.lowBin == 0 || this.highBin == 0) {
            return null;
        }
        String line = this.theApp.getTimeStamp() + " FSK200/500 Sync Sequence Found";
        return line;
    }

    private int fsk200500Freq(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        if (waveData.getSampleRate() == 8000.0) {
            int freq = this.doFSK200500_8000FFT(circBuf, waveData, pos, (int)this.samplesPerSymbol);
            return freq;
        }
        return -1;
    }

    private int fsk200500FreqHalf(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        double[] late;
        boolean high2;
        int sp = (int)this.samplesPerSymbol / 2;
        double[] early = this.do64FFTHalfSymbolBinRequest(circBuf, pos, sp, this.lowBin, this.highBin);
        boolean high1 = !(early[0] > early[1]);
        int v = high1 == (high2 = !((late = this.do64FFTHalfSymbolBinRequest(circBuf, pos + sp, sp, this.lowBin, this.highBin))[0] > late[1])) ? (!high1 ? 1 : 0) : (this.checkValid() ? (high2 > high1 ? 2 : (early[0] + late[0] > early[1] + late[1] ? 1 : 0)) : (early[0] + late[0] > early[1] + late[1] ? 1 : 0));
        if (v < 2) {
            double lowTotal = early[0] + late[0];
            double highTotal = early[1] + late[1];
            if (lowTotal > highTotal) {
                this.addToAdjBuffer(this.getPercentageDifference(early[0], late[0]));
            } else {
                this.addToAdjBuffer(this.getPercentageDifference(early[1], late[1]));
            }
        }
        return v;
    }

    private void addToCharBuffer(int in) {
        for (int a = 1; a < this.inChar.length; ++a) {
            this.inChar[a - 1] = this.inChar[a];
        }
        this.inChar[6] = in != 0;
        ++this.bcount;
    }

    private String getCharBuffer() {
        StringBuilder lb = new StringBuilder();
        for (int a = 0; a < 7; ++a) {
            if (this.inChar[a]) {
                lb.append("1");
            } else {
                lb.append("0");
            }
            if (a != 0 && a != 5) continue;
            lb.append(" ");
        }
        return lb.toString();
    }

    private String getBaudotChar() {
        int a = 0;
        if (this.inChar[5]) {
            a = 16;
        }
        if (this.inChar[4]) {
            a += 8;
        }
        if (this.inChar[3]) {
            a += 4;
        }
        if (this.inChar[2]) {
            a += 2;
        }
        if (this.inChar[1]) {
            ++a;
        }
        if (a == 0) {
            return "";
        }
        if (a == 27) {
            this.lettersMode = false;
            return "";
        }
        if (a == 31) {
            this.lettersMode = true;
            return "";
        }
        return this.getBAUDOT_NUMBERS(a);
    }

    private boolean checkValid() {
        return !this.inChar[0] && this.inChar[6] && this.bcount >= 7;
    }

    private void addToAdjBuffer(double in) {
        this.adjBuffer[this.adjCounter] = in;
        ++this.adjCounter;
        if (this.adjCounter == this.adjBuffer.length) {
            this.adjCounter = 0;
        }
    }

    private double adjAverage() {
        double total = 0.0;
        for (int a = 0; a < this.adjBuffer.length; ++a) {
            total += this.adjBuffer[a];
        }
        return total / (double)this.adjBuffer.length;
    }

    private int adjAdjust() {
        double av = this.adjAverage();
        double r = Math.abs(av) / 5.0;
        if (av < 0.0) {
            r = 0.0 - r;
        }
        return (int)r;
    }

    public String getQuailty() {
        String line = "Missing characters made up " + String.format("%.2f", this.errorPercentage) + "% of this message (" + Long.toString(this.missingCharCounter) + " characters missing)";
        return line;
    }
}

