/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import java.util.List;
import javax.swing.JOptionPane;
import org.e2k.CircularBitSet;
import org.e2k.CircularDataBuffer;
import org.e2k.FSK;
import org.e2k.Rivet;
import org.e2k.Trigger;
import org.e2k.WaveData;

public class FSKraw
extends FSK {
    private final boolean NOISY = false;
    private double baudRate = 50.0;
    private int state = 0;
    private double samplesPerSymbol;
    private Rivet theApp;
    public long sampleCount = 0L;
    private long symbolCounter = 0L;
    private int highBin;
    private int lowBin;
    private final int MAXCHARLENGTH = 100;
    private int characterCounter = 0;
    private double[] adjBuffer = new double[2];
    private int adjCounter = 0;
    private int shift = 450;
    private CircularBitSet circularBitSet = new CircularBitSet();
    private boolean display = false;
    private int charactersRemaining = 0;
    private boolean activeTrigger;
    private long bitsReceived;
    private boolean sBit0;
    private boolean sBit1;

    public FSKraw(Rivet tapp) {
        this.theApp = tapp;
        this.samplesPerSymbol = this.samplesPerSymbol(this.baudRate, 8000.0);
        this.circularBitSet.setTotalLength(1024);
    }

    public void setBaudRate(double br) {
        if (br != this.baudRate) {
            this.setState(0);
        }
        this.baudRate = br;
        this.samplesPerSymbol = this.samplesPerSymbol(this.baudRate, 8000.0);
    }

    public double getBaudRate() {
        return this.baudRate;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 1) {
            this.theApp.setStatusLabel("Sync Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Decoding Traffic");
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nFSK recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.setState(1);
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.activeTrigger = false;
            this.theApp.newLineWrite();
            return true;
        }
        if (this.state == 1) {
            String sRet;
            if (this.sampleCount > 0L && (sRet = this.syncSequenceHunt(circBuf, waveData)) != null) {
                this.setState(2);
                this.characterCounter = 0;
                this.bitsReceived = 0L;
                this.circularBitSet.clear();
                this.circularBitSet.add(this.sBit0);
                this.circularBitSet.add(this.sBit1);
                this.bitsReceived = 2L;
                this.clearAdjBuffer();
                if (this.display) {
                    this.theApp.writeLine(sRet, Color.BLACK, this.theApp.italicFont);
                    this.theApp.newLineWrite();
                    if (this.sBit0) {
                        this.theApp.writeChar("1", Color.BLACK, this.theApp.boldFont);
                    } else {
                        this.theApp.writeChar("0", Color.BLACK, this.theApp.boldFont);
                    }
                    if (this.sBit1) {
                        this.theApp.writeChar("1", Color.BLACK, this.theApp.boldFont);
                    } else {
                        this.theApp.writeChar("0", Color.BLACK, this.theApp.boldFont);
                    }
                    this.characterCounter = 2;
                }
            }
        } else if (this.state == 2 && (double)this.symbolCounter >= this.samplesPerSymbol) {
            boolean ibit = this.fskFreqHalf(circBuf, waveData, 0);
            this.circularBitSet.add(ibit);
            if (this.theApp.getActiveTriggerCount() > 0) {
                this.triggerCheck();
            } else {
                this.display = true;
            }
            if (this.display && this.state == 2) {
                if (ibit) {
                    this.theApp.writeChar("1", Color.BLACK, this.theApp.boldFont);
                } else {
                    this.theApp.writeChar("0", Color.BLACK, this.theApp.boldFont);
                }
                ++this.characterCounter;
                ++this.bitsReceived;
            }
            if (this.charactersRemaining > 0) {
                --this.charactersRemaining;
                if (this.charactersRemaining == 0) {
                    this.display = false;
                    this.activeTrigger = false;
                }
            }
            if (this.characterCounter == 100) {
                this.characterCounter = 0;
                this.theApp.newLineWrite();
            }
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    public int getShift() {
        return this.shift;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    private int rttyFreq(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        if (waveData.getSampleRate() == 8000.0) {
            int freq = this.doRTTY_8000FFT(circBuf, waveData, pos, (int)this.samplesPerSymbol, this.baudRate);
            return freq;
        }
        return -1;
    }

    private String syncSequenceHunt(CircularDataBuffer circBuf, WaveData waveData) {
        double signalPercentage = 10.0;
        int freq1 = this.rttyFreq(circBuf, waveData, 0);
        int bin1 = this.getFreqBin();
        if (this.getPercentageOfTotal() < signalPercentage) {
            return null;
        }
        int freq2 = this.rttyFreq(circBuf, waveData, (int)this.samplesPerSymbol * 1);
        int bin2 = this.getFreqBin();
        if (this.getPercentageOfTotal() < signalPercentage) {
            return null;
        }
        int difference = freq2 > freq1 ? freq2 - freq1 : freq1 - freq2;
        if (difference < this.shift - 25 || difference > this.shift + 25) {
            return null;
        }
        if (freq1 > freq2) {
            this.highBin = bin1;
            this.lowBin = bin2;
            if (!this.theApp.isInvertSignal()) {
                this.sBit0 = true;
                this.sBit1 = false;
            } else {
                this.sBit0 = false;
                this.sBit1 = true;
            }
        } else {
            this.highBin = bin2;
            this.lowBin = bin1;
            if (this.theApp.isInvertSignal()) {
                this.sBit0 = true;
                this.sBit1 = false;
            } else {
                this.sBit0 = false;
                this.sBit1 = true;
            }
        }
        if (this.lowBin == 0 || this.highBin == 0) {
            return null;
        }
        String line = this.theApp.getTimeStamp() + " FSK Sync Sequence Found";
        return line;
    }

    private void addToAdjBuffer(double in) {
        double lossAverage = 25.0;
        if (this.absAverage() > lossAverage) {
            if (this.display) {
                String line = "(" + Long.toString(this.bitsReceived) + " bits received)";
                this.theApp.writeLine(line, Color.BLACK, this.theApp.italicFont);
                this.theApp.newLineWrite();
            }
            if (this.activeTrigger) {
                this.charactersRemaining = 0;
                this.display = false;
                this.activeTrigger = false;
            }
            this.setState(1);
        } else {
            this.adjBuffer[this.adjCounter] = in;
            ++this.adjCounter;
            if (this.adjCounter == this.adjBuffer.length) {
                this.adjCounter = 0;
            }
        }
    }

    private double absAverage() {
        double av = this.adjAverage();
        return Math.abs(av);
    }

    private double adjAverage() {
        double total = 0.0;
        for (int a = 0; a < this.adjBuffer.length; ++a) {
            total += this.adjBuffer[a];
        }
        return total / (double)this.adjBuffer.length;
    }

    private int adjAdjust() {
        double divisor = 5.0;
        double av = this.adjAverage();
        double r = Math.abs(av) / divisor;
        if (av < 0.0) {
            r = 0.0 - r;
        }
        return (int)r;
    }

    private boolean fskFreqHalf(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        double[] late;
        int sp = (int)this.samplesPerSymbol / 2;
        double[] early = this.doRTTYHalfSymbolBinRequest(this.baudRate, circBuf, pos, this.lowBin, this.highBin);
        if (early[0] + (late = this.doRTTYHalfSymbolBinRequest(this.baudRate, circBuf, pos + sp, this.lowBin, this.highBin))[0] > early[1] + late[1]) {
            this.addToAdjBuffer(this.getPercentageDifference(early[0], late[0]));
        } else {
            this.addToAdjBuffer(this.getPercentageDifference(early[1], late[1]));
        }
        this.symbolCounter = this.adjAdjust();
        double lowTotal = early[0] + late[0];
        double highTotal = early[1] + late[1];
        boolean out = !this.theApp.isInvertSignal() ? lowTotal > highTotal : !(lowTotal > highTotal);
        if (this.theApp.isBitStreamOut()) {
            if (out) {
                this.theApp.bitStreamWrite("1");
            } else {
                this.theApp.bitStreamWrite("0");
            }
        }
        return out;
    }

    private void clearAdjBuffer() {
        for (int a = 0; a < this.adjBuffer.length; ++a) {
            this.adjBuffer[a] = 0.0;
        }
    }

    public void triggerCheck() {
        boolean showTrigger = false;
        List<Trigger> tList = this.theApp.getListTriggers();
        if (tList == null) {
            return;
        }
        for (int a = 0; a < tList.size(); ++a) {
            Trigger trigger = tList.get(a);
            if (!trigger.triggerMatch(this.circularBitSet)) continue;
            if (trigger.getTriggerType() == 1) {
                this.display = true;
                this.characterCounter = 0;
                this.activeTrigger = true;
                showTrigger = true;
            } else if (trigger.getTriggerType() == 2 && this.activeTrigger) {
                this.display = false;
                this.activeTrigger = false;
                showTrigger = true;
            }
            if (trigger.getTriggerType() == 3) {
                this.display = true;
                this.characterCounter = 0;
                this.charactersRemaining = trigger.getForwardGrab();
                if (trigger.getBackwardGrab() > 0) {
                    this.theApp.writeLine(trigger.getBackwardBitsString(this.circularBitSet), Color.BLACK, this.theApp.boldFont);
                }
                this.activeTrigger = true;
                showTrigger = true;
            }
            if (!showTrigger) continue;
            this.theApp.newLineWrite();
            String des = this.theApp.getTimeStamp() + " " + trigger.getTriggerDescription();
            this.theApp.writeLine(des, Color.BLUE, this.theApp.italicFont);
            this.theApp.newLineWrite();
        }
    }
}

