/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import java.util.List;
import javax.swing.JOptionPane;
import org.e2k.CircularBitSet;
import org.e2k.CircularDataBuffer;
import org.e2k.FSK;
import org.e2k.Rivet;
import org.e2k.Ship;
import org.e2k.UserIdentifier;
import org.e2k.WaveData;

public class GW
extends FSK {
    private int state = 0;
    private double samplesPerSymbol100;
    private Rivet theApp;
    public long sampleCount = 0L;
    private long symbolCounter = 0L;
    private int highTone;
    private int lowTone;
    private int highBin;
    private int lowBin;
    private double[] adjBuffer = new double[1];
    private int adjCounter = 0;
    private CircularBitSet dataBitSet = new CircularBitSet();
    private int characterCount = 0;
    private int bitCount;
    private StringBuilder positionReport = new StringBuilder();
    private boolean receivingPositionReport = false;
    private String lastPositionFragment;
    private int positionFragmentCounter = 0;
    private long fragmentStartTime = 0L;
    private boolean shoreSide;

    public GW(Rivet tapp) {
        this.theApp = tapp;
        this.dataBitSet.setTotalLength(200);
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nGW FSK recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.samplesPerSymbol100 = this.samplesPerSymbol(100.0, waveData.getSampleRate());
            this.setState(1);
            this.shoreSide = false;
            this.theApp.clearLoggedShipsList();
            return true;
        }
        if (this.state == 1) {
            if (this.sampleCount > 0L && this.syncSequenceHunt(circBuf, waveData)) {
                this.setState(2);
                this.bitCount = 0;
                this.dataBitSet.totalClear();
            }
        } else if (this.state == 2 && (double)this.symbolCounter >= this.samplesPerSymbol100) {
            this.symbolCounter = 0L;
            boolean ibit = this.gwFreqHalf(circBuf, waveData, 0);
            this.dataBitSet.add(ibit);
            if (this.theApp.isDebug()) {
                if (ibit) {
                    this.theApp.writeChar("1", Color.BLACK, this.theApp.boldFont);
                } else {
                    this.theApp.writeChar("0", Color.BLACK, this.theApp.boldFont);
                }
                ++this.characterCount;
                if (this.characterCount == 80) {
                    this.characterCount = 0;
                    this.theApp.newLineWrite();
                }
            }
            ++this.bitCount;
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 1) {
            this.theApp.setStatusLabel("Sync Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Msg Hunt");
        }
    }

    private int getSymbolFreq(CircularDataBuffer circBuf, WaveData waveData, int start) {
        int fr = this.do100baudFFT(circBuf, waveData, start);
        return fr;
    }

    private boolean gwFreqHalf(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        double[] late;
        int sp = (int)this.samplesPerSymbol100 / 2;
        double[] early = this.do100baudFSKHalfSymbolBinRequest(circBuf, pos, this.lowBin, this.highBin);
        if (early[0] + (late = this.do100baudFSKHalfSymbolBinRequest(circBuf, pos + sp, this.lowBin, this.highBin))[0] > early[1] + late[1]) {
            this.addToAdjBuffer(this.getPercentageDifference(early[0], late[0]));
        } else {
            this.addToAdjBuffer(this.getPercentageDifference(early[1], late[1]));
        }
        this.symbolCounter = this.adjAdjust();
        double lowTotal = early[0] + late[0];
        double highTotal = early[1] + late[1];
        boolean out = !this.theApp.isInvertSignal() ? lowTotal > highTotal : !(lowTotal > highTotal);
        if (this.theApp.isBitStreamOut()) {
            if (out) {
                this.theApp.bitStreamWrite("1");
            } else {
                this.theApp.bitStreamWrite("0");
            }
        }
        return out;
    }

    private void addToAdjBuffer(double in) {
        if (in > 45.0) {
            this.processGWData();
            this.setState(1);
        } else {
            this.adjBuffer[this.adjCounter] = in;
            ++this.adjCounter;
            if (this.adjCounter == this.adjBuffer.length) {
                this.adjCounter = 0;
            }
        }
    }

    private double adjAverage() {
        double total = 0.0;
        for (int a = 0; a < this.adjBuffer.length; ++a) {
            total += this.adjBuffer[a];
        }
        return total / (double)this.adjBuffer.length;
    }

    private int adjAdjust() {
        double av = this.adjAverage();
        double r = Math.abs(av) / 15.0;
        if (av < 0.0) {
            r = 0.0 - r;
        }
        return (int)r;
    }

    private boolean syncSequenceHunt(CircularDataBuffer circBuf, WaveData waveData) {
        int pos = 0;
        int f0 = this.getSymbolFreq(circBuf, waveData, pos);
        int b0 = this.getFreqBin();
        if (this.getPercentageOfTotal() < 10.0) {
            return false;
        }
        pos = (int)this.samplesPerSymbol100 * 1;
        int f1 = this.getSymbolFreq(circBuf, waveData, pos);
        int b1 = this.getFreqBin();
        if (this.getPercentageOfTotal() < 10.0) {
            return false;
        }
        if (f0 == f1) {
            return false;
        }
        if (f0 > f1) {
            this.highTone = f0;
            this.highBin = b0;
            this.lowTone = f1;
            this.lowBin = b1;
        } else {
            this.highTone = f1;
            this.highBin = b1;
            this.lowTone = f0;
            this.lowBin = b0;
        }
        if (this.lowBin == 0 || this.highBin == 0) {
            return false;
        }
        return this.highTone - this.lowTone == 200;
    }

    private String stationName(int id) {
        if (id == 204) {
            return "LFI, Rogaland, Norway & 9MG, Georgetown, Malaysia";
        }
        if (id == 184) {
            return "HLF, Seoul, South Korea";
        }
        if (id == 156) {
            return "VCS, Halifax, Canada";
        }
        if (id == 174) {
            return "KEJ, Honolulu, Hawaii";
        }
        if (id == 94) {
            return "CPK, Santa Cruz, Bolivia";
        }
        if (id == 190) {
            return "A9M, Hamala, Bahrain";
        }
        if (id == 99) {
            return "9HD, Malta";
        }
        if (id == 240) {
            return "XSV, Tianjin, China";
        }
        if (id == 201) {
            return "ZLA, Awanui, New Zealand";
        }
        if (id == 210) {
            return "ZSC, Capetown, RSA";
        }
        if (id == 250) {
            return "KPH, San Francisco, USA";
        }
        if (id == 198) {
            return "WNU, Slidell Radio, USA";
        }
        if (id == 246) {
            return "KHF, Agana, Guam";
        }
        if (id == 206) {
            return "KFS, Palo Alto, USA";
        }
        if (id == 238) {
            return "LSD836, Buenos Aires, Argentina";
        }
        if (id == 222) {
            return "SAB, Goeteborg, Sweden";
        }
        if (id == 227) {
            return "8PO, Bridgetown, Barbados";
        }
        return "Unknown";
    }

    private void processGWData() {
        String sData = this.dataBitSet.extractSectionFromStart(0, this.bitCount);
        if (this.bitCount > 144) {
            int pos = sData.indexOf("0011100010100011");
            if (pos < 8) {
                return;
            }
            List<Integer> frame = this.dataBitSet.returnIntsFromStart(pos -= 8);
            if (frame.size() < 18) {
                return;
            }
            if (frame.get(8).equals(242) && frame.get(9).equals(242) && frame.get(10).equals(242) && frame.get(11).equals(frame.get(12)) && frame.get(12).equals(frame.get(13)) && frame.get(13).equals(frame.get(14)) && frame.get(14).equals(frame.get(15)) && frame.get(15).equals(frame.get(16)) && frame.get(17).equals(255)) {
                StringBuilder lo = new StringBuilder();
                lo.append(this.theApp.getTimeStamp());
                lo.append(" GW Free Channel Marker from Station Code 0x" + Integer.toHexString(frame.get(12)) + " (" + this.stationName(frame.get(12)) + ") ");
                for (int a = 0; a < 18; ++a) {
                    lo.append(" " + Integer.toHexString(frame.get(a)) + " ");
                }
                if (this.theApp.isViewGWChannelMarkers()) {
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                }
                this.shoreSide = true;
                return;
            }
        } else {
            if (this.bitCount > 63 && this.bitCount < 95) {
                long difTime;
                if (sData.charAt(0) != '1' || sData.charAt(1) != '0') {
                    return;
                }
                StringBuilder lo = new StringBuilder();
                lo.append(this.theApp.getTimeStamp() + " GW");
                int type = 0;
                int packetCounter = 0;
                int subType = 0;
                if (sData.charAt(2) == '1') {
                    type = 8;
                }
                if (sData.charAt(3) == '1') {
                    type += 4;
                }
                if (sData.charAt(4) == '1') {
                    type += 2;
                }
                if (sData.charAt(5) == '1') {
                    ++type;
                }
                if (sData.charAt(6) == '1') {
                    packetCounter = 1;
                }
                if (sData.charAt(7) == '1') {
                    subType = 64;
                }
                if (sData.charAt(8) == '1') {
                    subType += 32;
                }
                if (sData.charAt(9) == '1') {
                    subType += 16;
                }
                if (sData.charAt(10) == '1') {
                    subType += 8;
                }
                if (sData.charAt(11) == '1') {
                    subType += 4;
                }
                if (sData.charAt(12) == '1') {
                    subType += 2;
                }
                if (sData.charAt(13) == '1') {
                    ++subType;
                }
                lo.append(" Type=" + Integer.toString(type) + " Count=" + Integer.toString(packetCounter) + " Subtype=" + Integer.toString(subType) + " (");
                lo.append(this.dataBitSet.extractSectionFromStart(0, 14));
                lo.append(") (" + this.displayGWAsHex(0) + ")");
                if (this.receivingPositionReport && (difTime = System.currentTimeMillis() / 1000L - this.fragmentStartTime) > 60L && this.positionFragmentCounter > 0) {
                    String line = this.theApp.getTimeStamp() + " position report timeout (fragment Count is " + Integer.toString(this.positionFragmentCounter) + ")";
                    this.theApp.writeLine(line, Color.RED, this.theApp.boldFont);
                    this.receivingPositionReport = false;
                }
                if (type == 5 && subType == 102) {
                    this.positionReport.delete(0, this.positionReport.length());
                    this.lastPositionFragment = "";
                    this.receivingPositionReport = true;
                    this.positionFragmentCounter = 0;
                    this.fragmentStartTime = System.currentTimeMillis() / 1000L;
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                    this.theApp.writeLine(this.displayGWAsAscii(0), Color.BLUE, this.theApp.boldFont);
                    return;
                }
                if (type == 5 && subType == 86) {
                    this.shoreSide = false;
                    String curFrag = this.displayGWAsAscii(0);
                    if (curFrag.startsWith("$")) {
                        this.positionFragmentCounter = 0;
                        this.positionReport.delete(0, this.positionReport.length());
                    } else if (curFrag.equals(this.lastPositionFragment)) {
                        return;
                    }
                    this.positionReport.append(curFrag);
                    this.lastPositionFragment = curFrag;
                    ++this.positionFragmentCounter;
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                    this.theApp.writeLine(this.displayGWAsAscii(0), Color.BLUE, this.theApp.boldFont);
                    return;
                }
                if (type == 5 && subType == 118) {
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                    this.theApp.writeLine(this.displayGWAsAscii(0), Color.BLUE, this.theApp.boldFont);
                    this.createPositionReportLine();
                    return;
                }
                if (type == 5 && subType == 54) {
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                    this.theApp.writeLine(this.displayGWAsAscii(0), Color.BLUE, this.theApp.boldFont);
                    this.createPositionReportLine();
                    return;
                }
                if (type == 2 && subType == 106) {
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                    this.theApp.writeLine(this.displayGWAsAscii(0), Color.BLUE, this.theApp.boldFont);
                    return;
                }
                if (type == 2 && subType == 101) {
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                    List<Integer> mInts = this.dataBitSet.returnIntsFromStart(14);
                    Color colour = Color.BLUE;
                    if (mInts.get(0) == 226 && mInts.get(1) == 114 && mInts.get(2) == 255 && mInts.get(3) == 255 && mInts.get(4) == 231 && mInts.get(5) == 230) {
                        this.shoreSide = true;
                        String[] mLines = this.getGW_Shore2101(mInts);
                        this.theApp.writeLine(mLines[0], colour, this.theApp.boldFont);
                        this.theApp.writeLine(mLines[1], colour, this.theApp.boldFont);
                    } else {
                        String mLine = this.getGW_MMSI(mInts);
                        if (mLine.contains("ERROR")) {
                            colour = Color.RED;
                        }
                        this.theApp.writeLine(mLine, colour, this.theApp.boldFont);
                    }
                    return;
                }
                if (type == 5 && subType == 41) {
                    Color colour = Color.BLUE;
                    String[] mLine = new String[2];
                    List<Integer> mInts = this.dataBitSet.returnIntsFromStart(14);
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                    if (this.shoreSide) {
                        mLine = this.getGW_Shore541(mInts);
                        if (mLine[0].contains("ERROR")) {
                            colour = Color.RED;
                        }
                    } else {
                        mLine = this.getGW_Ship541(mInts);
                    }
                    this.theApp.writeLine(mLine[0], colour, this.theApp.boldFont);
                    this.theApp.writeLine(mLine[1], colour, this.theApp.boldFont);
                    return;
                }
                if (type == 5 && subType == 63) {
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                    return;
                }
                if (this.theApp.isDisplayBadPackets()) {
                    this.theApp.writeLine(lo.toString(), Color.RED, this.theApp.boldFont);
                }
                return;
            }
            if (this.bitCount > 7 && this.bitCount < 12) {
                StringBuilder lo = new StringBuilder();
                String shortContent = this.dataBitSet.extractSectionFromStart(0, 6);
                if (shortContent.equals("010101") || shortContent.equals("101010")) {
                    lo.append(this.theApp.getTimeStamp() + " GW ACK");
                    this.theApp.writeLine(lo.toString(), Color.BLACK, this.theApp.boldFont);
                }
                return;
            }
        }
    }

    private String displayGWAsAscii(int sPos) {
        StringBuilder lo = new StringBuilder();
        List<Integer> aInts = this.dataBitSet.returnIntsFromStart(sPos + 14);
        for (int a = 0; a < 6; ++a) {
            lo.append(this.getGWChar(aInts.get(a)));
        }
        return lo.toString();
    }

    private String displayGWAsHex(int sPos) {
        StringBuilder lo = new StringBuilder();
        List<Integer> aInts = this.dataBitSet.returnIntsFromStart(sPos + 14);
        for (int a = 0; a < 6; ++a) {
            if (a > 0) {
                lo.append(",");
            }
            lo.append("0x" + Integer.toHexString(aInts.get(a)));
        }
        return lo.toString();
    }

    private String getGWChar(int c) {
        if (c == 96) {
            return "0";
        }
        if (c == 32) {
            return "1";
        }
        if (c == 64) {
            return "2";
        }
        if (c == 0) {
            return "3";
        }
        if (c == 112) {
            return "4";
        }
        if (c == 48) {
            return "5";
        }
        if (c == 80) {
            return "6";
        }
        if (c == 16) {
            return "7";
        }
        if (c == 104) {
            return "8";
        }
        if (c == 40) {
            return "9";
        }
        if (c == 120 || c == 62 || c == 78 || c == 248) {
            return "<";
        }
        if (c == 46 || c == 124) {
            return ",";
        }
        if (c == 92) {
            return ".";
        }
        if (c == 116) {
            return "$";
        }
        if (c == 76) {
            return "*";
        }
        if (c == 39) {
            return "A";
        }
        if (c == 71 || c == 63) {
            return "B";
        }
        if (c == 55 || c == 7) {
            return "E";
        }
        if (c == 23) {
            return "G";
        }
        if (c == 127 || c == 99) {
            return "L";
        }
        if (c == 95) {
            return "N";
        }
        if (c == 31 || c == 67) {
            return "O";
        }
        if (c == 19) {
            return "W";
        }
        return "[0x" + Integer.toHexString(c) + "]";
    }

    private String getGW_MMSI(List<Integer> mm) {
        UserIdentifier uid = new UserIdentifier();
        String sMMSI = this.displayGW_ShipMMSI(mm, 9);
        this.theApp.logShip(sMMSI);
        Ship ship = uid.getShipDetails(sMMSI);
        if (ship == null) {
            String ret = "MMSI : " + sMMSI;
            if (uid.getErrorMessage() != null) {
                ret = ret + " (ERROR " + uid.getErrorMessage() + " )";
            }
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MMSI : " + sMMSI + " (" + ship.getName() + "," + ship.getFlag() + ")");
        return sb.toString();
    }

    public String[] getGW_Shore541(List<Integer> mm) {
        String[] ret = new String[2];
        UserIdentifier uid = new UserIdentifier();
        String fullp = this.displayGW_ShoreMMSI(mm, 12);
        String sMMSI = fullp.substring(0, 9);
        String sCom = "Command=" + fullp.substring(9, 12);
        this.theApp.logShip(sMMSI);
        Ship ship = uid.getShipDetails(sMMSI);
        if (ship == null) {
            ret[0] = "Traffic for : MMSI " + sMMSI;
            if (uid.getErrorMessage() != null) {
                ret[0] = ret[0] + " (ERROR " + uid.getErrorMessage() + " )";
            }
        } else {
            ret[0] = "Traffic For : MMSI " + sMMSI + " (" + ship.getName() + "," + ship.getFlag() + ")";
        }
        ret[1] = sCom;
        return ret;
    }

    public String[] getGW_Ship541(List<Integer> mm) {
        String[] ret = new String[2];
        String fullp = this.displayGW_ShipMMSI(mm, 12);
        String sMMSI = fullp.substring(0, 9);
        String sCom = "Command=" + fullp.substring(9, 12);
        ret[0] = "Traffic for : " + sMMSI;
        ret[1] = sCom;
        return ret;
    }

    public String[] getGW_Shore2101(List<Integer> mm) {
        String[] ret = new String[2];
        String fullp = this.displayGW_ShoreMMSI(mm, 12);
        String sMMSI = fullp.substring(0, 9);
        String sCom = "Command=" + fullp.substring(9, 12);
        ret[0] = sMMSI;
        ret[1] = sCom;
        return ret;
    }

    public String displayGW_ShipMMSI(List<Integer> mm, int totalDigits) {
        StringBuilder sb = new StringBuilder();
        int digitCounter = 0;
        for (int a = 0; a < 6; ++a) {
            int hn = (mm.get(a) & 0xF0) >> 4;
            int ln = mm.get(a) & 0xF;
            int followingNibble = a < 5 ? (mm.get(a + 1) & 0xF0) >> 4 : 0;
            boolean alternate = followingNibble >= 8;
            sb.append(this.convertMMSI(ln, alternate));
            if (++digitCounter == totalDigits) {
                return sb.toString();
            }
            alternate = ln >= 8;
            sb.append(this.convertMMSI(hn, alternate));
            if (++digitCounter != totalDigits) continue;
            return sb.toString();
        }
        return sb.toString();
    }

    private String convertMMSI(int n, boolean alternate) {
        if (n == 0) {
            return "3";
        }
        if (n == 1) {
            return "7";
        }
        if (n == 2) {
            if (!alternate) {
                return "1";
            }
            return "9";
        }
        if (n == 3) {
            return "5";
        }
        if (n == 4) {
            return "2";
        }
        if (n == 5) {
            return "6";
        }
        if (n == 6) {
            if (!alternate) {
                return "0";
            }
            return "8";
        }
        if (n == 7) {
            return "4";
        }
        if (n == 8) {
            return "3";
        }
        if (n == 9) {
            return "7";
        }
        if (n == 10) {
            if (!alternate) {
                return "1";
            }
            return "9";
        }
        if (n == 11) {
            return "5";
        }
        if (n == 12) {
            return "2";
        }
        if (n == 13) {
            return "6";
        }
        if (n == 14) {
            if (!alternate) {
                return "0";
            }
            return "8";
        }
        if (n == 15) {
            return "4";
        }
        return "[0x" + Integer.toHexString(n) + "]";
    }

    private void createPositionReportLine() {
        if (!this.receivingPositionReport) {
            return;
        }
        this.receivingPositionReport = false;
        if (this.positionFragmentCounter < 10) {
            String line = "Position fragment count is " + Integer.toString(this.positionFragmentCounter);
            this.theApp.writeLine(line, Color.RED, this.theApp.boldFont);
            return;
        }
        String curFrag = this.displayGWAsAscii(0);
        if (curFrag.equals(this.lastPositionFragment)) {
            return;
        }
        this.positionReport.append(curFrag);
        this.theApp.writeLine(this.positionReport.toString(), Color.BLUE, this.theApp.boldFont);
    }

    public String displayGW_ShoreMMSI(List<Integer> mm, int totalDigits) {
        StringBuilder sb = new StringBuilder();
        int digitCounter = 0;
        for (int a = 0; a < 6; ++a) {
            int hn = (mm.get(a) & 0xF0) >> 4;
            int ln = mm.get(a) & 0xF;
            int followingNibble = a < 5 ? (mm.get(a + 1) & 0xF0) >> 4 : 0;
            boolean alternate = followingNibble < 8;
            sb.append(this.convertShoreNum(ln, alternate));
            if (++digitCounter == totalDigits) {
                return sb.toString();
            }
            alternate = ln < 8;
            sb.append(this.convertShoreNum(hn, alternate));
            if (++digitCounter != totalDigits) continue;
            return sb.toString();
        }
        return sb.toString();
    }

    private String convertShoreNum(int n, boolean alternate) {
        if (!alternate) {
            if (n == 0) {
                return "7";
            }
            if (n == 1) {
                return "3";
            }
            if (n == 2) {
                return "5";
            }
            if (n == 3) {
                return "1";
            }
            if (n == 4) {
                return "6";
            }
            if (n == 5) {
                return "2";
            }
            if (n == 6) {
                return "4";
            }
            if (n == 7) {
                return "0";
            }
            if (n == 8) {
                return "7";
            }
            if (n == 9) {
                return "3";
            }
            if (n == 10) {
                return "5";
            }
            if (n == 11) {
                return "1";
            }
            if (n == 12) {
                return "6";
            }
            if (n == 13) {
                return "2";
            }
            if (n == 14) {
                return "4";
            }
            if (n == 15) {
                return "0";
            }
        } else {
            if (n == 0) {
                return "7";
            }
            if (n == 1) {
                return "3";
            }
            if (n == 2) {
                return "5";
            }
            if (n == 3) {
                return "9";
            }
            if (n == 4) {
                return "6";
            }
            if (n == 5) {
                return "2";
            }
            if (n == 6) {
                return "4";
            }
            if (n == 7) {
                return "8";
            }
            if (n == 8) {
                return "7";
            }
            if (n == 9) {
                return "3";
            }
            if (n == 10) {
                return "5";
            }
            if (n == 11) {
                return "9";
            }
            if (n == 12) {
                return "6";
            }
            if (n == 13) {
                return "2";
            }
            if (n == 14) {
                return "4";
            }
            if (n == 15) {
                return "8";
            }
        }
        return "[0x" + Integer.toHexString(n) + "]";
    }
}

