/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.io.DataOutputStream;
import java.io.File;
import java.io.PipedOutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.JOptionPane;
import org.e2k.AudioMixer;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class InputThread
extends Thread {
    private boolean audioReady = false;
    private boolean gettingAudio = false;
    private boolean loadingFile = false;
    private PipedOutputStream ps = new PipedOutputStream();
    private DataOutputStream outPipe = new DataOutputStream(this.ps);
    private File wavFile;
    private long fileSize;
    public final int CHUNK_SIZE = 32768;
    private long fileCounter;
    private String errorCause = "None";
    private long sampleCounter = 0L;
    private static int VOLUMEBUFFERSIZE = 100;
    private int[] volumeBuffer = new int[VOLUMEBUFFERSIZE];
    private int volumeBufferCounter = 0;
    private static int ISIZE = 4096;
    private byte[] buffer = new byte[ISIZE + 1];
    private int inputLevel = 0;
    private Rivet theApp;
    private AudioMixer audioMixer = new AudioMixer();
    private AudioInputStream audioInputStream;

    public InputThread(Rivet TtheApp) {
        this.theApp = TtheApp;
        this.setPriority(1);
        this.start();
        Thread.yield();
    }

    @Override
    public void run() {
        while (true) {
            if (this.audioReady && !this.loadingFile && !this.gettingAudio) {
                this.getSample();
                continue;
            }
            if (this.loadingFile) {
                this.getFileData();
                continue;
            }
            try {
                InputThread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error in run()\n" + e.toString(), "Rivet", 0);
                continue;
            }
            break;
        }
    }

    public WaveData startFileLoad(String fileName) {
        WaveData waveData = new WaveData();
        try {
            this.wavFile = new File(fileName);
            this.fileSize = this.wavFile.length();
            this.fileCounter = 0L;
            this.sampleCounter = 0L;
            this.audioInputStream = AudioSystem.getAudioInputStream(this.wavFile);
            waveData.setBytesPerFrame(this.audioInputStream.getFormat().getFrameSize());
            waveData.setSampleRate(this.audioInputStream.getFormat().getSampleRate());
            waveData.setSampleSizeInBits(this.audioInputStream.getFormat().getSampleSizeInBits());
            waveData.setChannels(this.audioInputStream.getFormat().getChannels());
            waveData.setEndian(this.audioInputStream.getFormat().isBigEndian());
            this.theApp.setSoundCardInputOnly(false);
            this.loadingFile = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in startFileLoad()\n" + e.toString(), "Rivet", 0);
            return null;
        }
        return waveData;
    }

    private boolean getFileData() {
        if (!this.grabWavBlock()) {
            try {
                this.audioInputStream.close();
                this.loadingFile = false;
            }
            catch (Exception e) {
                this.errorCause = e.toString();
                JOptionPane.showMessageDialog(null, "Error in getFileData()\n" + e.toString(), "Rivet", 0);
                return false;
            }
        }
        return true;
    }

    private boolean grabWavBlock() {
        if (!this.audioInputStream.getFormat().isBigEndian() && this.audioInputStream.getFormat().getSampleSizeInBits() == 16) {
            return this.grabWavBlock16LE(this.audioInputStream);
        }
        if (!this.audioInputStream.getFormat().isBigEndian() && this.audioInputStream.getFormat().getSampleSizeInBits() == 8) {
            return this.grabWavBlock8LE(this.audioInputStream);
        }
        return false;
    }

    private boolean grabWavBlock16LE(AudioInputStream audioStream) {
        int countLoad;
        byte[] inBlock = new byte[32768];
        try {
            countLoad = audioStream.read(inBlock);
            for (int a = 0; a < countLoad; a += 2) {
                this.outPipe.writeInt(this.LEconv16(inBlock[a], inBlock[a + 1]));
                this.fileCounter += 2L;
                ++this.sampleCounter;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in grabWavBlock16LE()\n" + e.toString(), "Rivet", 0);
            return false;
        }
        return countLoad >= 32768;
    }

    private int LEconv16(Byte a, Byte b) {
        return a & 0xFF | b << 8;
    }

    private int LEconv8(Byte a) {
        return (a & 0xFF) - 128;
    }

    private boolean grabWavBlock8LE(AudioInputStream audioStream) {
        int countLoad;
        byte[] inBlock = new byte[32768];
        try {
            countLoad = audioStream.read(inBlock);
            for (int a = 0; a < countLoad; ++a) {
                this.outPipe.writeInt(this.LEconv8(inBlock[a]));
                ++this.fileCounter;
                ++this.sampleCounter;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in grabWavBlock8LE()\n" + e.toString(), "Rivet", 0);
            return false;
        }
        return countLoad >= 32768;
    }

    public PipedOutputStream getPipedWriter() {
        return this.ps;
    }

    public boolean getLoadingFileState() {
        return this.loadingFile;
    }

    public int returnFileLoadPercentage() {
        double percentage = (double)this.fileCounter / (double)this.fileSize * 100.0;
        return (int)percentage;
    }

    public String getErrorCause() {
        return this.errorCause;
    }

    public boolean stopReadingFile() {
        this.loadingFile = false;
        try {
            this.audioInputStream.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in stopReadingFile()\n" + e.toString(), "Rivet", 0);
            return false;
        }
        return true;
    }

    public long getSampleCounter() {
        return this.sampleCounter;
    }

    public void setInputLevel(int il) {
        this.inputLevel = il;
    }

    public void setupAudio(WaveData waveData) {
        try {
            if (this.audioReady) {
                this.closeAudio();
                return;
            }
            this.sampleCounter = 0L;
            this.audioMixer.stopAudio();
            AudioFormat format = new AudioFormat((int)waveData.getSampleRate(), waveData.getSampleSizeInBits(), waveData.getChannels(), true, waveData.isEndian());
            this.audioMixer.setAudioFormat(format);
            if (!this.audioMixer.openLine()) {
                String err = this.audioMixer.getErrorMsg();
                JOptionPane.showMessageDialog(null, err, "Rivet", 0);
                return;
            }
            this.audioMixer.line.start();
            this.audioReady = true;
            this.loadingFile = false;
        }
        catch (Exception e) {
            String err = "Fatal error in setupAudio()\n" + e.getMessage();
            JOptionPane.showMessageDialog(null, err, "Rivet", 0);
            System.exit(0);
        }
    }

    public boolean closeAudio() {
        try {
            this.audioMixer.line.close();
            this.audioReady = false;
            return true;
        }
        catch (Exception e) {
            String err = "Error in closeAudio()\n" + e.getMessage();
            JOptionPane.showMessageDialog(null, err, "Rivet", 0);
            return false;
        }
    }

    private void addToVolumeBuffer(int tsample) {
        this.volumeBuffer[this.volumeBufferCounter] = tsample;
        ++this.volumeBufferCounter;
        if (this.volumeBufferCounter == VOLUMEBUFFERSIZE) {
            this.volumeBufferCounter = 0;
        }
    }

    public int returnVolumeAverage() {
        long va = 0L;
        int volumeAverage = 0;
        for (int a = 0; a < VOLUMEBUFFERSIZE; ++a) {
            va += (long)Math.abs(this.volumeBuffer[a]);
        }
        volumeAverage = (int)va / VOLUMEBUFFERSIZE;
        return volumeAverage;
    }

    private void getSample() {
        String err;
        this.gettingAudio = true;
        try {
            int count;
            for (int total = 0; total < ISIZE; total += count) {
                count = this.audioMixer.line.read(this.buffer, 0, ISIZE);
            }
        }
        catch (Exception e) {
            err = e.getMessage();
            JOptionPane.showMessageDialog(null, err, "Rivet", 0);
        }
        for (int a = 0; a < ISIZE; a += 2) {
            int sample = (this.buffer[a] << 8) + this.buffer[a + 1];
            if (this.inputLevel > 0) {
                sample *= this.inputLevel;
            } else if (this.inputLevel < 0) {
                sample /= Math.abs(this.inputLevel);
            }
            this.addToVolumeBuffer(sample);
            try {
                this.outPipe.writeInt(sample);
                ++this.sampleCounter;
                continue;
            }
            catch (Exception e) {
                err = e.getMessage();
                JOptionPane.showMessageDialog(null, err, "Rivet", 0);
            }
        }
        this.gettingAudio = false;
    }

    public boolean getAudioReady() {
        return this.audioReady;
    }

    public boolean changeMixer(String mixerName) {
        return this.audioMixer.changeMixer(mixerName);
    }

    public String getMixerName() {
        return this.audioMixer.getMixer().getMixerInfo().getName();
    }

    public String getMixerErrorMessage() {
        return this.audioMixer.getErrorMsg();
    }

    public void writeAudioDebugMessage(String msg) {
        this.audioMixer.audioDebugDump(msg);
    }
}

