/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.e2k.Rivet;

public class JStatusBar
extends JPanel
implements ChangeListener {
    public static final long serialVersionUID = 1L;
    private JLabel logMode = new JLabel();
    private JLabel statusLabel = new JLabel();
    private JLabel modeLabel = new JLabel();
    private JProgressBar volumeBar = new JProgressBar(0, 100);
    private Rivet TtheApp;
    private JSlider inputLevelSlider;
    private JButton clearDisplayButton = new JButton("Clear Display");
    private JButton pauseDisplayButton = new JButton("Pause Display");
    private JPanel buttonPane = new JPanel(new BorderLayout());

    public JStatusBar() {
        int FONTSIZE = 20;
        String FONTTYPE = "Times New Roman";
        Border paddingBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        Border border = BorderFactory.createLineBorder(Color.BLUE);
        this.logMode.setHorizontalAlignment(2);
        this.logMode.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
        this.logMode.setFont(new Font("Times New Roman", 1, 20));
        this.logMode.setBackground(Color.YELLOW);
        this.logMode.setOpaque(true);
        this.logMode.updateUI();
        this.statusLabel.setHorizontalAlignment(2);
        this.statusLabel.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
        this.statusLabel.setFont(new Font("Times New Roman", 1, 20));
        this.statusLabel.setBackground(Color.YELLOW);
        this.statusLabel.setOpaque(true);
        this.statusLabel.updateUI();
        this.modeLabel.setHorizontalAlignment(2);
        this.modeLabel.setBorder(BorderFactory.createCompoundBorder(border, paddingBorder));
        this.modeLabel.setFont(new Font("Times New Roman", 1, 20));
        this.modeLabel.setBackground(Color.YELLOW);
        this.modeLabel.setOpaque(true);
        this.modeLabel.updateUI();
        this.inputLevelSlider = new JSlider(0, -10, 10, 1);
        this.inputLevelSlider.addChangeListener(this);
        this.inputLevelSlider.setMajorTickSpacing(5);
        this.inputLevelSlider.setMinorTickSpacing(1);
        this.inputLevelSlider.setPaintTicks(true);
        this.inputLevelSlider.setPaintLabels(true);
        this.inputLevelSlider.setBorder(BorderFactory.createTitledBorder("Input Level Adjust"));
        this.clearDisplayButton.addActionListener(new ButtonListener());
        this.pauseDisplayButton.addActionListener(new ButtonListener());
        this.volumeBar.setBorder(BorderFactory.createTitledBorder("Input Level"));
        this.volumeBar.setForeground(Color.GREEN);
        this.buttonPane.add((Component)this.clearDisplayButton, "North");
        this.buttonPane.add((Component)this.pauseDisplayButton, "South");
        this.setLayout(new FlowLayout(0));
        this.add((Component)this.buttonPane, "Center");
        this.add((Component)this.volumeBar, "Center");
        this.add((Component)this.inputLevelSlider, "Center");
        this.add((Component)this.modeLabel, "Center");
        this.add((Component)this.logMode, "Center");
        this.add((Component)this.statusLabel, "Center");
    }

    public void setLoggingStatus(String text) {
        this.logMode.setText(text);
    }

    public void setStatusLabel(String st) {
        this.statusLabel.setText(st);
    }

    public void setVolumeBar(int val) {
        if (val > 100) {
            val = 100;
        }
        this.volumeBar.setValue(val);
        this.volumeBar.repaint();
    }

    public void setModeLabel(String label) {
        this.modeLabel.setText(label);
    }

    public void setApp(Rivet theApp) {
        this.TtheApp = theApp;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (!source.getValueIsAdjusting()) {
            int level = source.getValue();
            this.TtheApp.setSoundCardLevel(level);
        }
    }

    public void setSoundCardInput(int scl) {
        this.inputLevelSlider.setValue(scl);
    }

    public void setSmallScreen() {
        this.remove(this.buttonPane);
        this.repaint();
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Clear Display") && JStatusBar.this.TtheApp != null) {
                JStatusBar.this.TtheApp.clearScreen();
            }
            if (e.getActionCommand().equals("Pause Display")) {
                if (JStatusBar.this.TtheApp != null) {
                    JStatusBar.this.TtheApp.setPauseDisplay(true);
                }
                JStatusBar.this.pauseDisplayButton.setText("Restart Display");
            }
            if (e.getActionCommand().equals("Restart Display")) {
                if (JStatusBar.this.TtheApp != null) {
                    JStatusBar.this.TtheApp.setPauseDisplay(false);
                }
                JStatusBar.this.pauseDisplayButton.setText("Pause Display");
            }
        }
    }
}

