/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import org.e2k.CircularDataBuffer;
import org.e2k.FSK;
import org.e2k.WaveData;

public class MFSK
extends FSK {
    public final int FFT_8_SIZE = 8;
    public final int FFT_64_SIZE = 64;
    public final int FFT_128_SIZE = 128;
    public final int FFT_200_SIZE = 200;
    public final int FFT_256_SIZE = 256;
    public final int FFT_512_SIZE = 512;
    public final int FFT_1024_SIZE = 1024;
    private DoubleFFT_1D fft1024 = new DoubleFFT_1D(1024);
    private DoubleFFT_1D fft200 = new DoubleFFT_1D(200);
    private DoubleFFT_1D fft256 = new DoubleFFT_1D(256);
    private DoubleFFT_1D fft512 = new DoubleFFT_1D(512);
    private DoubleFFT_1D fft8 = new DoubleFFT_1D(8);
    private DoubleFFT_1D fft128 = new DoubleFFT_1D(128);
    private DoubleFFT_1D fft64 = new DoubleFFT_1D(64);

    public int symbolFreq(CircularDataBuffer circBuf, WaveData waveData, int start, double samplePerSymbol) {
        double freq = -1.0;
        if (samplePerSymbol < 1024.0) {
            if (samplePerSymbol < 512.0) {
                return -1;
            }
            int fftStart = start + ((int)samplePerSymbol - 512) / 2;
            freq = this.do512FFT(circBuf, waveData, fftStart);
        } else {
            int fftStart = start + ((int)samplePerSymbol - 1024) / 2;
            freq = this.doXPAFFT(circBuf, waveData, fftStart);
        }
        return (int)freq;
    }

    public int do1024FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 1024);
        this.fft1024.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do128FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 128);
        this.fft128.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    @Override
    public int do64FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 64);
        this.fft64.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do512FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 512);
        this.fft512.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do256FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 256);
        this.fft256.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do200FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 200);
        this.fft200.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int do8FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datar = circBuf.extractDataDouble(start, 8);
        this.fft8.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int doCR36_8000FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datao = circBuf.extractDataDouble(start, 200);
        double[] datar = new double[512];
        int c = 0;
        for (int a = 0; a < 512; ++a) {
            datar[a] = c < 200 ? datao[c] : 0.0;
            datar[a] = this.windowBlackman(datar[a], a, datar.length);
            ++c;
        }
        this.fft512.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    public int doCR36_11025FFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datao = circBuf.extractDataDouble(start, 275);
        double[] datar = new double[512];
        int c = 0;
        for (int a = 0; a < 512; ++a) {
            datar[a] = c < 200 ? datao[c] : 0.0;
            ++c;
        }
        this.fft512.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }

    private int doXPAFFT(CircularDataBuffer circBuf, WaveData waveData, int start) {
        double[] datao = circBuf.extractDataDouble(start, 1024);
        double[] datar = new double[1024];
        for (int a = 0; a < datar.length; ++a) {
            datar[a] = this.windowBlackman(datao[a], a, datao.length);
        }
        this.fft1024.realForward(datar);
        double[] spec = this.getSpectrum(datar);
        int freq = this.getFFTFreq(spec, waveData.getSampleRate());
        return freq;
    }
}

