/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.util.ArrayList;
import java.util.List;
import org.e2k.CarrierInfo;
import org.e2k.CircularDataBuffer;
import org.e2k.FFT;
import org.e2k.WaveData;

public class OFDM
extends FFT {
    public double[] doRDFTFFTSpectrum(CircularDataBuffer circBuf, WaveData waveData, int start, boolean type, int ss, boolean window) {
        double[] datao = circBuf.extractDataDouble(start, ss);
        double[] datar = new double[800];
        for (int a = 0; a < datar.length; ++a) {
            if (ss == 65 || ss == 66) {
                datar[a] = a >= 167 && a < 232 ? datao[a - 167] : 0.0;
            } else if (ss == 650) {
                datar[a] = a >= 75 && a < 725 ? datao[a - 75] : 0.0;
            } else if (ss == 800) {
                datar[a] = datao[a];
            }
            if (!window) continue;
            datar[a] = this.windowHamming(datar[a], a, datar.length);
        }
        this.RDFTfft.realForward(datar);
        if (type) {
            return this.getSpectrum(datar);
        }
        return datar;
    }

    public List<CarrierInfo> findOFDMCarriers(double[] spectrum, double sampleRate, int binCount, double multiFactor) {
        int a;
        ArrayList<CarrierInfo> cList = new ArrayList<CarrierInfo>();
        double dPoint = -1.0;
        for (a = 0; a < spectrum.length - 1; ++a) {
            if (!(spectrum[a] > dPoint)) continue;
            dPoint = spectrum[a];
        }
        dPoint *= multiFactor;
        for (a = 1; a < spectrum.length - 1; ++a) {
            if (!(spectrum[a] > spectrum[a - 1]) || !(spectrum[a] > spectrum[a + 1]) || !(spectrum[a] > dPoint)) continue;
            CarrierInfo cInfo = new CarrierInfo();
            cInfo.setBinFFT(a);
            cInfo.setEnergy(spectrum[a]);
            double freq = (double)a * (sampleRate / (double)binCount);
            cInfo.setFrequencyHZ(freq);
            cList.add(cInfo);
        }
        return cList;
    }

    public boolean carrierSpacingCheck(List<CarrierInfo> carrierList, int correctBinSpacing) {
        for (int a = 1; a < carrierList.size(); ++a) {
            int lastBin = carrierList.get(a).getBinFFT() - carrierList.get(a - 1).getBinFFT();
            if (lastBin == correctBinSpacing) continue;
            return false;
        }
        return true;
    }

    public int returnRealBin(int binno) {
        int rb = (binno + 1) * 2;
        return rb;
    }

    public int returnImagBin(int binno) {
        int rb = (binno + 1) * 2;
        return rb + 1;
    }

    public double averageCarrierSpacing(List<CarrierInfo> carrierList) {
        double average = 0.0;
        for (int a = 1; a < carrierList.size(); ++a) {
            average += carrierList.get(a).getFrequencyHZ() - carrierList.get(a - 1).getFrequencyHZ();
        }
        return average /= (double)carrierList.size();
    }

    public List<CarrierInfo> findOFDMCarriersWithinRange(double[] spectrum, double sampleRate, int binCount, double multiFactor, int startBin, int endBin) {
        int a;
        ArrayList<CarrierInfo> cList = new ArrayList<CarrierInfo>();
        double dPoint = -1.0;
        for (a = startBin; a < endBin; ++a) {
            if (!(spectrum[a] > dPoint)) continue;
            dPoint = spectrum[a];
        }
        dPoint *= multiFactor;
        for (a = startBin; a < endBin; ++a) {
            if (!(spectrum[a] > spectrum[a - 1]) || !(spectrum[a] > spectrum[a + 1]) || !(spectrum[a] > dPoint)) continue;
            CarrierInfo cInfo = new CarrierInfo();
            cInfo.setBinFFT(a);
            cInfo.setEnergy(spectrum[a]);
            double freq = (double)a * (sampleRate / (double)binCount);
            cInfo.setFrequencyHZ(freq);
            cList.add(cInfo);
        }
        return cList;
    }
}

