/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.e2k.CarrierInfo;
import org.e2k.CircularDataBuffer;
import org.e2k.Complex;
import org.e2k.OFDM;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class RDFT
extends OFDM {
    private int state = 0;
    private Rivet theApp;
    private long sampleCount = 0L;
    private long symbolCounter = 0L;
    private double samplesPerSymbol;
    private int[][][] carrierBinNos = new int[8][23][2];
    private double totalCarriersEnergy;
    private double[] pastEnergyBuffer = new double[3];
    private int pastEnergyBufferCounter = 0;

    public RDFT(Rivet tapp) {
        this.theApp = tapp;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 0) {
            this.theApp.setStatusLabel("Setup");
        } else if (state == 1) {
            this.theApp.setStatusLabel("Signal Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Msg Hunt");
        }
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nRDFT recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.samplesPerSymbol = this.samplesPerSymbol(122.5, waveData.getSampleRate());
            this.theApp.writeLine("Please note that this mode is experimental and doesn't work yet !", Color.RED, this.theApp.italicFont);
            this.setState(1);
            return true;
        }
        if (this.state == 1) {
            double[] spr;
            List<CarrierInfo> clist;
            ++this.sampleCount;
            if (this.sampleCount < 0L) {
                return true;
            }
            if (this.sampleCount % 50L == 0L && this.RDFTCheck(clist = this.findOFDMCarriers(spr = this.doRDFTFFTSpectrum(circBuf, waveData, 0, true, 650, true), waveData.getSampleRate(), 800, 0.2))) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.theApp.getTimeStamp() + " RDFT lead in tones found. Carrier 1 at " + Double.toString(clist.get(0).getFrequencyHZ()) + " Hz");
                sb.append(" & Carrier 8 at " + Double.toString(clist.get(7).getFrequencyHZ()) + " Hz");
                this.theApp.writeLine(sb.toString(), Color.BLACK, this.theApp.boldFont);
                this.populateCarrierTonesBins(clist.get(0).getBinFFT());
                this.setState(2);
            }
        } else if (this.state == 2) {
            ++this.sampleCount;
            ++this.symbolCounter;
            this.symbolCounter = 0L;
            double[] ri = this.doRDFTFFTSpectrum(circBuf, waveData, 0, false, (int)this.samplesPerSymbol, false);
            List<Complex> symbolComplex = this.extractCarrierSymbols(ri);
            StringBuilder sb = new StringBuilder();
            sb.append(Long.toString(this.sampleCount));
            this.pastEnergyBuffer[this.pastEnergyBufferCounter] = this.totalCarriersEnergy;
            ++this.pastEnergyBufferCounter;
            if (this.pastEnergyBufferCounter == this.pastEnergyBuffer.length) {
                this.pastEnergyBufferCounter = 0;
            }
            double av = 0.0;
            for (int a = 0; a < this.pastEnergyBuffer.length; ++a) {
                av += this.pastEnergyBuffer[a];
            }
            sb.append("," + Double.toString(av /= (double)this.pastEnergyBuffer.length));
        }
        return true;
    }

    private List<Complex> extractCarrierSymbols(double[] fdata) {
        ArrayList<Complex> complexList = new ArrayList<Complex>();
        this.totalCarriersEnergy = 0.0;
        for (int carrierNo = 0; carrierNo < 8; ++carrierNo) {
            Complex total = new Complex();
            for (int b = 0; b < 23; ++b) {
                int rBin = this.carrierBinNos[carrierNo][b][0];
                int iBin = this.carrierBinNos[carrierNo][b][1];
                Complex tbin = new Complex(fdata[rBin], fdata[iBin]);
                total = total.add(tbin);
            }
            complexList.add(total);
            this.totalCarriersEnergy += total.getMagnitude();
        }
        return complexList;
    }

    private boolean RDFTCheck(List<CarrierInfo> carrierList) {
        if (carrierList.size() != 8) {
            return false;
        }
        int[] leadCarrierNos = new int[8];
        int totalDifference = carrierList.get(7).getBinFFT() - carrierList.get(0).getBinFFT();
        if (totalDifference < 159 || totalDifference > 162) {
            return false;
        }
        double spacing = this.averageCarrierSpacing(carrierList);
        if (spacing < 190.0 || spacing > 250.0) {
            return false;
        }
        for (int a = 0; a < 8; ++a) {
            leadCarrierNos[a] = carrierList.get(0).getBinFFT() + a * 23;
        }
        return true;
    }

    private void populateCarrierTonesBins(int carrierCentre) {
        for (int carrierNos = 0; carrierNos < 8; ++carrierNos) {
            int mod = -11;
            for (int binNos = 0; binNos < 23; ++binNos) {
                this.carrierBinNos[carrierNos][binNos][0] = this.returnRealBin(carrierCentre + mod);
                this.carrierBinNos[carrierNos][binNos][1] = this.returnImagBin(carrierCentre + mod);
                ++mod;
            }
            carrierCentre += 23;
        }
    }

    private double[] recoverCarrier(int carrierNo, double[] spectrumIn) {
        double[] spectrum = new double[spectrumIn.length];
        for (int b = 0; b < 23; ++b) {
            int rBin = this.carrierBinNos[carrierNo][b][0];
            int iBin = this.carrierBinNos[carrierNo][b][1];
            spectrum[rBin] = spectrumIn[rBin];
            spectrum[iBin] = spectrumIn[iBin];
        }
        this.RDFTfft.realInverse(spectrum, false);
        return spectrum;
    }
}

