/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.e2k.CircularDataBuffer;
import org.e2k.FSK;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class RTTY
extends FSK {
    private double baudRate = 50.0;
    private int state = 0;
    private double samplesPerSymbol;
    private Rivet theApp;
    public long sampleCount = 0L;
    private long symbolCounter = 0L;
    private CircularDataBuffer energyBuffer = new CircularDataBuffer();
    private int characterCount = 0;
    private int highBin;
    private int lowBin;
    private boolean[] inChar7 = new boolean[7];
    private boolean[] inChar8 = new boolean[8];
    private final int MAXCHARLENGTH = 100;
    private int bcount;
    private long missingCharCounter = 0L;
    private double[] adjBuffer = new double[2];
    private int adjCounter = 0;
    private int shift = 450;
    private double stopBits = 1.5;
    private int previousbcount = 0;
    private double symbolTotal;
    private double previousSymbolTotal;
    private double[] oldSymbolPercentage = new double[4];

    public RTTY(Rivet tapp) {
        this.theApp = tapp;
        this.samplesPerSymbol = this.samplesPerSymbol(this.baudRate, 8000.0);
    }

    public void setBaudRate(double br) {
        if (br != this.baudRate) {
            this.setState(0);
        }
        this.baudRate = br;
        this.samplesPerSymbol = this.samplesPerSymbol(this.baudRate, 8000.0);
    }

    public double getBaudRate() {
        return this.baudRate;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 1) {
            this.theApp.setStatusLabel("Sync Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Decoding Traffic");
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        String sRet;
        if (this.state == 0) {
            if (waveData.getSampleRate() != 8000.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nRTTY recordings must have\nbeen recorded at a sample rate\nof 8 KHz.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.setState(1);
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.energyBuffer.setBufferCounter(0);
            this.characterCount = 0;
            this.lettersMode = true;
            return true;
        }
        if (this.state == 1 && this.sampleCount > 0L && (sRet = this.syncSequenceHunt(circBuf, waveData)) != null) {
            this.theApp.writeLine(sRet, Color.BLACK, this.theApp.italicFont);
            this.setState(2);
            this.energyBuffer.setBufferCounter(0);
            this.bcount = 0;
            this.missingCharCounter = 0L;
            this.theApp.newLineWrite();
        }
        if (this.state == 2 && (double)this.symbolCounter >= this.samplesPerSymbol) {
            boolean cend = false;
            int ibit = this.rttyFreqHalf(circBuf, waveData, 0);
            if (this.theApp.isInvertSignal()) {
                if (ibit == 0) {
                    ibit = 1;
                } else if (ibit == 1) {
                    ibit = 0;
                }
            }
            if (this.theApp.isBitStreamOut()) {
                if (ibit == 1) {
                    this.theApp.bitStreamWrite("1");
                } else if (ibit == 0) {
                    this.theApp.bitStreamWrite("0");
                } else if (ibit == 2) {
                    this.theApp.bitStreamWrite("2");
                } else if (ibit == 3) {
                    this.theApp.bitStreamWrite("3");
                }
            }
            this.oldSymbolPercentage[3] = this.oldSymbolPercentage[2];
            this.oldSymbolPercentage[2] = this.oldSymbolPercentage[1];
            this.oldSymbolPercentage[1] = this.oldSymbolPercentage[0];
            this.oldSymbolPercentage[0] = this.symbolTotal < this.previousSymbolTotal ? 100.0 - this.symbolTotal / this.previousSymbolTotal * 100.0 : 100.0 - this.previousSymbolTotal / this.symbolTotal * 100.0;
            double av = (this.oldSymbolPercentage[0] + this.oldSymbolPercentage[1] + this.oldSymbolPercentage[2] + this.oldSymbolPercentage[3]) / 4.0;
            if (av > 40.0 && this.missingCharCounter > 2L) {
                this.setState(1);
            }
            if ((this.stopBits == 1.5 || this.stopBits == 2.5) && ibit == 2) {
                cend = true;
            } else if (this.stopBits == 1.0) {
                if (this.checkValid15()) {
                    cend = true;
                }
            } else if (this.stopBits == 2.0 && this.checkValid20()) {
                cend = true;
            }
            if (this.bcount < 7) {
                cend = false;
            }
            if (cend) {
                this.symbolCounter = (int)this.samplesPerSymbol / 2;
                if (this.theApp.isDebug()) {
                    this.theApp.writeLine(this.getCharBuffer() + " (" + Integer.toString(this.bcount) + ")  " + this.getBaudotChar(), Color.BLACK, this.theApp.italicFont);
                } else {
                    String ch = this.getBaudotChar();
                    if (ch.equals(this.getBAUDOT_LETTERS(2))) {
                        this.characterCount = 0;
                        this.theApp.newLineWrite();
                    } else if (ch.equals(this.getBAUDOT_LETTERS(8))) {
                        this.characterCount = 0;
                        this.theApp.newLineWrite();
                    } else {
                        this.theApp.writeChar(ch, Color.BLACK, this.theApp.boldFont);
                        ++this.characterCount;
                    }
                }
                if (this.bcount > 8) {
                    ++this.missingCharCounter;
                }
                if (this.bcount < 9 && this.previousbcount < 9) {
                    this.missingCharCounter = 0L;
                }
                this.previousbcount = this.bcount;
                this.bcount = 0;
            } else {
                this.addToCharBuffer(ibit);
                this.symbolCounter = this.adjAdjust();
            }
            if (this.characterCount >= 100) {
                this.characterCount = 0;
                this.theApp.newLineWrite();
            }
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    public int getShift() {
        return this.shift;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    private int rttyFreq(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        if (waveData.getSampleRate() == 8000.0) {
            int freq = this.doRTTY_8000FFT(circBuf, waveData, pos, (int)this.samplesPerSymbol, this.baudRate);
            return freq;
        }
        return -1;
    }

    private String syncSequenceHunt(CircularDataBuffer circBuf, WaveData waveData) {
        int freq1 = this.rttyFreq(circBuf, waveData, 0);
        int bin1 = this.getFreqBin();
        if (this.getPercentageOfTotal() < 5.0) {
            return null;
        }
        int freq2 = this.rttyFreq(circBuf, waveData, (int)this.samplesPerSymbol * 1);
        int bin2 = this.getFreqBin();
        if (freq2 > freq1) {
            return null;
        }
        int difference = freq1 - freq2;
        if (difference < this.shift - 25 || difference > this.shift + 25) {
            return null;
        }
        int freq3 = this.rttyFreq(circBuf, waveData, (int)this.samplesPerSymbol * 2);
        if (freq1 != freq3) {
            return null;
        }
        int freq4 = this.rttyFreq(circBuf, waveData, (int)this.samplesPerSymbol * 3);
        if (freq1 != freq3 || freq2 != freq4) {
            return null;
        }
        if (freq1 == freq2 || freq3 == freq4) {
            return null;
        }
        if (freq1 > freq2) {
            this.highBin = bin1;
            this.lowBin = bin2;
        } else {
            this.highBin = bin2;
            this.lowBin = bin1;
        }
        if (this.lowBin == 0 || this.highBin == 0) {
            return null;
        }
        String line = this.theApp.getTimeStamp() + " RTTY Sync Sequence Found";
        return line;
    }

    private void addToCharBuffer(int in) {
        int a;
        for (a = 1; a < this.inChar7.length; ++a) {
            this.inChar7[a - 1] = this.inChar7[a];
        }
        this.inChar7[6] = in != 0;
        for (a = 1; a < this.inChar8.length; ++a) {
            this.inChar8[a - 1] = this.inChar8[a];
        }
        this.inChar8[7] = in != 0;
        ++this.bcount;
    }

    private String getCharBuffer() {
        StringBuilder lb = new StringBuilder();
        if (this.stopBits < 2.0) {
            for (int a = 0; a < 7; ++a) {
                if (this.inChar7[a]) {
                    lb.append("1");
                } else {
                    lb.append("0");
                }
                if (a != 0 && a != 5) continue;
                lb.append(" ");
            }
        } else {
            for (int a = 0; a < 8; ++a) {
                if (this.inChar8[a]) {
                    lb.append("1");
                } else {
                    lb.append("0");
                }
                if (a != 0 && a != 5) continue;
                lb.append(" ");
            }
        }
        return lb.toString();
    }

    private String getBaudotChar() {
        int a = 0;
        if (this.stopBits < 2.0) {
            if (this.inChar7[5]) {
                a = 16;
            }
            if (this.inChar7[4]) {
                a += 8;
            }
            if (this.inChar7[3]) {
                a += 4;
            }
            if (this.inChar7[2]) {
                a += 2;
            }
            if (this.inChar7[1]) {
                ++a;
            }
        } else {
            if (this.inChar8[5]) {
                a = 16;
            }
            if (this.inChar8[4]) {
                a += 8;
            }
            if (this.inChar8[3]) {
                a += 4;
            }
            if (this.inChar8[2]) {
                a += 2;
            }
            if (this.inChar8[1]) {
                ++a;
            }
        }
        if (a == 0) {
            return "";
        }
        if (a == 27) {
            this.lettersMode = false;
            return "";
        }
        if (a == 31) {
            this.lettersMode = true;
            return "";
        }
        if (this.lettersMode) {
            return this.getBAUDOT_LETTERS(a);
        }
        return this.getBAUDOT_NUMBERS(a);
    }

    private boolean checkValid15() {
        return !this.inChar7[0] && this.inChar7[6] && this.bcount >= 7;
    }

    private boolean checkValid20() {
        return !this.inChar8[0] && this.inChar8[6] && this.inChar8[7] && this.bcount >= 8;
    }

    private void addToAdjBuffer(double in) {
        this.adjBuffer[this.adjCounter] = in;
        ++this.adjCounter;
        if (this.adjCounter == this.adjBuffer.length) {
            this.adjCounter = 0;
        }
    }

    private double adjAverage() {
        double total = 0.0;
        for (int a = 0; a < this.adjBuffer.length; ++a) {
            total += this.adjBuffer[a];
        }
        return total / (double)this.adjBuffer.length;
    }

    private int adjAdjust() {
        double av = this.adjAverage();
        double r = Math.abs(av) / 5.0;
        if (av < 0.0) {
            r = 0.0 - r;
        }
        return (int)r;
    }

    private int rttyFreqHalf(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        boolean high2;
        int v = 0;
        int sp = (int)this.samplesPerSymbol / 2;
        double[] early = this.doRTTYHalfSymbolBinRequest(this.baudRate, circBuf, pos, this.lowBin, this.highBin);
        double[] late = this.doRTTYHalfSymbolBinRequest(this.baudRate, circBuf, pos + sp, this.lowBin, this.highBin);
        this.previousSymbolTotal = this.symbolTotal;
        this.symbolTotal = early[0] + late[0] + early[1] + late[1];
        boolean high1 = !(early[0] > early[1]);
        if (high1 == (high2 = !(late[0] > late[1]))) {
            v = !high1 ? 1 : 0;
        } else if (this.stopBits == 1.5) {
            if (this.checkValid15()) {
                v = high2 > high1 ? 2 : 3;
            }
        } else if (this.stopBits == 2.5) {
            if (this.checkValid20()) {
                v = high2 > high1 ? 2 : 3;
            }
        } else {
            v = early[0] + late[0] > early[1] + late[1] ? 1 : 0;
        }
        if (v < 2) {
            double lowTotal = early[0] + late[0];
            double highTotal = early[1] + late[1];
            if (lowTotal > highTotal) {
                this.addToAdjBuffer(this.getPercentageDifference(early[0], late[0]));
            } else {
                this.addToAdjBuffer(this.getPercentageDifference(early[1], late[1]));
            }
        }
        return v;
    }

    public double getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(double stopBits) {
        this.stopBits = stopBits;
    }
}

