/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.e2k.CCIR493;
import org.e2k.CIS3650;
import org.e2k.CROWD36;
import org.e2k.CircularDataBuffer;
import org.e2k.DisplayFrame;
import org.e2k.DisplayModel;
import org.e2k.DisplayView;
import org.e2k.FSK2001000;
import org.e2k.FSK200500;
import org.e2k.FSKraw;
import org.e2k.GW;
import org.e2k.InputThread;
import org.e2k.RTTY;
import org.e2k.Ship;
import org.e2k.Trigger;
import org.e2k.UserIdentifier;
import org.e2k.WaveData;
import org.e2k.XPA;
import org.e2k.XPA2;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Rivet {
    private static boolean RUNNING = true;
    private DisplayModel display_model;
    private DisplayView display_view;
    private static Rivet theApp;
    private static DisplayFrame window;
    public final String program_version = "Rivet (Build 90)";
    public int vertical_scrollbar_value = 0;
    public int horizontal_scrollbar_value = 0;
    public boolean pReady = false;
    private int system = 1;
    public final Font plainFont = new Font("SanSerif", 0, 12);
    public final Font boldFont = new Font("SanSerif", 1, 12);
    public final Font italicFont = new Font("SanSerif", 2, 12);
    public XPA xpaHandler = new XPA(this, 10);
    public XPA2 xpa2Handler = new XPA2(this);
    public CROWD36 crowd36Handler = new CROWD36(this, 40);
    public FSK200500 fsk200500Handler = new FSK200500(this, 200);
    public FSK2001000 fsk2001000Handler = new FSK2001000(this, 200);
    public CIS3650 cis3650Handler = new CIS3650(this);
    public CCIR493 ccir493Handler = new CCIR493(this);
    public RTTY rttyHandler = new RTTY(this);
    public GW gwHandler = new GW(this);
    public FSKraw fskHandler = new FSKraw(this);
    public InputThread inputThread = new InputThread(this);
    private DataInputStream inPipeData;
    private PipedInputStream inPipe;
    private CircularDataBuffer circBuffer = new CircularDataBuffer();
    private WaveData waveData = new WaveData();
    private boolean logging = false;
    public FileWriter file;
    public FileWriter bitStreamFile;
    private boolean debug = false;
    private boolean soundCardInput = false;
    private boolean wavFileLoadOngoing = false;
    private boolean invertSignal = false;
    private int soundCardInputLevel = 0;
    private boolean soundCardInputTemp;
    private boolean bitStreamOut = false;
    private boolean viewGWChannelMarkers = true;
    private int bitStreamOutCount = 0;
    private List<Trigger> listTriggers = new ArrayList<Trigger>();
    private int activeTriggerCount = 0;
    private boolean pauseDisplay = false;
    private boolean autoScroll = true;
    private long lastUserScroll = 0L;
    private boolean smallScreen = false;
    private boolean displayBadPackets = false;
    private boolean logInUTC = false;
    private List<Ship> listLoggedShips = new ArrayList<Ship>();
    public final String[] MODENAMES = new String[]{"CROWD36", "XPA (10 Baud)", "XPA2", "XPA (20 Baud)", "Experimental", "CIS 36-50", "FSK200/500", "CCIR493-4", "FSK200/1000", "GW FSK (100 Baud)", "Baudot", "FSK (Raw)"};

    public static void main(String[] args) {
        theApp = new Rivet();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                theApp.createGUI();
            }
        });
        try {
            Rivet.theApp.inPipe = new PipedInputStream(Rivet.theApp.inputThread.getPipedWriter());
            Rivet.theApp.inPipeData = new DataInputStream(Rivet.theApp.inPipe);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in main()", "Rivet", 0);
            System.exit(0);
        }
        while (RUNNING) {
            if (Rivet.theApp.wavFileLoadOngoing && Rivet.theApp.pReady) {
                theApp.getWavData();
                continue;
            }
            if (Rivet.theApp.inputThread.getAudioReady() && Rivet.theApp.pReady) {
                theApp.getAudioData();
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error in main2()\n" + e.toString(), "Rivet", 0);
            }
        }
    }

    public void createGUI() {
        window = new DisplayFrame("Rivet (Build 90)", this);
        Toolkit theKit = window.getToolkit();
        Dimension wndsize = theKit.getScreenSize();
        int x = wndsize.width / 6;
        int y = wndsize.height / 6;
        int width = 2 * wndsize.width / 3;
        int height = 2 * wndsize.height / 3;
        window.setBounds(x, y, width, height);
        window.addWindowListener(new WindowHandler());
        this.display_model = new DisplayModel();
        this.display_view = new DisplayView(this);
        this.display_model.addObserver(this.display_view);
        window.getContentPane().add((Component)this.display_view, "Center");
        window.setVisible(true);
        if (width < 600) {
            window.setSmallScreen();
        }
        this.pReady = true;
    }

    public DisplayFrame getWindow() {
        return window;
    }

    public DisplayModel getModel() {
        return this.display_model;
    }

    public DisplayView getView() {
        return this.display_view;
    }

    public void setSystem(int system) {
        this.system = system;
        if (system == 1) {
            this.xpaHandler.setBaudRate(10);
        } else if (system == 3) {
            this.xpaHandler.setBaudRate(20);
        }
    }

    public int getSystem() {
        return this.system;
    }

    public boolean isCROWD36() {
        return this.system == 0;
    }

    public boolean isXPA_10() {
        return this.system == 1;
    }

    public boolean isXPA_20() {
        return this.system == 3;
    }

    public boolean isXPA2() {
        return this.system == 2;
    }

    public boolean isExperimental() {
        return this.system == 4;
    }

    public boolean isCIS3650() {
        return this.system == 5;
    }

    public boolean isFSK200500() {
        return this.system == 6;
    }

    public boolean isCCIR493() {
        return this.system == 7;
    }

    public boolean isFSK2001000() {
        return this.system == 8;
    }

    public boolean isGW() {
        return this.system == 9;
    }

    public boolean isRTTY() {
        return this.system == 10;
    }

    public boolean isFSK() {
        return this.system == 11;
    }

    public void loadWAVfile(String fileName) {
        String disp = this.getTimeStamp() + " Loading file " + fileName;
        this.writeLine(disp, Color.BLACK, this.italicFont);
        this.waveData = this.inputThread.startFileLoad(fileName);
        this.waveData.setFromFile(true);
        this.circBuffer.setBufferCounter(0);
        if (this.system == 0) {
            this.crowd36Handler.setState(0);
        } else if (this.system == 1 || this.system == 3) {
            this.xpaHandler.setState(0);
        } else if (this.system == 2) {
            this.xpa2Handler.setState(0);
        } else if (this.system == 5) {
            this.cis3650Handler.setState(0);
        } else if (this.system == 6) {
            this.fsk200500Handler.setState(0);
        } else if (this.system == 7) {
            this.ccir493Handler.setState(0);
        } else if (this.system == 8) {
            this.fsk2001000Handler.setState(0);
        } else if (this.system == 9) {
            this.gwHandler.setState(0);
        } else if (this.system == 10) {
            this.rttyHandler.setState(0);
        } else if (this.system == 11) {
            this.fskHandler.setState(0);
        }
        this.wavFileLoadOngoing = true;
    }

    private void getWavData() {
        try {
            this.circBuffer.addToCircBuffer(this.inPipeData.readInt());
            this.processData();
            this.updateProgressBar();
            if (!this.inputThread.getLoadingFileState()) {
                for (int a = 0; a < this.circBuffer.retMax(); ++a) {
                    this.processData();
                    this.circBuffer.addToCircBuffer(0);
                }
                if (this.system == 0) {
                    this.writeLine(this.crowd36Handler.lowHighFreqs(), Color.BLACK, this.plainFont);
                    this.crowd36Handler.toneResults();
                } else if (this.system != 5) {
                    if (this.system == 6) {
                        this.writeLine(this.fsk200500Handler.getQuailty(), Color.BLACK, this.plainFont);
                    } else if (this.system == 8) {
                        this.writeLine(this.fsk2001000Handler.getQuailty(), Color.BLACK, this.plainFont);
                    }
                }
                if (this.wavFileLoadOngoing) {
                    String disp = this.getTimeStamp() + " WAV file loaded and analysis complete (" + Long.toString(this.inputThread.getSampleCounter()) + " samples read)";
                    this.writeLine(disp, Color.BLACK, this.italicFont);
                    this.wavFileLoadOngoing = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error in getWavData()", "Rivet", 0);
        }
    }

    private void getAudioData() {
        try {
            this.circBuffer.addToCircBuffer(this.inPipeData.readInt());
            this.processData();
            if (this.inputThread.getSampleCounter() % 50L == 0L) {
                this.updateVolumeBar();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Error in getAudioData()", "Rivet", 0);
        }
    }

    private void processData() {
        try {
            boolean res = false;
            if (this.system == 0) {
                res = this.crowd36Handler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 1 || this.system == 3) {
                res = this.xpaHandler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 2) {
                res = this.xpa2Handler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 5) {
                res = this.cis3650Handler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 6) {
                res = this.fsk200500Handler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 7) {
                res = this.ccir493Handler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 8) {
                res = this.fsk2001000Handler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 9) {
                res = this.gwHandler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 10) {
                res = this.rttyHandler.decode(this.circBuffer, this.waveData);
            } else if (this.system == 11) {
                res = this.fskHandler.decode(this.circBuffer, this.waveData);
            }
            if (!res && !this.soundCardInput) {
                this.inputThread.stopReadingFile();
                this.wavFileLoadOngoing = false;
                this.writeLine("Error Loading WAV File", Color.RED, Rivet.theApp.boldFont);
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String str = sw.toString();
            JOptionPane.showMessageDialog(null, "Error in processData()\n" + str, "Rivet", 0);
        }
    }

    public void debugDump(String line) {
        try {
            FileWriter dfile = new FileWriter("debug.csv", true);
            dfile.write(line);
            dfile.write("\r\n");
            dfile.flush();
            dfile.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }

    public String getTimeStamp() {
        Date now = new Date();
        DateFormat df = DateFormat.getTimeInstance();
        if (this.logInUTC) {
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return df.format(now);
    }

    private void updateProgressBar() {
        window.progressBarUpdate(this.inputThread.returnFileLoadPercentage());
    }

    private void updateVolumeBar() {
        int pval = (int)((float)this.inputThread.returnVolumeAverage() / 3000.0f * 100.0f);
        window.progressBarUpdate(pval);
    }

    public void setStatusLabel(String st) {
        window.setStatusLabel(st);
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public boolean getLogging() {
        return this.logging;
    }

    public boolean fileWriteLine(String fline) {
        try {
            this.file.write(fline);
            this.file.write("\r\n");
            this.file.flush();
        }
        catch (Exception e) {
            this.logging = false;
            JOptionPane.showMessageDialog(null, "Error writing to the log file in fileWriteLine().\n" + e.toString(), "Rivet", 0);
            return false;
        }
        return true;
    }

    public boolean fileWriteChar(String ch) {
        try {
            this.file.write(ch);
        }
        catch (Exception e) {
            this.logging = false;
            JOptionPane.showMessageDialog(null, "Error writing to the log file in fileWriteChar().\n" + e.toString(), "Rivet", 0);
            return false;
        }
        return true;
    }

    public boolean fileWriteNewline() {
        try {
            this.file.write("\r\n");
        }
        catch (Exception e) {
            this.logging = false;
            JOptionPane.showMessageDialog(null, "Error writing to the log file in fileWriteNewline().\n" + e.toString(), "Rivet", 0);
            return false;
        }
        return true;
    }

    public boolean bitStreamWrite(String fline) {
        try {
            ++this.bitStreamOutCount;
            if (this.bitStreamOutCount == 80) {
                fline = fline + "\n";
                this.bitStreamOutCount = 0;
            }
            this.bitStreamFile.write(fline);
        }
        catch (Exception e) {
            this.bitStreamOut = false;
            JOptionPane.showMessageDialog(null, "Error writing to the bit stream file.\n" + e.toString(), "Rivet", 0);
            return false;
        }
        return true;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isSoundCardInput() {
        return this.soundCardInput;
    }

    public void setSoundCardInput(boolean s) {
        if (this.soundCardInput) {
            this.inputThread.closeAudio();
        }
        if (!s) {
            this.soundCardInput = false;
        } else if (this.system == 0 || this.system == 1 || this.system == 2 || this.system == 3 || this.system == 4 || this.system == 5 || this.system == 6 || this.system == 8 || this.system == 7 || this.system == 9 || this.system == 10 || this.system == 11 || this.system == 12) {
            WaveData waveSetting = new WaveData();
            waveSetting.setChannels(1);
            waveSetting.setEndian(true);
            waveSetting.setSampleSizeInBits(16);
            waveSetting.setFromFile(false);
            waveSetting.setSampleRate(8000.0);
            waveSetting.setBytesPerFrame(2);
            this.inputThread.setupAudio(waveSetting);
            this.waveData = waveSetting;
            this.soundCardInput = true;
        }
    }

    public void setSoundCardInputOnly(boolean s) {
        this.soundCardInput = s;
    }

    public void resetDecoderState() {
        if (this.system == 0) {
            this.crowd36Handler.setState(0);
        } else if (this.system == 1 || this.system == 3) {
            this.xpaHandler.setState(0);
        } else if (this.system == 2) {
            this.xpa2Handler.setState(0);
        } else if (this.system == 5) {
            this.cis3650Handler.setState(0);
        } else if (this.system == 6) {
            this.fsk200500Handler.setState(0);
        } else if (this.system == 7) {
            this.ccir493Handler.setState(0);
        } else if (this.system == 8) {
            this.fsk2001000Handler.setState(0);
        } else if (this.system == 9) {
            this.gwHandler.setState(0);
        } else if (this.system == 10) {
            this.rttyHandler.setState(0);
        } else if (this.system == 11) {
            this.fskHandler.setState(0);
        }
    }

    public String getAllText() {
        String all = this.display_view.getText();
        return all;
    }

    public void getCROWD36SyncHighTone() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        JLabel label = new JLabel("High Sync Tone Number (0 to 33)");
        JTextField toneField = new JTextField(2);
        toneField.setText(Integer.toString(this.crowd36Handler.getSyncHighTone()));
        panel.add(label);
        panel.add(toneField);
        panel.setVisible(true);
        int resp = JOptionPane.showConfirmDialog(window, panel, "Enter the CROWD36 High Sync Tone Number", 2, 3);
        if (resp == 0) {
            String sval = new String(toneField.getText());
            this.crowd36Handler.setSyncHighTone(Integer.parseInt(sval));
        }
    }

    public void setBEEOptions() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        JLabel labelShift = new JLabel("Shift : ");
        String[] SHIFTS = new String[]{"75 Hz", "200 Hz", "250 Hz", "400 Hz", "500 Hz"};
        JComboBox<String> shiftList = new JComboBox<String>(SHIFTS);
        if (this.cis3650Handler.getShift() == 75) {
            shiftList.setSelectedIndex(0);
        } else if (this.cis3650Handler.getShift() == 200) {
            shiftList.setSelectedIndex(1);
        } else if (this.cis3650Handler.getShift() == 250) {
            shiftList.setSelectedIndex(2);
        } else if (this.cis3650Handler.getShift() == 400) {
            shiftList.setSelectedIndex(3);
        } else if (this.cis3650Handler.getShift() == 500) {
            shiftList.setSelectedIndex(4);
        }
        panel.add(labelShift);
        panel.add(shiftList);
        int resp = JOptionPane.showConfirmDialog(window, panel, "CIS36-50 Options", 2, 3);
        if (resp == 0) {
            if (shiftList.getSelectedIndex() == 0) {
                this.cis3650Handler.setShift(75);
            } else if (shiftList.getSelectedIndex() == 1) {
                this.cis3650Handler.setShift(200);
            } else if (shiftList.getSelectedIndex() == 2) {
                this.cis3650Handler.setShift(250);
            } else if (shiftList.getSelectedIndex() == 3) {
                this.cis3650Handler.setShift(400);
            } else if (shiftList.getSelectedIndex() == 4) {
                this.cis3650Handler.setShift(500);
            }
        }
    }

    public void setRTTYOptions() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, 2));
        JLabel labelBaud = new JLabel("Baud Rate : ");
        String[] BAUDRATES = new String[]{"45.5 baud", "50 baud", "75 baud", "100 baud", "145 baud", "150 baud", "200 baud", "300 baud", "600 baud"};
        JComboBox<String> baudRateList = new JComboBox<String>(BAUDRATES);
        if (this.rttyHandler.getBaudRate() == 45.45) {
            baudRateList.setSelectedIndex(0);
        } else if (this.rttyHandler.getBaudRate() == 50.0) {
            baudRateList.setSelectedIndex(1);
        } else if (this.rttyHandler.getBaudRate() == 75.0) {
            baudRateList.setSelectedIndex(2);
        } else if (this.rttyHandler.getBaudRate() == 100.0) {
            baudRateList.setSelectedIndex(3);
        } else if (this.rttyHandler.getBaudRate() == 145.0) {
            baudRateList.setSelectedIndex(4);
        } else if (this.rttyHandler.getBaudRate() == 150.0) {
            baudRateList.setSelectedIndex(5);
        } else if (this.rttyHandler.getBaudRate() == 200.0) {
            baudRateList.setSelectedIndex(6);
        } else if (this.rttyHandler.getBaudRate() == 300.0) {
            baudRateList.setSelectedIndex(7);
        } else if (this.rttyHandler.getBaudRate() == 600.0) {
            baudRateList.setSelectedIndex(8);
        }
        panel.add(labelBaud);
        panel.add(baudRateList);
        JLabel labelShift = new JLabel("Shift : ");
        String[] SHIFTS = new String[]{"75 Hz", "150 Hz", "170 Hz", "200 Hz", "250 Hz", "300 Hz", "400 Hz", "425 Hz", "450 Hz", "500 Hz", "600 Hz", "625 Hz", "800 Hz", "850 Hz", "1000 Hz"};
        JComboBox<String> shiftList = new JComboBox<String>(SHIFTS);
        if (this.rttyHandler.getShift() == 75) {
            shiftList.setSelectedIndex(0);
        } else if (this.rttyHandler.getShift() == 150) {
            shiftList.setSelectedIndex(1);
        } else if (this.rttyHandler.getShift() == 170) {
            shiftList.setSelectedIndex(2);
        } else if (this.rttyHandler.getShift() == 200) {
            shiftList.setSelectedIndex(3);
        } else if (this.rttyHandler.getShift() == 250) {
            shiftList.setSelectedIndex(4);
        } else if (this.rttyHandler.getShift() == 300) {
            shiftList.setSelectedIndex(5);
        } else if (this.rttyHandler.getShift() == 400) {
            shiftList.setSelectedIndex(6);
        } else if (this.rttyHandler.getShift() == 425) {
            shiftList.setSelectedIndex(7);
        } else if (this.rttyHandler.getShift() == 450) {
            shiftList.setSelectedIndex(8);
        } else if (this.rttyHandler.getShift() == 500) {
            shiftList.setSelectedIndex(9);
        } else if (this.rttyHandler.getShift() == 600) {
            shiftList.setSelectedIndex(10);
        } else if (this.rttyHandler.getShift() == 625) {
            shiftList.setSelectedIndex(11);
        } else if (this.rttyHandler.getShift() == 800) {
            shiftList.setSelectedIndex(12);
        } else if (this.rttyHandler.getShift() == 850) {
            shiftList.setSelectedIndex(13);
        } else if (this.rttyHandler.getShift() == 1000) {
            shiftList.setSelectedIndex(14);
        }
        panel.add(labelShift);
        panel.add(shiftList);
        JLabel labelStop = new JLabel("Stop Bits (Baudot only) : ");
        String[] STOPBITS = new String[]{"1 Bit", "1.5 Bits", "2 Bits", "2.5 Bits"};
        JComboBox<String> stopBitsList = new JComboBox<String>(STOPBITS);
        if (this.rttyHandler.getStopBits() == 1.0) {
            stopBitsList.setSelectedIndex(0);
        } else if (this.rttyHandler.getStopBits() == 1.5) {
            stopBitsList.setSelectedIndex(1);
        } else if (this.rttyHandler.getStopBits() == 2.0) {
            stopBitsList.setSelectedIndex(2);
        } else if (this.rttyHandler.getStopBits() == 2.5) {
            stopBitsList.setSelectedIndex(3);
        }
        panel.add(labelStop);
        panel.add(stopBitsList);
        int resp = JOptionPane.showConfirmDialog(window, panel, "Baudot & FSK Options", 2, 3);
        if (resp == 0) {
            if (baudRateList.getSelectedIndex() == 0) {
                this.rttyHandler.setBaudRate(45.45);
                this.fskHandler.setBaudRate(45.45);
            }
            if (baudRateList.getSelectedIndex() == 1) {
                this.rttyHandler.setBaudRate(50.0);
                this.fskHandler.setBaudRate(50.0);
            }
            if (baudRateList.getSelectedIndex() == 2) {
                this.rttyHandler.setBaudRate(75.0);
                this.fskHandler.setBaudRate(75.0);
            }
            if (baudRateList.getSelectedIndex() == 3) {
                this.rttyHandler.setBaudRate(100.0);
                this.fskHandler.setBaudRate(100.0);
            }
            if (baudRateList.getSelectedIndex() == 4) {
                this.rttyHandler.setBaudRate(145.0);
                this.fskHandler.setBaudRate(145.0);
            }
            if (baudRateList.getSelectedIndex() == 5) {
                this.rttyHandler.setBaudRate(150.0);
                this.fskHandler.setBaudRate(150.0);
            }
            if (baudRateList.getSelectedIndex() == 6) {
                this.rttyHandler.setBaudRate(200.0);
                this.fskHandler.setBaudRate(200.0);
            }
            if (baudRateList.getSelectedIndex() == 7) {
                this.rttyHandler.setBaudRate(300.0);
                this.fskHandler.setBaudRate(300.0);
            }
            if (baudRateList.getSelectedIndex() == 8) {
                this.rttyHandler.setBaudRate(600.0);
                this.fskHandler.setBaudRate(600.0);
            }
            if (shiftList.getSelectedIndex() == 0) {
                this.rttyHandler.setShift(75);
                this.fskHandler.setShift(75);
            }
            if (shiftList.getSelectedIndex() == 1) {
                this.rttyHandler.setShift(150);
                this.fskHandler.setShift(150);
            }
            if (shiftList.getSelectedIndex() == 2) {
                this.rttyHandler.setShift(170);
                this.fskHandler.setShift(170);
            }
            if (shiftList.getSelectedIndex() == 3) {
                this.rttyHandler.setShift(200);
                this.fskHandler.setShift(200);
            }
            if (shiftList.getSelectedIndex() == 4) {
                this.rttyHandler.setShift(250);
                this.fskHandler.setShift(250);
            }
            if (shiftList.getSelectedIndex() == 5) {
                this.rttyHandler.setShift(300);
                this.fskHandler.setShift(300);
            }
            if (shiftList.getSelectedIndex() == 6) {
                this.rttyHandler.setShift(400);
                this.fskHandler.setShift(400);
            }
            if (shiftList.getSelectedIndex() == 7) {
                this.rttyHandler.setShift(425);
                this.fskHandler.setShift(425);
            }
            if (shiftList.getSelectedIndex() == 8) {
                this.rttyHandler.setShift(450);
                this.fskHandler.setShift(450);
            }
            if (shiftList.getSelectedIndex() == 9) {
                this.rttyHandler.setShift(500);
                this.fskHandler.setShift(500);
            }
            if (shiftList.getSelectedIndex() == 10) {
                this.rttyHandler.setShift(600);
                this.fskHandler.setShift(600);
            }
            if (shiftList.getSelectedIndex() == 11) {
                this.rttyHandler.setShift(625);
                this.fskHandler.setShift(625);
            }
            if (shiftList.getSelectedIndex() == 12) {
                this.rttyHandler.setShift(800);
                this.fskHandler.setShift(800);
            }
            if (shiftList.getSelectedIndex() == 13) {
                this.rttyHandler.setShift(850);
                this.fskHandler.setShift(850);
            }
            if (shiftList.getSelectedIndex() == 14) {
                this.rttyHandler.setShift(1000);
                this.fskHandler.setShift(1000);
            }
            if (stopBitsList.getSelectedIndex() == 0) {
                this.rttyHandler.setStopBits(1.0);
            }
            if (stopBitsList.getSelectedIndex() == 1) {
                this.rttyHandler.setStopBits(1.5);
            }
            if (stopBitsList.getSelectedIndex() == 2) {
                this.rttyHandler.setStopBits(2.0);
            }
            if (stopBitsList.getSelectedIndex() == 3) {
                this.rttyHandler.setStopBits(2.5);
            }
        }
    }

    public boolean isInvertSignal() {
        return this.invertSignal;
    }

    public void setInvertSignal(boolean invertSignal) {
        this.invertSignal = invertSignal;
    }

    public void saveSettings() {
        try {
            FileWriter xmlfile = new FileWriter("rivet_settings.xml");
            String line = "<?xml version='1.0' encoding='utf-8' standalone='yes'?>\n<settings>\n";
            xmlfile.write(line);
            line = "<invert val='";
            line = this.invertSignal ? line + "TRUE" : line + "FALSE";
            line = line + "'/>\n";
            xmlfile.write(line);
            line = "<debug val='";
            line = this.debug ? line + "TRUE" : line + "FALSE";
            line = line + "'/>\n";
            xmlfile.write(line);
            line = "<mode val='" + Integer.toString(this.system) + "'/>\n";
            xmlfile.write(line);
            line = "<c36tone val='" + Integer.toString(this.crowd36Handler.getSyncHighTone()) + "'/>\n";
            xmlfile.write(line);
            line = "<soundcard_level val='" + Integer.toString(this.soundCardInputLevel) + "'/>\n";
            xmlfile.write(line);
            line = this.soundCardInput ? "<soundcard_input val='1'/>\n" : "<soundcard_input val='0'/>\n";
            xmlfile.write(line);
            line = this.viewGWChannelMarkers ? "<view_gw_markers val='1'/>\n" : "<view_gw_markers val='0'/>\n";
            xmlfile.write(line);
            line = "<rttybaud val='" + Double.toString(this.rttyHandler.getBaudRate()) + "'/>\n";
            xmlfile.write(line);
            line = "<rttyshift val='" + Integer.toString(this.rttyHandler.getShift()) + "'/>\n";
            xmlfile.write(line);
            line = "<rttystop val='" + Double.toString(this.rttyHandler.getStopBits()) + "'/>\n";
            xmlfile.write(line);
            line = "<audioDevice val='" + this.inputThread.getMixerName() + "'/>\n";
            xmlfile.write(line);
            line = this.displayBadPackets ? "<display_bad_packets val='1'/>\n" : "<display_bad_packets val='0'/>\n";
            xmlfile.write(line);
            line = this.logInUTC ? "<UTC val='1'/>\n" : "<UTC val='0'/>\n";
            xmlfile.write(line);
            line = "<cis3650shift val='" + Integer.toString(this.cis3650Handler.getShift()) + "'/>\n";
            xmlfile.write(line);
            line = "</settings>";
            xmlfile.write(line);
            xmlfile.flush();
            xmlfile.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error : Unable to create the file rivet_settings.xml\n" + e.toString(), "Rivet", 0);
        }
    }

    public void readDefaultSettings() throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        String filename = "rivet_settings.xml";
        DefaultXMLFileHandler handler = new DefaultXMLFileHandler();
        parser.parse(new File(filename), (DefaultHandler)handler);
    }

    public void changeInvertSetting() {
        this.invertSignal = !this.invertSignal;
    }

    public void setSoundCardLevel(int sli) {
        this.soundCardInputLevel = sli;
        this.inputThread.setInputLevel(sli);
    }

    public int getSoundCardLevel() {
        return this.soundCardInputLevel;
    }

    public boolean issoundCardInputTemp() {
        return this.soundCardInputTemp;
    }

    public boolean isBitStreamOut() {
        return this.bitStreamOut;
    }

    public void setBitStreamOut(boolean bitStreamOut) {
        this.bitStreamOut = bitStreamOut;
    }

    public boolean isViewGWChannelMarkers() {
        return this.viewGWChannelMarkers;
    }

    public void setViewGWChannelMarkers(boolean viewGWChannelMarkers) {
        this.viewGWChannelMarkers = viewGWChannelMarkers;
    }

    public void clearBitStreamCountOut() {
        this.bitStreamOutCount = 0;
    }

    public void writeLine(String line, Color col, Font font) {
        if (line != null) {
            if (this.logging) {
                this.fileWriteLine(line);
            }
            if (!this.pauseDisplay) {
                this.display_view.addLine(line, col, font);
            }
        }
    }

    public void writeChar(String ct, Color col, Font font) {
        if (ct != null) {
            if (!this.pauseDisplay) {
                this.display_view.addChar(ct, col, font);
            }
            if (this.logging) {
                this.fileWriteChar(ct);
            }
        }
    }

    public void clearScreen() {
        this.display_view.clearScreen();
    }

    public void newLineWrite() {
        if (!this.pauseDisplay) {
            this.display_view.newLine();
        }
        if (this.logging) {
            this.fileWriteNewline();
        }
    }

    public List<Trigger> getListTriggers() {
        return this.listTriggers;
    }

    public void setListTriggers(List<Trigger> listTriggers) {
        this.listTriggers = listTriggers;
        this.activeTriggerCount = 0;
        for (int a = 0; a < listTriggers.size(); ++a) {
            if (!listTriggers.get(a).isActive()) continue;
            ++this.activeTriggerCount;
        }
    }

    public void readTriggerSettings() throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        String filename = "trigger.xml";
        TriggerXMLFileHandler handler = new TriggerXMLFileHandler();
        parser.parse(new File(filename), (DefaultHandler)handler);
    }

    public int getActiveTriggerCount() {
        return this.activeTriggerCount;
    }

    public boolean saveTriggerXMLFile() {
        try {
            FileWriter xmlfile = new FileWriter("trigger.xml");
            String line = "<?xml version='1.0' encoding='utf-8' standalone='yes'?>";
            xmlfile.write(line);
            line = "\n<settings>";
            xmlfile.write(line);
            for (int a = 0; a < this.listTriggers.size(); ++a) {
                line = "\n <trigger>";
                xmlfile.write(line);
                line = "\n  <description val='" + this.listTriggers.get(a).getTriggerDescription() + "'/>";
                xmlfile.write(line);
                line = "\n  <sequence val='" + this.listTriggers.get(a).getTriggerSequence() + "'/>";
                xmlfile.write(line);
                line = "\n  <type val='" + Integer.toString(this.listTriggers.get(a).getTriggerType()) + "'/>";
                xmlfile.write(line);
                if (this.listTriggers.get(a).getTriggerType() == 3) {
                    line = "\n  <forward val='" + Integer.toString(this.listTriggers.get(a).getForwardGrab()) + "'/>";
                    xmlfile.write(line);
                    line = "\n  <backward val='" + Integer.toString(this.listTriggers.get(a).getBackwardGrab()) + "'/>";
                    xmlfile.write(line);
                }
                line = "\n </trigger>";
                xmlfile.write(line);
            }
            line = "\n</settings>";
            xmlfile.write(line);
            xmlfile.flush();
            xmlfile.close();
        }
        catch (Exception e) {
            this.debugDump("Error writing Triger.xml :" + e.toString());
            return false;
        }
        return true;
    }

    public boolean changeMixer(String mixerName) {
        return this.inputThread.changeMixer(mixerName);
    }

    public boolean isPauseDisplay() {
        return this.pauseDisplay;
    }

    public void setPauseDisplay(boolean pauseDisplay) {
        this.pauseDisplay = pauseDisplay;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public int getCurrentHeight() {
        return Rivet.window.getBounds().height;
    }

    public void scrollDown(int v) {
        window.scrollDown(v - Rivet.window.getBounds().height + 200);
    }

    public boolean isAdjusting() {
        return window.isAdjusting();
    }

    public long getLastUserScroll() {
        return this.lastUserScroll;
    }

    public void setLastUserScroll(long lastUserScroll) {
        this.lastUserScroll = lastUserScroll;
    }

    public void displaySystemInfo() {
        this.clearScreen();
        this.writeLine("Rivet (Build 90)", Color.BLACK, Rivet.theApp.boldFont);
        String cores = "Available processors (cores): " + Runtime.getRuntime().availableProcessors();
        this.writeLine(cores, Color.BLACK, Rivet.theApp.boldFont);
        String jmem = "JVM Free memory (bytes): " + Runtime.getRuntime().freeMemory();
        this.writeLine(jmem, Color.BLACK, Rivet.theApp.boldFont);
        String os = "OS : " + System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")";
        this.writeLine(os, Color.BLACK, Rivet.theApp.boldFont);
        Toolkit theKit = window.getToolkit();
        Dimension wndsize = theKit.getScreenSize();
        String res = "Screen Resolution - Width " + Integer.toString(wndsize.width) + " : Height " + Integer.toString(wndsize.height);
        this.writeLine(res, Color.BLACK, Rivet.theApp.boldFont);
        String jver = "Java : " + System.getProperty("java.vendor") + " (" + System.getProperty("java.version") + ")";
        this.writeLine(jver, Color.BLACK, Rivet.theApp.boldFont);
        String folder = "Working directory : " + System.getProperty("user.dir");
        this.writeLine(folder, Color.BLACK, Rivet.theApp.boldFont);
        String time = "Current Time : " + this.getTimeStamp();
        this.writeLine(time, Color.BLACK, Rivet.theApp.boldFont);
        String contents = this.getAllText();
        window.setClipboard(contents);
    }

    public boolean isSmallScreen() {
        return this.smallScreen;
    }

    public void setSmallScreen(boolean smallScreen) {
        this.smallScreen = smallScreen;
    }

    public boolean isDisplayBadPackets() {
        return this.displayBadPackets;
    }

    public void setDisplayBadPackets(boolean displayBadPackets) {
        this.displayBadPackets = displayBadPackets;
    }

    public boolean isLogInUTC() {
        return this.logInUTC;
    }

    public void setLogInUTC(boolean logInUTC) {
        this.logInUTC = logInUTC;
    }

    public void clearLoggedShipsList() {
        this.listLoggedShips.clear();
    }

    public void logShip(String mmsi) {
        UserIdentifier uid = new UserIdentifier();
        for (int a = 0; a < this.listLoggedShips.size(); ++a) {
            if (!this.listLoggedShips.get(a).getMmsi().equals(mmsi)) continue;
            this.listLoggedShips.get(a).incrementLogCount();
            return;
        }
        Ship loggedShip = uid.getShipDetails(mmsi);
        if (loggedShip == null) {
            Ship newShip = new Ship();
            newShip.setMmsi(mmsi);
            newShip.incrementLogCount();
            this.listLoggedShips.add(newShip);
        } else {
            loggedShip.incrementLogCount();
            this.listLoggedShips.add(loggedShip);
        }
    }

    public String getShipList() {
        StringBuilder sb = new StringBuilder();
        if (this.listLoggedShips.isEmpty()) {
            return "\r\n\r\nNo ships were logged.";
        }
        if (this.listLoggedShips.size() == 1) {
            sb.append("\r\n\r\nYou logged one ship.");
        } else {
            sb.append("\r\n\r\nYou logged " + Integer.toString(this.listLoggedShips.size()) + " ships.");
        }
        for (int a = 0; a < this.listLoggedShips.size(); ++a) {
            sb.append("\r\nMMSI " + this.listLoggedShips.get(a).getMmsi());
            if (this.listLoggedShips.get(a).getName() != null) {
                sb.append(" " + this.listLoggedShips.get(a).getName() + " " + this.listLoggedShips.get(a).getFlag());
            }
            sb.append(" (" + Integer.toString(this.listLoggedShips.get(a).getLogCount()) + ")");
        }
        return sb.toString();
    }

    public class TriggerXMLFileHandler
    extends DefaultHandler {
        String value;
        String description;
        String sequence;
        int type;
        int backward;
        int forward;

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals("trigger")) {
                Trigger trigger = new Trigger();
                trigger.setTriggerDescription(this.description);
                trigger.setTriggerSequence(this.sequence);
                trigger.setTriggerType(this.type);
                if (this.type == 3) {
                    trigger.setForwardGrab(this.forward);
                    trigger.setBackwardGrab(this.backward);
                }
                Rivet.this.listTriggers.add(trigger);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String tval = new String(ch);
            this.value = tval.substring(start, start + length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes.getLength() > 0) {
                String aval = attributes.getValue(0);
                if (qName.equals("description")) {
                    this.description = aval;
                }
                if (qName.equals("sequence")) {
                    this.sequence = aval;
                }
                if (qName.equals("type")) {
                    this.type = Integer.parseInt(aval);
                }
                if (qName.equals("forward")) {
                    this.forward = Integer.parseInt(aval);
                }
                if (qName.equals("backward")) {
                    this.backward = Integer.parseInt(aval);
                }
            }
        }
    }

    public class DefaultXMLFileHandler
    extends DefaultHandler {
        String value;

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String tval = new String(ch);
            this.value = tval.substring(start, start + length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes.getLength() > 0) {
                String aval = attributes.getValue(0);
                if (qName.equals("debug")) {
                    if (aval.equals("TRUE")) {
                        Rivet.this.setDebug(true);
                    } else {
                        Rivet.this.setDebug(false);
                    }
                } else if (qName.equals("invert")) {
                    if (aval.equals("TRUE")) {
                        Rivet.this.setInvertSignal(true);
                    } else {
                        Rivet.this.setInvertSignal(false);
                    }
                } else if (qName.equals("mode")) {
                    Rivet.this.system = Integer.parseInt(aval);
                } else if (qName.equals("c36tone")) {
                    Rivet.this.crowd36Handler.setSyncHighTone(Integer.parseInt(aval));
                } else if (qName.equals("soundcard_level")) {
                    Rivet.this.soundCardInputLevel = Integer.parseInt(aval);
                    if (Rivet.this.soundCardInputLevel < -10) {
                        Rivet.this.soundCardInputLevel = -10;
                    } else if (Rivet.this.soundCardInputLevel > 10) {
                        Rivet.this.soundCardInputLevel = 10;
                    }
                } else if (qName.equals("soundcard_input")) {
                    if (Integer.parseInt(aval) == 1) {
                        Rivet.this.soundCardInputTemp = true;
                    } else {
                        Rivet.this.soundCardInputTemp = false;
                    }
                } else if (qName.equals("view_gw_markers")) {
                    if (Integer.parseInt(aval) == 1) {
                        Rivet.this.viewGWChannelMarkers = true;
                    } else {
                        Rivet.this.viewGWChannelMarkers = false;
                    }
                } else if (qName.equals("rttybaud")) {
                    Rivet.this.rttyHandler.setBaudRate(Double.parseDouble(aval));
                    Rivet.this.fskHandler.setBaudRate(Double.parseDouble(aval));
                } else if (qName.equals("rttyshift")) {
                    Rivet.this.rttyHandler.setShift(Integer.parseInt(aval));
                    Rivet.this.fskHandler.setShift(Integer.parseInt(aval));
                } else if (qName.equals("rttystop")) {
                    Rivet.this.rttyHandler.setStopBits(Double.parseDouble(aval));
                } else if (qName.equals("audioDevice")) {
                    if (!Rivet.this.inputThread.changeMixer(aval)) {
                        JOptionPane.showMessageDialog(null, "Read XML Error changing mixer\n" + Rivet.this.inputThread.getMixerErrorMessage() + "\n" + aval, "Rivet", 0);
                    }
                } else if (qName.equals("display_bad_packets")) {
                    if (Integer.parseInt(aval) == 1) {
                        Rivet.this.displayBadPackets = true;
                    } else {
                        Rivet.this.displayBadPackets = false;
                    }
                } else if (qName.equals("UTC")) {
                    if (Integer.parseInt(aval) == 1) {
                        Rivet.this.logInUTC = true;
                    } else {
                        Rivet.this.logInUTC = false;
                    }
                } else if (qName.equals("cis3650shift")) {
                    Rivet.this.cis3650Handler.setShift(Integer.parseInt(aval));
                }
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }
    }
}

