/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import org.e2k.CircularBitSet;

public class Trigger {
    private String triggerSequence;
    private String triggerDescription;
    private int triggerType = -1;
    private boolean active = false;
    private int forwardGrab = 0;
    private int backwardGrab = 0;

    public String getTriggerSequence() {
        return this.triggerSequence;
    }

    public void setTriggerSequence(String triggerSequence) {
        this.triggerSequence = triggerSequence;
    }

    public String getTriggerDescription() {
        return this.triggerDescription;
    }

    public void setTriggerDescription(String triggerDescription) {
        this.triggerDescription = triggerDescription;
    }

    public int getTriggerType() {
        return this.triggerType;
    }

    public void setTriggerType(int triggerType) {
        this.triggerType = triggerType;
    }

    public boolean triggerMatch(CircularBitSet cBitSet) {
        if (!this.active) {
            return false;
        }
        String cur = cBitSet.extractSequence(this.triggerSequence.length());
        return this.triggerSequence.equals(cur);
    }

    public String getBackwardBitsString(CircularBitSet cBitSet) {
        String cur = cBitSet.extractSequence(this.triggerSequence.length() + this.backwardGrab);
        return cur.substring(0, this.backwardGrab);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getTypeDescription() {
        if (this.triggerType == 1) {
            return " (START)";
        }
        if (this.triggerType == 2) {
            return " (END)";
        }
        if (this.triggerType == 3) {
            return " (GRAB)";
        }
        return " (UNKNOWN)";
    }

    public int getForwardGrab() {
        return this.forwardGrab;
    }

    public void setForwardGrab(int forwardGrab) {
        this.forwardGrab = forwardGrab;
    }

    public int getBackwardGrab() {
        return this.backwardGrab;
    }

    public void setBackwardGrab(int backwardGrab) {
        this.backwardGrab = backwardGrab;
    }
}

