/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.e2k.Rivet;
import org.e2k.Trigger;
import org.e2k.TriggerModifyAddEdit;

public class TriggerModify
extends JDialog
implements ActionListener {
    public static final long serialVersionUID = 1L;
    private Rivet TtheApp;
    private List<Trigger> triggerList = new ArrayList<Trigger>();
    private JComboBox<String> triggerComboList = new JComboBox();
    private JButton addTriggerButton = new JButton("Add a new Trigger");
    private JButton deleteTriggerButton = new JButton("Delete the selected Trigger");
    private JButton editTriggerButton = new JButton("Edit the selected Trigger");
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private boolean changedTriggers = false;

    public TriggerModify(JFrame mf, Rivet theApp) {
        super(mf, "Modify Triggers", true);
        this.TtheApp = theApp;
        this.setSize(250, 300);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        this.setLayout(new GridLayout(9, 1));
        this.triggerList = this.TtheApp.getListTriggers();
        JLabel labelCombo = new JLabel("Trigger Select : ");
        this.add(labelCombo);
        this.populateTriggerCombo();
        this.add(this.triggerComboList);
        this.add(new JLabel(""));
        this.add(this.addTriggerButton);
        this.addTriggerButton.addActionListener(this);
        this.add(this.deleteTriggerButton);
        this.deleteTriggerButton.addActionListener(this);
        this.add(this.editTriggerButton);
        this.editTriggerButton.addActionListener(this);
        this.add(new JLabel(""));
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.setVisible(true);
    }

    private void populateTriggerCombo() {
        if (this.triggerList != null) {
            for (int a = 0; a < this.triggerList.size(); ++a) {
                this.triggerComboList.addItem(this.triggerList.get(a).getTriggerDescription());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        TriggerModifyAddEdit triggerMod;
        String eventName = event.getActionCommand();
        if (eventName.equals("OK")) {
            this.TtheApp.setListTriggers(this.triggerList);
            this.changedTriggers = true;
            this.dispose();
        } else if (eventName.equals("Cancel")) {
            this.changedTriggers = false;
            this.dispose();
        } else if (eventName.equals("Delete the selected Trigger")) {
            this.deleteTrigger();
        } else if (eventName.equals("Edit the selected Trigger")) {
            String selectedTriggerName = (String)this.triggerComboList.getSelectedItem();
            int index = this.getTriggerIndex(selectedTriggerName);
            if (index == -1) {
                JOptionPane.showMessageDialog(null, "Please select the Trigger you wish to edit.", "Rivet", 0);
                return;
            }
            TriggerModifyAddEdit triggerMod2 = new TriggerModifyAddEdit(this, this.triggerList.get(index));
            if (triggerMod2.isChangedTriggers()) {
                this.triggerList.remove(index);
                this.triggerList.add(triggerMod2.exposeTrigger());
                this.changesMade();
            }
        } else if (eventName.equals("Add a new Trigger") && (triggerMod = new TriggerModifyAddEdit(this, null)).isChangedTriggers()) {
            this.triggerList.add(triggerMod.exposeTrigger());
            this.changesMade();
        }
    }

    private void deleteTrigger() {
        String selectedTriggerName = (String)this.triggerComboList.getSelectedItem();
        int index = this.getTriggerIndex(selectedTriggerName);
        if (index == -1) {
            JOptionPane.showMessageDialog(null, "Please select the Trigger you wish to delete.", "Rivet", 0);
            return;
        }
        String chkMsg = "Are you sure you wish to delete the trigger : " + selectedTriggerName;
        if (JOptionPane.showConfirmDialog(this, chkMsg, "Rivet", 0) == 0) {
            this.triggerList.remove(index);
            this.changesMade();
        }
    }

    public boolean isChangedTriggers() {
        return this.changedTriggers;
    }

    private void changesMade() {
        this.changedTriggers = true;
        this.triggerComboList.removeAllItems();
        this.populateTriggerCombo();
    }

    private int getTriggerIndex(String tName) {
        for (int a = 0; a < this.triggerList.size(); ++a) {
            if (!this.triggerList.get(a).getTriggerDescription().equals(tName)) continue;
            return a;
        }
        return -1;
    }
}

