/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.e2k.Trigger;

public class TriggerModifyAddEdit
extends JDialog
implements ActionListener {
    public static final long serialVersionUID = 1L;
    private Trigger trigger;
    private JTextField descriptionField;
    private JTextField sequenceField;
    private JTextField forwardGrabField;
    private JTextField backwardGrabField;
    private JComboBox<String> triggerTypeCombo = new JComboBox();
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private boolean changedTriggers = false;

    public TriggerModifyAddEdit(JDialog mf, Trigger Ttrigger) {
        super(mf, "Add or Edit Trigger", true);
        this.setSize(650, 200);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        this.setLayout(new GridLayout(6, 2));
        JLabel labelDescription = new JLabel("Trigger Description : ");
        labelDescription.setHorizontalAlignment(0);
        this.add(labelDescription);
        this.descriptionField = new JTextField(50);
        this.add(this.descriptionField);
        JLabel labelCombo = new JLabel("Trigger Type : ");
        labelCombo.setHorizontalAlignment(0);
        this.add(labelCombo);
        this.triggerTypeCombo.addItem("Start");
        this.triggerTypeCombo.addItem("End");
        this.triggerTypeCombo.addItem("Grab");
        this.triggerTypeCombo.addActionListener(this);
        this.add(this.triggerTypeCombo);
        JLabel sequenceDescription = new JLabel("Trigger Sequence : ");
        sequenceDescription.setHorizontalAlignment(0);
        this.add(sequenceDescription);
        this.sequenceField = new JTextField(150);
        this.add(this.sequenceField);
        JLabel forwardGrabDescription = new JLabel("Forward Grab (bits) : ");
        forwardGrabDescription.setHorizontalAlignment(0);
        this.add(forwardGrabDescription);
        this.forwardGrabField = new JTextField(3);
        this.add(this.forwardGrabField);
        JLabel backwardGrabDescription = new JLabel("Backward Grab (bits) : ");
        backwardGrabDescription.setHorizontalAlignment(0);
        this.add(backwardGrabDescription);
        this.backwardGrabField = new JTextField(3);
        this.add(this.backwardGrabField);
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        if (Ttrigger != null) {
            this.trigger = Ttrigger;
            this.descriptionField.setText(this.trigger.getTriggerDescription());
            this.triggerTypeCombo.setSelectedIndex(this.trigger.getTriggerType() - 1);
            this.sequenceField.setText(this.trigger.getTriggerSequence());
            this.forwardGrabField.setText(Integer.toString(this.trigger.getForwardGrab()));
            this.backwardGrabField.setText(Integer.toString(this.trigger.getBackwardGrab()));
        } else {
            this.trigger = new Trigger();
            this.descriptionField.setText("Trigger Name");
            this.forwardGrabField.setText("0");
            this.backwardGrabField.setText("0");
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String eventName = event.getActionCommand();
        if (eventName.equals("Cancel")) {
            this.changedTriggers = false;
            this.dispose();
        }
        if (eventName.equals("OK") && this.checkTrigger()) {
            this.changedTriggers = true;
            this.dispose();
        }
    }

    public boolean isChangedTriggers() {
        return this.changedTriggers;
    }

    boolean checkTrigger() {
        int forwardGrab = 0;
        int backwardGrab = 0;
        String description = this.descriptionField.getText();
        if (description == null || description.length() < 1) {
            JOptionPane.showMessageDialog(null, "You must enter a description for a trigger", "Rivet", 1);
            return false;
        }
        String sequence = this.sequenceField.getText();
        if (sequence == null || sequence.length() < 4) {
            JOptionPane.showMessageDialog(null, "You must enter a binary sequence of 3 or more bits for a valid trigger", "Rivet", 1);
            return false;
        }
        int triggerType = this.triggerTypeCombo.getSelectedIndex() + 1;
        if (triggerType == 3) {
            String forward = this.forwardGrabField.getText();
            try {
                forwardGrab = Integer.parseInt(forward);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "A Grab Trigger must have a numeric forward grab value", "Rivet", 1);
                return false;
            }
            if (forwardGrab < 0) {
                JOptionPane.showMessageDialog(null, "A Grab Trigger must not contain a negative numeric forward grab value", "Rivet", 1);
                return false;
            }
            String backward = this.backwardGrabField.getText();
            try {
                backwardGrab = Integer.parseInt(backward);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "A Grab Trigger must have a numeric backward grab value", "Rivet", 1);
                return false;
            }
            if (backwardGrab < 0) {
                JOptionPane.showMessageDialog(null, "A Grab Trigger must not contain a negative numeric backward grab value", "Rivet", 1);
                return false;
            }
        }
        this.trigger.setTriggerDescription(description);
        this.trigger.setTriggerSequence(sequence);
        this.trigger.setTriggerType(triggerType);
        this.trigger.setForwardGrab(forwardGrab);
        this.trigger.setBackwardGrab(backwardGrab);
        return true;
    }

    public Trigger exposeTrigger() {
        return this.trigger;
    }
}

