/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.e2k.Ship;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UserIdentifier {
    private String errorMessage = null;

    public Ship getShipDetails(String mmsi) {
        try {
            Ship xship = this.getShipFromXML(mmsi);
            if (xship != null) {
                return xship;
            }
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return null;
        }
        return null;
    }

    private Ship getShipFromXML(String Tmmsi) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        String filename = "ships.xml";
        ShipsXMLFileHandler handler = new ShipsXMLFileHandler();
        handler.setSearchMMSI(Tmmsi);
        parser.parse(new File(filename), (DefaultHandler)handler);
        return handler.getShip();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public class ShipsXMLFileHandler
    extends DefaultHandler {
        String value;
        String mmsi;
        String name;
        String flag;
        String searchMMSI;
        Ship foundShip = null;

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals("ship") && this.mmsi.equals(this.searchMMSI)) {
                Ship ship = new Ship();
                ship.setMmsi(this.mmsi);
                ship.setName(this.name);
                ship.setFlag(this.flag);
                this.foundShip = ship;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String tval = new String(ch);
            this.value = tval.substring(start, start + length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes.getLength() > 0) {
                String aval = attributes.getValue(0);
                if (qName.equals("mmsi")) {
                    this.mmsi = aval;
                }
                if (qName.equals("name")) {
                    this.name = aval;
                }
                if (qName.equals("flag")) {
                    this.flag = aval;
                }
            }
        }

        public void setSearchMMSI(String ms) {
            this.searchMMSI = ms;
        }

        public Ship getShip() {
            return this.foundShip;
        }
    }
}

