/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.e2k.CircularDataBuffer;
import org.e2k.MFSK;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class XPA
extends MFSK {
    private int baudRate = 10;
    private int state = 0;
    private double samplesPerSymbol;
    private Rivet theApp;
    private long sampleCount = 0L;
    private long symbolCounter = 0L;
    private String previousCharacter;
    private int groupCount = 0;
    private StringBuilder lineBuffer = new StringBuilder();
    private CircularDataBuffer energyBuffer = new CircularDataBuffer();
    private long syncFoundPoint;
    private int correctionFactor;

    public XPA(Rivet tapp, int baud) {
        this.baudRate = baud;
        this.theApp = tapp;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 1) {
            this.theApp.setStatusLabel("Start Tone Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Sync Hunt");
        } else if (state == 3) {
            this.theApp.setStatusLabel("Sync Found");
        } else if (state == 4) {
            this.theApp.setStatusLabel("Decoding");
        } else if (state == 5) {
            this.theApp.setStatusLabel("Complete");
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        String dout;
        if (this.state == 0) {
            if (waveData.getSampleRate() > 11025.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nXPA recordings must have\nbeen recorded at a sample rate\nof 11.025 KHz or less.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.samplesPerSymbol = this.samplesPerSymbol(this.baudRate, waveData.getSampleRate());
            this.setState(1);
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.correctionFactor = 0;
            this.previousCharacter = null;
            this.energyBuffer.setBufferCounter(0);
            return true;
        }
        if (this.state == 1 && (dout = this.sampleCount >= 0L && this.sampleCount % 100L == 0L ? this.startToneHunt(circBuf, waveData) : null) != null) {
            this.setState(2);
            this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
            return true;
        }
        if (this.state == 2) {
            int ERRORALLOWANCE = 40;
            if (this.sampleCount % 100L > 0L) {
                ++this.sampleCount;
                ++this.symbolCounter;
                return true;
            }
            int lfft = this.symbolFreq(circBuf, waveData, 0, this.samplesPerSymbol);
            if (!this.toneTest(lfft += this.correctionFactor, 1120, 40)) {
                ++this.sampleCount;
                ++this.symbolCounter;
                return true;
            }
            int lfft2 = this.symbolFreq(circBuf, waveData, (int)this.samplesPerSymbol, this.samplesPerSymbol * 2.0);
            if (!this.toneTest(lfft2 += this.correctionFactor, 1120, 40)) {
                ++this.sampleCount;
                ++this.symbolCounter;
                return true;
            }
            this.setState(3);
            this.syncFoundPoint = this.sampleCount;
            this.theApp.writeLine(this.theApp.getTimeStamp() + " High sync tone found", Color.BLACK, this.theApp.italicFont);
            return true;
        }
        if (this.state == 3) {
            this.do8FFT(circBuf, waveData, 0);
            this.energyBuffer.addToCircBuffer((int)this.getTotalEnergy());
            ++this.sampleCount;
            ++this.symbolCounter;
            if (this.energyBuffer.getBufferCounter() < (int)(this.samplesPerSymbol * 3.0)) {
                return true;
            }
            long perfectPoint = (long)this.energyBuffer.returnHighestBin() + this.syncFoundPoint;
            this.symbolCounter -= perfectPoint;
            this.setState(4);
            this.theApp.writeLine(this.theApp.getTimeStamp() + " Symbol timing found", Color.BLACK, this.theApp.italicFont);
            return true;
        }
        if (this.state == 4 && this.symbolCounter >= (long)this.samplesPerSymbol) {
            this.symbolCounter = 0L;
            int freq = this.symbolFreq(circBuf, waveData, 0, this.samplesPerSymbol);
            this.displayMessage(freq += this.correctionFactor, waveData.isFromFile());
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    private String startToneHunt(CircularDataBuffer circBuf, WaveData waveData) {
        int tone2;
        int HighTONE = 1280;
        int LowTONE = 520;
        int toneDIFFERENCE = 760;
        int ErrorALLOWANCE = 40;
        int tone1 = this.do1024FFT(circBuf, waveData, 0);
        if (tone1 != (tone2 = this.do1024FFT(circBuf, waveData, (int)this.samplesPerSymbol * 1))) {
            return null;
        }
        int tone3 = this.do1024FFT(circBuf, waveData, (int)this.samplesPerSymbol * 2);
        if (tone1 > tone3) {
            return null;
        }
        int tone4 = this.do1024FFT(circBuf, waveData, (int)this.samplesPerSymbol * 3);
        if (tone1 != tone2 || tone3 != tone4) {
            return null;
        }
        if (tone2 == tone3) {
            return null;
        }
        int difference = tone3 - tone1;
        if (difference < 720 || difference > 800) {
            return null;
        }
        this.correctionFactor = 520 - tone1;
        String line = this.theApp.getTimeStamp() + " XPA Start Tones Found (correcting by " + Integer.toString(this.correctionFactor) + " Hz)";
        return line;
    }

    private String getChar(int tone, String prevChar) {
        int errorAllowance = 20;
        if (tone > 500 && tone < 540) {
            return "Start Low";
        }
        if (tone >= 580 && tone < 620) {
            return "Sync Low";
        }
        if (tone >= 660 && tone < 700) {
            return " ";
        }
        if (tone >= 700 && tone < 740) {
            return "End Tone";
        }
        if (tone >= 740 && tone < 780) {
            return "0";
        }
        if (tone >= 780 && tone < 820) {
            return "1";
        }
        if (tone >= 820 && tone < 860) {
            return "2";
        }
        if (tone >= 860 && tone < 900) {
            return "3";
        }
        if (tone >= 900 && tone < 940) {
            return "4";
        }
        if (tone >= 940 && tone < 980) {
            return "5";
        }
        if (tone >= 980 && tone < 1020) {
            return "6";
        }
        if (tone >= 1020 && tone < 1060) {
            return "7";
        }
        if (tone >= 1060 && tone < 1100) {
            return "8";
        }
        if (tone >= 1100 && tone < 1140) {
            if (prevChar == "Sync Low") {
                return "Sync High";
            }
            return "9";
        }
        if (tone >= 1140 && tone < 1180) {
            return "Message Start";
        }
        if (tone >= 1180 && tone < 1220) {
            return "R";
        }
        if (tone >= 1260 && tone < 1300) {
            return "Start High";
        }
        return "UNID";
    }

    private void displayMessage(int freq, boolean isFile) {
        String tChar = this.getChar(freq, this.previousCharacter);
        int tlength = 0;
        int llength = 0;
        if (tChar == "R" && this.previousCharacter == "End Tone") {
            this.theApp.writeLine(this.theApp.getTimeStamp() + " XPA Decode Complete", Color.BLACK, this.theApp.italicFont);
            this.lineBuffer.delete(0, this.lineBuffer.length());
            if (isFile) {
                this.setState(5);
            } else {
                this.setState(0);
            }
            return;
        }
        if (tChar == "R") {
            tChar = this.previousCharacter;
        }
        if (tChar == "Message Start" && this.previousCharacter == "Message Start") {
            this.previousCharacter = tChar;
            return;
        }
        if (tChar == " " && this.previousCharacter == " ") {
            this.previousCharacter = tChar;
            return;
        }
        if (tChar == " " && this.lineBuffer.length() == 0) {
            this.previousCharacter = tChar;
            return;
        }
        if (tChar != "Sync High" && tChar != "Sync Low" && tChar != "Start High" && tChar != "Start Low") {
            tlength = tChar.length();
            this.lineBuffer.append(tChar);
            llength = this.lineBuffer.length();
        }
        this.previousCharacter = tChar;
        if (tChar == "Message Start") {
            this.groupCount = 0;
            this.lineBuffer.delete(llength - tlength, llength);
            this.theApp.writeLine(this.lineBuffer.toString(), Color.BLACK, this.theApp.boldFont);
            this.theApp.writeLine("Message Start", Color.BLACK, this.theApp.boldFont);
            this.lineBuffer.delete(0, this.lineBuffer.length());
            return;
        }
        if (tChar == "End Tone") {
            this.groupCount = 0;
            this.lineBuffer.delete(llength - tlength, llength);
            this.theApp.writeLine(this.lineBuffer.toString(), Color.BLACK, this.theApp.boldFont);
            this.lineBuffer.delete(0, this.lineBuffer.length());
            this.setState(1);
            return;
        }
        String blockSync = "6666622662626";
        if (this.lineBuffer.indexOf("6666622662626") != -1) {
            this.groupCount = 0;
            tlength = "6666622662626".length();
            this.lineBuffer.delete(llength - tlength, llength);
            if (this.lineBuffer.length() > 0) {
                this.theApp.writeLine(this.lineBuffer.toString(), Color.BLACK, this.theApp.boldFont);
            }
            this.theApp.writeLine("Block Sync", Color.BLACK, this.theApp.boldFont);
            this.lineBuffer.delete(0, this.lineBuffer.length());
            return;
        }
        String sbreak = "4444444444";
        if (this.lineBuffer.indexOf("4444444444") != -1) {
            this.groupCount = 0;
            tlength = "4444444444".length();
            this.lineBuffer.delete(llength - tlength, llength);
            if (this.lineBuffer.length() > 0) {
                this.theApp.writeLine(this.lineBuffer.toString(), Color.BLACK, this.theApp.boldFont);
            }
            this.theApp.writeLine("4444444444", Color.BLACK, this.theApp.boldFont);
            this.lineBuffer.delete(0, this.lineBuffer.length());
            return;
        }
        if (this.lineBuffer.indexOf("UNID") != -1) {
            this.groupCount = 0;
            this.lineBuffer.delete(llength - tlength, llength);
            this.theApp.writeLine(this.lineBuffer.toString(), Color.BLACK, this.theApp.boldFont);
            this.theApp.writeLine("UNID " + freq + " Hz", Color.BLACK, this.theApp.boldFont);
            this.lineBuffer.delete(0, this.lineBuffer.length());
            return;
        }
        if (tChar == " ") {
            ++this.groupCount;
        }
        if (this.groupCount == 15) {
            this.groupCount = 0;
            this.theApp.writeLine(this.lineBuffer.toString(), Color.BLACK, this.theApp.boldFont);
            this.lineBuffer.delete(0, this.lineBuffer.length());
            return;
        }
    }
}

