/*
 * Decompiled with CFR 0.152.
 */
package org.e2k;

import java.awt.Color;
import javax.swing.JOptionPane;
import org.e2k.CircularDataBuffer;
import org.e2k.MFSK;
import org.e2k.Rivet;
import org.e2k.WaveData;

public class XPA2
extends MFSK {
    private final double BAUDRATE = 7.8125;
    private int state = 0;
    private double samplesPerSymbol;
    private Rivet theApp;
    private long sampleCount = 0L;
    private long symbolCounter = 0L;
    private long syncFoundPoint;
    private String previousCharacter;
    private int groupCount = 0;
    private CircularDataBuffer energyBuffer = new CircularDataBuffer();
    private int correctionFactor;
    private final int PIVOT = 5000;
    private int characterCount;

    public XPA2(Rivet tapp) {
        this.theApp = tapp;
    }

    public void setState(int state) {
        this.state = state;
        if (state == 1) {
            this.theApp.setStatusLabel("Start Tone Hunt");
        } else if (state == 2) {
            this.theApp.setStatusLabel("Sync Hunt");
        } else if (state == 3) {
            this.theApp.setStatusLabel("Sync Found");
        } else if (state == 4) {
            this.theApp.setStatusLabel("Decoding");
        } else if (state == 5) {
            this.theApp.setStatusLabel("Complete");
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean decode(CircularDataBuffer circBuf, WaveData waveData) {
        String dout;
        if (this.state == 0) {
            if (waveData.getSampleRate() > 11025.0) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "WAV files containing\nXPA2 recordings must have\nbeen recorded at a sample rate\nof 11.025 KHz or less.", "Rivet", 1);
                return false;
            }
            if (waveData.getChannels() != 1) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\nmono WAV files.", "Rivet", 1);
                return false;
            }
            if (waveData.getSampleSizeInBits() != 16) {
                this.state = -1;
                JOptionPane.showMessageDialog(null, "Rivet can only process\n16 bit WAV files.", "Rivet", 1);
                return false;
            }
            this.samplesPerSymbol = this.samplesPerSymbol(7.8125, waveData.getSampleRate());
            this.sampleCount = 0 - circBuf.retMax();
            this.symbolCounter = 0L;
            this.correctionFactor = 0;
            this.previousCharacter = null;
            this.theApp.setInvertSignal(false);
            this.energyBuffer.setBufferCounter(0);
            this.setState(1);
            this.characterCount = 0;
            return true;
        }
        if (this.state == 1 && (dout = this.sampleCount >= 0L && this.sampleCount % 200L == 0L ? this.startToneHunt(circBuf, waveData) : null) != null) {
            this.setState(2);
            this.theApp.writeLine(dout, Color.BLACK, this.theApp.italicFont);
            return true;
        }
        if (this.state == 2) {
            int SYNCLOW = 1037;
            int ERRORALLOWANCE = 30;
            if (this.sampleCount % 200L > 0L) {
                ++this.sampleCount;
                ++this.symbolCounter;
                return true;
            }
            int freq = this.xpa2Freq(circBuf, waveData, 0);
            if (!this.toneTest(freq, 1037, 30)) {
                ++this.sampleCount;
                ++this.symbolCounter;
                return true;
            }
            int freq2 = this.xpa2Freq(circBuf, waveData, (int)this.samplesPerSymbol);
            if (!this.toneTest(freq2, 1037, 30)) {
                ++this.sampleCount;
                ++this.symbolCounter;
                return true;
            }
            this.setState(3);
            this.syncFoundPoint = this.symbolCounter;
            this.theApp.setStatusLabel("Sync Found");
            this.theApp.writeLine(this.theApp.getTimeStamp() + " Sync tone found", Color.BLACK, this.theApp.italicFont);
        }
        if (this.state == 3) {
            boolean lookAHEAD = true;
            if (waveData.getSampleRate() == 11025.0) {
                this.do128FFT(circBuf, waveData, 0);
            } else if (waveData.getSampleRate() == 8000.0) {
                this.do8FFT(circBuf, waveData, 0);
            }
            this.energyBuffer.addToCircBuffer((int)this.getTotalEnergy());
            ++this.sampleCount;
            ++this.symbolCounter;
            if (this.energyBuffer.getBufferCounter() < (int)(this.samplesPerSymbol * 1.0)) {
                return true;
            }
            long perfectPoint = (long)this.energyBuffer.returnLowestBin() + this.syncFoundPoint + (long)((int)this.samplesPerSymbol);
            this.symbolCounter = (long)((int)this.samplesPerSymbol) - (perfectPoint - this.sampleCount);
            this.setState(4);
            this.theApp.setStatusLabel("Symbol Timing Achieved");
            this.theApp.writeLine(this.theApp.getTimeStamp() + " Symbol timing found", Color.BLACK, this.theApp.italicFont);
            this.theApp.newLineWrite();
            return true;
        }
        if (this.state == 4 && this.symbolCounter >= (long)((int)this.samplesPerSymbol)) {
            this.symbolCounter = 0L;
            int freq = this.xpa2Freq(circBuf, waveData, 0);
            this.displayMessage(freq);
        }
        ++this.sampleCount;
        ++this.symbolCounter;
        return true;
    }

    private String getChar(int tone, String prevChar) {
        int errorAllowance = 9;
        if (tone >= 969 && tone < 987) {
            return " ";
        }
        if (tone >= 1001 && tone < 1019) {
            return "Sync Low";
        }
        if (tone >= 1017 && tone < 1035) {
            return "End Tone";
        }
        if (tone >= 1032 && tone < 1066) {
            if (prevChar == "Sync Low") {
                return "Sync High";
            }
            return "R";
        }
        if (tone >= 1064 && tone < 1082) {
            return "0";
        }
        if (tone >= 1079 && tone < 1097) {
            return "1";
        }
        if (tone >= 1095 && tone < 1113) {
            return "2";
        }
        if (tone >= 1110 && tone < 1128) {
            return "3";
        }
        if (tone >= 1125 && tone < 1143) {
            return "4";
        }
        if (tone >= 1142 && tone < 1160) {
            return "5";
        }
        if (tone >= 1158 && tone < 1176) {
            return "6";
        }
        if (tone >= 1173 && tone < 1191) {
            return "7";
        }
        if (tone >= 1188 && tone < 1206) {
            return "8";
        }
        if (tone >= 1203 && tone < 1221) {
            return "9";
        }
        return "UNID";
    }

    private void displayMessage(int freq) {
        String tChar = this.getChar(freq, this.previousCharacter);
        if (tChar == "R" && this.previousCharacter == "End Tone") {
            this.theApp.writeLine(this.theApp.getTimeStamp() + " XPA2 Decode Complete", Color.BLACK, this.theApp.italicFont);
            this.setState(1);
            return;
        }
        if (tChar == "R") {
            tChar = this.previousCharacter == null ? "" : this.previousCharacter;
        }
        if (tChar == "Message Start" && this.previousCharacter == "Message Start") {
            this.previousCharacter = tChar;
            return;
        }
        if (tChar == " " && this.previousCharacter == " ") {
            this.previousCharacter = tChar;
            return;
        }
        if (tChar == " " && this.characterCount == 0) {
            this.previousCharacter = tChar;
            return;
        }
        if (tChar != "Sync High" && tChar != "Sync Low" && tChar != "End Tone" && tChar != "UNID" && tChar != "") {
            this.theApp.writeChar(tChar, Color.BLACK, this.theApp.boldFont);
            ++this.characterCount;
        }
        this.previousCharacter = tChar;
        if (tChar == "End Tone") {
            this.groupCount = 0;
            this.theApp.writeLine("End Tone", Color.BLACK, this.theApp.boldFont);
            return;
        }
        if (tChar == "UNID") {
            this.groupCount = 0;
            this.theApp.writeLine("UNID " + freq + " Hz", Color.BLACK, this.theApp.boldFont);
            this.theApp.newLineWrite();
            return;
        }
        if (tChar == " ") {
            ++this.groupCount;
        }
        if (this.groupCount == 15) {
            this.groupCount = 0;
            this.characterCount = 0;
            this.theApp.newLineWrite();
            return;
        }
    }

    private String startToneHunt(CircularDataBuffer circBuf, WaveData waveData) {
        int tone2;
        int HighTONE = 1212;
        int LowTONE = 978;
        int toneDIFFERENCE = 234;
        int ErrorALLOWANCE = 40;
        int tone1 = this.xpa2Freq(circBuf, waveData, 0);
        if (tone1 != (tone2 = this.xpa2Freq(circBuf, waveData, (int)this.samplesPerSymbol * 1))) {
            return null;
        }
        int tone3 = this.xpa2Freq(circBuf, waveData, (int)this.samplesPerSymbol * 2);
        if (tone1 > tone3) {
            return null;
        }
        int tone4 = this.xpa2Freq(circBuf, waveData, (int)this.samplesPerSymbol * 3);
        if (tone1 != tone2 || tone3 != tone4) {
            return null;
        }
        if (tone2 == tone3) {
            return null;
        }
        int difference = tone3 - tone1;
        if (difference < 194 || difference > 274) {
            return null;
        }
        int toneAhead = this.xpa2Freq(circBuf, waveData, (int)this.samplesPerSymbol * 6);
        if (toneAhead == tone3) {
            this.theApp.setInvertSignal(true);
            tone3 = 5000 - tone3;
            this.correctionFactor = 978 - tone3;
        } else {
            this.theApp.setInvertSignal(false);
            this.correctionFactor = 978 - tone1;
        }
        String line = this.theApp.getTimeStamp() + " XPA2 Start Tones Found (correcting by " + Integer.toString(this.correctionFactor) + " Hz)";
        return line;
    }

    private int xpa2Freq(CircularDataBuffer circBuf, WaveData waveData, int pos) {
        if (waveData.getSampleRate() == 8000.0) {
            int freq = this.symbolFreq(circBuf, waveData, pos, this.samplesPerSymbol);
            freq = !this.theApp.isInvertSignal() ? (freq += this.correctionFactor) : 5000 - freq + this.correctionFactor;
            return freq;
        }
        if (waveData.getSampleRate() == 11025.0) {
            int freq = this.symbolFreq(circBuf, waveData, pos, this.samplesPerSymbol);
            freq = !this.theApp.isInvertSignal() ? (freq += this.correctionFactor) : 5000 - freq + this.correctionFactor;
            return freq;
        }
        return -1;
    }
}

