#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <math.h>

/* Purpose of program: receive messages using the Motorola MDC4800    */
/* protocol and show them on the screen                               */
/*                                                                    */
/* WARNING TO ALL : This program is free. Please distribute and modify*/
/* this program. I only request that you always include the source    */
/* code so that others may also learn and add improvements. The       */
/* status of this program at the time of the original release is :    */
/* it doesn't have much in the way of a user interface or options but */
/* it should work if you follow the procedure in the text file. Don't */
/* expect any sort of support (you get what you pay for - nothing in  */
/* this case). Finally, here's a special message to all of you who    */
/* might have the urge to try to make money with this information:    */
/* I know where you live. I will shave your pets and pour rubbing     */
/* alcohol all over them (unless said pet happens to be a Rottweiler).*/
/* I will have sex with your wife while you off at work; on the rare  */
/* occasions when you have sex with your wife she will in the throes  */
/* of passion cry not your name but mine. I will sell drugs to the    */
/* demented spawn you refer to as your children. And if that's not    */
/* enough for you let a thousand lawyers from motorola descend on you */
/* and pound your fat rear end so far into the ground that it finally */
/* sees daylight again somewhere in Australia.                        */
/*                                                                    */
/*                                                                    */
/* General tidbits (a few of those "Why were things done this way     */
/* questions).                                                        */
/* 1. Why is captured data kept in an array and only written to a     */
/* disk file at the very end? Because disk access seems unreliable    */
/* when so much time is taken up by the background interrupt service  */
/* routine.                                                           */
/* 2. Why is the array storing this so small? Because yours truly was */
/* too damn lazy to use a pointer and allocate a huge chunk of memory.*/
/* (Hint for those of you who would like to improve this.             */
/*--------------------------------------------------------------------*/

/* global variables */
int lc=0;
char fob[30000];/* output buffer for captured data to be sent to disk */
int foblen=29900;
int fobp=0;	/* pointer to current position in array fob	      */
char ob[1000];  /* output buffer for packet before being sent to screen */
int obp=0;	/* pointer to current position in array ob		*/

static unsigned int buflen= 15000;      /* length of data buffer      */
static volatile unsigned int cpstn = 0; /* current position in buffer */
static unsigned int fdata[15001] ;      /* frequency data array       */

void interrupt (*oldfuncc) (); /* vector to old com port interrupt    */

/**********************************************************************/
/*                                this is serial com port interrupt   */
/* we assume here that it only gets called when one of the status     */
/* lines on the serial port changes (that's all you have hooked up).  */
/* All this handler does is read the system timer (which increments   */
/* every 840 nanoseconds) and stores it in the fdata array. The MSB   */
/* is set to indicate whether the status line is zero. In this way    */
/* the fdata array is continuously updated with the appropriate the   */
/* length and polarity of each data pulse for further processing by   */
/* the main program.						      */
void interrupt com1int()
{
  static unsigned int d1,d2,ltick,tick,dtick;

  /* the system timer is a 16 bit counter whose value counts down     */
  /* from 65535 to zero and repeats ad nauseum. For those who really  */
  /* care, every time the count reaches zero the system timer 	      */
  /* interrupt is called (remember that thing that gets called every  */
  /* 55 milliseconds and does housekeeping such as checking the       */
  /* keyboard.                                                        */
  outportb (0x43, 0x00);       /* latch counter until we read it      */
  d1 = inportb (0x40);         /* get low count                       */
  d2 = inportb (0x40);         /* get high count                      */

  /* get difference between current, last counter reading             */
  tick  = (d2 << 8) + d1;
  dtick = ltick - tick;
  ltick = tick;

    /* Corrected per arron5@geocities.com 02/08/97 */
  if ((inportb(0x3fe) & 0xF0) > 0) dtick = dtick | 0x8000;
			      else dtick = dtick & 0x3fff;

  fdata[cpstn] = dtick;        /* put freq in fdata array             */
  cpstn  ++;                   /* increment data buffer pointer       */
  if (cpstn>buflen) cpstn=0;   /* make sure cpstn doesnt leave array  */

  d1 = inportb (0x03fa);       /* clear IIR                           */
  d1 = inportb (0x03fd);       /* clear LSR                           */
  d1 = inportb (0x03fe);       /* clear MSR                           */
  d1 = inportb (0x03f8);       /* clear RX                            */
  outportb (0x20, 0x20);       /* this is the END OF INTERRUPT SIGNAL */
                               /* "... that's all folks!!!!"          */
}

void set8250 ()                /* sets up the 8250 UART               */
{
  static unsigned int t;
  outportb (0x03fb, 0x00);     /*  set IER on 0x03f9                  */
  outportb (0x03f9, 0x08);     /*  enable MODEM STATUS INTERRUPT      */
  outportb (0x03fc, 0x0a);     /*  push up RTS, DOWN DTR              */
  t = inportb(0x03fd);         /*  clear LSR                          */
  t = inportb(0x03f8);         /*  clear RX                           */
  t = inportb(0x03fe);         /*  clear MSR                          */
  t = inportb(0x03fa);         /*  clear IID                          */
  t = inportb(0x03fa);         /*  clear IID - again to make sure     */
}

void set8253()                 /*  set up the 8253 timer chip         */
{                              /* NOTE: ctr zero, the one we are using*/
                               /*  is incremented every 840nSec, is   */
                               /*  main system time keeper for dos    */
  outportb (0x43, 0x34);       /* set ctr 0 to mode 2, binary         */
  outportb (0x40, 0x00);       /* this gives us the max count         */
  outportb (0x40, 0x00);
}

/****************************************************************/

int pork(int l)
{
  static int s=0,sl=0x0000,t1,asp=0,ll,k,v,b,tap,synd=0,nsy;
  static char line[200]; /* array used to format 112 bit data chunks */
  static int lc=0;	 /* pointer to position in array line	     */
  if (l == -1)
  {
/*    printf ("  %2i\n",asp); */
    sl = 0x0000;
    s = 0;
    synd = 0;
    if ((asp <12) && (lc > 50))
    {
      ll = 12 - asp;
      for (ll=0; ll<6; ll++)
      {
	v = 0;
	for (k=7; k>=0; k--)
	{
	  b = line[ (ll<<3) +k ];
	  v = v << 1;
	  if ( b == 49) v++;
	}
	ob[obp] = (char) v;
	if (obp < 999) obp++;
      }
    }
    lc = 0;
    tap = asp;
    asp = 0;
    return(tap);
  }
  else
  {
    s++;
    if (s==1)
    {
      line[lc] = (char) l;
      lc++;
    }

    /* update sliding buffer */
    sl = sl << 1;
    sl = sl & 0x7fff;
    if (l == 49) sl++;

    if (s >1)
    {
      s = 0;

      if ((sl & 0x2000) > 0) t1 = 1; else t1 = 0;
      if ((sl & 0x0800) > 0) t1^=1;
      if ((sl & 0x0020) > 0) t1^=1;
      if ((sl & 0x0002) > 0) t1^=1;
      if ((sl & 0x0001) > 0) t1^=1;

      /* attempt to identify, correct certain erroneous bits */

      synd = synd << 1;
      if (t1 == 0)
      {
	asp++;
	synd++;
      }
      nsy = 0;

    /* Corrected per arron5@geocities.com 02/08/97 */
      if ( (synd & 0x0001) > 0) nsy++;
      if ( (synd & 0x0002) > 0) nsy++;
      if ( (synd & 0x0010) > 0) nsy++;
      if ( (synd & 0x0040) > 0) nsy++;
      /* assume bit is correctable */
      if ( nsy >= 3)
      {
	printf ("*");
	synd = synd ^ 0x53;
	line[lc - 7] ^= 0x01;
      }


    }

  }
  return(0);
}

void shob()
{
  int i1,i2,j1,j2,k1;

  /* update file output buffer */
  i1 = obp / 18;
  if ( (obp-(i1*18)) > 0) i1++;
  fob[fobp] = (char) (i1 & 0xff);
  if (fobp < 29999) fobp++;
  for (i2 = obp; i2<=(obp+20); i2++) ob[i2] = 0;
  for (j1 = 0; j1 < i1; j1++)
  {
    for (j2 = 0; j2 < 18; j2++)
    {
      k1 = j2 + (j1*18);
      printf("%02X ", ob[k1] & 0xff);
      fob[fobp] = (char) (ob[k1] & 0xff);
      if (fobp < 29999) fobp++;
    }
    printf ("    ");
    for (j2 = 0; j2 < 18; j2++)
    {
      k1 = j2 + (j1*18);
      if (ob[k1] >=32) printf("%c",ob[k1]); else printf(".");
    }
    printf("\n");
  }

  obp=0;
  printf("BUFFER: %3i percent full\n",(int)(fobp/299.0));
}

/**********************************************************************/
/*                      frame_sync                                    */
/**********************************************************************/
/* this routine recieves the raw bit stream and tries to decode it    */
/* the first step is frame synchronization - a particular 40 bit      */
/* long sequence indicates the start of each data frame. Data frames  */
/* are always 112 bits long. After each 112 bit chunk this routine    */
/* tries to see if the message is finished (assumption - it's finished*/
/* if the 40 bit frame sync sequence is detected right after the end  */
/* of the 112 bit data chunk). This routine also goes back to hunting */
/* for the frame sync when the routine processing the 112 bit data    */
/* chunk decides there are too many errors (transmitter stopped or    */
/* bit detection routine skipped or gained an extra bit).	      */
/*                                                                    */
/* inputs are fed to this routine one bit at a time                   */
/* input : 48 - bit is a zero                                         */
/*         49 - bit is a 1                                            */

void frame_sync(char gin)
{
  static unsigned int s1=0,s2=0,s3=0,nm,j,t1,t2,t3,ns=0,st=0,n,m,l,chu=0,eef=0;
  static char ta[200];

  if (st == 1)
  {
    ta[ns] = gin;
    ns++;
    if (ns >= 112)   /* process 112 bit chunk */
    {
      chu++;
      ns = 0;
      for (n= 0; n<16; n++)
      {
	for (m=0; m<7; m++)
	{
	  l = n + (m<<4);
	  pork(ta[l]);
	}
      }
      if (pork(-1) > 20) eef++; else eef=0;
      if (eef > 1)  /* if two consecutive excess error chunks - bye  */
      {
	st = 0;
	shob();
	eef = 0;
      }
/*      else eef = 0; */
    }
  }

    /* s1,s2,s3 represent a 40 bit long buffer */
    s1 = (s1 << 1) & 0xff;
    if ((s2 & 0x8000) > 0) s1++;
    s2 = (s2 << 1);
    if ((s3 & 0x8000) > 0) s2++;
    s3 = (s3 << 1);
    if (gin == 49) s3++;

    /* xor with 40 bit long sync word */
    t1 = s1 ^ 0x0007;
    t2 = s2 ^ 0x092A;
    t3 = s3 ^ 0x446F;

    /* find how many bits match up */
    /* currently : the frame sync indicates system id / idling / whatever */
    /*        inverted frame sync indicates message follows             */
    nm = 0;
    for (j=0; j<16; j++)
    {
      if (t1 & 1) nm++;
      if (t2 & 1) nm++;
      if (t3 & 1) nm++;
      t1 = t1 >> 1;
      t2 = t2 >> 1;
      t3 = t3 >> 1;
    }

    if (nm <  5)
    {
      st = 1;
      ns = 0;
    }
    else if (nm > 35)
    {
      if (st==1)
      {
	shob();
      }
      st = 0;
      ns = 0;
    }
}

void main (int argc)
{
  unsigned int n,i=0,j,k,l,cw1=49,cw0=48;
  FILE *out;
  char s=48;
  double pl,dt,exc=0.0,clk=0.0,xct;

  if (argc > 1)
  {
    printf ("Reverse Polarity.\n");
    cw1 = 48;
    cw0 = 49;
  }

  /* dt is the number of expected clock ticks per bit */
  dt =  1.0/(4800.0*838.8e-9);

  oldfuncc = getvect(0x0c);    /* save COM1 Vector                    */
  setvect (0x0c, com1int);     /* Capture COM1 vector                 */


  n = inportb (0x21);          /* enable IRQ4 interrupt               */
  outportb(0x21, n & 0xef);

  set8253();                   /* set up 8253 timer chip              */

  set8250();                   /* set up 8250 UART                    */

  while ((kbhit() == 0) && (fobp<29900))
  {
   if (i != cpstn)
   {
    if  ( ( fdata[i] & 0x8000) != 0) s = cw1; else s = cw0;

    /* add in new number of cycles to clock  */
    clk += (fdata[i] & 0x7fff);
    xct = exc + 0.5 * dt;  /* exc is current boundary */
    while ( clk >= xct )
    {
      frame_sync(s);
      clk = clk - dt;
    }
    /* clk now holds new boundary position. update exc slowly... */
    /* 0.005 sucks; 0.02 better; 0.06 mayber even better; 0.05 seems pretty good */
    exc = exc + 0.020*(clk - exc);

    i++;
    if( i >buflen) i = 0;
   }

  }

  outportb (0x21, n);          /* disable IRQ4 interrupt              */
  setvect (0x0c, oldfuncc);    /* restore old COM1 Vector             */


  /* save captured data to disk file	*/
  i = 0;
  out = fopen("data.dat","wt");
  if (out == NULL)
  {
    printf ("couldn't open output file.\n");
    exit(1);
  }

  i = 0;
  while ( (i < fobp) && (i < 29800))
  {
    j = ((int)fob[i] & 0xff);
    i++;
    for (k=0; k<j; k++)
    {
      for (l=0; l<18; l++)
      {
	fprintf(out,"%02X ",((int) fob[i + l]&0xff));
      }
      fprintf(out,"    ");
      for (l=0; l<18; l++)
      {
	n = ((int)fob[i]&0xff);
	i++;
	if (n >=32) fprintf(out,"%c",n); else fprintf(out,".");
      }
      fprintf(out,"\n");
    }
    fprintf(out,"\n");
  }
  fclose(out);
}
