/* Copyright (c) 2012, The Linux Foundation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * Neither the name of The Linux Foundation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <stdint.h>
#include <msm_panel.h>
#include <mipi_dsi.h>
#include <sys/types.h>
#include <err.h>
#include <reg.h>
#include <debug.h>
#include <target/display.h>

extern int mipi_nt35510_panel_wvga_rotate();

/* MIPI NT35510 panel commands */
static char exit_sleep[4] = {0x11, 0x00, 0x05, 0x80};
static char display_on[4] = {0x29, 0x00, 0x05, 0x80};
static char write_ram[4] = {0x2c, 0x00, 0x05, 0x80}; /* write ram */

static char cmd0[12] = {
	0x06, 0x00, 0x29, 0xc0, 0xF0, 0x55, 0xAA, 0x52,
	0x08, 0x01, 0xff, 0xff,
};
static char cmd1[8] = {
	0x04, 0x00, 0x29, 0xc0, 0xBC, 0x00, 0xA0, 0x00,
};
static char cmd2[8] = {
	0x04, 0x00, 0x29, 0xc0, 0xBD, 0x00, 0xA0, 0x00,
};
static char cmd3[8] = {
	0x03, 0x00, 0x29, 0xc0, 0xBE, 0x00, 0x79, 0xff,
};
static char cmd4[60] = {
	0x35, 0x00, 0x29, 0xc0, 0xD1, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x32, 0x00,
	0x4F, 0x00, 0x65, 0x00,
	0x8B, 0x00, 0xA8, 0x00,
	0xD5, 0x00, 0xF7, 0x01,
	0x2B, 0x01, 0x54, 0x01,
	0x8E, 0x01, 0xBB, 0x01,
	0xBC, 0x01, 0xE3, 0x02,
	0x08, 0x02, 0x1C, 0x02,
	0x39, 0x02, 0x4F, 0x02,
	0x76, 0x02, 0xA3, 0x02,
	0xE3, 0x03, 0x12, 0x03,
	0x4C, 0x03, 0x66, 0x03,
	0x9A, 0xff, 0xff, 0xff,
};
static char cmd5[60] = {
	0x35, 0x00, 0x29, 0xc0, 0xD2, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x32, 0x00,
	0x4F, 0x00, 0x65, 0x00,
	0x8B, 0x00, 0xA8, 0x00,
	0xD5, 0x00, 0xF7, 0x01,
	0x2B, 0x01, 0x54, 0x01,
	0x8E, 0x01, 0xBB, 0x01,
	0xBC, 0x01, 0xE3, 0x02,
	0x08, 0x02, 0x1C, 0x02,
	0x39, 0x02, 0x4F, 0x02,
	0x76, 0x02, 0xA3, 0x02,
	0xE3, 0x03, 0x12, 0x03,
	0x4C, 0x03, 0x66, 0x03,
	0x9A, 0xff, 0xff, 0xff,
};
static char cmd6[60] = {
	0x35, 0x00, 0x29, 0xc0, 0xD3, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x32, 0x00,
	0x4F, 0x00, 0x65, 0x00,
	0x8B, 0x00, 0xA8, 0x00,
	0xD5, 0x00, 0xF7, 0x01,
	0x2B, 0x01, 0x54, 0x01,
	0x8E, 0x01, 0xBB, 0x01,
	0xBC, 0x01, 0xE3, 0x02,
	0x08, 0x02, 0x1C, 0x02,
	0x39, 0x02, 0x4F, 0x02,
	0x76, 0x02, 0xA3, 0x02,
	0xE3, 0x03, 0x12, 0x03,
	0x4C, 0x03, 0x66, 0x03,
	0x9A, 0xff, 0xff, 0xff,
};
static char cmd7[60] = {
	0x35, 0x00, 0x29, 0xc0, 0xD4, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x32, 0x00,
	0x4F, 0x00, 0x65, 0x00,
	0x8B, 0x00, 0xA8, 0x00,
	0xD5, 0x00, 0xF7, 0x01,
	0x2B, 0x01, 0x54, 0x01,
	0x8E, 0x01, 0xBB, 0x01,
	0xBC, 0x01, 0xE3, 0x02,
	0x08, 0x02, 0x1C, 0x02,
	0x39, 0x02, 0x4F, 0x02,
	0x76, 0x02, 0xA3, 0x02,
	0xE3, 0x03, 0x12, 0x03,
	0x4C, 0x03, 0x66, 0x03,
	0x9A, 0xff, 0xff, 0xff,
};
static char cmd8[60] = {
	0x35, 0x00, 0x29, 0xc0, 0xD5, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x32, 0x00,
	0x4F, 0x00, 0x65, 0x00,
	0x8B, 0x00, 0xA8, 0x00,
	0xD5, 0x00, 0xF7, 0x01,
	0x2B, 0x01, 0x54, 0x01,
	0x8E, 0x01, 0xBB, 0x01,
	0xBC, 0x01, 0xE3, 0x02,
	0x08, 0x02, 0x1C, 0x02,
	0x39, 0x02, 0x4F, 0x02,
	0x76, 0x02, 0xA3, 0x02,
	0xE3, 0x03, 0x12, 0x03,
	0x4C, 0x03, 0x66, 0x03,
	0x9A, 0xff, 0xff, 0xff,
};
static char cmd9[60] = {
	0x35, 0x00, 0x29, 0xc0, 0xD6, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x32, 0x00,
	0x4F, 0x00, 0x65, 0x00,
	0x8B, 0x00, 0xA8, 0x00,
	0xD5, 0x00, 0xF7, 0x01,
	0x2B, 0x01, 0x54, 0x01,
	0x8E, 0x01, 0xBB, 0x01,
	0xBC, 0x01, 0xE3, 0x02,
	0x08, 0x02, 0x1C, 0x02,
	0x39, 0x02, 0x4F, 0x02,
	0x76, 0x02, 0xA3, 0x02,
	0xE3, 0x03, 0x12, 0x03,
	0x4C, 0x03, 0x66, 0x03,
	0x9A, 0xff, 0xff, 0xff,
};
static char cmd10[8] = {
	0x04, 0x00, 0x29, 0xc0, 0xB0, 0x0A, 0x0A, 0x0A,
};
static char cmd11[8] = {
	0x04, 0x00, 0x29, 0xc0, 0xB1, 0x0A, 0x0A, 0x0A,
};
static char cmd12[8] = {
	0x04, 0x00, 0x29, 0xc0, 0xBA, 0x24, 0x24, 0x24,
};
static char cmd13[8] = {
	0x04, 0x00, 0x29, 0xc0, 0xB9, 0x24, 0x24, 0x24,
};
static char cmd14[8] = {
	0x04, 0x00, 0x29, 0xc0, 0xB8, 0x24, 0x24, 0x24,
};
static char cmd15[12] = {
	0x06, 0x00, 0x29, 0xc0, 0xF0, 0x55, 0xAA, 0x52,
	0x08, 0x00, 0xff, 0xff,
};
static char cmd16[8] = {
	0x02, 0x00, 0x29, 0xc0, 0xB3, 0x00, 0xff, 0xff,
};
static char cmd17[8] = {
	0x02, 0x00, 0x29, 0xc0, 0xB4, 0x10, 0xff, 0xff,
};
static char cmd18[8] = {
	0x02, 0x00, 0x29, 0xc0, 0xB6, 0x02, 0xff, 0xff,
};
static char cmd19[8] = {
	0x03, 0x00, 0x29, 0xc0, 0xB1, 0xEC, 0x00, 0xff,
};
static char cmd20[8] = {
	0x04, 0x00, 0x29, 0xc0, 0xBC, 0x05, 0x05, 0x05,
};
static char cmd21[8] = {
	0x03, 0x00, 0x29, 0xc0, 0xB7, 0x20, 0x20, 0xff,
};
static char cmd22[12] = {
	0x05, 0x00, 0x29, 0xc0, 0xB8, 0x01, 0x03, 0x03,
	0x03, 0xff, 0xff, 0xff,
};
static char cmd23[24] = {
	0x13, 0x00, 0x29, 0xc0, 0xC8, 0x01, 0x00, 0x78,
	0x50, 0x78, 0x50, 0x78,
	0x50, 0x78, 0x50, 0xC8,
	0x3C, 0x3C, 0xC8, 0xC8,
	0x3C, 0x3C, 0xC8, 0xff,
};
static char cmd24[12] = {
	0x06, 0x00, 0x29, 0xc0, 0xBD, 0x01, 0x84, 0x07,
	0x31, 0x00, 0xff, 0xff,
};
static char cmd25[12] = {
	0x06, 0x00, 0x29, 0xc0, 0xBE, 0x01, 0x84, 0x07,
	0x31, 0x00, 0xff, 0xff,
};
static char cmd26[12] = {
	0x06, 0x00, 0x29, 0xc0, 0xBF, 0x01, 0x84, 0x07,
	0x31, 0x00, 0xff, 0xff,
};
static char cmd27[8] = {
	0x02, 0x00, 0x29, 0xc0, 0x35, 0x00, 0xff, 0xff,
};

static char config_MADCTL[4] = {0x36, 0x00, 0x15, 0x80};

static struct mipi_dsi_cmd nt35510_panel_cmd_mode_cmds[] = {
	{sizeof(cmd0), cmd0},
	{sizeof(cmd1), cmd1},
	{sizeof(cmd2), cmd2},
	{sizeof(cmd3), cmd3},
	{sizeof(cmd4), cmd4},
	{sizeof(cmd5), cmd5},
	{sizeof(cmd6), cmd6},
	{sizeof(cmd7), cmd7},
	{sizeof(cmd8), cmd8},
	{sizeof(cmd9), cmd9},
	{sizeof(cmd10), cmd10},
	{sizeof(cmd11), cmd11},
	{sizeof(cmd12), cmd12},
	{sizeof(cmd13), cmd13},
	{sizeof(cmd14), cmd14},
	{sizeof(cmd15), cmd15},
	{sizeof(cmd16), cmd16},
	{sizeof(cmd17), cmd17},
	{sizeof(cmd18), cmd18},
	{sizeof(cmd19), cmd19},
	{sizeof(cmd20), cmd20},
	{sizeof(cmd21), cmd21},
	{sizeof(cmd22), cmd22},
	{sizeof(cmd23), cmd23},
	{sizeof(cmd24), cmd24},
	{sizeof(cmd25), cmd25},
	{sizeof(cmd26), cmd26},
	{sizeof(cmd27), cmd27},
	{sizeof(exit_sleep), exit_sleep},
	{sizeof(display_on), display_on},
	{sizeof(config_MADCTL), config_MADCTL},
	{sizeof(write_ram), write_ram},
};

int mipi_nt35510_cmd_wvga_on()
{
	int ret = NO_ERROR;
	return ret;
}

int mipi_nt35510_cmd_wvga_off()
{
	int ret = NO_ERROR;
	return ret;
}

int mipi_nt35510_cmd_wvga_config(void *pdata)
{
	int ret = NO_ERROR;

	struct msm_panel_info *pinfo = (struct msm_panel_info *) pdata;

	if (pinfo == NULL)
		return ERR_INVALID_ARGS;

	ret = mipi_dsi_cmd_mode_config((pinfo->xres),
			(pinfo->yres),
			(pinfo->xres),
			(pinfo->yres),
			pinfo->mipi.dst_format,
			pinfo->mipi.traffic_mode);
	return ret;
}

struct mipi_dsi_phy_ctrl dsi_cmd_mode_phy_db = {
	/* DSI_BIT_CLK at 500MHz, 2 lane, RGB888 */
	{0x03, 0x01, 0x01, 0x00},	/* regulator */
	/* timing   */
	{0xb9, 0x8e, 0x1f, 0x00, 0x98, 0x9c, 0x22,
	0x90, 0x18, 0x03, 0x04},
	{0x7f, 0x00, 0x00, 0x00},	/* phy ctrl */
	{0xbb, 0x02, 0x06, 0x00},	/* strength */
	/* pll control */
	{0x00, 0xec, 0x31, 0xd2, 0x00, 0x40, 0x37, 0x62,
	0x01, 0x0f, 0x07,	/*  --> Two lane configuration */
	0x05, 0x14, 0x03, 0x0, 0x0, 0x0, 0x20, 0x0, 0x02, 0x0},
};

void mipi_nt35510_cmd_wvga_init(struct msm_panel_info *pinfo)
{
	if (!pinfo)
		return;

	pinfo->xres = NT35510_MIPI_FB_WIDTH;
	pinfo->yres = NT35510_MIPI_FB_HEIGHT;
	pinfo->mipi.num_of_lanes = 2;

	pinfo->type = MIPI_CMD_PANEL;
	pinfo->wait_cycle = 0;
	pinfo->bpp = 24;
	pinfo->clk_rate = 499000000;

	pinfo->mipi.mode = DSI_CMD_MODE;
	pinfo->mipi.traffic_mode = 0;
	pinfo->mipi.dst_format = 0;
	pinfo->mipi.dsi_phy_db = &dsi_cmd_mode_phy_db;
	pinfo->mipi.tx_eot_append = TRUE;

	pinfo->mipi.lane_swap = 1;
	pinfo->mipi.panel_cmds = nt35510_panel_cmd_mode_cmds;
	pinfo->mipi.num_of_panel_cmds = \
			ARRAY_SIZE(nt35510_panel_cmd_mode_cmds);

	pinfo->on = mipi_nt35510_cmd_wvga_on;
	pinfo->off = mipi_nt35510_cmd_wvga_off;
	pinfo->config = mipi_nt35510_cmd_wvga_config;
	pinfo->rotate = mipi_nt35510_panel_wvga_rotate;

	return;
}
