/*
 * * Copyright (c) 2011, The Linux Foundation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *  * Neither the name of The Linux Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __PLATFORM_MDM9615_CLOCK_H
#define __PLATFORM_MDM9615_CLOCK_H

/* NS/MD value for USB XCVR */
#define USB_XCVR_CLK_NS        0x00E400C3
#define USB_XCVR_CLK_MD        0x000500DF

/* NS/MD value for UART */
/* Target is 1.8 MHz with cxo source */
#define UART_DM_CLK_NS_115200  0xFFEC0040
#define UART_DM_CLK_MD_115200  0x0002FFEA

#define UART_DM_CLK_RX_TX_BIT_RATE 0xFF

#define SC0_U_BRANCH_ENA_VOTE            0x903080
#define SC0_U_BRANCH_ENA_VOTE_ADM0       2
#define SC0_U_BRANCH_ENA_VOTE_ADM0_PBUS  3

void hsusb_clock_init(void);
void clock_config_uart_dm(uint8_t id);

#endif
