/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <fcntl.h>
#include <getopt.h>
#include <limits.h>
#include <linux/input.h>
#include <linux/reboot.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dirent.h>
#include <syscall.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>
#include <sys/select.h>
#include <signal.h>

#include "mtdutils/mtdutils.h"
#include "mtdutils/mounts.h"
#include "common.h"
#include "redbend/redbend.h"

#include "redbend/include/RB_FileSystemUpdate.h"
#include "redbend/include/RB_ImageUpdate.h"
#include "redbend/include/RB_vRM_Errors.h"
#include "redbend/include/RB_vRM_Update.h"

#define UPI_MEM_SIZE            (80 * 128 *1024)
extern void quec_clr_percent(void);
static int init_fota_device_data(redbend_fota *rfd)
{
	static const unsigned char temp_path[] = "/cache/fota";
	char command[256];
	unsigned int i = 0;
	vRM_DeviceData *vddata = &rfd->vrm_dev_data;

	rfd->vrm_ram = malloc(UPI_MEM_SIZE);
	if (rfd->vrm_ram == NULL)
	{
		printf("%s: malloc vrm_ram err\n", __func__);
		goto malloc_vrm_ram;
	}
	memset(rfd->vrm_ram, 0, UPI_MEM_SIZE);

	sprintf(command, "mkdir -p %s ; mount -t yaffs2 %s %s", \
			rfd->mount_point, rfd->device_name, rfd->mount_point);
	system(command);
	sleep(2);
	printf("\n");

#if 0
	if (mtd_mount_partition(rfd->mtd_part, rfd->mount_point, "yaffs2", 0 /* rw */) != 0)
	{
		printf("%s: mtd mount of %s failed: %s\n", __func__, rfd->mount_point, strerror(errno));
		goto mount_point_err;
	}
#endif

	rfd->partion_data[0].partition_name = rfd->part_name;
	rfd->partion_data[0].rom_start_address = 0;
	rfd->partion_data[0].mount_point = rfd->mount_point;
	rfd->partion_data[0].partition_type = PT_FS;
	//rfd->partion_data[0].strSourcePath = rfd->update_name;
	//rfd->partion_data[0].strTargetPath = rfd->mount_point;

	vddata->ui32Operation = 0;
	vddata->pRam = rfd->vrm_ram;
	vddata->ui32RamSize = UPI_MEM_SIZE;
	vddata->ui32NumberOfBuffers = 0;
	vddata->pBufferBlocks = 0;
	vddata->ui32NumberOfPartitions = \
									 sizeof(rfd->partion_data) / \
									 sizeof(rfd->partion_data[0]);
	vddata->pFirstPartitionData = rfd->partion_data;
	vddata->pTempPath = temp_path;
	vddata->enmUpdateType = UT_NO_SELF_UPDATE;
	vddata->pComponentInstallerTypes = rfd->component_installer_types;
	vddata->ui32ComponentInstallerTypesNum = 1;
	vddata->ui32ComponentUpdateFlags = (RB_UINT32) - 1;
	vddata->ui32OrdinalToUpdate = (RB_UINT32) - 1;
	vddata->pDeltaPath = rfd->update_name;
	vddata->pbUserData = rfd;

	return 0;

mount_point_err:
	free(rfd->vrm_ram);
	rfd->vrm_ram = NULL;
malloc_vrm_ram:
	return -1;
}

int redbend_fs_entry(char *fs)
{
	redbend_fota *rfd;
	size_t total_size, block_size, page_size;
	char *ptr, c = '/';
	char urc[128] = {'\0'};
	unsigned int image_name_len;

	sprintf(urc, "start fota update (%s)\n", fs);
	printf("%s", urc);//urc_to_ttygs_modem(urc); 2015/6/1 deled by tommy
	quec_clr_percent();
	if (strcmp(".diff", fs + strlen(fs) - strlen(".diff")) != NULL)
	{
		printf("%s: The file name suffix is not correct(%s)\n", __func__, fs);
		goto malloc_rfd_err;
	}

	rfd = malloc(sizeof(redbend_fota));
	if (rfd == NULL)
	{
		printf("%s: malloc rfd err\n", __func__);
		goto malloc_rfd_err;
	}
	memset(rfd, 0, sizeof(redbend_fota));
	strcpy(rfd->update_name, fs);

	ptr = strrchr(fs, c);
	memcpy(rfd->part_name ,ptr+1, (strlen(ptr) - 6));

	mtd_scan_partitions();
	rfd->mtd_part = mtd_find_partition_by_name(rfd->part_name);
	if (rfd->mtd_part == NULL)
	{
		printf("%s: mtd find partition err\n", __func__);
		goto init_fota_device_data_err;
	}

	sprintf(rfd->device_name, "/dev/mtdblock%d", rfd->mtd_part->device_index);
	sprintf(rfd->mount_point, "/tmp/%s", rfd->part_name);

	printf("%s: device_name: %s\n", __func__, rfd->device_name);
	printf("%s: mount_point: %s\n", __func__, rfd->mount_point);
	printf("%s: update_name: %s\n", __func__, rfd->update_name);
	printf("%s: part_name: %s\n", __func__, rfd->part_name);

	rfd->fota_flag = FOTA_FS_PART;

	if (init_fota_device_data(rfd) != 0)
	{
		goto init_fota_device_data_err;
	}

	//mtd_test(rfd);
	if (RB_vRM_Update(&rfd->vrm_dev_data) == S_RB_SUCCESS)
	{
		sprintf(urc, "fota update success (%s)\n", fs);
		printf("%s", urc);//urc_to_ttygs_modem(urc); 2015/6/1 deled by tommy
	}
	else
	{
		goto init_fota_device_data_err;
	}
	sleep(5);
	sprintf(urc, "umount %s", rfd->mount_point);
	system(urc);
	free(rfd->vrm_ram);
	free(rfd);
	return 0;

init_fota_device_data_err:
	if (rfd->vrm_ram != NULL) free(rfd->vrm_ram);
	sprintf(urc, "umount %s", rfd->mount_point);
	system(urc);
	free(rfd);
malloc_rfd_err:
	sprintf(urc, "fota update fail (%s)\n", fs);
	printf("%s", urc);//urc_to_ttygs_modem(urc); 2015/6/1 deled by tommy
	return -1;
}

