/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <fcntl.h>
#include <getopt.h>
#include <limits.h>
#include <linux/input.h>
#include <linux/reboot.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dirent.h>
#include <syscall.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>
#include "common.h"

#include "mtdutils/mtdutils.h"
#include "mtdutils/mounts.h"
#include "redbend/redbend.h"

#include "redbend/include/RB_FileSystemUpdate.h"
#include "redbend/include/RB_ImageUpdate.h"
#include "redbend/include/RB_vRM_Errors.h"
#include "redbend/include/RB_vRM_Update.h"

extern void quec_clr_percent(void);
#if 0
static int mtd_test(redbend_fota *pbUserData)
{
	size_t r;
	FILE *fp =NULL;
	char *test_file = "/cache/mtd.log";
	char *write_file = "/cache/update.zip";
	redbend_fota *rbf = pbUserData;
	printf("%s: ################ start mtd test\n", __func__);

#define TEST_FILE_SIZE	0x400
	char data[TEST_FILE_SIZE];

	fp = fopen(write_file, "r");
	if (fp == NULL)
	{
		printf("%s: open %s err\n", __func__, write_file);
		return -1;
	}

	r = fread(data, sizeof(char), TEST_FILE_SIZE, fp);
	if (r != TEST_FILE_SIZE)
	{
		printf("%s: read %s err\n", __func__, write_file);
		fclose(fp);
		return -1;
	}

	system("cat /dev/mtd10 > /tmp/mtd10_old.log");

	r = mtd_write_data_offset(rbf, data, TEST_FILE_SIZE, 0x00);
	if (r != TEST_FILE_SIZE)
	{
		printf("%s: write %s err\n", __func__, write_file);
		fclose(fp);
		return -1;
	}

	system("sync");
	system("cat /dev/mtd10 > /tmp/mtd10_new.log");
	
#if 0
	ssize_t r = mtd_read_data_offset(pbUserData, data, TEST_FILE_SIZE, 0x08);
	if (r != size) printf("%s: Can't read MISC\n(%s)\n", __func__,  strerror(errno));
	mtd_read_close(read);

	fp = fopen(test_file, "w");
	if (fp == NULL)
	{
		printf("%s: open %s err\n", __func__, test_file);
		return -1;
	}

	r = fwrite(data, sizeof(char), size, fp);
	if (r != size)
	{
		printf("%s: write %s err\n", __func__, test_file);
		return -1;
	}
	fclose(fp);
#endif

	printf("%s: ################ stop mtd test\n", __func__);
	return 0;

}
#endif

static int init_fota_device_data(redbend_fota *redbend_fota_data)
{
	static const unsigned char partition_name[] = {'p', 'a', 'r', 't', '0', '\0'};
	unsigned int i = 0;
	vRM_DeviceData *vddata = &redbend_fota_data->vrm_dev_data;

	redbend_fota_data->vrm_ram = malloc(UPI_MEM_SIZE);
	if (redbend_fota_data->vrm_ram == NULL)
	{
		printf("%s: malloc vrm_ram err\n", __func__);
		goto malloc_vrm_ram;
	}
	memset(redbend_fota_data->vrm_ram, 0, UPI_MEM_SIZE);

	for(i=0; i <BACKUP_USE_NUM; i++)
	{
		redbend_fota_data->backup_buffer_address[i] = i * redbend_fota_data->flash_block_size;
	}

	redbend_fota_data->partion_data[0].partition_name = (const char*)partition_name;
	redbend_fota_data->partion_data[0].rom_start_address = 0;
	redbend_fota_data->partion_data[0].mount_point = NULL;
	redbend_fota_data->partion_data[0].strSourcePath = NULL;
	redbend_fota_data->partion_data[0].strTargetPath = NULL;
	redbend_fota_data->partion_data[0].priv = NULL;
	redbend_fota_data->partion_data[0].partition_type = PT_FOTA;

	vddata->ui32Operation = 0;
	vddata->pRam = redbend_fota_data->vrm_ram;
	vddata->ui32RamSize = UPI_MEM_SIZE;
	vddata->ui32NumberOfBuffers = BACKUP_USE_NUM;
	vddata->pBufferBlocks = redbend_fota_data->backup_buffer_address;
	vddata->ui32NumberOfPartitions = \
									 sizeof(redbend_fota_data->partion_data) / \
									 sizeof(redbend_fota_data->partion_data[0]);
	vddata->pFirstPartitionData = redbend_fota_data->partion_data;
	vddata->pTempPath = 0;
	vddata->pComponentInstallerTypes = redbend_fota_data->component_installer_types;
	vddata->ui32ComponentInstallerTypesNum = 1;
	vddata->ui32ComponentUpdateFlags = (RB_UINT32) - 1;
	vddata->enmUpdateType = UT_NO_SELF_UPDATE;
	vddata->ui32OrdinalToUpdate = (RB_UINT32) - 1;
	vddata->pDeltaPath = NULL;
	vddata->pbUserData = redbend_fota_data;

	return 0;

malloc_vrm_ram:
	return -1;
}

int redbend_image_entry(char *image_name)
{
	redbend_fota *redbend_fota_data;
	size_t total_size, block_size, page_size;
	char part_name[16] = {0};
	char command[128] = {0};
	char *ptr, c = '/';
	char urc[128] = {'\0'};
	unsigned int image_name_len;
	int i, block_count, list_num = 0;
	MtdWriteContext *ctx;
	nand_bad_rec *p;

	sprintf(urc, "start fota update (%s)\n", image_name);
	printf("%s", urc);//urc_to_ttygs_modem(urc); 2015/6/1 deled by tommy
	quec_clr_percent();

	build_compile();	// Why this tuning, good strange, ha ha, don't tell you why.
	redbend_fota_data = malloc(sizeof(redbend_fota));
	if (redbend_fota_data == NULL)
	{
		printf("%s: malloc redbend_fota_data err\n", __func__);
		goto malloc_redbend_fota_data_err;
	}
	memset(redbend_fota_data, 0, sizeof(redbend_fota));
	strcpy(redbend_fota_data->update_name, image_name);

	ptr = strrchr(image_name, c);
	memcpy(part_name ,ptr+1, (strlen(ptr) - 6));
	mtd_scan_partitions();
	redbend_fota_data->mtd_part = mtd_find_partition_by_name(part_name);
	//redbend_fota_data->mtd_part = mtd_find_partition_by_name("misc");
	if (redbend_fota_data->mtd_part == NULL)
	{
		printf("%s: mtd find partition err\n", __func__);
		goto malloc_redbend_fota_data_err;
	}

	if (mtd_partition_info(redbend_fota_data->mtd_part, &total_size, &block_size, &page_size) != NULL)
	{
		printf("%s: get mtd partition info err\n", __func__);
		goto malloc_redbend_fota_data_err;
	}

	redbend_fota_data->flash_part_size = total_size;
	redbend_fota_data->flash_block_size = block_size;
	redbend_fota_data->flash_page_size = page_size;
	redbend_fota_data->flash_page_count = block_size / page_size;
	redbend_fota_data->flash_block_count = total_size / block_size;
	block_count = redbend_fota_data->flash_block_count;
	printf("%s: total_size: 0x%x block_size: 0x%x page_size: 0x%x page_count: 0x%x block_count: 0x%x\n", __func__, \
			redbend_fota_data->flash_part_size, \
			redbend_fota_data->flash_block_size, \
			redbend_fota_data->flash_page_size, \
			redbend_fota_data->flash_page_count, \
			redbend_fota_data->flash_block_count);

	strcpy(redbend_fota_data->backup_name, BACKUP_FILE_NAME);
	if (access(redbend_fota_data->backup_name , F_OK))
	{
		sprintf(command, "dd if=/dev/zero of=%s bs=128K count=4", redbend_fota_data->backup_name);
		ds_system_call(command, strlen(command));
		printf("\n");
		for (i=0; i < 4; i++)
		{
			if (RB_EraseBackupBlock(redbend_fota_data, i*0x20000) == E_RB_FAILURE)
			{
				printf("%s: Erase backup block fail\n", __func__);
				sprintf(command, "rm %s", redbend_fota_data->backup_name);
				ds_system_call(command, strlen(command));
				goto init_fota_device_data_err;
			}
		}
	}

	/* Find bad block */
	redbend_fota_data->bad_block_list.next = &redbend_fota_data->bad_block_list;
	ctx = mtd_write_partition(redbend_fota_data->mtd_part);
	int bn = 0;/* 2015/11/25 added by tommy */
	for (i=0; i < block_count; i++)
	{
		if (mtd_find_bad_block(ctx, i * redbend_fota_data->flash_block_size))
		{
			//static int bn = 0; /* 2015/11/25 deled by tommy */
			++bn;
			printf("%s: find nand bad block(0x%x %d)\n", __func__, i * redbend_fota_data->flash_block_size, bn);
			nand_bad_rec* nbc = malloc(sizeof(nand_bad_rec));
			if (nbc == NULL)
			{
				printf("%s: malloc nand bad rec fail(0x%x)\n", __func__, i * redbend_fota_data->flash_block_size);
				goto init_fota_device_data_err;
			}
			nbc->addr_off = i * redbend_fota_data->flash_block_size;
			nbc->bad_num = bn;
			sam_list_add_tail(nbc, &redbend_fota_data->bad_block_list, nand_bad_rec);
		}
	}

	printf("%s: updata_name: %s\n", __func__, redbend_fota_data->update_name);
	redbend_fota_data->fota_flag = FOTA_IMAGE_PART;

	if (init_fota_device_data(redbend_fota_data) != 0)
	{
		goto init_fota_device_data_err;
	}

	//mtd_test(redbend_fota_data);
	if (RB_vRM_Update(&redbend_fota_data->vrm_dev_data) == S_RB_SUCCESS)
	{
		sprintf(urc, "update image success (%s)\n", image_name);
		printf("%s", urc);//urc_to_ttygs_modem(urc); 2015/6/1 deled by tommy
	}
	else
	{
		goto rb_vrm_update_err;
	}

#if 1
#if FOTA_BAD_BLOCK_LIST
	sam_list_del(&redbend_fota_data->bad_block_list, nand_bad_rec);
#else
	sam_list_for_each(p, &redbend_fota_data->bad_block_list, nand_bad_rec)
	{
				++list_num;
	}
	for (; list_num; --list_num)
	{
		sam_list_for_each(p, &redbend_fota_data->bad_block_list, nand_bad_rec)
		{
			sam_list_del(p, &redbend_fota_data->bad_block_list, nand_bad_rec);
			free(p);
			break;
		}
	}
#endif
#endif
	unlink(BACKUP_FILE_NAME);
	free(redbend_fota_data->vrm_ram);
	free(redbend_fota_data);
	return 0;

rb_vrm_update_err:
	unlink(BACKUP_FILE_NAME);
	free(redbend_fota_data->vrm_ram);
	free(redbend_fota_data);
init_fota_device_data_err:
	if (redbend_fota_data->vrm_ram != NULL) free(redbend_fota_data->vrm_ram);
	free(redbend_fota_data);
malloc_redbend_fota_data_err:
	/* 2015/11/25 added by tommy */
#if FOTA_BAD_BLOCK_LIST
        sam_list_del(&redbend_fota_data->bad_block_list, nand_bad_rec);
#else
	sam_list_for_each(p, &redbend_fota_data->bad_block_list, nand_bad_rec)
        {
                                ++list_num;
        }

        for (; list_num; --list_num)
        {
                sam_list_for_each(p, &redbend_fota_data->bad_block_list, nand_bad_rec)
                {
                        sam_list_del(p, &redbend_fota_data->bad_block_list, nand_bad_rec);
                        free(p);
                        break;
                }
        }
#endif
	sprintf(urc, "update image fail (%s)\n", image_name);
	printf("%s", urc);//urc_to_ttygs_modem(urc); 2015/6/1 deled by tommy
	return -1;
}

