/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef RECOVERY_REDBEND_H_
#define RECOVERY_REDBEND_H_

#include "deltaupdate_config.h"
#include "common.h"
#include "redbend/include/RB_vRM_Update.h"
#include "mtdutils/mtdutils.h"

#ifdef EMBED_UPDATE_BINARY

#define PAGE_BUFFER_MAX_SIZE (3000)

#define UPI_MEM_SIZE            (80 * 128 *1024)
#define BACKUP_NUM              (16)
#define BACKUP_USE_NUM          (4)
#define DELTA_DATA_START_BLOCK  (1)

#define BACKUP_FILE_NAME	"/cache/backup.bin"

#define	FOTA_IMAGE_PART		0x01
#define	FOTA_FS_PART		0x02

/* 2016/2/2 added by tommy for clr list */
#define FOTA_BAD_BLOCK_LIST	1

struct sam_list_head {
	struct sam_list_head *next;
};

#define	sam_list_head_init(name) { (name)->next = name; }
#define	list_init(name) struct sam_list_head name

#define	sam_list_for_each(pos, head, style) \
	for (pos = ((style *)(head))->next; pos != (style *)(head); pos = pos->next)

#define	sam_list_add_tail(pos, head, style) \
	{ \
		style *p; \
		for (p = ((style *)(head)); p->next != (style *)(head); p = p->next); \
		pos->next = (style *)(head); \
		p->next = pos; \
	}

/* 2016/2/2 added by tommy for clr list */
#if FOTA_BAD_BLOCK_LIST
#define	sam_list_del(head,style) \
	{\
		style *q,*p=((style *)head)->next; \
		while(p != ((style *)head)){ \
			q=p->next; \
			free(p); \
                        printf("free 0x%x\n",p); \
                        p=q; \
		}\
	}
#else
#define	sam_list_del(pos, head, style) \
	{ \
		style *p; \
		for (p = ((style *)(head)); (p->next != pos && p->next != (style *)(head)); p = p->next); \
		if (p->next != (style *)(head)) p->next = pos->next; \
	}
#endif
#endif

struct __nand_bad_rec {
	struct __nand_bad_rec *next;
	size_t addr_off;
	unsigned int bad_num;
};

typedef struct __nand_bad_rec nand_bad_rec;

struct __redbend_fota {

	vRM_DeviceData vrm_dev_data;
	CustomerPartitionData partion_data[1];
	RB_UINT32 component_installer_types[1];
	RB_UINT32 backup_buffer_address[BACKUP_USE_NUM];
	MtdPartition *mtd_part;
	int fota_flag;

	unsigned int flash_part_size;
	unsigned int flash_block_size;
	unsigned int flash_page_size;
	unsigned int flash_page_count;
	unsigned int flash_block_count;
	unsigned char *vrm_ram;

	char part_name[32];
	char update_name[128];
	char mount_point[128];
	char device_name[128];
	char backup_name[128];

	struct sam_list_head bad_block_list;
};

typedef struct __redbend_fota redbend_fota;

int redbend_image_entry(char *image_name);
int redbend_fs_entry(char *image_name);

ssize_t mtd_read_data_offset(redbend_fota *rbf, char *data, size_t len, size_t offset);
ssize_t mtd_write_data_offset(redbend_fota *rbf, char *data, size_t len, size_t offset);
int ds_system_call(const char *command, unsigned int cmdlen);
void urc_to_ttygs_modem(char *buf);
void build_compile(void);

#endif  // RECOVERY_REDBEND_H_
