/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <fcntl.h>
#include <getopt.h>
#include <limits.h>
#include <linux/input.h>
#include <linux/reboot.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dirent.h>
#include <syscall.h>
#include <errno.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>
#include <sys/select.h>
#include <signal.h>

#include "mtdutils/mtdutils.h"
#include "mtdutils/mounts.h"
#include "common.h"
#include "redbend/redbend.h"

/*===========================================================================
  FUNCTION  ds_system_call
===========================================================================*/
/*!
@brief
  Execute a shell command.

@return
  int - numeric value 0 on success, -1 otherwise

@note
  - Dependencies
    - None

  - Side Effects
   - None
*/
/*=========================================================================*/
int ds_system_call(const char *command, unsigned int cmdlen)
{
	int result = 0;
	FILE *stream = NULL;
	unsigned int vallen = strlen(command);

	if( vallen != cmdlen ) {
		printf( "system call length mismatch: %d != %d", cmdlen, vallen );
		return -1;
	}

	printf("system call: %s", command);

	stream = popen( command, "w" );
	if( stream == NULL )
	{
		printf("system command failed");
		result = -1;
	}
	else if( 0 > pclose( stream ) )
	{
		printf("pclose command failed");
	}

	return result;
}

ssize_t mtd_read_data_offset(redbend_fota *rbf, char *data, size_t len, size_t offset)
{

#if 0
#define	DSP2_IMG	"/cache/dsp2_image"

	FILE *fp = fopen(DSP2_IMG, "rb");
	if (fp == NULL)
	{
		printf("%s: fopen err\n", __func__);
		return 0;
	}

	fseek(fp, 0, SEEK_END);
	printf("%s: file len: 0x%x\n", __func__, ftell(fp));

	fseek(fp, offset, SEEK_SET);
	if (fread(data, sizeof(char), len, fp) != len)
	{
		printf("%s: fread err\n", __func__);
		return 0;
	}

	fclose(fp);
	return len;
#else
	size_t block_size = rbf->flash_block_size;
	size_t bad_offset = offset;
	size_t block_align;
	size_t block_offset;
	size_t total_size;
	char *buf;
    ssize_t count;
	nand_bad_rec *p;
	//unsigned int old = 0; /* 2016/3/14 deled by tommy for bad block bug */

	sam_list_for_each(p, &rbf->bad_block_list, nand_bad_rec)
	{
		if (p->addr_off <= bad_offset)
		{
			//old = p->bad_num; /* 2016/3/14 deled by tommy for bad block bug */
			bad_offset += block_size;
		}
		else if (p->addr_off > bad_offset)
		{
			break;
		}
	}
	//bad_offset  = offset + old * block_size; /* 2016/3/14 deled by tommy for bad block bug */
	block_align = bad_offset / block_size;
	block_offset = bad_offset % block_size;
	total_size = len + block_offset;

	//printf("%s: offset: 0x%x bad_offset: 0x%x line_offset: 0x%x\n", \
			__func__, offset, bad_offset / block_size, offset / block_size);

	MtdReadContext *read = mtd_read_partition(rbf->mtd_part);
	if (read == NULL)
	{
		printf("%s: Can't open misc err\n", __func__);
		return 0;
	}

	buf = malloc(total_size);
	if (buf == NULL)
	{
		printf("%s: malloc buffer(0x%x) err\n", __func__, total_size);
		mtd_read_close(read);
		return 0;
	}

	mtd_read_skip_to(read, (block_align * block_size));
	count = mtd_read_data(read, buf, total_size);
	if (count != total_size)
	{
		printf("%s: Can't read err\n", __func__);
		free(buf);
		mtd_read_close(read);
		return 0;
	}
	memcpy(data, buf+block_offset, len);
	free(buf);
	mtd_read_close(read);
    return len;
#endif
}

ssize_t mtd_write_data_offset(redbend_fota *rbf, char *data, size_t len, size_t offset)
{
#if 0

	FILE *fp = fopen(DSP2_IMG, "rb+");
	if (fp == NULL)
	{
		printf("%s: fopen err\n", __func__);
		return 0;
	}

	fseek(fp, 0, SEEK_END);
	printf("%s: file len: 0x%x\n", __func__, ftell(fp));

	fseek(fp, offset, SEEK_SET);
	if (fwrite(data, sizeof(char), len, fp) != len)
	{
		printf("%s: fwrite err\n", __func__);
		return 0;
	}

	fclose(fp);
	return len;
#else
	size_t block_size = rbf->flash_block_size;
	size_t bad_offset = offset;
	size_t block_align;
	size_t block_offset;
	size_t total_size;
	char *buf;
    ssize_t count;
	MtdReadContext *read;
	MtdWriteContext *write;
	nand_bad_rec *p;
	//unsigned int old = 0;/* 2016/3/14 deled by tommy for bad block bug */

	sam_list_for_each(p, &rbf->bad_block_list, nand_bad_rec)
	{
		if (p->addr_off <= bad_offset)
		{
			//old = p->bad_num; /* 2016/3/14 deled by tommy for bad block bug */
			bad_offset += block_size;
		}
		else if (p->addr_off > bad_offset)
		{
			break;
		}
	}

	//bad_offset = offset + old * block_size; /* 2016/3/14 deled by tommy for bad block bug */
	block_align = bad_offset / block_size;
	block_offset = bad_offset % block_size;
	total_size = len + block_offset;

	//printf("%s: offset: 0x%x bad_offset: 0x%x line_offset: 0x%x\n", \
			__func__, offset, bad_offset / block_size, offset / block_size);

	read = mtd_read_partition(rbf->mtd_part);
	if (read == NULL)
	{
		printf("%s: Can't open %s read err\n", __func__, rbf->update_name);
		return 0;
	}

	buf = malloc(total_size);
	if (buf == NULL)
	{
		printf("%s: malloc buffer(0x%x) err\n", __func__, total_size);
		mtd_read_close(read);
		return 0;
	}

	mtd_read_skip_to(read, block_align * block_size);
	count = mtd_read_data(read, buf, block_offset);
	if (count != block_offset)
	{
		printf("%s: Can't read err\n", __func__);
		mtd_read_close(read);
		free(buf);
		return 0;
	}
	memcpy(buf + block_offset, data, len);
	mtd_read_close(read);

	write = mtd_write_partition(rbf->mtd_part);
	if (write == NULL)
	{
		printf("%s: Can't open %s write err\n", __func__, rbf->update_name);
		free(buf);
		return 0;
	}

	mtd_write_skip_to(write, block_align * block_size);
	count = mtd_write_data(write, buf, total_size);
	if (count != total_size)
	{
		printf("%s: Can't write err\n", __func__);
		mtd_write_close(write);
		free(buf);
		return 0;
	}

	mtd_write_close(write);
	free(buf);
    return len;
#endif
}

#define QUECTEL_USBSTAT_LEN	64
static int quec_usb_online=0;

void urc_to_ttygs_modem(char *buf)
{
	//static FILE *fp = NULL;
	static int fp=0;
	FILE *fp_stat =NULL;
	char stat[QUECTEL_USBSTAT_LEN];
	
	if(0 == quec_usb_online){
		fp_stat = fopen("/sys/kernel/debug/msm_otg/otg_state","r");
		if(fp_stat){
                fread(stat,QUECTEL_USBSTAT_LEN,1,fp_stat);
                	if(0 != strncmp(stat,"b_peripheral",12)){
                        	fclose(fp_stat);
                        	return;
                	}
			quec_usb_online = 1;
                	fclose(fp_stat);
        	}
        	else
                	return;
	}

	//if (fp == NULL)
	if(!fp)
	{
		//fp = fopen("/dev/ttyGS1", "w");
		fp = open("/dev/ttyGS1",O_WRONLY | O_NONBLOCK);
		//if (fp == NULL)
		if(!fp)
		{
			printf("RB_Progress: fopen \"/dev/ttyGS1\" fail\n");
			return;
		}
	}
	//if (fwrite(buf, sizeof(char), strlen(buf), fp) != strlen(buf))
	if(write(fp,buf,strlen(buf)) != strlen(buf))
	{
		printf("RB_Progress: fwrite \"/dev/ttyGS1\" fail\n");
		close(fp);
		fp = open("/dev/ttyGS1",O_WRONLY | O_NONBLOCK);
		if(!fp)
                {
                        printf("RB_Progress: fopen \"/dev/ttyGS1\" fail\n");
                        return;
                }
	}

#if 0
	fp = fopen("/dev/ttyGS2", "w");
	if (fp == NULL)
	{
		printf("RB_Progress: fopen \"/dev/ttyGS2\" fail\n");
		return;
	}
	if (fwrite(buf, sizeof(char), strlen(buf), fp) != strlen(buf))
	{
		printf("RB_Progress: fwrite \"/dev/ttyGS2\" fail\n");
	}
	fclose(fp);
#endif
}
