/*
 * Copyright (C) 2008, The Android Open Source Project
 * Copyright (c) 2011, The Linux Foundation. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.bluetooth;

import android.bluetooth.IBluetoothCallback;
import android.os.ParcelUuid;
import android.bluetooth.IBluetoothGattService;

/**
 * System private API for talking with the Bluetooth service.
 *
 * {@hide}
 */
interface IBluetooth
{
    boolean isEnabled();
    int getBluetoothState();
    boolean enable();
    boolean disable(boolean persistSetting);

    String getAddress();
    String getName();
    String getCOD();
    boolean setName(in String name);

    int getScanMode();
    boolean setScanMode(int mode, int duration);

    int getDiscoverableTimeout();
    boolean setDiscoverableTimeout(int timeout);

    boolean startDiscovery();
    boolean cancelDiscovery();
    boolean isDiscovering();
    byte[] readOutOfBandData();

    boolean createBond(in String address);
    boolean createBondOutOfBand(in String address, in byte[] hash, in byte[] randomizer);
    boolean cancelBondProcess(in String address);
    boolean removeBond(in String address);
    String[] listBonds();
    int getBondState(in String address);
    boolean setDeviceOutOfBandData(in String address, in byte[] hash, in byte[] randomizer);
    boolean setBluetoothClass(String address, int classOfDevice);

    String getRemoteName(in String address);
    int getRemoteClass(in String address);
    ParcelUuid[] getRemoteUuids(in String address);
    boolean fetchRemoteUuids(in String address, in ParcelUuid uuid, in IBluetoothCallback callback);
    int getRemoteServiceChannel(in String address, in ParcelUuid uuid);
    int getRemoteL2capPsm(in String address, in ParcelUuid uuid);
    String getRemoteFeature(String address, String feature);
    boolean setPin(in String address, in byte[] pin);
    boolean setPasskey(in String address, int passkey);
    boolean setPairingConfirmation(in String address, boolean confirm);
    boolean setRemoteOutOfBandData(in String addres);
    boolean cancelPairingUserInput(in String address);

    boolean setTrust(in String address, in boolean value);
    boolean getTrustState(in String address);
    boolean isBluetoothDock(in String address);

    int addRfcommServiceRecord(in String serviceName, in ParcelUuid uuid, int channel, IBinder b);
    void removeServiceRecord(int handle);

    boolean connectHeadset(String address);
    boolean disconnectHeadset(String address);
    boolean notifyIncomingConnection(String address);

    int registerEl2capConnection(in IBluetoothCallback callback, in int ampPolicy);
    void deregisterEl2capConnection(in int handle);
    int getEffectiveAmpPolicy(in int policy);
    boolean setDesiredAmpPolicy(in int handle, in int policy);
    void setUseWifiForBtTransfers(in boolean useWifi);

    boolean getGattServices(in String address, in ParcelUuid uuid);
    String getGattServiceName(in String path);
    boolean discoverCharacteristics(in String path);
    String getGattServiceProperty(in String path, in String property);
    String[] getCharacteristicProperties(in String path);
    boolean setCharacteristicProperty(in String path, in String key, in byte[] value, boolean reliable);
    boolean registerCharacteristicsWatcher(in String path, in IBluetoothGattService gattCallback);
    boolean updateCharacteristicValue(in String path);
    boolean deregisterCharacteristicsWatcher(in String path);
    void disconnectSap();
    boolean startRemoteGattService(in String path, IBluetoothGattService gattCallback);
    void closeRemoteGattService(in String path);
}
