 /*
  * Copyright (c) 2010-2011, The Linux Foundation. All rights reserved.
  *
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions are
  * met:
  *
  *    * Redistributions of source code must retain the above copyright
  *      notice, this list of conditions and the following disclaimer.
  *    * Redistributions in binary form must reproduce the above
  *      copyright notice, this list of conditions and the following
  *      disclaimer in the documentation and/or other materials provided
  *      with the distribution.
  *    * Neither the name of The Linux Foundation nor the names of its
  *      contributors may be used to endorse or promote products derived
  *      from this software without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
  * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
  * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
  * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
  * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
  * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
  * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  */
package com.android.internal.telephony;

/**
 * See also RIL_SimRefresh in include/telephony/ril.h
 *
 * {@hide}
 */

public class SimRefreshResponse {

    public enum Result{
        SIM_FILE_UPDATE,                       /* Single file updated */
        SIM_INIT,                              /* SIM initialized; reload all apps */
        SIM_RESET;                             /* SIM reset; data update on SIM by Network */
    }

    public Result          refreshResult;      /* Sim Refresh result */
    public int             efId;               /* EFID */
    public String          aidPtr;             /* null terminated string, e.g., from 0xA0, 0x00
                                                  0x41, 0x30*/

    public static Result
        refreshResultFromRIL(int refreshResult) throws ATParseEx {
        switch(refreshResult) {

            case 0: return Result.SIM_FILE_UPDATE;
            case 1: return Result.SIM_INIT;
            case 2: return Result.SIM_RESET;
            default:
                throw new ATParseEx("Sim Refresh response is Unknown " + refreshResult);
        }
    }

    public String toString() {
        return "{" + refreshResult + ", " + aidPtr +", " + efId + "}";
    }
}
