/*
 * quectel start timer driver
 * author:Wythe
 * date:2015/09/28
 */

#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/fs.h>
#include <linux/cdev.h>
#include <linux/device.h>
#include <linux/wait.h>
#include <linux/sched.h>
#include <linux/miscdevice.h>
#include <linux/workqueue.h>
#include <linux/uaccess.h>
#include <mach/msm_smsm.h>
#include <linux/mtd/mtd.h>
#include <linux/slab.h>
#include <linux/reboot.h>

#define QUEC_START_TIMER_TOUT	30

struct qstart_device_t{
	struct miscdevice misc;
};

static struct mtd_info *mtd = NULL;
static loff_t qfirst_goodblock_addr = 0;

struct qstart_device_t *qstart_devp;
struct timer_list qstart_poll_timer;
struct work_struct qstart_timer_work;

static DEFINE_MUTEX(qstart_timer_lock);

static int start_mode_set(const char *val, struct kernel_param *kp);
static int start_mode = 0;
module_param_call(start_mode, start_mode_set, param_get_int, &start_mode, 0644);

static int start_mode_set(const char *val, struct kernel_param *kp)
{
	int ret;

	ret = param_set_int(val,kp);

	if(ret)
		return ret;
	
	return 0;
}

static void qstart_poll_timer_cb(void)
{
    static unsigned int count = 0;

	mutex_lock(&qstart_timer_lock);
	count++;
    if(count >=  QUEC_START_TIMER_TOUT && 0 == start_mode)
    {
		printk("\n\n\nStart mode = %d, count=%d\n\n\n", start_mode,count);
		schedule_work(&qstart_timer_work);	
   		//panic("Quec Start Timer error!");     
    }
	mutex_unlock(&qstart_timer_lock);

	if(1 == start_mode)
		del_timer(&qstart_poll_timer);
	else
 		mod_timer(&qstart_poll_timer,jiffies + HZ);
}

static struct qstart_device_t qstart_device = {
	.misc = {
		.minor = MISC_DYNAMIC_MINOR,
		.name = "qstart",
	}
};

unsigned int qstart_timer_set_cookie(void)
{
	unsigned char *onepage = NULL;
	struct erase_info ei;
	size_t write = 0;
	int err,i;
	int ret = 0;
	uint64_t tmp;

	mtd = get_mtd_device_nm("fota");
	if(IS_ERR(mtd))
	{
		printk("get fota mtd fail.");
		return 0;
	}
	else{
		tmp = mtd->size;
		printk("qstart:mtdsize:%llx\n", tmp);
		do_div(tmp, mtd->erasesize);
		for(i=0;i<tmp;i++)
		{
			qfirst_goodblock_addr = i * mtd->erasesize;
			if(!mtd->block_isbad(mtd,qfirst_goodblock_addr))	
				break;
		}

		onepage = kmalloc(mtd->writesize, GFP_KERNEL);
		if(NULL == onepage)
		{
			printk("memory is not enough to onepage\n");
			return ret;
		}
		/*setting fota cookie*/
		onepage[0] = 0x43;
		onepage[1] = 0x53;
		onepage[2] = 0x64;
		onepage[3] = 0x64;
		/*setting erase cookie*/
		onepage[4] = 0x44;
		onepage[5] = 0x33;
		onepage[6] = 0x44;
		onepage[7] = 0x33;

		memset(&ei, 0, sizeof(struct erase_info));
		ei.mtd = mtd;
		ei.addr = qfirst_goodblock_addr;
		ei.len = mtd->erasesize;

		err = mtd->erase(mtd, &ei);

		err = mtd->write(mtd, qfirst_goodblock_addr, mtd->writesize, &write, onepage);
		if(err || write != mtd->writesize)
		{
			printk("%s:%d write mtd failed at %#llx\n", __func__, __LINE__,(long long)qfirst_goodblock_addr);
			goto exit;
		}
	}	
	ret = 1;
exit:
	if(onepage != NULL)
	{
		kfree(onepage);
		onepage = NULL;
	}
	return ret;
}

EXPORT_SYMBOL(qstart_timer_set_cookie);

static void qstart_timer_handle(struct work_struct *work)
{
	unsigned char *onepage = NULL;
	struct erase_info ei;
	size_t write = 0;
	int err,i;
	uint64_t tmp;

	mtd = get_mtd_device_nm("fota");
	if(IS_ERR(mtd))
	{
		printk("get fota mtd fail.");
		return;
	}
	else{
		tmp = mtd->size;
		printk("qstart:mtdsize:%llx\n", tmp);
		do_div(tmp, mtd->erasesize);
		for(i=0;i<tmp;i++)
		{
			qfirst_goodblock_addr = i * mtd->erasesize;
			if(!mtd->block_isbad(mtd,qfirst_goodblock_addr))	
				break;
		}

		onepage = kmalloc(mtd->writesize, GFP_KERNEL);
		if(NULL == onepage)
		{
			printk("memory is not enough to onepage\n");
			return;
		}
		/*setting fota cookie*/
		onepage[0] = 0x43;
		onepage[1] = 0x53;
		onepage[2] = 0x64;
		onepage[3] = 0x64;
		/*setting erase cookie*/
		onepage[4] = 0x44;
		onepage[5] = 0x33;
		onepage[6] = 0x44;
		onepage[7] = 0x33;

		memset(&ei, 0, sizeof(struct erase_info));
		ei.mtd = mtd;
		ei.addr = qfirst_goodblock_addr;
		ei.len = mtd->erasesize;

		err = mtd->erase(mtd, &ei);

		err = mtd->write(mtd, qfirst_goodblock_addr, mtd->writesize, &write, onepage);
		if(err || write != mtd->writesize)
		{
			printk("%s:%d write mtd failed at %#llx\n", __func__, __LINE__,(long long)qfirst_goodblock_addr);
			return;
		}
	}	
	machine_restart("recovery");
}

static void __exit qstart_exit(void)
{
	misc_deregister(&qstart_device.misc);
}

static int __init qstart_init(void)
{
	int ret;

	qstart_devp = &qstart_device;
	init_timer(&qstart_poll_timer);
                qstart_poll_timer.function = (void *)qstart_poll_timer_cb; 
                qstart_poll_timer.expires = jiffies + HZ;
                add_timer(&qstart_poll_timer);
	
	INIT_WORK(&qstart_timer_work, qstart_timer_handle);		
	
	ret = misc_register(&qstart_device.misc);

	return ret;
}

module_init(qstart_init);
module_exit(qstart_exit);

MODULE_DESCRIPTION("QUECTEL Start Driver");
MODULE_LICENSE("GPL v2");

