/*
 * nau8814.h  --  NAU8814 Soc Audio driver
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _NAU8814_H
#define _NAU8814_H

// Configuration Register Defines.
#define CFG_SOFTWARE_RESET    (0x000)
#define CFG_POWER_MANAGEMENT1 (0x001)
#define CFG_POWER_MANAGEMENT2	(0x002)
#define CFG_POWER_MANAGEMENT3 (0x003)
#define CFG_AUDIO_INTERFACE	  (0x004)
#define CFG_COMPANDING_CTRL   (0x005)
#define CFG_CLK_GEN_CTRL	    (0x006)
#define CFG_ADDITIONAL_CTRL	  (0x007)
#define CFG_GPIO 			        (0x008)
#define CFG_JACK_DETECT_CTRL1 (0x009)
#define CFG_DAC_CTRL		      (0x00A)
#define CFG_LEFT_DAC_DIGITAL_VOL  (0x00B)
#define CFG_RIGHT_DAC_DIGITAL_VOL (0x00C)
#define CFG_JACK_DETECT_CTRL2  	  (0x00D)
#define CFG_ADC_CTRL		  	  (0x00E)
#define CFG_LEFT_ADC_DIGITAL_VOL  (0x00F)
#define CFG_RIGHT_ADC_DIGITAL_VOL (0x010)
#define CFG_EQ1_SHELF_LOW   	(0x012)
#define CFG_EQ2_PEAK1 			  (0x013)
#define CFG_EQ3_PEAK2 			  (0x014)
#define CFG_EQ4_PEAK3			    (0x015)
#define CFG_EQ5_HIGH_SHELF		(0x016)
#define CFG_DAC_LIMITER1		  (0x018)
#define CFG_DAC_LIMITER2 		  (0x019)
#define CFG_NOTCH_FILTER1		  (0x01B)
#define CFG_NOTCH_FILTER2 		(0x01C)
#define CFG_NOTCH_FILTER3 		(0x01D)
#define CFG_NOTCH_FILTER4     (0x01E)
#define CFG_ALC_CTRL1			    (0x020)
#define CFG_ALC_CTRL2 			  (0x021)
#define CFG_ALC_CTRL3 			  (0x022)
#define CFG_NOISE_GATE 	(0x023)
#define CFG_PLLN		    (0x024)
#define CFG_PLL_K1	  	(0x025)
#define CFG_PLL_K2 	  	(0x026)
#define CFG_PLL_K3 	  	(0x027)
#define CFG_ATTENUATION_CTRL	  (0x028)
#define CFG_3D_CONTROL   (0x029)
#define CFG_BEEP_CONTROL (0x02B)
#define CFG_INPUT_CTRL   (0x02C)
#define CFG_LEFT_INP_PGA_GAIN_CTRL  (0x02D)
#define CFG_RIGHT_INP_PGA_GAIN_CTRL (0x02E)
#define CFG_LEFT_ADC_BOOST_CTRL     (0x02F)
#define CFG_RIGHT_ADC_BOOST_CTRL 	(0x030)
#define CFG_OUTPUT_CTRL			      (0x031)
#define CFG_LEFT_MIXER_CTRL		  	(0x032)
#define CFG_RIGHT_MIXER_CTRL 	  	(0x033)
//LOUT1 --> HP-,ROUT1 --> HP+,LOUT2 --> SPKOUT-,ROUT2 --> SPKOUT+,OUT3 --> AUXOUT2,OUT4 --> AUXOUT1
#define CFG_LOUT1_HP_VOLUME_CTRL		(0x034)
#define CFG_ROUT1_HP_VOLUME_CTRL 		(0x035)
#define CFG_LOUT2_SPKR_VOLUME_CTRL	(0x036)
#define CFG_ROUT2_SPKR_VOLUME_CTRL 	(0x037)
#define CFG_OUT3_MIXER_CTRL (0x038)
#define CFG_OUT4_MIXER_CTRL (0x039)


/* NAU8814 register space */

#define NAU8814_RESET	  	0x0
#define NAU8814_POWER1		0x1
#define NAU8814_POWER2		0x2
#define NAU8814_POWER3		0x3
#define NAU8814_IFACE		  0x4
#define NAU8814_COMP			0x5
#define NAU8814_CLOCK	  	0x6
#define NAU8814_ADD		  	0x7
#define NAU8814_GPIO			0x8
#define NAU8814_DAC			  0xa
#define NAU8814_DACVOL		0xb
#define NAU8814_ADC			  0xe
#define NAU8814_ADCVOL		0xf
#define NAU8814_EQ1			  0x12
#define NAU8814_EQ2			  0x13
#define NAU8814_EQ3		  	0x14
#define NAU8814_EQ4		  	0x15
#define NAU8814_EQ5		  	0x16
#define NAU8814_DACLIM1		0x18
#define NAU8814_DACLIM2		0x19
#define NAU8814_NOTCH1		0x1b
#define NAU8814_NOTCH2		0x1c
#define NAU8814_NOTCH3		0x1d
#define NAU8814_NOTCH4		0x1e
#define NAU8814_ALC1			0x20
#define NAU8814_ALC2			0x21
#define NAU8814_ALC3			0x22
#define NAU8814_NGATE		  0x23
#define NAU8814_PLLN			0x24
#define NAU8814_PLLK1		  0x25
#define NAU8814_PLLK2		  0x26
#define NAU8814_PLLK3		  0x27
#define NAU8814_ATTEN		  0x28
#define NAU8814_INPUT		  0x2c
#define NAU8814_INPPGA		0x2d
#define NAU8814_ADCBOOST	0x2f
#define NAU8814_OUTPUT		0x31
#define NAU8814_SPKMIX		0x32
#define NAU8814_SPKVOL		0x36
#define NAU8814_MONOMIX		0x38
#define NAU8814_2WID		0x3f

#define NAU8814_CACHEREGNUM 	0x4f

/* Clock divider Id's */
#define NAU8814_OPCLKDIV		0
#define NAU8814_MCLKDIV	  	1
#define NAU8814_ADCCLK	  	2
#define NAU8814_DACCLK	  	3
#define NAU8814_BCLKDIV		  4

/* DAC clock dividers */
#define NAU8814_DACCLK_F2	  (1 << 3)
#define NAU8814_DACCLK_F4	  (0 << 3)

/* ADC clock dividers */
#define NAU8814_ADCCLK_F2	  (1 << 3)
#define NAU8814_ADCCLK_F4	  (0 << 3)

/* PLL Out dividers */
#define NAU8814_OPCLKDIV_1	(0 << 4)
#define NAU8814_OPCLKDIV_2	(1 << 4)
#define NAU8814_OPCLKDIV_3	(2 << 4)
#define NAU8814_OPCLKDIV_4	(3 << 4)

/* BCLK clock dividers */
#define NAU8814_BCLKDIV_1	  (0 << 2)
#define NAU8814_BCLKDIV_2	  (1 << 2)
#define NAU8814_BCLKDIV_4	  (2 << 2)
#define NAU8814_BCLKDIV_8	  (3 << 2)
#define NAU8814_BCLKDIV_16	(4 << 2)
#define NAU8814_BCLKDIV_32	(5 << 2)

/* MCLK clock dividers */
#define NAU8814_MCLKDIV_1	  (0 << 5)
#define NAU8814_MCLKDIV_1_5	(1 << 5)
#define NAU8814_MCLKDIV_2	  (2 << 5)
#define NAU8814_MCLKDIV_3	  (3 << 5)
#define NAU8814_MCLKDIV_4	  (4 << 5)
#define NAU8814_MCLKDIV_6  	(5 << 5)
#define NAU8814_MCLKDIV_8 	(6 << 5)
#define NAU8814_MCLKDIV_12	(7 << 5)

#define NAU8814_DEV_NAME    "nau8814-codec"

#endif

