# Let bitbake use the following env-vars as if they were pre-set bitbake ones.
# (BBLAYERS is explicitly blocked from this within OE-Core itself, though...)

if [ ! -f  "build/conf/wind_to_linux.txt" ];then
cd ../../
for file in `find . -name "*.c__" -or -name "*.h__" -or -name "*.s__"`
do
	tmp="`echo $file |sed 's/__$//'`"
	echo "fix file "$file" to "$tmp""
	cp "$file" "$tmp"
done

rm -rf apps_proc/oe-core/meta/recipes-extended/ghostscript/ghostscript/i686
ln -s apps_proc/oe-core/meta/recipes-extended/ghostscript/ghostscript/i586/ apps_proc/oe-core/meta/recipes-extended/ghostscript/ghostscript/i686

rm -rf apps_proc/bootable/bootloader/lk/lib/openssl/apps/md4.c
ln -s apps_proc/bootable/bootloader/lk/lib/openssl/crypto/md4/md4.c apps_proc/bootable/bootloader/lk/lib/openssl/apps/md4.c

rm -rf apps_proc/kernel/arch/microblaze/boot/dts/system.dts
if [ ! -d apps_proc/kernel/arch/microblaze/boot/dts ];then
	mkdir -p apps_proc/kernel/arch/microblaze/boot/dts
fi
ln -s apps_proc/kernel/arch/microblaze/platform/generic/system.dts  apps_proc/kernel/arch/microblaze/boot/dts/system.dts
echo 1 > apps_proc/oe-core/build/conf/wind_to_linux.txt
cd -
fi

export BB_ENV_EXTRAWHITE="http_proxy MACHINE DISTRO DL_DIR"
if [[ ! $(readlink $(which sh)) =~ bash ]]
then
  echo ""
  echo "### Please Change your /bin/sh symlink to point to bash. ### "
  echo ""
  echo "### sudo ln -sf /bin/bash /bin/sh ### "
  echo ""
  export SHELL=/bin/bash
fi
umask 022
unset MACHINE

# Find where the global conf directory is...
scriptdir="$(dirname "${BASH_SOURCE}")"
# Find where the workspace is...
WS=$(readlink -f $scriptdir/../../..)

# Dynamically generate our bblayers.conf since we effectively can't whitelist
# BBLAYERS (by OE-Core class policy...Bitbake understands it...) to support
# dynamic workspace layer functionality.
python $scriptdir/get_bblayers.py ${WS}/oe-core \"meta*\" > $scriptdir/bblayers.conf

# Convienence function provided for backwards compat with the
# earlier versions of the QuIC provided OE Linux distro.
build9615() {
  export MACHINE=9615-cdp
  bitbake 9615-cdp-image && \
  bitbake 9615-cdp-recovery-image
}

build9625() {
  export MACHINE=mdm9625
  bitbake mdm-image
}

build8655() {
  export MACHINE=msm8655
  bitbake msm-x11-image
}

build7627a() {
  export MACHINE=msm7627a
  bitbake msm-x11-image
}

# Yocto/OE-core works a bit differently than OE-classic so we're
# going to source the OE build environment setup script they provided.  
# This will dump the user in ${WS}/yocto/build, ready to run the 
# convienence function or straight up bitbake commands.
. ${WS}/oe-core/oe-init-build-env



