/*
 * Copyright (c) 2011-2015 The Linux Foundation. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This file was originally distributed by Qualcomm Atheros, Inc.
 * under proprietary terms before Copyright ownership was assigned
 * to the Linux Foundation.
 */

/*
 * DO NOT EDIT - This file is generated automatically
 */

/*
 * IMPORTANT:  This file is for system that supports STA mode ONLY.
 */


#ifndef __WNICFGSTA_H
#define __WNICFGSTA_H

/*
 * Configuration Parameter ID for STA
 */

#define WNI_CFG_STA_ID    0
#define WNI_CFG_CFP_PERIOD    2
#define WNI_CFG_CFP_MAX_DURATION    3
#define WNI_CFG_SSID    4
#define WNI_CFG_BEACON_INTERVAL    5
#define WNI_CFG_DTIM_PERIOD    6
#define WNI_CFG_WEP_KEY_LENGTH    7
#define WNI_CFG_WEP_DEFAULT_KEY_TABLE    8
#define WNI_CFG_WEP_DEFAULT_KEY_TABLE_ROW    4
#define WNI_CFG_WEP_DEFAULT_KEY_TABLE_COL    1
#define WNI_CFG_WEP_DEFAULT_KEY_1    8
#define WNI_CFG_WEP_DEFAULT_KEY_2    9
#define WNI_CFG_WEP_DEFAULT_KEY_3    10
#define WNI_CFG_WEP_DEFAULT_KEY_4    11
#define WNI_CFG_WEP_DEFAULT_KEYID    12
#define WNI_CFG_EXCLUDE_UNENCRYPTED    13
#define WNI_CFG_RTS_THRESHOLD    14
#define WNI_CFG_SHORT_RETRY_LIMIT    15
#define WNI_CFG_LONG_RETRY_LIMIT    16
#define WNI_CFG_FRAGMENTATION_THRESHOLD    17
#define WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME    18
#define WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME    19
#define WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME    20
#define WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME    21
#define WNI_CFG_JOIN_FAILURE_TIMEOUT    22
#define WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT    23
#define WNI_CFG_AUTHENTICATE_RSP_TIMEOUT    24
#define WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT    25
#define WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT    26
#define WNI_CFG_RA_PERIODICITY_TIMEOUT_IN_PS    27
#define WNI_CFG_PS_ENABLE_BCN_FILTER    28
#define WNI_CFG_PS_ENABLE_HEART_BEAT    29
#define WNI_CFG_PS_ENABLE_RSSI_MONITOR    30
#define WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT    31
#define WNI_CFG_RF_SETTLING_TIME_CLK    32
#define WNI_CFG_SUPPORTED_RATES_11B    33
#define WNI_CFG_SUPPORTED_RATES_11A    34
#define WNI_CFG_PHY_MODE    35
#define WNI_CFG_DOT11_MODE    36
#define WNI_CFG_OPERATIONAL_RATE_SET    37
#define WNI_CFG_EXTENDED_OPERATIONAL_RATE_SET    38
#define WNI_CFG_PROPRIETARY_OPERATIONAL_RATE_SET    39
#define WNI_CFG_LISTEN_INTERVAL    40
#define WNI_CFG_VALID_CHANNEL_LIST    41
#define WNI_CFG_CURRENT_CHANNEL    42
#define WNI_CFG_DEFAULT_RATE_INDEX_5GHZ    43
#define WNI_CFG_DEFAULT_RATE_INDEX_24GHZ    44
#define WNI_CFG_RATE_ADAPTATION_TYPE    45
#define WNI_CFG_FIXED_RATE    46
#define WNI_CFG_FIXED_RATE_MULTICAST_24GHZ    47
#define WNI_CFG_FIXED_RATE_MULTICAST_5GHZ    48
#define WNI_CFG_RETRYRATE_POLICY    49
#define WNI_CFG_RETRYRATE_SECONDARY    50
#define WNI_CFG_RETRYRATE_TERTIARY    51
#define WNI_CFG_APSD_ENABLED    52
#define WNI_CFG_SHARED_KEY_AUTH_ENABLE    53
#define WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE    54
#define WNI_CFG_AUTHENTICATION_TYPE    55
#define WNI_CFG_PRIVACY_ENABLED    57
#define WNI_CFG_SHORT_PREAMBLE    58
#define WNI_CFG_SHORT_SLOT_TIME    59
#define WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY    60
#define WNI_CFG_QOS_ENABLED    61
#define WNI_CFG_HCF_ENABLED    62
#define WNI_CFG_RSN_ENABLED    63
#define WNI_CFG_BACKGROUND_SCAN_PERIOD    64
#define WNI_CFG_MAX_NUM_PRE_AUTH    65
#define WNI_CFG_HEART_BEAT_THRESHOLD    68
#define WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT    69
#define WNI_CFG_MANUFACTURER_OUI    70
#define WNI_CFG_MANUFACTURER_NAME    71
#define WNI_CFG_MODEL_NUMBER    72
#define WNI_CFG_MODEL_NAME    73
#define WNI_CFG_MANUFACTURER_PRODUCT_NAME    74
#define WNI_CFG_MANUFACTURER_PRODUCT_VERSION    75
#define WNI_CFG_11D_ENABLED    76
#define WNI_CFG_MAX_TX_POWER_2_4    77
#define WNI_CFG_MAX_TX_POWER_5    78
#define WNI_CFG_NETWORK_DENSITY    79
#define WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM    80
#define WNI_CFG_CURRENT_TX_ANTENNA    81
#define WNI_CFG_CURRENT_RX_ANTENNA    82
#define WNI_CFG_CURRENT_TX_POWER_LEVEL    83
#define WNI_CFG_NEW_BSS_FOUND_IND    84
#define WNI_CFG_PROPRIETARY_RATES_ENABLED    85
#define WNI_CFG_COUNTRY_CODE    87
#define WNI_CFG_11H_ENABLED    88
#define WNI_CFG_WT_CNF_TIMEOUT    89
#define WNI_CFG_KEEPALIVE_TIMEOUT    90
#define WNI_CFG_PROXIMITY    91
#define WNI_CFG_LOG_LEVEL    92
#define WNI_CFG_OLBC_DETECT_TIMEOUT    93
#define WNI_CFG_PROTECTION_ENABLED    94
#define WNI_CFG_11G_PROTECTION_ALWAYS    95
#define WNI_CFG_FORCE_POLICY_PROTECTION    96
#define WNI_CFG_11G_SHORT_PREAMBLE_ENABLED    97
#define WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED    98
#define WNI_CFG_11G_ONLY_POLICY    99
#define WNI_CFG_PACKET_CLASSIFICATION    100
#define WNI_CFG_WME_ENABLED    101
#define WNI_CFG_ADDTS_RSP_TIMEOUT    102
#define WNI_CFG_MAX_SP_LENGTH    103
#define WNI_CFG_SEND_SINGLE_SSID_ALWAYS    105
#define WNI_CFG_WSM_ENABLED    106
#define WNI_CFG_EDCA_PROFILE    107
#define WNI_CFG_EDCA_ANI_ACBK_LOCAL    108
#define WNI_CFG_EDCA_ANI_ACBE_LOCAL    109
#define WNI_CFG_EDCA_ANI_ACVI_LOCAL    110
#define WNI_CFG_EDCA_ANI_ACVO_LOCAL    111
#define WNI_CFG_EDCA_ANI_ACBK    112
#define WNI_CFG_EDCA_ANI_ACBE    113
#define WNI_CFG_EDCA_ANI_ACVI    114
#define WNI_CFG_EDCA_ANI_ACVO    115
#define WNI_CFG_EDCA_WME_ACBK_LOCAL    116
#define WNI_CFG_EDCA_WME_ACBE_LOCAL    117
#define WNI_CFG_EDCA_WME_ACVI_LOCAL    118
#define WNI_CFG_EDCA_WME_ACVO_LOCAL    119
#define WNI_CFG_EDCA_WME_ACBK    120
#define WNI_CFG_EDCA_WME_ACBE    121
#define WNI_CFG_EDCA_WME_ACVI    122
#define WNI_CFG_EDCA_WME_ACVO    123
#define WNI_CFG_RDET_FLAG    124
#define WNI_CFG_RADAR_CHANNEL_LIST    125
#define WNI_CFG_LOCAL_POWER_CONSTRAINT    126
#define WNI_CFG_ADMIT_POLICY    127
#define WNI_CFG_ADMIT_BWFACTOR    128
#define WNI_CFG_MAX_CONSECUTIVE_BACKGROUND_SCAN_FAILURE    129
#define WNI_CFG_CHANNEL_BONDING_MODE    130
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE    131
#define WNI_CFG_DYNAMIC_THRESHOLD_ZERO    132
#define WNI_CFG_DYNAMIC_THRESHOLD_ONE    133
#define WNI_CFG_DYNAMIC_THRESHOLD_TWO    134
#define WNI_CFG_TRIG_STA_BK_SCAN    135
#define WNI_CFG_DYNAMIC_PROFILE_SWITCHING    136
#define WNI_CFG_SCAN_CONTROL_LIST    137
#define WNI_CFG_MIMO_ENABLED    138
#define WNI_CFG_BLOCK_ACK_ENABLED    139
#define WNI_CFG_BA_ACTIVITY_CHECK_TIMEOUT    140
#define WNI_CFG_HT_RX_STBC    141
#define WNI_CFG_HT_CAP_INFO    142
#define WNI_CFG_HT_AMPDU_PARAMS    143
#define WNI_CFG_SUPPORTED_MCS_SET    144
#define WNI_CFG_EXT_HT_CAP_INFO    145
#define WNI_CFG_TX_BF_CAP    146
#define WNI_CFG_AS_CAP    147
#define WNI_CFG_HT_INFO_FIELD1    148
#define WNI_CFG_HT_INFO_FIELD2    149
#define WNI_CFG_HT_INFO_FIELD3    150
#define WNI_CFG_BASIC_MCS_SET    151
#define WNI_CFG_CURRENT_MCS_SET    152
#define WNI_CFG_GREENFIELD_CAPABILITY    153
#define WNI_CFG_VHT_MAX_MPDU_LENGTH    154
#define WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET    155
#define WNI_CFG_VHT_LDPC_CODING_CAP    156
#define WNI_CFG_VHT_SHORT_GI_80MHZ    157
#define WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ    158
#define WNI_CFG_VHT_TXSTBC    159
#define WNI_CFG_VHT_RXSTBC    160
#define WNI_CFG_VHT_SU_BEAMFORMER_CAP    161
#define WNI_CFG_VHT_SU_BEAMFORMEE_CAP    162
#define WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED    163
#define WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS    164
#define WNI_CFG_VHT_MU_BEAMFORMER_CAP    165
#define WNI_CFG_VHT_MU_BEAMFORMEE_CAP    166
#define WNI_CFG_VHT_TXOP_PS    167
#define WNI_CFG_VHT_HTC_VHTC_CAP    168
#define WNI_CFG_VHT_AMPDU_LEN_EXPONENT    169
#define WNI_CFG_VHT_LINK_ADAPTATION_CAP    170
#define WNI_CFG_VHT_RX_ANT_PATTERN    171
#define WNI_CFG_VHT_TX_ANT_PATTERN    172
#define WNI_CFG_VHT_RX_MCS_MAP    173
#define WNI_CFG_VHT_TX_MCS_MAP    174
#define WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE    175
#define WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE    176
#define WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT1    177
#define WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT2    178
#define WNI_CFG_VHT_BASIC_MCS_SET    179
#define WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT    180
#define WNI_CFG_VHT_SS_UNDER_UTIL    181
#define WNI_CFG_VHT_40MHZ_UTILIZATION    182
#define WNI_CFG_VHT_80MHZ_UTILIZATION    183
#define WNI_CFG_VHT_160MHZ_UTILIZATION    184
#define WNI_CFG_MAX_AMSDU_LENGTH    185
#define WNI_CFG_MPDU_DENSITY    186
#define WNI_CFG_NUM_BUFF_ADVERT    187
#define WNI_CFG_MAX_RX_AMPDU_FACTOR    188
#define WNI_CFG_SHORT_GI_20MHZ    189
#define WNI_CFG_SHORT_GI_40MHZ    190
#define WNI_CFG_RIFS_ENABLED    191
#define WNI_CFG_MAX_PS_POLL    192
#define WNI_CFG_NUM_BEACON_PER_RSSI_AVERAGE    193
#define WNI_CFG_RSSI_FILTER_PERIOD    194
#define WNI_CFG_MIN_RSSI_THRESHOLD    195
#define WNI_CFG_NTH_BEACON_FILTER    196
#define WNI_CFG_BROADCAST_FRAME_FILTER_ENABLE    197
#define WNI_CFG_SCAN_IN_POWERSAVE    198
#define WNI_CFG_IGNORE_DTIM    199
#define WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE    200
#define WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE    201
#define WNI_CFG_WOWLAN_DEAUTH_ENABLE    202
#define WNI_CFG_WOWLAN_DISASSOC_ENABLE    203
#define WNI_CFG_WOWLAN_MAX_MISSED_BEACON    204
#define WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD    205
#define WNI_CFG_BA_TIMEOUT    206
#define WNI_CFG_BA_THRESHOLD_HIGH    207
#define WNI_CFG_MAX_BA_BUFFERS    208
#define WNI_CFG_MAX_BA_SESSIONS    209
#define WNI_CFG_BA_AUTO_SETUP    210
#define WNI_CFG_ADDBA_REQ_DECLINE    211
#define WNI_CFG_DEL_ALL_RX_BA_SESSIONS_2_4_G_BTC    212
#define WNI_CFG_BG_SCAN_CHANNEL_LIST    213
#define WNI_CFG_MAX_MEDIUM_TIME    214
#define WNI_CFG_MAX_MPDUS_IN_AMPDU    215
#define WNI_CFG_IBSS_AUTO_BSSID    216
#define WNI_CFG_PROBE_REQ_ADDNIE_FLAG    217
#define WNI_CFG_PROBE_REQ_ADDNIE_DATA    218
#define WNI_CFG_PROBE_RSP_ADDNIE_FLAG    219
#define WNI_CFG_PROBE_RSP_ADDNIE_DATA1    220
#define WNI_CFG_PROBE_RSP_ADDNIE_DATA2    221
#define WNI_CFG_PROBE_RSP_ADDNIE_DATA3    222
#define WNI_CFG_ASSOC_RSP_ADDNIE_FLAG    223
#define WNI_CFG_ASSOC_RSP_ADDNIE_DATA    224
#define WNI_CFG_PROBE_REQ_ADDNP2PIE_FLAG    225
#define WNI_CFG_PROBE_REQ_ADDNP2PIE_DATA    226
#define WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG    227
#define WNI_CFG_PROBE_RSP_BCN_ADDNIE_DATA    228
#define WNI_CFG_WPS_ENABLE    229
#define WNI_CFG_WPS_STATE    230
#define WNI_CFG_WPS_PROBE_REQ_FLAG    231
#define WNI_CFG_WPS_VERSION    232
#define WNI_CFG_WPS_REQUEST_TYPE    233
#define WNI_CFG_WPS_CFG_METHOD    234
#define WNI_CFG_WPS_UUID    235
#define WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY    236
#define WNI_CFG_WPS_PIMARY_DEVICE_OUI    237
#define WNI_CFG_WPS_DEVICE_SUB_CATEGORY    238
#define WNI_CFG_WPS_ASSOCIATION_STATE    239
#define WNI_CFG_WPS_CONFIGURATION_ERROR    240
#define WNI_CFG_WPS_DEVICE_PASSWORD_ID    241
#define WNI_CFG_WPS_ASSOC_METHOD    242
#define WNI_CFG_LOW_GAIN_OVERRIDE    243
#define WNI_CFG_ENABLE_PHY_AGC_LISTEN_MODE    244
#define WNI_CFG_RPE_POLLING_THRESHOLD    245
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC0_REG    246
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC1_REG    247
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC2_REG    248
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC3_REG    249
#define WNI_CFG_NO_OF_ONCHIP_REORDER_SESSIONS    250
#define WNI_CFG_SINGLE_TID_RC    251
#define WNI_CFG_TX_PWR_CTRL_ENABLE    252
#define WNI_CFG_MCAST_BCAST_FILTER_SETTING    253
#define WNI_CFG_BTC_DHCP_BT_SLOTS_TO_BLOCK    254
#define WNI_CFG_DYNAMIC_PS_POLL_VALUE    255
#define WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT    256
#define WNI_CFG_TELE_BCN_WAKEUP_EN    257
#define WNI_CFG_TELE_BCN_TRANS_LI    258
#define WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS    259
#define WNI_CFG_TELE_BCN_MAX_LI    260
#define WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS    261
#define WNI_CFG_BTC_A2DP_DHCP_BT_SUB_INTERVALS    262
#define WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD    263
#define WNI_CFG_ASSOC_STA_LIMIT    264
#define WNI_CFG_SAP_CHANNEL_SELECT_START_CHANNEL    265
#define WNI_CFG_SAP_CHANNEL_SELECT_END_CHANNEL    266
#define WNI_CFG_SAP_CHANNEL_SELECT_OPERATING_BAND    267
#define WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD    268
#define WNI_CFG_ENABLE_CLOSE_LOOP    269
#define WNI_CFG_ENABLE_LTE_COEX    270
#define WNI_CFG_AP_KEEP_ALIVE_TIMEOUT    271
#define WNI_CFG_GO_KEEP_ALIVE_TIMEOUT    272
#define WNI_CFG_ENABLE_MC_ADDR_LIST    273
#define WNI_CFG_ENABLE_UC_FILTER    274
#define WNI_CFG_ENABLE_LPWR_IMG_TRANSITION    275
#define WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED    276
#define WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP    277
#define WNI_CFG_AP_LINK_MONITOR_TIMEOUT    278
#define WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK    279
#define WNI_CFG_TDLS_BUF_STA_ENABLED    280
#define WNI_CFG_TDLS_PUAPSD_INACT_TIME    281
#define WNI_CFG_TDLS_RX_FRAME_THRESHOLD    282
#define WNI_CFG_PMF_SA_QUERY_MAX_RETRIES    283
#define WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL    284
#define WNI_CFG_ENABLE_ADAPT_RX_DRAIN    285
#define WNI_CFG_FLEX_CONNECT_POWER_FACTOR    286
#define WNI_CFG_ANTENNA_DIVESITY    287
#define WNI_CFG_GO_LINK_MONITOR_TIMEOUT    288
#define WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY    289
#define WNI_CFG_CURRENT_RSSI    290
#define WNI_CFG_RTT3_ENABLE    291
#define WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL    292
#define WNI_CFG_TDLS_OFF_CHANNEL_ENABLED    293
#define WNI_CFG_IBSS_ATIM_WIN_SIZE    294
#define WNI_CFG_DFS_MASTER_ENABLED    295
#define WNI_CFG_VHT_ENABLE_TXBF_20MHZ    296
#define WNI_CFG_TDLS_WMM_MODE_ENABLED    297

/*
 * String parameter lengths
 */

#define WNI_CFG_STA_ID_LEN    6
#define WNI_CFG_SSID_LEN    32
#define WNI_CFG_WEP_DEFAULT_KEY_1_LEN    13
#define WNI_CFG_WEP_DEFAULT_KEY_2_LEN    13
#define WNI_CFG_WEP_DEFAULT_KEY_3_LEN    13
#define WNI_CFG_WEP_DEFAULT_KEY_4_LEN    13
#define WNI_CFG_SUPPORTED_RATES_11B_LEN    4
#define WNI_CFG_SUPPORTED_RATES_11A_LEN    8
#define WNI_CFG_OPERATIONAL_RATE_SET_LEN    12
#define WNI_CFG_EXTENDED_OPERATIONAL_RATE_SET_LEN    8
#define WNI_CFG_PROPRIETARY_OPERATIONAL_RATE_SET_LEN    4
#define WNI_CFG_VALID_CHANNEL_LIST_LEN    100
#define WNI_CFG_MANUFACTURER_OUI_LEN    3
#define WNI_CFG_MANUFACTURER_NAME_LEN    64
#define WNI_CFG_MODEL_NUMBER_LEN    32
#define WNI_CFG_MODEL_NAME_LEN    32
#define WNI_CFG_MANUFACTURER_PRODUCT_NAME_LEN    32
#define WNI_CFG_MANUFACTURER_PRODUCT_VERSION_LEN    32
#define WNI_CFG_MAX_TX_POWER_2_4_LEN    128
#define WNI_CFG_MAX_TX_POWER_5_LEN    128
#define WNI_CFG_COUNTRY_CODE_LEN    3
#define WNI_CFG_EDCA_ANI_ACBK_LOCAL_LEN    20
#define WNI_CFG_EDCA_ANI_ACBE_LOCAL_LEN    20
#define WNI_CFG_EDCA_ANI_ACVI_LOCAL_LEN    20
#define WNI_CFG_EDCA_ANI_ACVO_LOCAL_LEN    20
#define WNI_CFG_EDCA_ANI_ACBK_LEN    20
#define WNI_CFG_EDCA_ANI_ACBE_LEN    20
#define WNI_CFG_EDCA_ANI_ACVI_LEN    20
#define WNI_CFG_EDCA_ANI_ACVO_LEN    20
#define WNI_CFG_EDCA_WME_ACBK_LOCAL_LEN    20
#define WNI_CFG_EDCA_WME_ACBE_LOCAL_LEN    20
#define WNI_CFG_EDCA_WME_ACVI_LOCAL_LEN    20
#define WNI_CFG_EDCA_WME_ACVO_LOCAL_LEN    20
#define WNI_CFG_EDCA_WME_ACBK_LEN    20
#define WNI_CFG_EDCA_WME_ACBE_LEN    20
#define WNI_CFG_EDCA_WME_ACVI_LEN    20
#define WNI_CFG_EDCA_WME_ACVO_LEN    20
#define WNI_CFG_RADAR_CHANNEL_LIST_LEN    20
#define WNI_CFG_SCAN_CONTROL_LIST_LEN    128
#define WNI_CFG_SUPPORTED_MCS_SET_LEN    16
#define WNI_CFG_BASIC_MCS_SET_LEN    16
#define WNI_CFG_CURRENT_MCS_SET_LEN    16
#define WNI_CFG_BG_SCAN_CHANNEL_LIST_LEN    100
#define WNI_CFG_PROBE_REQ_ADDNIE_DATA_LEN    255
#define WNI_CFG_PROBE_RSP_ADDNIE_DATA1_LEN    255
#define WNI_CFG_PROBE_RSP_ADDNIE_DATA2_LEN    255
#define WNI_CFG_PROBE_RSP_ADDNIE_DATA3_LEN    255
#define WNI_CFG_ASSOC_RSP_ADDNIE_DATA_LEN    255
#define WNI_CFG_PROBE_REQ_ADDNP2PIE_DATA_LEN    255
#define WNI_CFG_PROBE_RSP_BCN_ADDNIE_DATA_LEN    255
#define WNI_CFG_WPS_UUID_LEN    16

/*
 * Integer parameter min/max/default values
 */

#define WNI_CFG_CFP_PERIOD_STAMIN    0
#define WNI_CFG_CFP_PERIOD_STAMAX    255
#define WNI_CFG_CFP_PERIOD_STADEF    1

#define WNI_CFG_CFP_MAX_DURATION_STAMIN    0
#define WNI_CFG_CFP_MAX_DURATION_STAMAX    65535
#define WNI_CFG_CFP_MAX_DURATION_STADEF    30000

#define WNI_CFG_BEACON_INTERVAL_STAMIN    0
#define WNI_CFG_BEACON_INTERVAL_STAMAX    65535
#define WNI_CFG_BEACON_INTERVAL_STADEF    100

#define WNI_CFG_DTIM_PERIOD_STAMIN    0
#define WNI_CFG_DTIM_PERIOD_STAMAX    65535
#define WNI_CFG_DTIM_PERIOD_STADEF    1

#define WNI_CFG_WEP_KEY_LENGTH_STAMIN    5
#define WNI_CFG_WEP_KEY_LENGTH_STAMAX    13
#define WNI_CFG_WEP_KEY_LENGTH_STADEF    5

#define WNI_CFG_WEP_KEY_LENGTH_5    5
#define WNI_CFG_WEP_KEY_LENGTH_13    13

#define WNI_CFG_WEP_DEFAULT_KEYID_STAMIN    0
#define WNI_CFG_WEP_DEFAULT_KEYID_STAMAX    3
#define WNI_CFG_WEP_DEFAULT_KEYID_STADEF    0

#define WNI_CFG_WEP_DEFAULT_KEYID_0    0
#define WNI_CFG_WEP_DEFAULT_KEYID_1    1
#define WNI_CFG_WEP_DEFAULT_KEYID_2    2
#define WNI_CFG_WEP_DEFAULT_KEYID_3    3

#define WNI_CFG_EXCLUDE_UNENCRYPTED_STAMIN    0
#define WNI_CFG_EXCLUDE_UNENCRYPTED_STAMAX    1
#define WNI_CFG_EXCLUDE_UNENCRYPTED_STADEF    0

#define WNI_CFG_RTS_THRESHOLD_STAMIN    0
#define WNI_CFG_RTS_THRESHOLD_STAMAX    1048576
#define WNI_CFG_RTS_THRESHOLD_STADEF    2347

#define WNI_CFG_SHORT_RETRY_LIMIT_STAMIN    0
#define WNI_CFG_SHORT_RETRY_LIMIT_STAMAX    255
#define WNI_CFG_SHORT_RETRY_LIMIT_STADEF    6

#define WNI_CFG_LONG_RETRY_LIMIT_STAMIN    0
#define WNI_CFG_LONG_RETRY_LIMIT_STAMAX    255
#define WNI_CFG_LONG_RETRY_LIMIT_STADEF    6

#define WNI_CFG_FRAGMENTATION_THRESHOLD_STAMIN    256
#define WNI_CFG_FRAGMENTATION_THRESHOLD_STAMAX    8000
#define WNI_CFG_FRAGMENTATION_THRESHOLD_STADEF    8000

#define WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STAMIN    0
#define WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STAMAX    65535
#define WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STADEF    20

#define WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STAMIN    0
#define WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STAMAX    65535
#define WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STADEF    40

#define WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STAMIN    0
#define WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STAMAX    65535
#define WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STADEF    60

#define WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STAMIN    0
#define WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STAMAX    65535
#define WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STADEF    110

#define WNI_CFG_JOIN_FAILURE_TIMEOUT_STAMIN    0
#define WNI_CFG_JOIN_FAILURE_TIMEOUT_STAMAX    65535
#define WNI_CFG_JOIN_FAILURE_TIMEOUT_STADEF    3000

#define WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STAMIN    0
#define WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STAMAX    65535
#define WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STADEF    1000

#define WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STAMIN    0
#define WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STAMAX    65535
#define WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STADEF    1000

#define WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STAMIN    0
#define WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STAMAX    65535
#define WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STADEF    2000

#define WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STAMIN    0
#define WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STAMAX    65535
#define WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STADEF    1000

#define WNI_CFG_RA_PERIODICITY_TIMEOUT_IN_PS_STAMIN    0
#define WNI_CFG_RA_PERIODICITY_TIMEOUT_IN_PS_STAMAX    65535
#define WNI_CFG_RA_PERIODICITY_TIMEOUT_IN_PS_STADEF    1000

#define WNI_CFG_PS_ENABLE_BCN_FILTER_STAMIN    0
#define WNI_CFG_PS_ENABLE_BCN_FILTER_STAMAX    1
#define WNI_CFG_PS_ENABLE_BCN_FILTER_STADEF    1

#define WNI_CFG_PS_ENABLE_HEART_BEAT_STAMIN    0
#define WNI_CFG_PS_ENABLE_HEART_BEAT_STAMAX    1
#define WNI_CFG_PS_ENABLE_HEART_BEAT_STADEF    1

#define WNI_CFG_PS_ENABLE_RSSI_MONITOR_STAMIN    0
#define WNI_CFG_PS_ENABLE_RSSI_MONITOR_STAMAX    1
#define WNI_CFG_PS_ENABLE_RSSI_MONITOR_STADEF    0

#define WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STAMIN    1
#define WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STAMAX    255
#define WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STADEF    20

#define WNI_CFG_RF_SETTLING_TIME_CLK_STAMIN    0
#define WNI_CFG_RF_SETTLING_TIME_CLK_STAMAX    60000
#define WNI_CFG_RF_SETTLING_TIME_CLK_STADEF    1500

#define WNI_CFG_PHY_MODE_STAMIN    0
#define WNI_CFG_PHY_MODE_STAMAX    3
#define WNI_CFG_PHY_MODE_STADEF    0

#define WNI_CFG_PHY_MODE_11A    0
#define WNI_CFG_PHY_MODE_11B    1
#define WNI_CFG_PHY_MODE_11G    2
#define WNI_CFG_PHY_MODE_NONE    3

#define WNI_CFG_DOT11_MODE_STAMIN    0
#define WNI_CFG_DOT11_MODE_STAMAX    11
#define WNI_CFG_DOT11_MODE_STADEF    0

#define WNI_CFG_DOT11_MODE_ALL    0
#define WNI_CFG_DOT11_MODE_11A    1
#define WNI_CFG_DOT11_MODE_11B    2
#define WNI_CFG_DOT11_MODE_11G    3
#define WNI_CFG_DOT11_MODE_11N    4
#define WNI_CFG_DOT11_MODE_11G_ONLY    5
#define WNI_CFG_DOT11_MODE_11N_ONLY    6
#define WNI_CFG_DOT11_MODE_11AC    7
#define WNI_CFG_DOT11_MODE_11AC_ONLY    8

#define WNI_CFG_LISTEN_INTERVAL_STAMIN    0
#define WNI_CFG_LISTEN_INTERVAL_STAMAX    65535
#define WNI_CFG_LISTEN_INTERVAL_STADEF    1

#define WNI_CFG_CURRENT_CHANNEL_STAMIN    0
#define WNI_CFG_CURRENT_CHANNEL_STAMAX    165
#define WNI_CFG_CURRENT_CHANNEL_STADEF    1

#define WNI_CFG_DEFAULT_RATE_INDEX_5GHZ_STAMIN    0
#define WNI_CFG_DEFAULT_RATE_INDEX_5GHZ_STAMAX    11
#define WNI_CFG_DEFAULT_RATE_INDEX_5GHZ_STADEF    5

#define WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STAMIN    0
#define WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STAMAX    31
#define WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STADEF    1

#define WNI_CFG_RATE_ADAPTATION_TYPE_STAMIN    0
#define WNI_CFG_RATE_ADAPTATION_TYPE_STAMAX    2
#define WNI_CFG_RATE_ADAPTATION_TYPE_STADEF    1

#define WNI_CFG_RATE_ADAPTATION_TYPE_FIXED    0
#define WNI_CFG_RATE_ADAPTATION_TYPE_AUTO    1
#define WNI_CFG_RATE_ADAPTATION_TYPE_SNR_BASED    2

#define WNI_CFG_FIXED_RATE_STAMIN    0
#define WNI_CFG_FIXED_RATE_STAMAX    44
#define WNI_CFG_FIXED_RATE_STADEF    0

#define WNI_CFG_FIXED_RATE_AUTO    0
#define WNI_CFG_FIXED_RATE_1MBPS    1
#define WNI_CFG_FIXED_RATE_2MBPS    2
#define WNI_CFG_FIXED_RATE_5_5MBPS    3
#define WNI_CFG_FIXED_RATE_11MBPS    4
#define WNI_CFG_FIXED_RATE_6MBPS    5
#define WNI_CFG_FIXED_RATE_9MBPS    6
#define WNI_CFG_FIXED_RATE_12MBPS    7
#define WNI_CFG_FIXED_RATE_18MBPS    8
#define WNI_CFG_FIXED_RATE_24MBPS    9
#define WNI_CFG_FIXED_RATE_36MBPS    10
#define WNI_CFG_FIXED_RATE_48MBPS    11
#define WNI_CFG_FIXED_RATE_54MBPS    12
#define WNI_CFG_FIXED_RATE_6_5MBPS_MCS0_20MHZ_SIMO    13
#define WNI_CFG_FIXED_RATE_13MBPS_MCS1_20MHZ_SIMO    14
#define WNI_CFG_FIXED_RATE_19_5MBPS_MCS2_20MHZ_SIMO    15
#define WNI_CFG_FIXED_RATE_26MBPS_MCS3_20MHZ_SIMO    16
#define WNI_CFG_FIXED_RATE_39MBPS_MCS4_20MHZ_SIMO    17
#define WNI_CFG_FIXED_RATE_52MBPS_MCS5_20MHZ_SIMO    18
#define WNI_CFG_FIXED_RATE_58_5MBPS_MCS6_20MHZ_SIMO    19
#define WNI_CFG_FIXED_RATE_65MBPS_MCS7_20MHZ_SIMO    20
#define WNI_CFG_FIXED_RATE_7_2MBPS_MCS0_20MHZ_SIMO_SGI    21
#define WNI_CFG_FIXED_RATE_14_4MBPS_MCS1_20MHZ_SIMO_SGI    22
#define WNI_CFG_FIXED_RATE_21_7MBPS_MCS2_20MHZ_SIMO_SGI    23
#define WNI_CFG_FIXED_RATE_28_9MBPS_MCS3_20MHZ_SIMO_SGI    24
#define WNI_CFG_FIXED_RATE_43_3MBPS_MCS4_20MHZ_SIMO_SGI    25
#define WNI_CFG_FIXED_RATE_57_8MBPS_MCS5_20MHZ_SIMO_SGI    26
#define WNI_CFG_FIXED_RATE_65MBPS_MCS6_20MHZ_SIMO_SGI    27
#define WNI_CFG_FIXED_RATE_72_2MBPS_MCS7_20MHZ_SIMO_SGI    28
#define WNI_CFG_FIXED_RATE_0_25MBPS_SLR_20MHZ_SIMO    29
#define WNI_CFG_FIXED_RATE_0_5MBPS_SLR_20MHZ_SIMO    30
#define WNI_CFG_FIXED_RATE_68_25MBPS_QC_PROP_20MHZ_SIMO    31
#define WNI_CFG_FIXED_RATE_54MBPS_MCS3_40MHZ_SIMO    32
#define WNI_CFG_FIXED_RATE_81MBPS_MCS4_40MHZ_SIMO    33
#define WNI_CFG_FIXED_RATE_108MBPS_MCS5_40MHZ_SIMO    34
#define WNI_CFG_FIXED_RATE_121_5MBPS_MCS6_40MHZ_SIMO    35
#define WNI_CFG_FIXED_RATE_135MBPS_MCS7_40MHZ_SIMO    36
#define WNI_CFG_FIXED_RATE_15MBPS_MCS0_40MHZ_SIMO_SGI    37
#define WNI_CFG_FIXED_RATE_30MBPS_MCS1_40MHZ_SIMO_SGI    38
#define WNI_CFG_FIXED_RATE_45MBPS_MCS2_40MHZ_SIMO_SGI    39
#define WNI_CFG_FIXED_RATE_60MBPS_MCS3_40MHZ_SIMO_SGI    40
#define WNI_CFG_FIXED_RATE_90MBPS_MCS4_40MHZ_SIMO_SGI    41
#define WNI_CFG_FIXED_RATE_120MBPS_MCS5_40MHZ_SIMO_SGI    42
#define WNI_CFG_FIXED_RATE_135MBPS_MCS6_40MHZ_SIMO_SGI    43
#define WNI_CFG_FIXED_RATE_150MBPS_MCS7_40MHZ_SIMO_SGI    44

#define WNI_CFG_FIXED_RATE_MULTICAST_24GHZ_STAMIN    0
#define WNI_CFG_FIXED_RATE_MULTICAST_24GHZ_STAMAX    31
#define WNI_CFG_FIXED_RATE_MULTICAST_24GHZ_STADEF    1

#define WNI_CFG_FIXED_RATE_MULTICAST_5GHZ_STAMIN    0
#define WNI_CFG_FIXED_RATE_MULTICAST_5GHZ_STAMAX    31
#define WNI_CFG_FIXED_RATE_MULTICAST_5GHZ_STADEF    5

#define WNI_CFG_RETRYRATE_POLICY_STAMIN    0
#define WNI_CFG_RETRYRATE_POLICY_STAMAX    255
#define WNI_CFG_RETRYRATE_POLICY_STADEF    4

#define WNI_CFG_RETRYRATE_POLICY_MIN_SUPPORTED    0
#define WNI_CFG_RETRYRATE_POLICY_PRIMARY    1
#define WNI_CFG_RETRYRATE_POLICY_RESERVED    2
#define WNI_CFG_RETRYRATE_POLICY_CLOSEST    3
#define WNI_CFG_RETRYRATE_POLICY_AUTOSELECT    4
#define WNI_CFG_RETRYRATE_POLICY_MAX    5

#define WNI_CFG_RETRYRATE_SECONDARY_STAMIN    0
#define WNI_CFG_RETRYRATE_SECONDARY_STAMAX    255
#define WNI_CFG_RETRYRATE_SECONDARY_STADEF    0

#define WNI_CFG_RETRYRATE_TERTIARY_STAMIN    0
#define WNI_CFG_RETRYRATE_TERTIARY_STAMAX    255
#define WNI_CFG_RETRYRATE_TERTIARY_STADEF    0

#define WNI_CFG_APSD_ENABLED_STAMIN    0
#define WNI_CFG_APSD_ENABLED_STAMAX    1
#define WNI_CFG_APSD_ENABLED_STADEF    0

#define WNI_CFG_SHARED_KEY_AUTH_ENABLE_STAMIN    0
#define WNI_CFG_SHARED_KEY_AUTH_ENABLE_STAMAX    1
#define WNI_CFG_SHARED_KEY_AUTH_ENABLE_STADEF    1

#define WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STAMIN    0
#define WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STAMAX    1
#define WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STADEF    1

#define WNI_CFG_AUTHENTICATION_TYPE_STAMIN    0
#define WNI_CFG_AUTHENTICATION_TYPE_STAMAX    65535
#define WNI_CFG_AUTHENTICATION_TYPE_STADEF    0

#define WNI_CFG_PRIVACY_ENABLED_STAMIN    0
#define WNI_CFG_PRIVACY_ENABLED_STAMAX    1
#define WNI_CFG_PRIVACY_ENABLED_STADEF    0

#define WNI_CFG_SHORT_PREAMBLE_STAMIN    0
#define WNI_CFG_SHORT_PREAMBLE_STAMAX    1
#define WNI_CFG_SHORT_PREAMBLE_STADEF    1

#define WNI_CFG_SHORT_SLOT_TIME_STAMIN    0
#define WNI_CFG_SHORT_SLOT_TIME_STAMAX    1
#define WNI_CFG_SHORT_SLOT_TIME_STADEF    1

#define WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STAMIN    0
#define WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STAMAX    1
#define WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STADEF    0

#define WNI_CFG_QOS_ENABLED_STAMIN    0
#define WNI_CFG_QOS_ENABLED_STAMAX    1
#define WNI_CFG_QOS_ENABLED_STADEF    0

#define WNI_CFG_HCF_ENABLED_STAMIN    0
#define WNI_CFG_HCF_ENABLED_STAMAX    1
#define WNI_CFG_HCF_ENABLED_STADEF    0

#define WNI_CFG_RSN_ENABLED_STAMIN    0
#define WNI_CFG_RSN_ENABLED_STAMAX    1
#define WNI_CFG_RSN_ENABLED_STADEF    0

#define WNI_CFG_BACKGROUND_SCAN_PERIOD_STAMIN    0
#define WNI_CFG_BACKGROUND_SCAN_PERIOD_STAMAX    180000
#define WNI_CFG_BACKGROUND_SCAN_PERIOD_STADEF    5000

#define WNI_CFG_MAX_NUM_PRE_AUTH_STAMIN    0
#define WNI_CFG_MAX_NUM_PRE_AUTH_STAMAX    256
#define WNI_CFG_MAX_NUM_PRE_AUTH_STADEF    64

#define WNI_CFG_HEART_BEAT_THRESHOLD_STAMIN    0
#define WNI_CFG_HEART_BEAT_THRESHOLD_STAMAX    65535
#define WNI_CFG_HEART_BEAT_THRESHOLD_STADEF    40

#define WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STAMIN    10
#define WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STAMAX    10000
#define WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STADEF    40

#define WNI_CFG_11D_ENABLED_STAMIN    0
#define WNI_CFG_11D_ENABLED_STAMAX    1
#define WNI_CFG_11D_ENABLED_STADEF    1

#define WNI_CFG_NETWORK_DENSITY_STAMIN    0
#define WNI_CFG_NETWORK_DENSITY_STAMAX    3
#define WNI_CFG_NETWORK_DENSITY_STADEF    3

#define WNI_CFG_NETWORK_DENSITY_LOW    0
#define WNI_CFG_NETWORK_DENSITY_MEDIUM    1
#define WNI_CFG_NETWORK_DENSITY_HIGH    2
#define WNI_CFG_NETWORK_DENSITY_ADAPTIVE    3

#define WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM_STAMIN    1
#define WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM_STAMAX    2
#define WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM_STADEF    2

#define WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM_CARRIER    1
#define WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM_CORRELATION    2

#define WNI_CFG_CURRENT_TX_ANTENNA_STAMIN    1
#define WNI_CFG_CURRENT_TX_ANTENNA_STAMAX    1
#define WNI_CFG_CURRENT_TX_ANTENNA_STADEF    1

#define WNI_CFG_CURRENT_RX_ANTENNA_STAMIN    1
#define WNI_CFG_CURRENT_RX_ANTENNA_STAMAX    2
#define WNI_CFG_CURRENT_RX_ANTENNA_STADEF    2

#define WNI_CFG_CURRENT_TX_POWER_LEVEL_STAMIN    0
#define WNI_CFG_CURRENT_TX_POWER_LEVEL_STAMAX    128
#define WNI_CFG_CURRENT_TX_POWER_LEVEL_STADEF    27

#define WNI_CFG_NEW_BSS_FOUND_IND_STAMIN    0
#define WNI_CFG_NEW_BSS_FOUND_IND_STAMAX    1
#define WNI_CFG_NEW_BSS_FOUND_IND_STADEF    0

#define WNI_CFG_PROPRIETARY_RATES_ENABLED_STAMIN    0
#define WNI_CFG_PROPRIETARY_RATES_ENABLED_STAMAX    1
#define WNI_CFG_PROPRIETARY_RATES_ENABLED_STADEF    0

#define WNI_CFG_11H_ENABLED_STAMIN    0
#define WNI_CFG_11H_ENABLED_STAMAX    1
#define WNI_CFG_11H_ENABLED_STADEF    1

#define WNI_CFG_WT_CNF_TIMEOUT_STAMIN    10
#define WNI_CFG_WT_CNF_TIMEOUT_STAMAX    3000
#define WNI_CFG_WT_CNF_TIMEOUT_STADEF    1000

#define WNI_CFG_KEEPALIVE_TIMEOUT_STAMIN    0
#define WNI_CFG_KEEPALIVE_TIMEOUT_STAMAX    3600000
#define WNI_CFG_KEEPALIVE_TIMEOUT_STADEF    0

#define WNI_CFG_PROXIMITY_STAMIN    0
#define WNI_CFG_PROXIMITY_STAMAX    1
#define WNI_CFG_PROXIMITY_STADEF    0

#define WNI_CFG_PROXIMITY_OFF    0
#define WNI_CFG_PROXIMITY_ON    1

#define WNI_CFG_LOG_LEVEL_STAMIN    0
#define WNI_CFG_LOG_LEVEL_STAMAX    7
#define WNI_CFG_LOG_LEVEL_STADEF    4

#define WNI_CFG_OLBC_DETECT_TIMEOUT_STAMIN    1000
#define WNI_CFG_OLBC_DETECT_TIMEOUT_STAMAX    30000
#define WNI_CFG_OLBC_DETECT_TIMEOUT_STADEF    10000

#define WNI_CFG_PROTECTION_ENABLED_STAMIN    0
#define WNI_CFG_PROTECTION_ENABLED_STAMAX    65535
#define WNI_CFG_PROTECTION_ENABLED_STADEF    65535

#define WNI_CFG_PROTECTION_ENABLED_FROM_llA    0
#define WNI_CFG_PROTECTION_ENABLED_FROM_llB    1
#define WNI_CFG_PROTECTION_ENABLED_FROM_llG    2
#define WNI_CFG_PROTECTION_ENABLED_HT_20    3
#define WNI_CFG_PROTECTION_ENABLED_NON_GF    4
#define WNI_CFG_PROTECTION_ENABLED_LSIG_TXOP    5
#define WNI_CFG_PROTECTION_ENABLED_RIFS    6
#define WNI_CFG_PROTECTION_ENABLED_OBSS    7
#define WNI_CFG_PROTECTION_ENABLED_OLBC_FROM_llA    8
#define WNI_CFG_PROTECTION_ENABLED_OLBC_FROM_llB    9
#define WNI_CFG_PROTECTION_ENABLED_OLBC_FROM_llG    10
#define WNI_CFG_PROTECTION_ENABLED_OLBC_HT20    11
#define WNI_CFG_PROTECTION_ENABLED_OLBC_NON_GF    12
#define WNI_CFG_PROTECTION_ENABLED_OLBC_LSIG_TXOP    13
#define WNI_CFG_PROTECTION_ENABLED_OLBC_RIFS    14
#define WNI_CFG_PROTECTION_ENABLED_OLBC_OBSS    15

#define WNI_CFG_11G_PROTECTION_ALWAYS_STAMIN    0
#define WNI_CFG_11G_PROTECTION_ALWAYS_STAMAX    1
#define WNI_CFG_11G_PROTECTION_ALWAYS_STADEF    0

#define WNI_CFG_FORCE_POLICY_PROTECTION_STAMIN    0
#define WNI_CFG_FORCE_POLICY_PROTECTION_STAMAX    5
#define WNI_CFG_FORCE_POLICY_PROTECTION_STADEF    5

#define WNI_CFG_FORCE_POLICY_PROTECTION_DISABLE    0
#define WNI_CFG_FORCE_POLICY_PROTECTION_CTS    1
#define WNI_CFG_FORCE_POLICY_PROTECTION_RTS    2
#define WNI_CFG_FORCE_POLICY_PROTECTION_DUAL_CTS    3
#define WNI_CFG_FORCE_POLICY_PROTECTION_RTS_ALWAYS    4
#define WNI_CFG_FORCE_POLICY_PROTECTION_AUTO    5

#define WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STAMIN    0
#define WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STAMAX    1
#define WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STADEF    0

#define WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STAMIN    0
#define WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STAMAX    1
#define WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STADEF    1

#define WNI_CFG_11G_ONLY_POLICY_STAMIN    0
#define WNI_CFG_11G_ONLY_POLICY_STAMAX    1
#define WNI_CFG_11G_ONLY_POLICY_STADEF    0

#define WNI_CFG_PACKET_CLASSIFICATION_STAMIN    0
#define WNI_CFG_PACKET_CLASSIFICATION_STAMAX    3
#define WNI_CFG_PACKET_CLASSIFICATION_STADEF    0

#define WNI_CFG_PACKET_CLASSIFICATION_DISABLED    0
#define WNI_CFG_PACKET_CLASSIFICATION_DSCP    1
#define WNI_CFG_PACKET_CLASSIFICATION_8021P    2
#define WNI_CFG_PACKET_CLASSIFICATION_ALL    3

#define WNI_CFG_WME_ENABLED_STAMIN    0
#define WNI_CFG_WME_ENABLED_STAMAX    1
#define WNI_CFG_WME_ENABLED_STADEF    1

#define WNI_CFG_ADDTS_RSP_TIMEOUT_STAMIN    0
#define WNI_CFG_ADDTS_RSP_TIMEOUT_STAMAX    65535
#define WNI_CFG_ADDTS_RSP_TIMEOUT_STADEF    1000

#define WNI_CFG_MAX_SP_LENGTH_STAMIN    0
#define WNI_CFG_MAX_SP_LENGTH_STAMAX    3
#define WNI_CFG_MAX_SP_LENGTH_STADEF    0

#define WNI_CFG_SEND_SINGLE_SSID_ALWAYS_STAMIN    0
#define WNI_CFG_SEND_SINGLE_SSID_ALWAYS_STAMAX    1
#define WNI_CFG_SEND_SINGLE_SSID_ALWAYS_STADEF    0

#define WNI_CFG_WSM_ENABLED_STAMIN    0
#define WNI_CFG_WSM_ENABLED_STAMAX    1
#define WNI_CFG_WSM_ENABLED_STADEF    0

#define WNI_CFG_EDCA_PROFILE_STAMIN    0
#define WNI_CFG_EDCA_PROFILE_STAMAX    255
#define WNI_CFG_EDCA_PROFILE_STADEF    1

#define WNI_CFG_EDCA_PROFILE_ANI    0
#define WNI_CFG_EDCA_PROFILE_WMM    1
#define WNI_CFG_EDCA_PROFILE_TIT_DEMO    2
#define WNI_CFG_EDCA_PROFILE_MAX    3
#define WNI_CFG_EDCA_PROFILE_ACM_IDX    0
#define WNI_CFG_EDCA_PROFILE_AIFSN_IDX    1
#define WNI_CFG_EDCA_PROFILE_CWMINA_IDX    2
#define WNI_CFG_EDCA_PROFILE_CWMAXA_IDX    4
#define WNI_CFG_EDCA_PROFILE_TXOPA_IDX    6
#define WNI_CFG_EDCA_PROFILE_CWMINB_IDX    7
#define WNI_CFG_EDCA_PROFILE_CWMAXB_IDX    9
#define WNI_CFG_EDCA_PROFILE_TXOPB_IDX    11
#define WNI_CFG_EDCA_PROFILE_CWMING_IDX    12
#define WNI_CFG_EDCA_PROFILE_CWMAXG_IDX    14
#define WNI_CFG_EDCA_PROFILE_TXOPG_IDX    16

#define WNI_CFG_RDET_FLAG_STAMIN    0
#define WNI_CFG_RDET_FLAG_STAMAX    1
#define WNI_CFG_RDET_FLAG_STADEF    0

#define WNI_CFG_RDET_FLAG_ENABLE    1
#define WNI_CFG_RDET_FLAG_DISABLE    0

#define WNI_CFG_LOCAL_POWER_CONSTRAINT_STAMIN    0
#define WNI_CFG_LOCAL_POWER_CONSTRAINT_STAMAX    255
#define WNI_CFG_LOCAL_POWER_CONSTRAINT_STADEF    0

#define WNI_CFG_ADMIT_POLICY_STAMIN    0
#define WNI_CFG_ADMIT_POLICY_STAMAX    2
#define WNI_CFG_ADMIT_POLICY_STADEF    0

#define WNI_CFG_ADMIT_POLICY_ADMIT_ALL    0
#define WNI_CFG_ADMIT_POLICY_REJECT_ALL    1
#define WNI_CFG_ADMIT_POLICY_BW_FACTOR    2

#define WNI_CFG_ADMIT_BWFACTOR_STAMIN    0
#define WNI_CFG_ADMIT_BWFACTOR_STAMAX    100
#define WNI_CFG_ADMIT_BWFACTOR_STADEF    20

#define WNI_CFG_MAX_CONSECUTIVE_BACKGROUND_SCAN_FAILURE_STAMIN    0
#define WNI_CFG_MAX_CONSECUTIVE_BACKGROUND_SCAN_FAILURE_STAMAX    256
#define WNI_CFG_MAX_CONSECUTIVE_BACKGROUND_SCAN_FAILURE_STADEF    60

#define WNI_CFG_CHANNEL_BONDING_MODE_STAMIN    0
#define WNI_CFG_CHANNEL_BONDING_MODE_STAMAX    10
#define WNI_CFG_CHANNEL_BONDING_MODE_STADEF    0

#define WNI_CFG_CHANNEL_BONDING_MODE_DISABLE    0
#define WNI_CFG_CHANNEL_BONDING_MODE_ENABLE    1
#define WNI_CFG_CHANNEL_BONDING_MODE_IF_NO_LEGACY_BSS    2
#define WNI_CFG_CHANNEL_BONDING_MODE_IF_NO_LEGACY_ALL    3
#define WNI_CFG_CHANNEL_BONDING_MODE_INTELLIGENT    4

#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_STAMIN    0
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_STAMAX    10
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_STADEF    0

#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_NONE    0
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_LOWER    1
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_HIGHER    2
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_11AC_20MHZ_LOW_40MHZ_CENTERED    3
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_11AC_20MHZ_CENTERED_40MHZ_CENTERED    4
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_11AC_20MHZ_HIGH_40MHZ_CENTERED    5
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_11AC_20MHZ_LOW_40MHZ_LOW    6
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_11AC_20MHZ_HIGH_40MHZ_LOW    7
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_11AC_20MHZ_LOW_40MHZ_HIGH    8
#define WNI_CFG_CB_SECONDARY_CHANNEL_STATE_11AC_20MHZ_HIGH_40MHZ_HIGH    9

#define WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STAMIN    0
#define WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STAMAX    255
#define WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STADEF    2

#define WNI_CFG_DYNAMIC_THRESHOLD_ONE_STAMIN    0
#define WNI_CFG_DYNAMIC_THRESHOLD_ONE_STAMAX    255
#define WNI_CFG_DYNAMIC_THRESHOLD_ONE_STADEF    4

#define WNI_CFG_DYNAMIC_THRESHOLD_TWO_STAMIN    0
#define WNI_CFG_DYNAMIC_THRESHOLD_TWO_STAMAX    255
#define WNI_CFG_DYNAMIC_THRESHOLD_TWO_STADEF    6

#define WNI_CFG_TRIG_STA_BK_SCAN_STAMIN    0
#define WNI_CFG_TRIG_STA_BK_SCAN_STAMAX    1
#define WNI_CFG_TRIG_STA_BK_SCAN_STADEF    0

#define WNI_CFG_DYNAMIC_PROFILE_SWITCHING_STAMIN    0
#define WNI_CFG_DYNAMIC_PROFILE_SWITCHING_STAMAX    255
#define WNI_CFG_DYNAMIC_PROFILE_SWITCHING_STADEF    255

#define WNI_CFG_DYNAMIC_PROFILE_SWITCHING_UNUSED    255

#define WNI_CFG_MIMO_ENABLED_STAMIN    0
#define WNI_CFG_MIMO_ENABLED_STAMAX    1
#define WNI_CFG_MIMO_ENABLED_STADEF    1

#define WNI_CFG_MIMO_ENABLED_ENABLE    1
#define WNI_CFG_MIMO_ENABLED_DISABLE    0

#define WNI_CFG_BLOCK_ACK_ENABLED_STAMIN    0
#define WNI_CFG_BLOCK_ACK_ENABLED_STAMAX    3
#define WNI_CFG_BLOCK_ACK_ENABLED_STADEF    0

#define WNI_CFG_BLOCK_ACK_ENABLED_DELAYED    0
#define WNI_CFG_BLOCK_ACK_ENABLED_IMMEDIATE    1

#define WNI_CFG_BA_ACTIVITY_CHECK_TIMEOUT_STAMIN    0
#define WNI_CFG_BA_ACTIVITY_CHECK_TIMEOUT_STAMAX    65535
#define WNI_CFG_BA_ACTIVITY_CHECK_TIMEOUT_STADEF    1000

#define WNI_CFG_HT_RX_STBC_STAMIN    0
#define WNI_CFG_HT_RX_STBC_STAMAX    3
#define WNI_CFG_HT_RX_STBC_STADEF    1

#define WNI_CFG_HT_CAP_INFO_STAMIN    0
#define WNI_CFG_HT_CAP_INFO_STAMAX    65535
#define WNI_CFG_HT_CAP_INFO_STADEF    364

#define WNI_CFG_HT_CAP_INFO_ADVANCE_CODING    0
#define WNI_CFG_HT_CAP_INFO_SUPPORTED_CHAN_WIDTH_SET    1
#define WNI_CFG_HT_CAP_INFO_SM_POWER_SAVE    2
#define WNI_CFG_HT_CAP_INFO_GREEN_FIELD    4
#define WNI_CFG_HT_CAP_INFO_SHORT_GI_20MHZ    5
#define WNI_CFG_HT_CAP_INFO_SHORT_GI_40MHZ    6
#define WNI_CFG_HT_CAP_INFO_TX_STBC    7
#define WNI_CFG_HT_CAP_INFO_RX_STBC    8
#define WNI_CFG_HT_CAP_INFO_DELAYED_BA    10
#define WNI_CFG_HT_CAP_INFO_MAX_AMSDU_SIZE    11
#define WNI_CFG_HT_CAP_INFO_DSSS_CCK_MODE_40MHZ    12
#define WNI_CFG_HT_CAP_INFO_PSMP    13
#define WNI_CFG_HT_CAP_INFO_STBC_CONTROL_FRAME    14
#define WNI_CFG_HT_CAP_INFO_LSIG_TXOP_PROTECTION    15

#define WNI_CFG_HT_AMPDU_PARAMS_STAMIN    0
#define WNI_CFG_HT_AMPDU_PARAMS_STAMAX    255
#define WNI_CFG_HT_AMPDU_PARAMS_STADEF    0

#define WNI_CFG_HT_AMPDU_PARAMS_MAX_RX_AMPDU_FACTOR    0
#define WNI_CFG_HT_AMPDU_PARAMS_MPDU_DENSITY    2
#define WNI_CFG_HT_AMPDU_PARAMS_RESERVED    5

#define WNI_CFG_EXT_HT_CAP_INFO_STAMIN    0
#define WNI_CFG_EXT_HT_CAP_INFO_STAMAX    65535
#define WNI_CFG_EXT_HT_CAP_INFO_STADEF    1024

#define WNI_CFG_EXT_HT_CAP_INFO_PCO    0
#define WNI_CFG_EXT_HT_CAP_INFO_TRANSITION_TIME    1
#define WNI_CFG_EXT_HT_CAP_INFO_RESERVED1    3
#define WNI_CFG_EXT_HT_CAP_INFO_MCS_FEEDBACK    8
#define WNI_CFG_EXT_HT_CAP_INFO_HTC_SUPPORT    10
#define WNI_CFG_EXT_HT_CAP_INFO_RD_RESPONDER    11
#define WNI_CFG_EXT_HT_CAP_INFO_RESERVED2    12

#define WNI_CFG_TX_BF_CAP_STAMIN    0
#define WNI_CFG_TX_BF_CAP_STAMAX    4294967295
#define WNI_CFG_TX_BF_CAP_STADEF    0

#define WNI_CFG_AS_CAP_STAMIN    0
#define WNI_CFG_AS_CAP_STAMAX    255
#define WNI_CFG_AS_CAP_STADEF    0

#define WNI_CFG_AS_CAP_ANTENNA_SELECTION    0
#define WNI_CFG_AS_CAP_EXPLICIT_CSI_FEEDBACK_TX    1
#define WNI_CFG_AS_CAP_ANTENNA_INDICES_FEEDBACK_TX    2
#define WNI_CFG_AS_CAP_EXPLICIT_CSI_FEEDBACK    3
#define WNI_CFG_AS_CAP_ANTENNA_INDICES_FEEDBACK    4
#define WNI_CFG_AS_CAP_RX_AS    5
#define WNI_CFG_AS_CAP_TX_SOUNDING_PPDUS    6
#define WNI_CFG_AS_CAP_RESERVED    7

#define WNI_CFG_HT_INFO_FIELD1_STAMIN    0
#define WNI_CFG_HT_INFO_FIELD1_STAMAX    255
#define WNI_CFG_HT_INFO_FIELD1_STADEF    15

#define WNI_CFG_HT_INFO_FIELD1_SECONDARY_CHANNEL_OFFSET    0
#define WNI_CFG_HT_INFO_FIELD1_RECOMMENDED_CHANNEL_WIDTH    2
#define WNI_CFG_HT_INFO_FIELD1_RIFS_MODE    3
#define WNI_CFG_HT_INFO_FIELD1_PSMP_ACCESS_ONLY    4
#define WNI_CFG_HT_INFO_FIELD1_SERVICE_INTERVAL_GRANULARITY    5

#define WNI_CFG_HT_INFO_FIELD2_STAMIN    0
#define WNI_CFG_HT_INFO_FIELD2_STAMAX    65535
#define WNI_CFG_HT_INFO_FIELD2_STADEF    0

#define WNI_CFG_HT_INFO_FIELD2_OP_MODE    0
#define WNI_CFG_HT_INFO_FIELD2_NON_GF_DEVICES_PRESENT    2
#define WNI_CFG_HT_INFO_FIELD2_RESERVED    3

#define WNI_CFG_HT_INFO_FIELD3_STAMIN    0
#define WNI_CFG_HT_INFO_FIELD3_STAMAX    65535
#define WNI_CFG_HT_INFO_FIELD3_STADEF    0

#define WNI_CFG_HT_INFO_FIELD3_BASIC_STBC_MCS    0
#define WNI_CFG_HT_INFO_FIELD3_DUAL_STBC_PROTECTION    7
#define WNI_CFG_HT_INFO_FIELD3_SECONDARY_BEACON    8
#define WNI_CFG_HT_INFO_FIELD3_LSIG_TXOP_PROTECTION_FULL_SUPPORT    9
#define WNI_CFG_HT_INFO_FIELD3_PCO_ACTIVE    10
#define WNI_CFG_HT_INFO_FIELD3_PCO_PHASE    11
#define WNI_CFG_HT_INFO_FIELD3_RESERVED    12

#define WNI_CFG_GREENFIELD_CAPABILITY_STAMIN    0
#define WNI_CFG_GREENFIELD_CAPABILITY_STAMAX    1
#define WNI_CFG_GREENFIELD_CAPABILITY_STADEF    0

#define WNI_CFG_GREENFIELD_CAPABILITY_ENABLE    1
#define WNI_CFG_GREENFIELD_CAPABILITY_DISABLE    0

#define WNI_CFG_VHT_MAX_MPDU_LENGTH_STAMIN    0
#define WNI_CFG_VHT_MAX_MPDU_LENGTH_STAMAX    2
#define WNI_CFG_VHT_MAX_MPDU_LENGTH_STADEF    0

#define WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STAMIN    0
#define WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STAMAX    0
#define WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STADEF    0

#define WNI_CFG_VHT_LDPC_CODING_CAP_STAMIN    0
#define WNI_CFG_VHT_LDPC_CODING_CAP_STAMAX    1
#define WNI_CFG_VHT_LDPC_CODING_CAP_STADEF    0

#define WNI_CFG_VHT_SHORT_GI_80MHZ_STAMIN    0
#define WNI_CFG_VHT_SHORT_GI_80MHZ_STAMAX    1
#define WNI_CFG_VHT_SHORT_GI_80MHZ_STADEF    1

#define WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STAMIN    0
#define WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STAMAX    1
#define WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STADEF    0

#define WNI_CFG_VHT_TXSTBC_STAMIN    0
#define WNI_CFG_VHT_TXSTBC_STAMAX    1
#define WNI_CFG_VHT_TXSTBC_STADEF    0

#define WNI_CFG_VHT_RXSTBC_STAMIN    0
#define WNI_CFG_VHT_RXSTBC_STAMAX    1
#define WNI_CFG_VHT_RXSTBC_STADEF    1

#define WNI_CFG_VHT_SU_BEAMFORMER_CAP_STAMIN    0
#define WNI_CFG_VHT_SU_BEAMFORMER_CAP_STAMAX    1
#define WNI_CFG_VHT_SU_BEAMFORMER_CAP_STADEF    0

#define WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STAMIN    0
#define WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STAMAX    1
#define WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STADEF    1

#define WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STAMIN    0
#define WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STAMAX    4
#define WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STADEF    0

#define WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STAMIN    0
#define WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STAMAX    3
#define WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STADEF    0

#define WNI_CFG_VHT_MU_BEAMFORMER_CAP_STAMIN    0
#define WNI_CFG_VHT_MU_BEAMFORMER_CAP_STAMAX    1
#define WNI_CFG_VHT_MU_BEAMFORMER_CAP_STADEF    0

#define WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STAMIN    0
#define WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STAMAX    1
#define WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STADEF    0

#define WNI_CFG_VHT_TXOP_PS_STAMIN    0
#define WNI_CFG_VHT_TXOP_PS_STAMAX    1
#define WNI_CFG_VHT_TXOP_PS_STADEF    0

#define WNI_CFG_VHT_HTC_VHTC_CAP_STAMIN    0
#define WNI_CFG_VHT_HTC_VHTC_CAP_STAMAX    1
#define WNI_CFG_VHT_HTC_VHTC_CAP_STADEF    0

#define WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STAMIN    0
#define WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STAMAX    7
#define WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STADEF    3

#define WNI_CFG_VHT_LINK_ADAPTATION_CAP_STAMIN    0
#define WNI_CFG_VHT_LINK_ADAPTATION_CAP_STAMAX    3
#define WNI_CFG_VHT_LINK_ADAPTATION_CAP_STADEF    0

#define WNI_CFG_VHT_RX_ANT_PATTERN_STAMIN    0
#define WNI_CFG_VHT_RX_ANT_PATTERN_STAMAX    1
#define WNI_CFG_VHT_RX_ANT_PATTERN_STADEF    1

#define WNI_CFG_VHT_TX_ANT_PATTERN_STAMIN    0
#define WNI_CFG_VHT_TX_ANT_PATTERN_STAMAX    1
#define WNI_CFG_VHT_TX_ANT_PATTERN_STADEF    1

#define WNI_CFG_VHT_RX_MCS_MAP_STAMIN    0
#define WNI_CFG_VHT_RX_MCS_MAP_STAMAX    65535
#define WNI_CFG_VHT_RX_MCS_MAP_STADEF    65534

#define WNI_CFG_VHT_TX_MCS_MAP_STAMIN    0
#define WNI_CFG_VHT_TX_MCS_MAP_STAMAX    65535
#define WNI_CFG_VHT_TX_MCS_MAP_STADEF    65534

#define WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STAMIN    0
#define WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STAMAX    780
#define WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STADEF    780

#define WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STAMIN    0
#define WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STAMAX    780
#define WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STADEF    780

#define WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT1_STAMIN    0
#define WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT1_STAMAX    256
#define WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT1_STADEF    0

#define WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT2_STAMIN    0
#define WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT2_STAMAX    0
#define WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT2_STADEF    0

#define WNI_CFG_VHT_BASIC_MCS_SET_STAMIN    0
#define WNI_CFG_VHT_BASIC_MCS_SET_STAMAX    65535
#define WNI_CFG_VHT_BASIC_MCS_SET_STADEF    65534

#define WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STAMIN    0
#define WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STAMAX    4
#define WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STADEF    0

#define WNI_CFG_VHT_SS_UNDER_UTIL_STAMIN    0
#define WNI_CFG_VHT_SS_UNDER_UTIL_STAMAX    0
#define WNI_CFG_VHT_SS_UNDER_UTIL_STADEF    0

#define WNI_CFG_VHT_40MHZ_UTILIZATION_STAMIN    0
#define WNI_CFG_VHT_40MHZ_UTILIZATION_STAMAX    0
#define WNI_CFG_VHT_40MHZ_UTILIZATION_STADEF    0

#define WNI_CFG_VHT_80MHZ_UTILIZATION_STAMIN    0
#define WNI_CFG_VHT_80MHZ_UTILIZATION_STAMAX    0
#define WNI_CFG_VHT_80MHZ_UTILIZATION_STADEF    0

#define WNI_CFG_VHT_160MHZ_UTILIZATION_STAMIN    0
#define WNI_CFG_VHT_160MHZ_UTILIZATION_STAMAX    0
#define WNI_CFG_VHT_160MHZ_UTILIZATION_STADEF    0

#define WNI_CFG_MAX_AMSDU_LENGTH_STAMIN    0
#define WNI_CFG_MAX_AMSDU_LENGTH_STAMAX    1
#define WNI_CFG_MAX_AMSDU_LENGTH_STADEF    0

#define WNI_CFG_MAX_AMSDU_LENGTH_SHORT_3839_BYTES    0
#define WNI_CFG_MAX_AMSDU_LENGTH_LONG_7935__BYTES    1

#define WNI_CFG_MPDU_DENSITY_STAMIN    0
#define WNI_CFG_MPDU_DENSITY_STAMAX    7
#define WNI_CFG_MPDU_DENSITY_STADEF    7

#define WNI_CFG_NUM_BUFF_ADVERT_STAMIN    0
#define WNI_CFG_NUM_BUFF_ADVERT_STAMAX    128
#define WNI_CFG_NUM_BUFF_ADVERT_STADEF    64

#define WNI_CFG_MAX_RX_AMPDU_FACTOR_STAMIN    0
#define WNI_CFG_MAX_RX_AMPDU_FACTOR_STAMAX    3
#define WNI_CFG_MAX_RX_AMPDU_FACTOR_STADEF    3

#define WNI_CFG_SHORT_GI_20MHZ_STAMIN    0
#define WNI_CFG_SHORT_GI_20MHZ_STAMAX    1
#define WNI_CFG_SHORT_GI_20MHZ_STADEF    1

#define WNI_CFG_SHORT_GI_20MHZ_ENABLE    1
#define WNI_CFG_SHORT_GI_20MHZ_DISABLE    0

#define WNI_CFG_SHORT_GI_40MHZ_STAMIN    0
#define WNI_CFG_SHORT_GI_40MHZ_STAMAX    1
#define WNI_CFG_SHORT_GI_40MHZ_STADEF    0

#define WNI_CFG_SHORT_GI_40MHZ_ENABLE    1
#define WNI_CFG_SHORT_GI_40MHZ_DISABLE    0

#define WNI_CFG_RIFS_ENABLED_STAMIN    0
#define WNI_CFG_RIFS_ENABLED_STAMAX    1
#define WNI_CFG_RIFS_ENABLED_STADEF    1

#define WNI_CFG_RIFS_ENABLED_ENABLE    1
#define WNI_CFG_RIFS_ENABLED_DISABLE    0

#define WNI_CFG_MAX_PS_POLL_STAMIN    0
#define WNI_CFG_MAX_PS_POLL_STAMAX    255
#define WNI_CFG_MAX_PS_POLL_STADEF    0

#define WNI_CFG_NUM_BEACON_PER_RSSI_AVERAGE_STAMIN    1
#define WNI_CFG_NUM_BEACON_PER_RSSI_AVERAGE_STAMAX    20
#define WNI_CFG_NUM_BEACON_PER_RSSI_AVERAGE_STADEF    20

#define WNI_CFG_RSSI_FILTER_PERIOD_STAMIN    0
#define WNI_CFG_RSSI_FILTER_PERIOD_STAMAX    255
#define WNI_CFG_RSSI_FILTER_PERIOD_STADEF    5

#define WNI_CFG_MIN_RSSI_THRESHOLD_STAMIN    0
#define WNI_CFG_MIN_RSSI_THRESHOLD_STAMAX    10
#define WNI_CFG_MIN_RSSI_THRESHOLD_STADEF    10

#define WNI_CFG_NTH_BEACON_FILTER_STAMIN    0
#define WNI_CFG_NTH_BEACON_FILTER_STAMAX    255
#define WNI_CFG_NTH_BEACON_FILTER_STADEF    10

#define WNI_CFG_BROADCAST_FRAME_FILTER_ENABLE_STAMIN    0
#define WNI_CFG_BROADCAST_FRAME_FILTER_ENABLE_STAMAX    1
#define WNI_CFG_BROADCAST_FRAME_FILTER_ENABLE_STADEF    0

#define WNI_CFG_SCAN_IN_POWERSAVE_STAMIN    0
#define WNI_CFG_SCAN_IN_POWERSAVE_STAMAX    1
#define WNI_CFG_SCAN_IN_POWERSAVE_STADEF    1

#define WNI_CFG_IGNORE_DTIM_STAMIN    0
#define WNI_CFG_IGNORE_DTIM_STAMAX    1
#define WNI_CFG_IGNORE_DTIM_STADEF    0

#define WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STAMIN    0
#define WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STAMAX    1
#define WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STADEF    1

#define WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STAMIN    0
#define WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STAMAX    1
#define WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STADEF    1

#define WNI_CFG_WOWLAN_DEAUTH_ENABLE_STAMIN    0
#define WNI_CFG_WOWLAN_DEAUTH_ENABLE_STAMAX    1
#define WNI_CFG_WOWLAN_DEAUTH_ENABLE_STADEF    1

#define WNI_CFG_WOWLAN_DISASSOC_ENABLE_STAMIN    0
#define WNI_CFG_WOWLAN_DISASSOC_ENABLE_STAMAX    1
#define WNI_CFG_WOWLAN_DISASSOC_ENABLE_STADEF    1

#define WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STAMIN    0
#define WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STAMAX    65535
#define WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STADEF    40

#define WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STAMIN    0
#define WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STAMAX    65535
#define WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STADEF    65535

#define WNI_CFG_BA_TIMEOUT_STAMIN    0
#define WNI_CFG_BA_TIMEOUT_STAMAX    65535
#define WNI_CFG_BA_TIMEOUT_STADEF    0

#define WNI_CFG_BA_THRESHOLD_HIGH_STAMIN    0
#define WNI_CFG_BA_THRESHOLD_HIGH_STAMAX    65535
#define WNI_CFG_BA_THRESHOLD_HIGH_STADEF    128

#define WNI_CFG_MAX_BA_BUFFERS_STAMIN    0
#define WNI_CFG_MAX_BA_BUFFERS_STAMAX    2560
#define WNI_CFG_MAX_BA_BUFFERS_STADEF    2560

#define WNI_CFG_MAX_BA_SESSIONS_STAMIN    0
#define WNI_CFG_MAX_BA_SESSIONS_STAMAX    64
#define WNI_CFG_MAX_BA_SESSIONS_STADEF    40

#define WNI_CFG_BA_AUTO_SETUP_STAMIN    0
#define WNI_CFG_BA_AUTO_SETUP_STAMAX    1
#define WNI_CFG_BA_AUTO_SETUP_STADEF    1

#define WNI_CFG_BA_AUTO_SETUP_ENABLE    1
#define WNI_CFG_BA_AUTO_SETUP_DISABLE    0

#define WNI_CFG_ADDBA_REQ_DECLINE_STAMIN    0
#define WNI_CFG_ADDBA_REQ_DECLINE_STAMAX    255
#define WNI_CFG_ADDBA_REQ_DECLINE_STADEF    0

#define WNI_CFG_DEL_ALL_RX_BA_SESSIONS_2_4_G_BTC_STAMIN    0
#define WNI_CFG_DEL_ALL_RX_BA_SESSIONS_2_4_G_BTC_STAMAX    1
#define WNI_CFG_DEL_ALL_RX_BA_SESSIONS_2_4_G_BTC_STADEF    0

#define WNI_CFG_MAX_MEDIUM_TIME_STAMIN    0
#define WNI_CFG_MAX_MEDIUM_TIME_STAMAX    65535
#define WNI_CFG_MAX_MEDIUM_TIME_STADEF    2048

#define WNI_CFG_MAX_MPDUS_IN_AMPDU_STAMIN    0
#define WNI_CFG_MAX_MPDUS_IN_AMPDU_STAMAX    65535
#define WNI_CFG_MAX_MPDUS_IN_AMPDU_STADEF    64

#define WNI_CFG_IBSS_AUTO_BSSID_STAMIN    0
#define WNI_CFG_IBSS_AUTO_BSSID_STAMAX    1
#define WNI_CFG_IBSS_AUTO_BSSID_STADEF    1

#define WNI_CFG_PROBE_REQ_ADDNIE_FLAG_STAMIN    0
#define WNI_CFG_PROBE_REQ_ADDNIE_FLAG_STAMAX    1
#define WNI_CFG_PROBE_REQ_ADDNIE_FLAG_STADEF    0

#define WNI_CFG_PROBE_RSP_ADDNIE_FLAG_STAMIN    0
#define WNI_CFG_PROBE_RSP_ADDNIE_FLAG_STAMAX    1
#define WNI_CFG_PROBE_RSP_ADDNIE_FLAG_STADEF    0

#define WNI_CFG_ASSOC_RSP_ADDNIE_FLAG_STAMIN    0
#define WNI_CFG_ASSOC_RSP_ADDNIE_FLAG_STAMAX    1
#define WNI_CFG_ASSOC_RSP_ADDNIE_FLAG_STADEF    0

#define WNI_CFG_PROBE_REQ_ADDNP2PIE_FLAG_STAMIN    0
#define WNI_CFG_PROBE_REQ_ADDNP2PIE_FLAG_STAMAX    1
#define WNI_CFG_PROBE_REQ_ADDNP2PIE_FLAG_STADEF    0

#define WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STAMIN    0
#define WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STAMAX    1
#define WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STADEF    0

#define WNI_CFG_WPS_ENABLE_STAMIN    0
#define WNI_CFG_WPS_ENABLE_STAMAX    255
#define WNI_CFG_WPS_ENABLE_STADEF    0

#define WNI_CFG_WPS_ENABLE_AP    1
#define WNI_CFG_WPS_ENABLE_STA    2

#define WNI_CFG_WPS_STATE_STAMIN    0
#define WNI_CFG_WPS_STATE_STAMAX    255
#define WNI_CFG_WPS_STATE_STADEF    1

#define WNI_CFG_WPS_PROBE_REQ_FLAG_STAMIN    0
#define WNI_CFG_WPS_PROBE_REQ_FLAG_STAMAX    1
#define WNI_CFG_WPS_PROBE_REQ_FLAG_STADEF    0

#define WNI_CFG_WPS_VERSION_STAMIN    0
#define WNI_CFG_WPS_VERSION_STAMAX    255
#define WNI_CFG_WPS_VERSION_STADEF    16

#define WNI_CFG_WPS_REQUEST_TYPE_STAMIN    0
#define WNI_CFG_WPS_REQUEST_TYPE_STAMAX    255
#define WNI_CFG_WPS_REQUEST_TYPE_STADEF    0

#define WNI_CFG_WPS_CFG_METHOD_STAMIN    0
#define WNI_CFG_WPS_CFG_METHOD_STAMAX    4294967295
#define WNI_CFG_WPS_CFG_METHOD_STADEF    8

#define WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STAMIN    0
#define WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STAMAX    65535
#define WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STADEF    1

#define WNI_CFG_WPS_PIMARY_DEVICE_OUI_STAMIN    0
#define WNI_CFG_WPS_PIMARY_DEVICE_OUI_STAMAX    4294967295
#define WNI_CFG_WPS_PIMARY_DEVICE_OUI_STADEF    5304836

#define WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STAMIN    0
#define WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STAMAX    65535
#define WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STADEF    1

#define WNI_CFG_WPS_ASSOCIATION_STATE_STAMIN    0
#define WNI_CFG_WPS_ASSOCIATION_STATE_STAMAX    65535
#define WNI_CFG_WPS_ASSOCIATION_STATE_STADEF    0

#define WNI_CFG_WPS_CONFIGURATION_ERROR_STAMIN    0
#define WNI_CFG_WPS_CONFIGURATION_ERROR_STAMAX    65535
#define WNI_CFG_WPS_CONFIGURATION_ERROR_STADEF    0

#define WNI_CFG_WPS_DEVICE_PASSWORD_ID_STAMIN    0
#define WNI_CFG_WPS_DEVICE_PASSWORD_ID_STAMAX    4294967295
#define WNI_CFG_WPS_DEVICE_PASSWORD_ID_STADEF    0

#define WNI_CFG_WPS_ASSOC_METHOD_STAMIN    0
#define WNI_CFG_WPS_ASSOC_METHOD_STAMAX    65535
#define WNI_CFG_WPS_ASSOC_METHOD_STADEF    0

#define WNI_CFG_LOW_GAIN_OVERRIDE_STAMIN    0
#define WNI_CFG_LOW_GAIN_OVERRIDE_STAMAX    1
#define WNI_CFG_LOW_GAIN_OVERRIDE_STADEF    0

#define WNI_CFG_ENABLE_PHY_AGC_LISTEN_MODE_STAMIN    0
#define WNI_CFG_ENABLE_PHY_AGC_LISTEN_MODE_STAMAX    128
#define WNI_CFG_ENABLE_PHY_AGC_LISTEN_MODE_STADEF    128

#define WNI_CFG_RPE_POLLING_THRESHOLD_STAMIN    0
#define WNI_CFG_RPE_POLLING_THRESHOLD_STAMAX    65535
#define WNI_CFG_RPE_POLLING_THRESHOLD_STADEF    10

#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC0_REG_STAMIN    0
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC0_REG_STAMAX    65535
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC0_REG_STADEF    30

#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC1_REG_STAMIN    0
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC1_REG_STAMAX    65535
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC1_REG_STADEF    30

#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC2_REG_STAMIN    0
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC2_REG_STAMAX    65535
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC2_REG_STADEF    30

#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC3_REG_STAMIN    0
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC3_REG_STAMAX    65535
#define WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC3_REG_STADEF    30

#define WNI_CFG_NO_OF_ONCHIP_REORDER_SESSIONS_STAMIN    0
#define WNI_CFG_NO_OF_ONCHIP_REORDER_SESSIONS_STAMAX    2
#define WNI_CFG_NO_OF_ONCHIP_REORDER_SESSIONS_STADEF    1

#define WNI_CFG_SINGLE_TID_RC_STAMIN    0
#define WNI_CFG_SINGLE_TID_RC_STAMAX    1
#define WNI_CFG_SINGLE_TID_RC_STADEF    1

#define WNI_CFG_TX_PWR_CTRL_ENABLE_STAMIN    0
#define WNI_CFG_TX_PWR_CTRL_ENABLE_STAMAX    1
#define WNI_CFG_TX_PWR_CTRL_ENABLE_STADEF    1

#define WNI_CFG_MCAST_BCAST_FILTER_SETTING_STAMIN    0
#define WNI_CFG_MCAST_BCAST_FILTER_SETTING_STAMAX    3
#define WNI_CFG_MCAST_BCAST_FILTER_SETTING_STADEF    0

#define WNI_CFG_BTC_DHCP_BT_SLOTS_TO_BLOCK_STAMIN    0
#define WNI_CFG_BTC_DHCP_BT_SLOTS_TO_BLOCK_STAMAX    255
#define WNI_CFG_BTC_DHCP_BT_SLOTS_TO_BLOCK_STADEF    0

#define WNI_CFG_DYNAMIC_PS_POLL_VALUE_STAMIN    0
#define WNI_CFG_DYNAMIC_PS_POLL_VALUE_STAMAX    255
#define WNI_CFG_DYNAMIC_PS_POLL_VALUE_STADEF    0

#define WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STAMIN    0
#define WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STAMAX    80
#define WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STADEF    0

#define WNI_CFG_TELE_BCN_WAKEUP_EN_STAMIN    0
#define WNI_CFG_TELE_BCN_WAKEUP_EN_STAMAX    1
#define WNI_CFG_TELE_BCN_WAKEUP_EN_STADEF    0

#define WNI_CFG_TELE_BCN_TRANS_LI_STAMIN    0
#define WNI_CFG_TELE_BCN_TRANS_LI_STAMAX    7
#define WNI_CFG_TELE_BCN_TRANS_LI_STADEF    3

#define WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STAMIN    5
#define WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STAMAX    255
#define WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STADEF    10

#define WNI_CFG_TELE_BCN_MAX_LI_STAMIN    0
#define WNI_CFG_TELE_BCN_MAX_LI_STAMAX    7
#define WNI_CFG_TELE_BCN_MAX_LI_STADEF    5

#define WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STAMIN    5
#define WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STAMAX    255
#define WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STADEF    15

#define WNI_CFG_BTC_A2DP_DHCP_BT_SUB_INTERVALS_STAMIN    0
#define WNI_CFG_BTC_A2DP_DHCP_BT_SUB_INTERVALS_STAMAX    255
#define WNI_CFG_BTC_A2DP_DHCP_BT_SUB_INTERVALS_STADEF    7

#define WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STAMIN    0
#define WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STAMAX    1000
#define WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STADEF    0

#define WNI_CFG_ASSOC_STA_LIMIT_STAMIN    1
#define WNI_CFG_ASSOC_STA_LIMIT_STAMAX    32
#define WNI_CFG_ASSOC_STA_LIMIT_STADEF    10

#define WNI_CFG_SAP_CHANNEL_SELECT_START_CHANNEL_STAMIN    1
#define WNI_CFG_SAP_CHANNEL_SELECT_START_CHANNEL_STAMAX    252
#define WNI_CFG_SAP_CHANNEL_SELECT_START_CHANNEL_STADEF    1

#define WNI_CFG_SAP_CHANNEL_SELECT_END_CHANNEL_STAMIN    1
#define WNI_CFG_SAP_CHANNEL_SELECT_END_CHANNEL_STAMAX    252
#define WNI_CFG_SAP_CHANNEL_SELECT_END_CHANNEL_STADEF    11

#define WNI_CFG_SAP_CHANNEL_SELECT_OPERATING_BAND_STAMIN    0
#define WNI_CFG_SAP_CHANNEL_SELECT_OPERATING_BAND_STAMAX    5
#define WNI_CFG_SAP_CHANNEL_SELECT_OPERATING_BAND_STADEF    0

#define WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STAMIN    0
#define WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STAMAX    65535
#define WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STADEF    5

#define WNI_CFG_ENABLE_CLOSE_LOOP_STAMIN    0
#define WNI_CFG_ENABLE_CLOSE_LOOP_STAMAX    1
#define WNI_CFG_ENABLE_CLOSE_LOOP_STADEF    0

#define WNI_CFG_ENABLE_LTE_COEX_STAMIN    0
#define WNI_CFG_ENABLE_LTE_COEX_STAMAX    1
#define WNI_CFG_ENABLE_LTE_COEX_STADEF    0

#define WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STAMIN    1
#define WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STAMAX    65535
#define WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STADEF    20

#define WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STAMIN    1
#define WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STAMAX    65535
#define WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STADEF    20

#define WNI_CFG_ENABLE_MC_ADDR_LIST_STAMIN    0
#define WNI_CFG_ENABLE_MC_ADDR_LIST_STAMAX    1
#define WNI_CFG_ENABLE_MC_ADDR_LIST_STADEF    0

#define WNI_CFG_ENABLE_UC_FILTER_STAMIN    0
#define WNI_CFG_ENABLE_UC_FILTER_STAMAX    1
#define WNI_CFG_ENABLE_UC_FILTER_STADEF    0

#define WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STAMIN    0
#define WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STAMAX    1
#define WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STADEF    0

#define WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STAMIN    0
#define WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STAMAX    1
#define WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STADEF    0

#define WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STAMIN    0
#define WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STAMAX    1
#define WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STADEF    0

#define WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STAMIN    1
#define WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STAMAX    255
#define WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STADEF    3

#define WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STAMIN    0
#define WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STAMAX    15
#define WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STADEF    0

#define WNI_CFG_TDLS_BUF_STA_ENABLED_STAMIN    0
#define WNI_CFG_TDLS_BUF_STA_ENABLED_STAMAX    1
#define WNI_CFG_TDLS_BUF_STA_ENABLED_STADEF    0

#define WNI_CFG_TDLS_PUAPSD_INACT_TIME_STAMIN    0
#define WNI_CFG_TDLS_PUAPSD_INACT_TIME_STAMAX    10
#define WNI_CFG_TDLS_PUAPSD_INACT_TIME_STADEF    0

#define WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STAMIN    10
#define WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STAMAX    20
#define WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STADEF    10

#define WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STAMIN    0
#define WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STAMAX    20
#define WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STADEF    5

#define WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STAMIN    10
#define WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STAMAX    2000
#define WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STADEF    200

#define WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STAMIN    0
#define WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STAMAX    1
#define WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STADEF    1

#define WNI_CFG_FLEX_CONNECT_POWER_FACTOR_STAMIN    0
#define WNI_CFG_FLEX_CONNECT_POWER_FACTOR_STAMAX    9
#define WNI_CFG_FLEX_CONNECT_POWER_FACTOR_STADEF    0

#define WNI_CFG_ANTENNA_DIVESITY_STAMIN    0
#define WNI_CFG_ANTENNA_DIVESITY_STAMAX    3
#define WNI_CFG_ANTENNA_DIVESITY_STADEF    0

#define WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STAMIN    3
#define WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STAMAX    50
#define WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STADEF    10

#define WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY_STAMIN    100
#define WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY_STAMAX    1000
#define WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY_STADEF    300

#define WNI_CFG_CURRENT_RSSI_STAMIN    0
#define WNI_CFG_CURRENT_RSSI_STAMAX    127
#define WNI_CFG_CURRENT_RSSI_STADEF    0

#define WNI_CFG_RTT3_ENABLE_STAMIN    0
#define WNI_CFG_RTT3_ENABLE_STAMAX    1
#define WNI_CFG_RTT3_ENABLE_STADEF    1

#define WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STAMIN    0
#define WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STAMAX    1
#define WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STADEF    0

#define WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STAMIN    0
#define WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STAMAX    1
#define WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STADEF    0

#define WNI_CFG_IBSS_ATIM_WIN_SIZE_STAMIN    0
#define WNI_CFG_IBSS_ATIM_WIN_SIZE_STAMAX    100
#define WNI_CFG_IBSS_ATIM_WIN_SIZE_STADEF    0

#define WNI_CFG_DFS_MASTER_ENABLED_STAMIN    0
#define WNI_CFG_DFS_MASTER_ENABLED_STAMAX    1
#define WNI_CFG_DFS_MASTER_ENABLED_STADEF    0

#define WNI_CFG_VHT_ENABLE_TXBF_20MHZ_STAMIN    0
#define WNI_CFG_VHT_ENABLE_TXBF_20MHZ_STAMAX    1
#define WNI_CFG_VHT_ENABLE_TXBF_20MHZ_STADEF    0

#define WNI_CFG_TDLS_WMM_MODE_ENABLED_STAMIN    0
#define WNI_CFG_TDLS_WMM_MODE_ENABLED_STAMAX    1
#define WNI_CFG_TDLS_WMM_MODE_ENABLED_STADEF    0

#define CFG_PARAM_MAX_NUM        298
#define CFG_STA_IBUF_MAX_SIZE    241
#define CFG_STA_SBUF_MAX_SIZE    3199
#define CFG_SEM_MAX_NUM          19

#define CFG_STA_MAGIC_DWORD    0xbeefbeef


#endif
